/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings that are used to configure and manage the lifecycle of Amazon SageMaker Studio applications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppLifecycleManagement implements SdkPojo, Serializable,
        ToCopyableBuilder<AppLifecycleManagement.Builder, AppLifecycleManagement> {
    private static final SdkField<IdleSettings> IDLE_SETTINGS_FIELD = SdkField.<IdleSettings> builder(MarshallingType.SDK_POJO)
            .memberName("IdleSettings").getter(getter(AppLifecycleManagement::idleSettings))
            .setter(setter(Builder::idleSettings)).constructor(IdleSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDLE_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("IdleSettings", IDLE_SETTINGS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final IdleSettings idleSettings;

    private AppLifecycleManagement(BuilderImpl builder) {
        this.idleSettings = builder.idleSettings;
    }

    /**
     * <p>
     * Settings related to idle shutdown of Studio applications.
     * </p>
     * 
     * @return Settings related to idle shutdown of Studio applications.
     */
    public final IdleSettings idleSettings() {
        return idleSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(idleSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppLifecycleManagement)) {
            return false;
        }
        AppLifecycleManagement other = (AppLifecycleManagement) obj;
        return Objects.equals(idleSettings(), other.idleSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppLifecycleManagement").add("IdleSettings", idleSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdleSettings":
            return Optional.ofNullable(clazz.cast(idleSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AppLifecycleManagement, T> g) {
        return obj -> g.apply((AppLifecycleManagement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppLifecycleManagement> {
        /**
         * <p>
         * Settings related to idle shutdown of Studio applications.
         * </p>
         * 
         * @param idleSettings
         *        Settings related to idle shutdown of Studio applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleSettings(IdleSettings idleSettings);

        /**
         * <p>
         * Settings related to idle shutdown of Studio applications.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdleSettings.Builder} avoiding the need
         * to create one manually via {@link IdleSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdleSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #idleSettings(IdleSettings)}.
         * 
         * @param idleSettings
         *        a consumer that will call methods on {@link IdleSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #idleSettings(IdleSettings)
         */
        default Builder idleSettings(Consumer<IdleSettings.Builder> idleSettings) {
            return idleSettings(IdleSettings.builder().applyMutation(idleSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IdleSettings idleSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(AppLifecycleManagement model) {
            idleSettings(model.idleSettings);
        }

        public final IdleSettings.Builder getIdleSettings() {
            return idleSettings != null ? idleSettings.toBuilder() : null;
        }

        public final void setIdleSettings(IdleSettings.BuilderImpl idleSettings) {
            this.idleSettings = idleSettings != null ? idleSettings.build() : null;
        }

        @Override
        public final Builder idleSettings(IdleSettings idleSettings) {
            this.idleSettings = idleSettings;
            return this;
        }

        @Override
        public AppLifecycleManagement build() {
            return new AppLifecycleManagement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
