/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration to control how SageMaker captures inference data for batch transform jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDataCaptureConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDataCaptureConfig.Builder, BatchDataCaptureConfig> {
    private static final SdkField<String> DESTINATION_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationS3Uri").getter(getter(BatchDataCaptureConfig::destinationS3Uri))
            .setter(setter(Builder::destinationS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationS3Uri").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(BatchDataCaptureConfig::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> GENERATE_INFERENCE_ID_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("GenerateInferenceId").getter(getter(BatchDataCaptureConfig::generateInferenceId))
            .setter(setter(Builder::generateInferenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerateInferenceId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_S3_URI_FIELD,
            KMS_KEY_ID_FIELD, GENERATE_INFERENCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DestinationS3Uri", DESTINATION_S3_URI_FIELD);
                    put("KmsKeyId", KMS_KEY_ID_FIELD);
                    put("GenerateInferenceId", GENERATE_INFERENCE_ID_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String destinationS3Uri;

    private final String kmsKeyId;

    private final Boolean generateInferenceId;

    private BatchDataCaptureConfig(BuilderImpl builder) {
        this.destinationS3Uri = builder.destinationS3Uri;
        this.kmsKeyId = builder.kmsKeyId;
        this.generateInferenceId = builder.generateInferenceId;
    }

    /**
     * <p>
     * The Amazon S3 location being used to capture the data.
     * </p>
     * 
     * @return The Amazon S3 location being used to capture the data.
     */
    public final String destinationS3Uri() {
        return destinationS3Uri;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that SageMaker uses to encrypt
     * data on the storage volume attached to the ML compute instance that hosts the batch transform job.
     * </p>
     * <p>
     * The KmsKeyId can be any of the following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Alias name: <code>alias/ExampleAlias</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that SageMaker uses to
     *         encrypt data on the storage volume attached to the ML compute instance that hosts the batch transform
     *         job.</p>
     *         <p>
     *         The KmsKeyId can be any of the following formats:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Alias name: <code>alias/ExampleAlias</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code>
     *         </p>
     *         </li>
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Flag that indicates whether to append inference id to the output.
     * </p>
     * 
     * @return Flag that indicates whether to append inference id to the output.
     */
    public final Boolean generateInferenceId() {
        return generateInferenceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(generateInferenceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDataCaptureConfig)) {
            return false;
        }
        BatchDataCaptureConfig other = (BatchDataCaptureConfig) obj;
        return Objects.equals(destinationS3Uri(), other.destinationS3Uri()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(generateInferenceId(), other.generateInferenceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDataCaptureConfig").add("DestinationS3Uri", destinationS3Uri()).add("KmsKeyId", kmsKeyId())
                .add("GenerateInferenceId", generateInferenceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationS3Uri":
            return Optional.ofNullable(clazz.cast(destinationS3Uri()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "GenerateInferenceId":
            return Optional.ofNullable(clazz.cast(generateInferenceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchDataCaptureConfig, T> g) {
        return obj -> g.apply((BatchDataCaptureConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDataCaptureConfig> {
        /**
         * <p>
         * The Amazon S3 location being used to capture the data.
         * </p>
         * 
         * @param destinationS3Uri
         *        The Amazon S3 location being used to capture the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationS3Uri(String destinationS3Uri);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that SageMaker uses to
         * encrypt data on the storage volume attached to the ML compute instance that hosts the batch transform job.
         * </p>
         * <p>
         * The KmsKeyId can be any of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Alias name: <code>alias/ExampleAlias</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param kmsKeyId
         *        The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that SageMaker uses
         *        to encrypt data on the storage volume attached to the ML compute instance that hosts the batch
         *        transform job.</p>
         *        <p>
         *        The KmsKeyId can be any of the following formats:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Alias name: <code>alias/ExampleAlias</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Flag that indicates whether to append inference id to the output.
         * </p>
         * 
         * @param generateInferenceId
         *        Flag that indicates whether to append inference id to the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generateInferenceId(Boolean generateInferenceId);
    }

    static final class BuilderImpl implements Builder {
        private String destinationS3Uri;

        private String kmsKeyId;

        private Boolean generateInferenceId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDataCaptureConfig model) {
            destinationS3Uri(model.destinationS3Uri);
            kmsKeyId(model.kmsKeyId);
            generateInferenceId(model.generateInferenceId);
        }

        public final String getDestinationS3Uri() {
            return destinationS3Uri;
        }

        public final void setDestinationS3Uri(String destinationS3Uri) {
            this.destinationS3Uri = destinationS3Uri;
        }

        @Override
        public final Builder destinationS3Uri(String destinationS3Uri) {
            this.destinationS3Uri = destinationS3Uri;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getGenerateInferenceId() {
            return generateInferenceId;
        }

        public final void setGenerateInferenceId(Boolean generateInferenceId) {
            this.generateInferenceId = generateInferenceId;
        }

        @Override
        public final Builder generateInferenceId(Boolean generateInferenceId) {
            this.generateInferenceId = generateInferenceId;
            return this;
        }

        @Override
        public BatchDataCaptureConfig build() {
            return new BatchDataCaptureConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
