/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an error encountered when deleting a node from a SageMaker HyperPod cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteClusterNodesError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDeleteClusterNodesError.Builder, BatchDeleteClusterNodesError> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(BatchDeleteClusterNodesError::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(BatchDeleteClusterNodesError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("NodeId")
            .getter(getter(BatchDeleteClusterNodesError::nodeId)).setter(setter(Builder::nodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, MESSAGE_FIELD,
            NODE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Code", CODE_FIELD);
                    put("Message", MESSAGE_FIELD);
                    put("NodeId", NODE_ID_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String message;

    private final String nodeId;

    private BatchDeleteClusterNodesError(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
        this.nodeId = builder.nodeId;
    }

    /**
     * <p>
     * The error code associated with the error encountered when deleting a node.
     * </p>
     * <p>
     * The code provides information about the specific issue encountered, such as the node not being found, the node's
     * status being invalid for deletion, or the node ID being in use by another process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link BatchDeleteClusterNodesErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #codeAsString}.
     * </p>
     * 
     * @return The error code associated with the error encountered when deleting a node.</p>
     *         <p>
     *         The code provides information about the specific issue encountered, such as the node not being found, the
     *         node's status being invalid for deletion, or the node ID being in use by another process.
     * @see BatchDeleteClusterNodesErrorCode
     */
    public final BatchDeleteClusterNodesErrorCode code() {
        return BatchDeleteClusterNodesErrorCode.fromValue(code);
    }

    /**
     * <p>
     * The error code associated with the error encountered when deleting a node.
     * </p>
     * <p>
     * The code provides information about the specific issue encountered, such as the node not being found, the node's
     * status being invalid for deletion, or the node ID being in use by another process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link BatchDeleteClusterNodesErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #codeAsString}.
     * </p>
     * 
     * @return The error code associated with the error encountered when deleting a node.</p>
     *         <p>
     *         The code provides information about the specific issue encountered, such as the node not being found, the
     *         node's status being invalid for deletion, or the node ID being in use by another process.
     * @see BatchDeleteClusterNodesErrorCode
     */
    public final String codeAsString() {
        return code;
    }

    /**
     * <p>
     * A message describing the error encountered when deleting a node.
     * </p>
     * 
     * @return A message describing the error encountered when deleting a node.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The ID of the node that encountered an error during the deletion process.
     * </p>
     * 
     * @return The ID of the node that encountered an error during the deletion process.
     */
    public final String nodeId() {
        return nodeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(nodeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteClusterNodesError)) {
            return false;
        }
        BatchDeleteClusterNodesError other = (BatchDeleteClusterNodesError) obj;
        return Objects.equals(codeAsString(), other.codeAsString()) && Objects.equals(message(), other.message())
                && Objects.equals(nodeId(), other.nodeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteClusterNodesError").add("Code", codeAsString()).add("Message", message())
                .add("NodeId", nodeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "NodeId":
            return Optional.ofNullable(clazz.cast(nodeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteClusterNodesError, T> g) {
        return obj -> g.apply((BatchDeleteClusterNodesError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDeleteClusterNodesError> {
        /**
         * <p>
         * The error code associated with the error encountered when deleting a node.
         * </p>
         * <p>
         * The code provides information about the specific issue encountered, such as the node not being found, the
         * node's status being invalid for deletion, or the node ID being in use by another process.
         * </p>
         * 
         * @param code
         *        The error code associated with the error encountered when deleting a node.</p>
         *        <p>
         *        The code provides information about the specific issue encountered, such as the node not being found,
         *        the node's status being invalid for deletion, or the node ID being in use by another process.
         * @see BatchDeleteClusterNodesErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchDeleteClusterNodesErrorCode
         */
        Builder code(String code);

        /**
         * <p>
         * The error code associated with the error encountered when deleting a node.
         * </p>
         * <p>
         * The code provides information about the specific issue encountered, such as the node not being found, the
         * node's status being invalid for deletion, or the node ID being in use by another process.
         * </p>
         * 
         * @param code
         *        The error code associated with the error encountered when deleting a node.</p>
         *        <p>
         *        The code provides information about the specific issue encountered, such as the node not being found,
         *        the node's status being invalid for deletion, or the node ID being in use by another process.
         * @see BatchDeleteClusterNodesErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchDeleteClusterNodesErrorCode
         */
        Builder code(BatchDeleteClusterNodesErrorCode code);

        /**
         * <p>
         * A message describing the error encountered when deleting a node.
         * </p>
         * 
         * @param message
         *        A message describing the error encountered when deleting a node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The ID of the node that encountered an error during the deletion process.
         * </p>
         * 
         * @param nodeId
         *        The ID of the node that encountered an error during the deletion process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeId(String nodeId);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String message;

        private String nodeId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteClusterNodesError model) {
            code(model.code);
            message(model.message);
            nodeId(model.nodeId);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(BatchDeleteClusterNodesErrorCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getNodeId() {
            return nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        @Override
        public BatchDeleteClusterNodesError build() {
            return new BatchDeleteClusterNodesError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
