/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The error code and error description associated with the resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDescribeModelPackageError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDescribeModelPackageError.Builder, BatchDescribeModelPackageError> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(BatchDescribeModelPackageError::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_RESPONSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorResponse").getter(getter(BatchDescribeModelPackageError::errorResponse))
            .setter(setter(Builder::errorResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorResponse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD,
            ERROR_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ErrorCode", ERROR_CODE_FIELD);
                    put("ErrorResponse", ERROR_RESPONSE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String errorCode;

    private final String errorResponse;

    private BatchDescribeModelPackageError(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.errorResponse = builder.errorResponse;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String errorResponse() {
        return errorResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDescribeModelPackageError)) {
            return false;
        }
        BatchDescribeModelPackageError other = (BatchDescribeModelPackageError) obj;
        return Objects.equals(errorCode(), other.errorCode()) && Objects.equals(errorResponse(), other.errorResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDescribeModelPackageError").add("ErrorCode", errorCode())
                .add("ErrorResponse", errorResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorResponse":
            return Optional.ofNullable(clazz.cast(errorResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchDescribeModelPackageError, T> g) {
        return obj -> g.apply((BatchDescribeModelPackageError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDescribeModelPackageError> {
        /**
         * <p/>
         * 
         * @param errorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p/>
         * 
         * @param errorResponse
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorResponse(String errorResponse);
    }

    static final class BuilderImpl implements Builder {
        private String errorCode;

        private String errorResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDescribeModelPackageError model) {
            errorCode(model.errorCode);
            errorResponse(model.errorResponse);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorResponse() {
            return errorResponse;
        }

        public final void setErrorResponse(String errorResponse) {
            this.errorResponse = errorResponse;
        }

        @Override
        public final Builder errorResponse(String errorResponse) {
            this.errorResponse = errorResponse;
            return this;
        }

        @Override
        public BatchDescribeModelPackageError build() {
            return new BatchDescribeModelPackageError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
