/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Stores the configuration information for how model candidates are generated using an AutoML job V2.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CandidateGenerationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CandidateGenerationConfig.Builder, CandidateGenerationConfig> {
    private static final SdkField<List<AutoMLAlgorithmConfig>> ALGORITHMS_CONFIG_FIELD = SdkField
            .<List<AutoMLAlgorithmConfig>> builder(MarshallingType.LIST)
            .memberName("AlgorithmsConfig")
            .getter(getter(CandidateGenerationConfig::algorithmsConfig))
            .setter(setter(Builder::algorithmsConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmsConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoMLAlgorithmConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoMLAlgorithmConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHMS_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AlgorithmsConfig", ALGORITHMS_CONFIG_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<AutoMLAlgorithmConfig> algorithmsConfig;

    private CandidateGenerationConfig(BuilderImpl builder) {
        this.algorithmsConfig = builder.algorithmsConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the AlgorithmsConfig property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAlgorithmsConfig() {
        return algorithmsConfig != null && !(algorithmsConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Your Autopilot job trains a default set of algorithms on your dataset. For tabular and time-series data, you can
     * customize the algorithm list by selecting a subset of algorithms for your problem type.
     * </p>
     * <p>
     * <code>AlgorithmsConfig</code> stores the customized selection of algorithms to train on your data.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>For the tabular problem type <code>TabularJobConfig</code>,</b> the list of available algorithms to choose
     * from depends on the training mode set in <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html">
     * <code>AutoMLJobConfig.Mode</code> </a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AlgorithmsConfig</code> should not be set when the training mode <code>AutoMLJobConfig.Mode</code> is set
     * to <code>AUTO</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * When <code>AlgorithmsConfig</code> is provided, one <code>AutoMLAlgorithms</code> attribute must be set and one
     * only.
     * </p>
     * <p>
     * If the list of algorithms provided as values for <code>AutoMLAlgorithms</code> is empty,
     * <code>CandidateGenerationConfig</code> uses the full set of algorithms for the given training mode.
     * </p>
     * </li>
     * <li>
     * <p>
     * When <code>AlgorithmsConfig</code> is not provided, <code>CandidateGenerationConfig</code> uses the full set of
     * algorithms for the given training mode.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For the list of all algorithms per training mode, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html">
     * AlgorithmConfig</a>.
     * </p>
     * <p>
     * For more information on each algorithm, see the <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support"
     * >Algorithm support</a> section in the Autopilot developer guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>For the time-series forecasting problem type <code>TimeSeriesForecastingJobConfig</code>,</b> choose your
     * algorithms from the list provided in <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html">
     * AlgorithmConfig</a>.
     * </p>
     * <p>
     * For more information on each algorithm, see the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/timeseries-forecasting-algorithms.html">Algorithms support
     * for time-series forecasting</a> section in the Autopilot developer guide.
     * </p>
     * <ul>
     * <li>
     * <p>
     * When <code>AlgorithmsConfig</code> is provided, one <code>AutoMLAlgorithms</code> attribute must be set and one
     * only.
     * </p>
     * <p>
     * If the list of algorithms provided as values for <code>AutoMLAlgorithms</code> is empty,
     * <code>CandidateGenerationConfig</code> uses the full set of algorithms for time-series forecasting.
     * </p>
     * </li>
     * <li>
     * <p>
     * When <code>AlgorithmsConfig</code> is not provided, <code>CandidateGenerationConfig</code> uses the full set of
     * algorithms for time-series forecasting.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlgorithmsConfig} method.
     * </p>
     * 
     * @return Your Autopilot job trains a default set of algorithms on your dataset. For tabular and time-series data,
     *         you can customize the algorithm list by selecting a subset of algorithms for your problem type.</p>
     *         <p>
     *         <code>AlgorithmsConfig</code> stores the customized selection of algorithms to train on your data.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>For the tabular problem type <code>TabularJobConfig</code>,</b> the list of available algorithms to
     *         choose from depends on the training mode set in <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html">
     *         <code>AutoMLJobConfig.Mode</code> </a>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AlgorithmsConfig</code> should not be set when the training mode <code>AutoMLJobConfig.Mode</code>
     *         is set to <code>AUTO</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When <code>AlgorithmsConfig</code> is provided, one <code>AutoMLAlgorithms</code> attribute must be set
     *         and one only.
     *         </p>
     *         <p>
     *         If the list of algorithms provided as values for <code>AutoMLAlgorithms</code> is empty,
     *         <code>CandidateGenerationConfig</code> uses the full set of algorithms for the given training mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When <code>AlgorithmsConfig</code> is not provided, <code>CandidateGenerationConfig</code> uses the full
     *         set of algorithms for the given training mode.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For the list of all algorithms per training mode, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html">
     *         AlgorithmConfig</a>.
     *         </p>
     *         <p>
     *         For more information on each algorithm, see the <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support"
     *         >Algorithm support</a> section in the Autopilot developer guide.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>For the time-series forecasting problem type <code>TimeSeriesForecastingJobConfig</code>,</b> choose
     *         your algorithms from the list provided in <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html">
     *         AlgorithmConfig</a>.
     *         </p>
     *         <p>
     *         For more information on each algorithm, see the <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/timeseries-forecasting-algorithms.html">Algorithms
     *         support for time-series forecasting</a> section in the Autopilot developer guide.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         When <code>AlgorithmsConfig</code> is provided, one <code>AutoMLAlgorithms</code> attribute must be set
     *         and one only.
     *         </p>
     *         <p>
     *         If the list of algorithms provided as values for <code>AutoMLAlgorithms</code> is empty,
     *         <code>CandidateGenerationConfig</code> uses the full set of algorithms for time-series forecasting.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When <code>AlgorithmsConfig</code> is not provided, <code>CandidateGenerationConfig</code> uses the full
     *         set of algorithms for time-series forecasting.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final List<AutoMLAlgorithmConfig> algorithmsConfig() {
        return algorithmsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAlgorithmsConfig() ? algorithmsConfig() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CandidateGenerationConfig)) {
            return false;
        }
        CandidateGenerationConfig other = (CandidateGenerationConfig) obj;
        return hasAlgorithmsConfig() == other.hasAlgorithmsConfig()
                && Objects.equals(algorithmsConfig(), other.algorithmsConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CandidateGenerationConfig")
                .add("AlgorithmsConfig", hasAlgorithmsConfig() ? algorithmsConfig() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlgorithmsConfig":
            return Optional.ofNullable(clazz.cast(algorithmsConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CandidateGenerationConfig, T> g) {
        return obj -> g.apply((CandidateGenerationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CandidateGenerationConfig> {
        /**
         * <p>
         * Your Autopilot job trains a default set of algorithms on your dataset. For tabular and time-series data, you
         * can customize the algorithm list by selecting a subset of algorithms for your problem type.
         * </p>
         * <p>
         * <code>AlgorithmsConfig</code> stores the customized selection of algorithms to train on your data.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>For the tabular problem type <code>TabularJobConfig</code>,</b> the list of available algorithms to choose
         * from depends on the training mode set in <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html">
         * <code>AutoMLJobConfig.Mode</code> </a>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AlgorithmsConfig</code> should not be set when the training mode <code>AutoMLJobConfig.Mode</code> is
         * set to <code>AUTO</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * When <code>AlgorithmsConfig</code> is provided, one <code>AutoMLAlgorithms</code> attribute must be set and
         * one only.
         * </p>
         * <p>
         * If the list of algorithms provided as values for <code>AutoMLAlgorithms</code> is empty,
         * <code>CandidateGenerationConfig</code> uses the full set of algorithms for the given training mode.
         * </p>
         * </li>
         * <li>
         * <p>
         * When <code>AlgorithmsConfig</code> is not provided, <code>CandidateGenerationConfig</code> uses the full set
         * of algorithms for the given training mode.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For the list of all algorithms per training mode, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html">
         * AlgorithmConfig</a>.
         * </p>
         * <p>
         * For more information on each algorithm, see the <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support"
         * >Algorithm support</a> section in the Autopilot developer guide.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>For the time-series forecasting problem type <code>TimeSeriesForecastingJobConfig</code>,</b> choose your
         * algorithms from the list provided in <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html">
         * AlgorithmConfig</a>.
         * </p>
         * <p>
         * For more information on each algorithm, see the <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/timeseries-forecasting-algorithms.html">Algorithms
         * support for time-series forecasting</a> section in the Autopilot developer guide.
         * </p>
         * <ul>
         * <li>
         * <p>
         * When <code>AlgorithmsConfig</code> is provided, one <code>AutoMLAlgorithms</code> attribute must be set and
         * one only.
         * </p>
         * <p>
         * If the list of algorithms provided as values for <code>AutoMLAlgorithms</code> is empty,
         * <code>CandidateGenerationConfig</code> uses the full set of algorithms for time-series forecasting.
         * </p>
         * </li>
         * <li>
         * <p>
         * When <code>AlgorithmsConfig</code> is not provided, <code>CandidateGenerationConfig</code> uses the full set
         * of algorithms for time-series forecasting.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param algorithmsConfig
         *        Your Autopilot job trains a default set of algorithms on your dataset. For tabular and time-series
         *        data, you can customize the algorithm list by selecting a subset of algorithms for your problem
         *        type.</p>
         *        <p>
         *        <code>AlgorithmsConfig</code> stores the customized selection of algorithms to train on your data.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>For the tabular problem type <code>TabularJobConfig</code>,</b> the list of available algorithms to
         *        choose from depends on the training mode set in <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html">
         *        <code>AutoMLJobConfig.Mode</code> </a>.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AlgorithmsConfig</code> should not be set when the training mode
         *        <code>AutoMLJobConfig.Mode</code> is set to <code>AUTO</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When <code>AlgorithmsConfig</code> is provided, one <code>AutoMLAlgorithms</code> attribute must be
         *        set and one only.
         *        </p>
         *        <p>
         *        If the list of algorithms provided as values for <code>AutoMLAlgorithms</code> is empty,
         *        <code>CandidateGenerationConfig</code> uses the full set of algorithms for the given training mode.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When <code>AlgorithmsConfig</code> is not provided, <code>CandidateGenerationConfig</code> uses the
         *        full set of algorithms for the given training mode.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For the list of all algorithms per training mode, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html">
         *        AlgorithmConfig</a>.
         *        </p>
         *        <p>
         *        For more information on each algorithm, see the <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support"
         *        >Algorithm support</a> section in the Autopilot developer guide.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>For the time-series forecasting problem type <code>TimeSeriesForecastingJobConfig</code>,</b>
         *        choose your algorithms from the list provided in <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html">
         *        AlgorithmConfig</a>.
         *        </p>
         *        <p>
         *        For more information on each algorithm, see the <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/timeseries-forecasting-algorithms.html"
         *        >Algorithms support for time-series forecasting</a> section in the Autopilot developer guide.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        When <code>AlgorithmsConfig</code> is provided, one <code>AutoMLAlgorithms</code> attribute must be
         *        set and one only.
         *        </p>
         *        <p>
         *        If the list of algorithms provided as values for <code>AutoMLAlgorithms</code> is empty,
         *        <code>CandidateGenerationConfig</code> uses the full set of algorithms for time-series forecasting.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When <code>AlgorithmsConfig</code> is not provided, <code>CandidateGenerationConfig</code> uses the
         *        full set of algorithms for time-series forecasting.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmsConfig(Collection<AutoMLAlgorithmConfig> algorithmsConfig);

        /**
         * <p>
         * Your Autopilot job trains a default set of algorithms on your dataset. For tabular and time-series data, you
         * can customize the algorithm list by selecting a subset of algorithms for your problem type.
         * </p>
         * <p>
         * <code>AlgorithmsConfig</code> stores the customized selection of algorithms to train on your data.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>For the tabular problem type <code>TabularJobConfig</code>,</b> the list of available algorithms to choose
         * from depends on the training mode set in <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html">
         * <code>AutoMLJobConfig.Mode</code> </a>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AlgorithmsConfig</code> should not be set when the training mode <code>AutoMLJobConfig.Mode</code> is
         * set to <code>AUTO</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * When <code>AlgorithmsConfig</code> is provided, one <code>AutoMLAlgorithms</code> attribute must be set and
         * one only.
         * </p>
         * <p>
         * If the list of algorithms provided as values for <code>AutoMLAlgorithms</code> is empty,
         * <code>CandidateGenerationConfig</code> uses the full set of algorithms for the given training mode.
         * </p>
         * </li>
         * <li>
         * <p>
         * When <code>AlgorithmsConfig</code> is not provided, <code>CandidateGenerationConfig</code> uses the full set
         * of algorithms for the given training mode.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For the list of all algorithms per training mode, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html">
         * AlgorithmConfig</a>.
         * </p>
         * <p>
         * For more information on each algorithm, see the <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support"
         * >Algorithm support</a> section in the Autopilot developer guide.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>For the time-series forecasting problem type <code>TimeSeriesForecastingJobConfig</code>,</b> choose your
         * algorithms from the list provided in <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html">
         * AlgorithmConfig</a>.
         * </p>
         * <p>
         * For more information on each algorithm, see the <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/timeseries-forecasting-algorithms.html">Algorithms
         * support for time-series forecasting</a> section in the Autopilot developer guide.
         * </p>
         * <ul>
         * <li>
         * <p>
         * When <code>AlgorithmsConfig</code> is provided, one <code>AutoMLAlgorithms</code> attribute must be set and
         * one only.
         * </p>
         * <p>
         * If the list of algorithms provided as values for <code>AutoMLAlgorithms</code> is empty,
         * <code>CandidateGenerationConfig</code> uses the full set of algorithms for time-series forecasting.
         * </p>
         * </li>
         * <li>
         * <p>
         * When <code>AlgorithmsConfig</code> is not provided, <code>CandidateGenerationConfig</code> uses the full set
         * of algorithms for time-series forecasting.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param algorithmsConfig
         *        Your Autopilot job trains a default set of algorithms on your dataset. For tabular and time-series
         *        data, you can customize the algorithm list by selecting a subset of algorithms for your problem
         *        type.</p>
         *        <p>
         *        <code>AlgorithmsConfig</code> stores the customized selection of algorithms to train on your data.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>For the tabular problem type <code>TabularJobConfig</code>,</b> the list of available algorithms to
         *        choose from depends on the training mode set in <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html">
         *        <code>AutoMLJobConfig.Mode</code> </a>.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AlgorithmsConfig</code> should not be set when the training mode
         *        <code>AutoMLJobConfig.Mode</code> is set to <code>AUTO</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When <code>AlgorithmsConfig</code> is provided, one <code>AutoMLAlgorithms</code> attribute must be
         *        set and one only.
         *        </p>
         *        <p>
         *        If the list of algorithms provided as values for <code>AutoMLAlgorithms</code> is empty,
         *        <code>CandidateGenerationConfig</code> uses the full set of algorithms for the given training mode.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When <code>AlgorithmsConfig</code> is not provided, <code>CandidateGenerationConfig</code> uses the
         *        full set of algorithms for the given training mode.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For the list of all algorithms per training mode, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html">
         *        AlgorithmConfig</a>.
         *        </p>
         *        <p>
         *        For more information on each algorithm, see the <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support"
         *        >Algorithm support</a> section in the Autopilot developer guide.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>For the time-series forecasting problem type <code>TimeSeriesForecastingJobConfig</code>,</b>
         *        choose your algorithms from the list provided in <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html">
         *        AlgorithmConfig</a>.
         *        </p>
         *        <p>
         *        For more information on each algorithm, see the <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/timeseries-forecasting-algorithms.html"
         *        >Algorithms support for time-series forecasting</a> section in the Autopilot developer guide.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        When <code>AlgorithmsConfig</code> is provided, one <code>AutoMLAlgorithms</code> attribute must be
         *        set and one only.
         *        </p>
         *        <p>
         *        If the list of algorithms provided as values for <code>AutoMLAlgorithms</code> is empty,
         *        <code>CandidateGenerationConfig</code> uses the full set of algorithms for time-series forecasting.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When <code>AlgorithmsConfig</code> is not provided, <code>CandidateGenerationConfig</code> uses the
         *        full set of algorithms for time-series forecasting.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmsConfig(AutoMLAlgorithmConfig... algorithmsConfig);

        /**
         * <p>
         * Your Autopilot job trains a default set of algorithms on your dataset. For tabular and time-series data, you
         * can customize the algorithm list by selecting a subset of algorithms for your problem type.
         * </p>
         * <p>
         * <code>AlgorithmsConfig</code> stores the customized selection of algorithms to train on your data.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>For the tabular problem type <code>TabularJobConfig</code>,</b> the list of available algorithms to choose
         * from depends on the training mode set in <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html">
         * <code>AutoMLJobConfig.Mode</code> </a>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AlgorithmsConfig</code> should not be set when the training mode <code>AutoMLJobConfig.Mode</code> is
         * set to <code>AUTO</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * When <code>AlgorithmsConfig</code> is provided, one <code>AutoMLAlgorithms</code> attribute must be set and
         * one only.
         * </p>
         * <p>
         * If the list of algorithms provided as values for <code>AutoMLAlgorithms</code> is empty,
         * <code>CandidateGenerationConfig</code> uses the full set of algorithms for the given training mode.
         * </p>
         * </li>
         * <li>
         * <p>
         * When <code>AlgorithmsConfig</code> is not provided, <code>CandidateGenerationConfig</code> uses the full set
         * of algorithms for the given training mode.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For the list of all algorithms per training mode, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html">
         * AlgorithmConfig</a>.
         * </p>
         * <p>
         * For more information on each algorithm, see the <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support"
         * >Algorithm support</a> section in the Autopilot developer guide.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>For the time-series forecasting problem type <code>TimeSeriesForecastingJobConfig</code>,</b> choose your
         * algorithms from the list provided in <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html">
         * AlgorithmConfig</a>.
         * </p>
         * <p>
         * For more information on each algorithm, see the <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/timeseries-forecasting-algorithms.html">Algorithms
         * support for time-series forecasting</a> section in the Autopilot developer guide.
         * </p>
         * <ul>
         * <li>
         * <p>
         * When <code>AlgorithmsConfig</code> is provided, one <code>AutoMLAlgorithms</code> attribute must be set and
         * one only.
         * </p>
         * <p>
         * If the list of algorithms provided as values for <code>AutoMLAlgorithms</code> is empty,
         * <code>CandidateGenerationConfig</code> uses the full set of algorithms for time-series forecasting.
         * </p>
         * </li>
         * <li>
         * <p>
         * When <code>AlgorithmsConfig</code> is not provided, <code>CandidateGenerationConfig</code> uses the full set
         * of algorithms for time-series forecasting.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithmConfig.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithmConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithmConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #algorithmsConfig(List<AutoMLAlgorithmConfig>)}.
         * 
         * @param algorithmsConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithmConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #algorithmsConfig(java.util.Collection<AutoMLAlgorithmConfig>)
         */
        Builder algorithmsConfig(Consumer<AutoMLAlgorithmConfig.Builder>... algorithmsConfig);
    }

    static final class BuilderImpl implements Builder {
        private List<AutoMLAlgorithmConfig> algorithmsConfig = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CandidateGenerationConfig model) {
            algorithmsConfig(model.algorithmsConfig);
        }

        public final List<AutoMLAlgorithmConfig.Builder> getAlgorithmsConfig() {
            List<AutoMLAlgorithmConfig.Builder> result = AutoMLAlgorithmsConfigCopier.copyToBuilder(this.algorithmsConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlgorithmsConfig(Collection<AutoMLAlgorithmConfig.BuilderImpl> algorithmsConfig) {
            this.algorithmsConfig = AutoMLAlgorithmsConfigCopier.copyFromBuilder(algorithmsConfig);
        }

        @Override
        public final Builder algorithmsConfig(Collection<AutoMLAlgorithmConfig> algorithmsConfig) {
            this.algorithmsConfig = AutoMLAlgorithmsConfigCopier.copy(algorithmsConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder algorithmsConfig(AutoMLAlgorithmConfig... algorithmsConfig) {
            algorithmsConfig(Arrays.asList(algorithmsConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder algorithmsConfig(Consumer<AutoMLAlgorithmConfig.Builder>... algorithmsConfig) {
            algorithmsConfig(Stream.of(algorithmsConfig).map(c -> AutoMLAlgorithmConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CandidateGenerationConfig build() {
            return new CandidateGenerationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
