/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration specifying how to treat different headers. If no headers are specified Amazon SageMaker will by default
 * base64 encode when capturing the data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaptureContentTypeHeader implements SdkPojo, Serializable,
        ToCopyableBuilder<CaptureContentTypeHeader.Builder, CaptureContentTypeHeader> {
    private static final SdkField<List<String>> CSV_CONTENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CsvContentTypes")
            .getter(getter(CaptureContentTypeHeader::csvContentTypes))
            .setter(setter(Builder::csvContentTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvContentTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> JSON_CONTENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("JsonContentTypes")
            .getter(getter(CaptureContentTypeHeader::jsonContentTypes))
            .setter(setter(Builder::jsonContentTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JsonContentTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CSV_CONTENT_TYPES_FIELD,
            JSON_CONTENT_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CsvContentTypes", CSV_CONTENT_TYPES_FIELD);
                    put("JsonContentTypes", JSON_CONTENT_TYPES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<String> csvContentTypes;

    private final List<String> jsonContentTypes;

    private CaptureContentTypeHeader(BuilderImpl builder) {
        this.csvContentTypes = builder.csvContentTypes;
        this.jsonContentTypes = builder.jsonContentTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the CsvContentTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCsvContentTypes() {
        return csvContentTypes != null && !(csvContentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of all content type headers that Amazon SageMaker will treat as CSV and capture accordingly.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCsvContentTypes} method.
     * </p>
     * 
     * @return The list of all content type headers that Amazon SageMaker will treat as CSV and capture accordingly.
     */
    public final List<String> csvContentTypes() {
        return csvContentTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the JsonContentTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasJsonContentTypes() {
        return jsonContentTypes != null && !(jsonContentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of all content type headers that SageMaker will treat as JSON and capture accordingly.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJsonContentTypes} method.
     * </p>
     * 
     * @return The list of all content type headers that SageMaker will treat as JSON and capture accordingly.
     */
    public final List<String> jsonContentTypes() {
        return jsonContentTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCsvContentTypes() ? csvContentTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasJsonContentTypes() ? jsonContentTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptureContentTypeHeader)) {
            return false;
        }
        CaptureContentTypeHeader other = (CaptureContentTypeHeader) obj;
        return hasCsvContentTypes() == other.hasCsvContentTypes() && Objects.equals(csvContentTypes(), other.csvContentTypes())
                && hasJsonContentTypes() == other.hasJsonContentTypes()
                && Objects.equals(jsonContentTypes(), other.jsonContentTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaptureContentTypeHeader")
                .add("CsvContentTypes", hasCsvContentTypes() ? csvContentTypes() : null)
                .add("JsonContentTypes", hasJsonContentTypes() ? jsonContentTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CsvContentTypes":
            return Optional.ofNullable(clazz.cast(csvContentTypes()));
        case "JsonContentTypes":
            return Optional.ofNullable(clazz.cast(jsonContentTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CaptureContentTypeHeader, T> g) {
        return obj -> g.apply((CaptureContentTypeHeader) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaptureContentTypeHeader> {
        /**
         * <p>
         * The list of all content type headers that Amazon SageMaker will treat as CSV and capture accordingly.
         * </p>
         * 
         * @param csvContentTypes
         *        The list of all content type headers that Amazon SageMaker will treat as CSV and capture accordingly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvContentTypes(Collection<String> csvContentTypes);

        /**
         * <p>
         * The list of all content type headers that Amazon SageMaker will treat as CSV and capture accordingly.
         * </p>
         * 
         * @param csvContentTypes
         *        The list of all content type headers that Amazon SageMaker will treat as CSV and capture accordingly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvContentTypes(String... csvContentTypes);

        /**
         * <p>
         * The list of all content type headers that SageMaker will treat as JSON and capture accordingly.
         * </p>
         * 
         * @param jsonContentTypes
         *        The list of all content type headers that SageMaker will treat as JSON and capture accordingly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonContentTypes(Collection<String> jsonContentTypes);

        /**
         * <p>
         * The list of all content type headers that SageMaker will treat as JSON and capture accordingly.
         * </p>
         * 
         * @param jsonContentTypes
         *        The list of all content type headers that SageMaker will treat as JSON and capture accordingly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonContentTypes(String... jsonContentTypes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> csvContentTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> jsonContentTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CaptureContentTypeHeader model) {
            csvContentTypes(model.csvContentTypes);
            jsonContentTypes(model.jsonContentTypes);
        }

        public final Collection<String> getCsvContentTypes() {
            if (csvContentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return csvContentTypes;
        }

        public final void setCsvContentTypes(Collection<String> csvContentTypes) {
            this.csvContentTypes = CsvContentTypesCopier.copy(csvContentTypes);
        }

        @Override
        public final Builder csvContentTypes(Collection<String> csvContentTypes) {
            this.csvContentTypes = CsvContentTypesCopier.copy(csvContentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder csvContentTypes(String... csvContentTypes) {
            csvContentTypes(Arrays.asList(csvContentTypes));
            return this;
        }

        public final Collection<String> getJsonContentTypes() {
            if (jsonContentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return jsonContentTypes;
        }

        public final void setJsonContentTypes(Collection<String> jsonContentTypes) {
            this.jsonContentTypes = JsonContentTypesCopier.copy(jsonContentTypes);
        }

        @Override
        public final Builder jsonContentTypes(Collection<String> jsonContentTypes) {
            this.jsonContentTypes = JsonContentTypesCopier.copy(jsonContentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jsonContentTypes(String... jsonContentTypes) {
            jsonContentTypes(Arrays.asList(jsonContentTypes));
            return this;
        }

        @Override
        public CaptureContentTypeHeader build() {
            return new CaptureContentTypeHeader(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
