/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for SHAP analysis using SageMaker Clarify Explainer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClarifyShapConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ClarifyShapConfig.Builder, ClarifyShapConfig> {
    private static final SdkField<ClarifyShapBaselineConfig> SHAP_BASELINE_CONFIG_FIELD = SdkField
            .<ClarifyShapBaselineConfig> builder(MarshallingType.SDK_POJO).memberName("ShapBaselineConfig")
            .getter(getter(ClarifyShapConfig::shapBaselineConfig)).setter(setter(Builder::shapBaselineConfig))
            .constructor(ClarifyShapBaselineConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShapBaselineConfig").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_SAMPLES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfSamples").getter(getter(ClarifyShapConfig::numberOfSamples))
            .setter(setter(Builder::numberOfSamples))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfSamples").build()).build();

    private static final SdkField<Boolean> USE_LOGIT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseLogit").getter(getter(ClarifyShapConfig::useLogit)).setter(setter(Builder::useLogit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseLogit").build()).build();

    private static final SdkField<Integer> SEED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Seed")
            .getter(getter(ClarifyShapConfig::seed)).setter(setter(Builder::seed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Seed").build()).build();

    private static final SdkField<ClarifyTextConfig> TEXT_CONFIG_FIELD = SdkField
            .<ClarifyTextConfig> builder(MarshallingType.SDK_POJO).memberName("TextConfig")
            .getter(getter(ClarifyShapConfig::textConfig)).setter(setter(Builder::textConfig))
            .constructor(ClarifyTextConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHAP_BASELINE_CONFIG_FIELD,
            NUMBER_OF_SAMPLES_FIELD, USE_LOGIT_FIELD, SEED_FIELD, TEXT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ShapBaselineConfig", SHAP_BASELINE_CONFIG_FIELD);
                    put("NumberOfSamples", NUMBER_OF_SAMPLES_FIELD);
                    put("UseLogit", USE_LOGIT_FIELD);
                    put("Seed", SEED_FIELD);
                    put("TextConfig", TEXT_CONFIG_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final ClarifyShapBaselineConfig shapBaselineConfig;

    private final Integer numberOfSamples;

    private final Boolean useLogit;

    private final Integer seed;

    private final ClarifyTextConfig textConfig;

    private ClarifyShapConfig(BuilderImpl builder) {
        this.shapBaselineConfig = builder.shapBaselineConfig;
        this.numberOfSamples = builder.numberOfSamples;
        this.useLogit = builder.useLogit;
        this.seed = builder.seed;
        this.textConfig = builder.textConfig;
    }

    /**
     * <p>
     * The configuration for the SHAP baseline of the Kernal SHAP algorithm.
     * </p>
     * 
     * @return The configuration for the SHAP baseline of the Kernal SHAP algorithm.
     */
    public final ClarifyShapBaselineConfig shapBaselineConfig() {
        return shapBaselineConfig;
    }

    /**
     * <p>
     * The number of samples to be used for analysis by the Kernal SHAP algorithm.
     * </p>
     * <note>
     * <p>
     * The number of samples determines the size of the synthetic dataset, which has an impact on latency of
     * explainability requests. For more information, see the <b>Synthetic data</b> of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html"
     * >Configure and create an endpoint</a>.
     * </p>
     * </note>
     * 
     * @return The number of samples to be used for analysis by the Kernal SHAP algorithm. </p> <note>
     *         <p>
     *         The number of samples determines the size of the synthetic dataset, which has an impact on latency of
     *         explainability requests. For more information, see the <b>Synthetic data</b> of <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html"
     *         >Configure and create an endpoint</a>.
     *         </p>
     */
    public final Integer numberOfSamples() {
        return numberOfSamples;
    }

    /**
     * <p>
     * A Boolean toggle to indicate if you want to use the logit function (true) or log-odds units (false) for model
     * predictions. Defaults to false.
     * </p>
     * 
     * @return A Boolean toggle to indicate if you want to use the logit function (true) or log-odds units (false) for
     *         model predictions. Defaults to false.
     */
    public final Boolean useLogit() {
        return useLogit;
    }

    /**
     * <p>
     * The starting value used to initialize the random number generator in the explainer. Provide a value for this
     * parameter to obtain a deterministic SHAP result.
     * </p>
     * 
     * @return The starting value used to initialize the random number generator in the explainer. Provide a value for
     *         this parameter to obtain a deterministic SHAP result.
     */
    public final Integer seed() {
        return seed;
    }

    /**
     * <p>
     * A parameter that indicates if text features are treated as text and explanations are provided for individual
     * units of text. Required for natural language processing (NLP) explainability only.
     * </p>
     * 
     * @return A parameter that indicates if text features are treated as text and explanations are provided for
     *         individual units of text. Required for natural language processing (NLP) explainability only.
     */
    public final ClarifyTextConfig textConfig() {
        return textConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(shapBaselineConfig());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfSamples());
        hashCode = 31 * hashCode + Objects.hashCode(useLogit());
        hashCode = 31 * hashCode + Objects.hashCode(seed());
        hashCode = 31 * hashCode + Objects.hashCode(textConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClarifyShapConfig)) {
            return false;
        }
        ClarifyShapConfig other = (ClarifyShapConfig) obj;
        return Objects.equals(shapBaselineConfig(), other.shapBaselineConfig())
                && Objects.equals(numberOfSamples(), other.numberOfSamples()) && Objects.equals(useLogit(), other.useLogit())
                && Objects.equals(seed(), other.seed()) && Objects.equals(textConfig(), other.textConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClarifyShapConfig").add("ShapBaselineConfig", shapBaselineConfig())
                .add("NumberOfSamples", numberOfSamples()).add("UseLogit", useLogit()).add("Seed", seed())
                .add("TextConfig", textConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShapBaselineConfig":
            return Optional.ofNullable(clazz.cast(shapBaselineConfig()));
        case "NumberOfSamples":
            return Optional.ofNullable(clazz.cast(numberOfSamples()));
        case "UseLogit":
            return Optional.ofNullable(clazz.cast(useLogit()));
        case "Seed":
            return Optional.ofNullable(clazz.cast(seed()));
        case "TextConfig":
            return Optional.ofNullable(clazz.cast(textConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClarifyShapConfig, T> g) {
        return obj -> g.apply((ClarifyShapConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClarifyShapConfig> {
        /**
         * <p>
         * The configuration for the SHAP baseline of the Kernal SHAP algorithm.
         * </p>
         * 
         * @param shapBaselineConfig
         *        The configuration for the SHAP baseline of the Kernal SHAP algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shapBaselineConfig(ClarifyShapBaselineConfig shapBaselineConfig);

        /**
         * <p>
         * The configuration for the SHAP baseline of the Kernal SHAP algorithm.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClarifyShapBaselineConfig.Builder}
         * avoiding the need to create one manually via {@link ClarifyShapBaselineConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClarifyShapBaselineConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #shapBaselineConfig(ClarifyShapBaselineConfig)}.
         * 
         * @param shapBaselineConfig
         *        a consumer that will call methods on {@link ClarifyShapBaselineConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shapBaselineConfig(ClarifyShapBaselineConfig)
         */
        default Builder shapBaselineConfig(Consumer<ClarifyShapBaselineConfig.Builder> shapBaselineConfig) {
            return shapBaselineConfig(ClarifyShapBaselineConfig.builder().applyMutation(shapBaselineConfig).build());
        }

        /**
         * <p>
         * The number of samples to be used for analysis by the Kernal SHAP algorithm.
         * </p>
         * <note>
         * <p>
         * The number of samples determines the size of the synthetic dataset, which has an impact on latency of
         * explainability requests. For more information, see the <b>Synthetic data</b> of <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html"
         * >Configure and create an endpoint</a>.
         * </p>
         * </note>
         * 
         * @param numberOfSamples
         *        The number of samples to be used for analysis by the Kernal SHAP algorithm. </p> <note>
         *        <p>
         *        The number of samples determines the size of the synthetic dataset, which has an impact on latency of
         *        explainability requests. For more information, see the <b>Synthetic data</b> of <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html"
         *        >Configure and create an endpoint</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfSamples(Integer numberOfSamples);

        /**
         * <p>
         * A Boolean toggle to indicate if you want to use the logit function (true) or log-odds units (false) for model
         * predictions. Defaults to false.
         * </p>
         * 
         * @param useLogit
         *        A Boolean toggle to indicate if you want to use the logit function (true) or log-odds units (false)
         *        for model predictions. Defaults to false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useLogit(Boolean useLogit);

        /**
         * <p>
         * The starting value used to initialize the random number generator in the explainer. Provide a value for this
         * parameter to obtain a deterministic SHAP result.
         * </p>
         * 
         * @param seed
         *        The starting value used to initialize the random number generator in the explainer. Provide a value
         *        for this parameter to obtain a deterministic SHAP result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder seed(Integer seed);

        /**
         * <p>
         * A parameter that indicates if text features are treated as text and explanations are provided for individual
         * units of text. Required for natural language processing (NLP) explainability only.
         * </p>
         * 
         * @param textConfig
         *        A parameter that indicates if text features are treated as text and explanations are provided for
         *        individual units of text. Required for natural language processing (NLP) explainability only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textConfig(ClarifyTextConfig textConfig);

        /**
         * <p>
         * A parameter that indicates if text features are treated as text and explanations are provided for individual
         * units of text. Required for natural language processing (NLP) explainability only.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClarifyTextConfig.Builder} avoiding the
         * need to create one manually via {@link ClarifyTextConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClarifyTextConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #textConfig(ClarifyTextConfig)}.
         * 
         * @param textConfig
         *        a consumer that will call methods on {@link ClarifyTextConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textConfig(ClarifyTextConfig)
         */
        default Builder textConfig(Consumer<ClarifyTextConfig.Builder> textConfig) {
            return textConfig(ClarifyTextConfig.builder().applyMutation(textConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ClarifyShapBaselineConfig shapBaselineConfig;

        private Integer numberOfSamples;

        private Boolean useLogit;

        private Integer seed;

        private ClarifyTextConfig textConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ClarifyShapConfig model) {
            shapBaselineConfig(model.shapBaselineConfig);
            numberOfSamples(model.numberOfSamples);
            useLogit(model.useLogit);
            seed(model.seed);
            textConfig(model.textConfig);
        }

        public final ClarifyShapBaselineConfig.Builder getShapBaselineConfig() {
            return shapBaselineConfig != null ? shapBaselineConfig.toBuilder() : null;
        }

        public final void setShapBaselineConfig(ClarifyShapBaselineConfig.BuilderImpl shapBaselineConfig) {
            this.shapBaselineConfig = shapBaselineConfig != null ? shapBaselineConfig.build() : null;
        }

        @Override
        public final Builder shapBaselineConfig(ClarifyShapBaselineConfig shapBaselineConfig) {
            this.shapBaselineConfig = shapBaselineConfig;
            return this;
        }

        public final Integer getNumberOfSamples() {
            return numberOfSamples;
        }

        public final void setNumberOfSamples(Integer numberOfSamples) {
            this.numberOfSamples = numberOfSamples;
        }

        @Override
        public final Builder numberOfSamples(Integer numberOfSamples) {
            this.numberOfSamples = numberOfSamples;
            return this;
        }

        public final Boolean getUseLogit() {
            return useLogit;
        }

        public final void setUseLogit(Boolean useLogit) {
            this.useLogit = useLogit;
        }

        @Override
        public final Builder useLogit(Boolean useLogit) {
            this.useLogit = useLogit;
            return this;
        }

        public final Integer getSeed() {
            return seed;
        }

        public final void setSeed(Integer seed) {
            this.seed = seed;
        }

        @Override
        public final Builder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public final ClarifyTextConfig.Builder getTextConfig() {
            return textConfig != null ? textConfig.toBuilder() : null;
        }

        public final void setTextConfig(ClarifyTextConfig.BuilderImpl textConfig) {
            this.textConfig = textConfig != null ? textConfig.build() : null;
        }

        @Override
        public final Builder textConfig(ClarifyTextConfig textConfig) {
            this.textConfig = textConfig;
            return this;
        }

        @Override
        public ClarifyShapConfig build() {
            return new ClarifyShapConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
