/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A parameter used to configure the SageMaker Clarify explainer to treat text features as text so that explanations are
 * provided for individual units of text. Required only for natural language processing (NLP) explainability.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClarifyTextConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ClarifyTextConfig.Builder, ClarifyTextConfig> {
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Language").getter(getter(ClarifyTextConfig::languageAsString)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()).build();

    private static final SdkField<String> GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Granularity").getter(getter(ClarifyTextConfig::granularityAsString))
            .setter(setter(Builder::granularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Granularity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_FIELD,
            GRANULARITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Language", LANGUAGE_FIELD);
                    put("Granularity", GRANULARITY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String language;

    private final String granularity;

    private ClarifyTextConfig(BuilderImpl builder) {
        this.language = builder.language;
        this.granularity = builder.granularity;
    }

    /**
     * <p>
     * Specifies the language of the text features in <a
     * href=" https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes">ISO 639-1</a> or <a
     * href="https://en.wikipedia.org/wiki/ISO_639-3">ISO 639-3</a> code of a supported language.
     * </p>
     * <note>
     * <p>
     * For a mix of multiple languages, use code <code>'xx'</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #language} will
     * return {@link ClarifyTextLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #languageAsString}.
     * </p>
     * 
     * @return Specifies the language of the text features in <a
     *         href=" https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes">ISO 639-1</a> or <a
     *         href="https://en.wikipedia.org/wiki/ISO_639-3">ISO 639-3</a> code of a supported language. </p> <note>
     *         <p>
     *         For a mix of multiple languages, use code <code>'xx'</code>.
     *         </p>
     * @see ClarifyTextLanguage
     */
    public final ClarifyTextLanguage language() {
        return ClarifyTextLanguage.fromValue(language);
    }

    /**
     * <p>
     * Specifies the language of the text features in <a
     * href=" https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes">ISO 639-1</a> or <a
     * href="https://en.wikipedia.org/wiki/ISO_639-3">ISO 639-3</a> code of a supported language.
     * </p>
     * <note>
     * <p>
     * For a mix of multiple languages, use code <code>'xx'</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #language} will
     * return {@link ClarifyTextLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #languageAsString}.
     * </p>
     * 
     * @return Specifies the language of the text features in <a
     *         href=" https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes">ISO 639-1</a> or <a
     *         href="https://en.wikipedia.org/wiki/ISO_639-3">ISO 639-3</a> code of a supported language. </p> <note>
     *         <p>
     *         For a mix of multiple languages, use code <code>'xx'</code>.
     *         </p>
     * @see ClarifyTextLanguage
     */
    public final String languageAsString() {
        return language;
    }

    /**
     * <p>
     * The unit of granularity for the analysis of text features. For example, if the unit is <code>'token'</code>, then
     * each token (like a word in English) of the text is treated as a feature. SHAP values are computed for each
     * unit/feature.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granularity} will
     * return {@link ClarifyTextGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #granularityAsString}.
     * </p>
     * 
     * @return The unit of granularity for the analysis of text features. For example, if the unit is
     *         <code>'token'</code>, then each token (like a word in English) of the text is treated as a feature. SHAP
     *         values are computed for each unit/feature.
     * @see ClarifyTextGranularity
     */
    public final ClarifyTextGranularity granularity() {
        return ClarifyTextGranularity.fromValue(granularity);
    }

    /**
     * <p>
     * The unit of granularity for the analysis of text features. For example, if the unit is <code>'token'</code>, then
     * each token (like a word in English) of the text is treated as a feature. SHAP values are computed for each
     * unit/feature.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granularity} will
     * return {@link ClarifyTextGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #granularityAsString}.
     * </p>
     * 
     * @return The unit of granularity for the analysis of text features. For example, if the unit is
     *         <code>'token'</code>, then each token (like a word in English) of the text is treated as a feature. SHAP
     *         values are computed for each unit/feature.
     * @see ClarifyTextGranularity
     */
    public final String granularityAsString() {
        return granularity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(languageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(granularityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClarifyTextConfig)) {
            return false;
        }
        ClarifyTextConfig other = (ClarifyTextConfig) obj;
        return Objects.equals(languageAsString(), other.languageAsString())
                && Objects.equals(granularityAsString(), other.granularityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClarifyTextConfig").add("Language", languageAsString())
                .add("Granularity", granularityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Language":
            return Optional.ofNullable(clazz.cast(languageAsString()));
        case "Granularity":
            return Optional.ofNullable(clazz.cast(granularityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClarifyTextConfig, T> g) {
        return obj -> g.apply((ClarifyTextConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClarifyTextConfig> {
        /**
         * <p>
         * Specifies the language of the text features in <a
         * href=" https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes">ISO 639-1</a> or <a
         * href="https://en.wikipedia.org/wiki/ISO_639-3">ISO 639-3</a> code of a supported language.
         * </p>
         * <note>
         * <p>
         * For a mix of multiple languages, use code <code>'xx'</code>.
         * </p>
         * </note>
         * 
         * @param language
         *        Specifies the language of the text features in <a
         *        href=" https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes">ISO 639-1</a> or <a
         *        href="https://en.wikipedia.org/wiki/ISO_639-3">ISO 639-3</a> code of a supported language. </p> <note>
         *        <p>
         *        For a mix of multiple languages, use code <code>'xx'</code>.
         *        </p>
         * @see ClarifyTextLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClarifyTextLanguage
         */
        Builder language(String language);

        /**
         * <p>
         * Specifies the language of the text features in <a
         * href=" https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes">ISO 639-1</a> or <a
         * href="https://en.wikipedia.org/wiki/ISO_639-3">ISO 639-3</a> code of a supported language.
         * </p>
         * <note>
         * <p>
         * For a mix of multiple languages, use code <code>'xx'</code>.
         * </p>
         * </note>
         * 
         * @param language
         *        Specifies the language of the text features in <a
         *        href=" https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes">ISO 639-1</a> or <a
         *        href="https://en.wikipedia.org/wiki/ISO_639-3">ISO 639-3</a> code of a supported language. </p> <note>
         *        <p>
         *        For a mix of multiple languages, use code <code>'xx'</code>.
         *        </p>
         * @see ClarifyTextLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClarifyTextLanguage
         */
        Builder language(ClarifyTextLanguage language);

        /**
         * <p>
         * The unit of granularity for the analysis of text features. For example, if the unit is <code>'token'</code>,
         * then each token (like a word in English) of the text is treated as a feature. SHAP values are computed for
         * each unit/feature.
         * </p>
         * 
         * @param granularity
         *        The unit of granularity for the analysis of text features. For example, if the unit is
         *        <code>'token'</code>, then each token (like a word in English) of the text is treated as a feature.
         *        SHAP values are computed for each unit/feature.
         * @see ClarifyTextGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClarifyTextGranularity
         */
        Builder granularity(String granularity);

        /**
         * <p>
         * The unit of granularity for the analysis of text features. For example, if the unit is <code>'token'</code>,
         * then each token (like a word in English) of the text is treated as a feature. SHAP values are computed for
         * each unit/feature.
         * </p>
         * 
         * @param granularity
         *        The unit of granularity for the analysis of text features. For example, if the unit is
         *        <code>'token'</code>, then each token (like a word in English) of the text is treated as a feature.
         *        SHAP values are computed for each unit/feature.
         * @see ClarifyTextGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClarifyTextGranularity
         */
        Builder granularity(ClarifyTextGranularity granularity);
    }

    static final class BuilderImpl implements Builder {
        private String language;

        private String granularity;

        private BuilderImpl() {
        }

        private BuilderImpl(ClarifyTextConfig model) {
            language(model.language);
            granularity(model.granularity);
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public final Builder language(ClarifyTextLanguage language) {
            this.language(language == null ? null : language.toString());
            return this;
        }

        public final String getGranularity() {
            return granularity;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public final Builder granularity(ClarifyTextGranularity granularity) {
            this.granularity(granularity == null ? null : granularity.toString());
            return this;
        }

        @Override
        public ClarifyTextConfig build() {
            return new ClarifyTextConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
