/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the configuration for attaching an additional Amazon Elastic Block Store (EBS) volume to each instance of the
 * SageMaker HyperPod cluster instance group. To learn more, see <a href=
 * "https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-release-notes.html#sagemaker-hyperpod-release-notes-20240620"
 * >SageMaker HyperPod release notes: June 20, 2024</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterEbsVolumeConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterEbsVolumeConfig.Builder, ClusterEbsVolumeConfig> {
    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumeSizeInGB").getter(getter(ClusterEbsVolumeConfig::volumeSizeInGB))
            .setter(setter(Builder::volumeSizeInGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInGB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_SIZE_IN_GB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("VolumeSizeInGB", VOLUME_SIZE_IN_GB_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer volumeSizeInGB;

    private ClusterEbsVolumeConfig(BuilderImpl builder) {
        this.volumeSizeInGB = builder.volumeSizeInGB;
    }

    /**
     * <p>
     * The size in gigabytes (GB) of the additional EBS volume to be attached to the instances in the SageMaker HyperPod
     * cluster instance group. The additional EBS volume is attached to each instance within the SageMaker HyperPod
     * cluster instance group and mounted to <code>/opt/sagemaker</code>.
     * </p>
     * 
     * @return The size in gigabytes (GB) of the additional EBS volume to be attached to the instances in the SageMaker
     *         HyperPod cluster instance group. The additional EBS volume is attached to each instance within the
     *         SageMaker HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code>.
     */
    public final Integer volumeSizeInGB() {
        return volumeSizeInGB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeSizeInGB());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterEbsVolumeConfig)) {
            return false;
        }
        ClusterEbsVolumeConfig other = (ClusterEbsVolumeConfig) obj;
        return Objects.equals(volumeSizeInGB(), other.volumeSizeInGB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterEbsVolumeConfig").add("VolumeSizeInGB", volumeSizeInGB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeSizeInGB":
            return Optional.ofNullable(clazz.cast(volumeSizeInGB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClusterEbsVolumeConfig, T> g) {
        return obj -> g.apply((ClusterEbsVolumeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterEbsVolumeConfig> {
        /**
         * <p>
         * The size in gigabytes (GB) of the additional EBS volume to be attached to the instances in the SageMaker
         * HyperPod cluster instance group. The additional EBS volume is attached to each instance within the SageMaker
         * HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code>.
         * </p>
         * 
         * @param volumeSizeInGB
         *        The size in gigabytes (GB) of the additional EBS volume to be attached to the instances in the
         *        SageMaker HyperPod cluster instance group. The additional EBS volume is attached to each instance
         *        within the SageMaker HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSizeInGB(Integer volumeSizeInGB);
    }

    static final class BuilderImpl implements Builder {
        private Integer volumeSizeInGB;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterEbsVolumeConfig model) {
            volumeSizeInGB(model.volumeSizeInGB);
        }

        public final Integer getVolumeSizeInGB() {
            return volumeSizeInGB;
        }

        public final void setVolumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
        }

        @Override
        public final Builder volumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
            return this;
        }

        @Override
        public ClusterEbsVolumeConfig build() {
            return new ClusterEbsVolumeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
