/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lists a summary of the properties of an instance (also called a <i>node</i> interchangeably) of a SageMaker HyperPod
 * cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterNodeSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterNodeSummary.Builder, ClusterNodeSummary> {
    private static final SdkField<String> INSTANCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceGroupName").getter(getter(ClusterNodeSummary::instanceGroupName))
            .setter(setter(Builder::instanceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupName").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(ClusterNodeSummary::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(ClusterNodeSummary::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<Instant> LAUNCH_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LaunchTime").getter(getter(ClusterNodeSummary::launchTime)).setter(setter(Builder::launchTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTime").build()).build();

    private static final SdkField<ClusterInstanceStatusDetails> INSTANCE_STATUS_FIELD = SdkField
            .<ClusterInstanceStatusDetails> builder(MarshallingType.SDK_POJO).memberName("InstanceStatus")
            .getter(getter(ClusterNodeSummary::instanceStatus)).setter(setter(Builder::instanceStatus))
            .constructor(ClusterInstanceStatusDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_GROUP_NAME_FIELD,
            INSTANCE_ID_FIELD, INSTANCE_TYPE_FIELD, LAUNCH_TIME_FIELD, INSTANCE_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("InstanceGroupName", INSTANCE_GROUP_NAME_FIELD);
                    put("InstanceId", INSTANCE_ID_FIELD);
                    put("InstanceType", INSTANCE_TYPE_FIELD);
                    put("LaunchTime", LAUNCH_TIME_FIELD);
                    put("InstanceStatus", INSTANCE_STATUS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String instanceGroupName;

    private final String instanceId;

    private final String instanceType;

    private final Instant launchTime;

    private final ClusterInstanceStatusDetails instanceStatus;

    private ClusterNodeSummary(BuilderImpl builder) {
        this.instanceGroupName = builder.instanceGroupName;
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.launchTime = builder.launchTime;
        this.instanceStatus = builder.instanceStatus;
    }

    /**
     * <p>
     * The name of the instance group in which the instance is.
     * </p>
     * 
     * @return The name of the instance group in which the instance is.
     */
    public final String instanceGroupName() {
        return instanceGroupName;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The type of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ClusterInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type of the instance.
     * @see ClusterInstanceType
     */
    public final ClusterInstanceType instanceType() {
        return ClusterInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The type of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ClusterInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type of the instance.
     * @see ClusterInstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The time when the instance is launched.
     * </p>
     * 
     * @return The time when the instance is launched.
     */
    public final Instant launchTime() {
        return launchTime;
    }

    /**
     * <p>
     * The status of the instance.
     * </p>
     * 
     * @return The status of the instance.
     */
    public final ClusterInstanceStatusDetails instanceStatus() {
        return instanceStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(launchTime());
        hashCode = 31 * hashCode + Objects.hashCode(instanceStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterNodeSummary)) {
            return false;
        }
        ClusterNodeSummary other = (ClusterNodeSummary) obj;
        return Objects.equals(instanceGroupName(), other.instanceGroupName()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(launchTime(), other.launchTime()) && Objects.equals(instanceStatus(), other.instanceStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterNodeSummary").add("InstanceGroupName", instanceGroupName())
                .add("InstanceId", instanceId()).add("InstanceType", instanceTypeAsString()).add("LaunchTime", launchTime())
                .add("InstanceStatus", instanceStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceGroupName":
            return Optional.ofNullable(clazz.cast(instanceGroupName()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "LaunchTime":
            return Optional.ofNullable(clazz.cast(launchTime()));
        case "InstanceStatus":
            return Optional.ofNullable(clazz.cast(instanceStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClusterNodeSummary, T> g) {
        return obj -> g.apply((ClusterNodeSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterNodeSummary> {
        /**
         * <p>
         * The name of the instance group in which the instance is.
         * </p>
         * 
         * @param instanceGroupName
         *        The name of the instance group in which the instance is.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupName(String instanceGroupName);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The type of the instance.
         * </p>
         * 
         * @param instanceType
         *        The type of the instance.
         * @see ClusterInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The type of the instance.
         * </p>
         * 
         * @param instanceType
         *        The type of the instance.
         * @see ClusterInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterInstanceType
         */
        Builder instanceType(ClusterInstanceType instanceType);

        /**
         * <p>
         * The time when the instance is launched.
         * </p>
         * 
         * @param launchTime
         *        The time when the instance is launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTime(Instant launchTime);

        /**
         * <p>
         * The status of the instance.
         * </p>
         * 
         * @param instanceStatus
         *        The status of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStatus(ClusterInstanceStatusDetails instanceStatus);

        /**
         * <p>
         * The status of the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterInstanceStatusDetails.Builder}
         * avoiding the need to create one manually via {@link ClusterInstanceStatusDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterInstanceStatusDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceStatus(ClusterInstanceStatusDetails)}.
         * 
         * @param instanceStatus
         *        a consumer that will call methods on {@link ClusterInstanceStatusDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceStatus(ClusterInstanceStatusDetails)
         */
        default Builder instanceStatus(Consumer<ClusterInstanceStatusDetails.Builder> instanceStatus) {
            return instanceStatus(ClusterInstanceStatusDetails.builder().applyMutation(instanceStatus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String instanceGroupName;

        private String instanceId;

        private String instanceType;

        private Instant launchTime;

        private ClusterInstanceStatusDetails instanceStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterNodeSummary model) {
            instanceGroupName(model.instanceGroupName);
            instanceId(model.instanceId);
            instanceType(model.instanceType);
            launchTime(model.launchTime);
            instanceStatus(model.instanceStatus);
        }

        public final String getInstanceGroupName() {
            return instanceGroupName;
        }

        public final void setInstanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
        }

        @Override
        public final Builder instanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ClusterInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Instant getLaunchTime() {
            return launchTime;
        }

        public final void setLaunchTime(Instant launchTime) {
            this.launchTime = launchTime;
        }

        @Override
        public final Builder launchTime(Instant launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public final ClusterInstanceStatusDetails.Builder getInstanceStatus() {
            return instanceStatus != null ? instanceStatus.toBuilder() : null;
        }

        public final void setInstanceStatus(ClusterInstanceStatusDetails.BuilderImpl instanceStatus) {
            this.instanceStatus = instanceStatus != null ? instanceStatus.build() : null;
        }

        @Override
        public final Builder instanceStatus(ClusterInstanceStatusDetails instanceStatus) {
            this.instanceStatus = instanceStatus;
            return this;
        }

        @Override
        public ClusterNodeSummary build() {
            return new ClusterNodeSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
