/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A Git repository that SageMaker automatically displays to users for cloning in the JupyterServer application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeRepository implements SdkPojo, Serializable, ToCopyableBuilder<CodeRepository.Builder, CodeRepository> {
    private static final SdkField<String> REPOSITORY_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryUrl").getter(getter(CodeRepository::repositoryUrl)).setter(setter(Builder::repositoryUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("RepositoryUrl", REPOSITORY_URL_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String repositoryUrl;

    private CodeRepository(BuilderImpl builder) {
        this.repositoryUrl = builder.repositoryUrl;
    }

    /**
     * <p>
     * The URL of the Git repository.
     * </p>
     * 
     * @return The URL of the Git repository.
     */
    public final String repositoryUrl() {
        return repositoryUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeRepository)) {
            return false;
        }
        CodeRepository other = (CodeRepository) obj;
        return Objects.equals(repositoryUrl(), other.repositoryUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeRepository").add("RepositoryUrl", repositoryUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RepositoryUrl":
            return Optional.ofNullable(clazz.cast(repositoryUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CodeRepository, T> g) {
        return obj -> g.apply((CodeRepository) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeRepository> {
        /**
         * <p>
         * The URL of the Git repository.
         * </p>
         * 
         * @param repositoryUrl
         *        The URL of the Git repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryUrl(String repositoryUrl);
    }

    static final class BuilderImpl implements Builder {
        private String repositoryUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeRepository model) {
            repositoryUrl(model.repositoryUrl);
        }

        public final String getRepositoryUrl() {
            return repositoryUrl;
        }

        public final void setRepositoryUrl(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
        }

        @Override
        public final Builder repositoryUrl(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
            return this;
        }

        @Override
        public CodeRepository build() {
            return new CodeRepository(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
