/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata for a Condition step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConditionStepMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ConditionStepMetadata.Builder, ConditionStepMetadata> {
    private static final SdkField<String> OUTCOME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Outcome")
            .getter(getter(ConditionStepMetadata::outcomeAsString)).setter(setter(Builder::outcome))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outcome").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTCOME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Outcome", OUTCOME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String outcome;

    private ConditionStepMetadata(BuilderImpl builder) {
        this.outcome = builder.outcome;
    }

    /**
     * <p>
     * The outcome of the Condition step evaluation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outcome} will
     * return {@link ConditionOutcome#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outcomeAsString}.
     * </p>
     * 
     * @return The outcome of the Condition step evaluation.
     * @see ConditionOutcome
     */
    public final ConditionOutcome outcome() {
        return ConditionOutcome.fromValue(outcome);
    }

    /**
     * <p>
     * The outcome of the Condition step evaluation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outcome} will
     * return {@link ConditionOutcome#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outcomeAsString}.
     * </p>
     * 
     * @return The outcome of the Condition step evaluation.
     * @see ConditionOutcome
     */
    public final String outcomeAsString() {
        return outcome;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outcomeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionStepMetadata)) {
            return false;
        }
        ConditionStepMetadata other = (ConditionStepMetadata) obj;
        return Objects.equals(outcomeAsString(), other.outcomeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConditionStepMetadata").add("Outcome", outcomeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Outcome":
            return Optional.ofNullable(clazz.cast(outcomeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConditionStepMetadata, T> g) {
        return obj -> g.apply((ConditionStepMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConditionStepMetadata> {
        /**
         * <p>
         * The outcome of the Condition step evaluation.
         * </p>
         * 
         * @param outcome
         *        The outcome of the Condition step evaluation.
         * @see ConditionOutcome
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionOutcome
         */
        Builder outcome(String outcome);

        /**
         * <p>
         * The outcome of the Condition step evaluation.
         * </p>
         * 
         * @param outcome
         *        The outcome of the Condition step evaluation.
         * @see ConditionOutcome
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionOutcome
         */
        Builder outcome(ConditionOutcome outcome);
    }

    static final class BuilderImpl implements Builder {
        private String outcome;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionStepMetadata model) {
            outcome(model.outcome);
        }

        public final String getOutcome() {
            return outcome;
        }

        public final void setOutcome(String outcome) {
            this.outcome = outcome;
        }

        @Override
        public final Builder outcome(String outcome) {
            this.outcome = outcome;
            return this;
        }

        @Override
        public final Builder outcome(ConditionOutcome outcome) {
            this.outcome(outcome == null ? null : outcome.toString());
            return this;
        }

        @Override
        public ConditionStepMetadata build() {
            return new ConditionStepMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
