/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFeatureGroupRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateFeatureGroupRequest.Builder, CreateFeatureGroupRequest> {
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureGroupName").getter(getter(CreateFeatureGroupRequest::featureGroupName))
            .setter(setter(Builder::featureGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupName").build()).build();

    private static final SdkField<String> RECORD_IDENTIFIER_FEATURE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecordIdentifierFeatureName")
            .getter(getter(CreateFeatureGroupRequest::recordIdentifierFeatureName))
            .setter(setter(Builder::recordIdentifierFeatureName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordIdentifierFeatureName")
                    .build()).build();

    private static final SdkField<String> EVENT_TIME_FEATURE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventTimeFeatureName").getter(getter(CreateFeatureGroupRequest::eventTimeFeatureName))
            .setter(setter(Builder::eventTimeFeatureName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTimeFeatureName").build())
            .build();

    private static final SdkField<List<FeatureDefinition>> FEATURE_DEFINITIONS_FIELD = SdkField
            .<List<FeatureDefinition>> builder(MarshallingType.LIST)
            .memberName("FeatureDefinitions")
            .getter(getter(CreateFeatureGroupRequest::featureDefinitions))
            .setter(setter(Builder::featureDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FeatureDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(FeatureDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<OnlineStoreConfig> ONLINE_STORE_CONFIG_FIELD = SdkField
            .<OnlineStoreConfig> builder(MarshallingType.SDK_POJO).memberName("OnlineStoreConfig")
            .getter(getter(CreateFeatureGroupRequest::onlineStoreConfig)).setter(setter(Builder::onlineStoreConfig))
            .constructor(OnlineStoreConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnlineStoreConfig").build()).build();

    private static final SdkField<OfflineStoreConfig> OFFLINE_STORE_CONFIG_FIELD = SdkField
            .<OfflineStoreConfig> builder(MarshallingType.SDK_POJO).memberName("OfflineStoreConfig")
            .getter(getter(CreateFeatureGroupRequest::offlineStoreConfig)).setter(setter(Builder::offlineStoreConfig))
            .constructor(OfflineStoreConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfflineStoreConfig").build())
            .build();

    private static final SdkField<ThroughputConfig> THROUGHPUT_CONFIG_FIELD = SdkField
            .<ThroughputConfig> builder(MarshallingType.SDK_POJO).memberName("ThroughputConfig")
            .getter(getter(CreateFeatureGroupRequest::throughputConfig)).setter(setter(Builder::throughputConfig))
            .constructor(ThroughputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputConfig").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateFeatureGroupRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateFeatureGroupRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateFeatureGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_NAME_FIELD,
            RECORD_IDENTIFIER_FEATURE_NAME_FIELD, EVENT_TIME_FEATURE_NAME_FIELD, FEATURE_DEFINITIONS_FIELD,
            ONLINE_STORE_CONFIG_FIELD, OFFLINE_STORE_CONFIG_FIELD, THROUGHPUT_CONFIG_FIELD, ROLE_ARN_FIELD, DESCRIPTION_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("FeatureGroupName", FEATURE_GROUP_NAME_FIELD);
                    put("RecordIdentifierFeatureName", RECORD_IDENTIFIER_FEATURE_NAME_FIELD);
                    put("EventTimeFeatureName", EVENT_TIME_FEATURE_NAME_FIELD);
                    put("FeatureDefinitions", FEATURE_DEFINITIONS_FIELD);
                    put("OnlineStoreConfig", ONLINE_STORE_CONFIG_FIELD);
                    put("OfflineStoreConfig", OFFLINE_STORE_CONFIG_FIELD);
                    put("ThroughputConfig", THROUGHPUT_CONFIG_FIELD);
                    put("RoleArn", ROLE_ARN_FIELD);
                    put("Description", DESCRIPTION_FIELD);
                    put("Tags", TAGS_FIELD);
                }
            });

    private final String featureGroupName;

    private final String recordIdentifierFeatureName;

    private final String eventTimeFeatureName;

    private final List<FeatureDefinition> featureDefinitions;

    private final OnlineStoreConfig onlineStoreConfig;

    private final OfflineStoreConfig offlineStoreConfig;

    private final ThroughputConfig throughputConfig;

    private final String roleArn;

    private final String description;

    private final List<Tag> tags;

    private CreateFeatureGroupRequest(BuilderImpl builder) {
        super(builder);
        this.featureGroupName = builder.featureGroupName;
        this.recordIdentifierFeatureName = builder.recordIdentifierFeatureName;
        this.eventTimeFeatureName = builder.eventTimeFeatureName;
        this.featureDefinitions = builder.featureDefinitions;
        this.onlineStoreConfig = builder.onlineStoreConfig;
        this.offlineStoreConfig = builder.offlineStoreConfig;
        this.throughputConfig = builder.throughputConfig;
        this.roleArn = builder.roleArn;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the <code>FeatureGroup</code>. The name must be unique within an Amazon Web Services Region in an
     * Amazon Web Services account.
     * </p>
     * <p>
     * The name:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must start with an alphanumeric character.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can only include alphanumeric characters, underscores, and hyphens. Spaces are not allowed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the <code>FeatureGroup</code>. The name must be unique within an Amazon Web Services Region
     *         in an Amazon Web Services account.</p>
     *         <p>
     *         The name:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must start with an alphanumeric character.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can only include alphanumeric characters, underscores, and hyphens. Spaces are not allowed.
     *         </p>
     *         </li>
     */
    public final String featureGroupName() {
        return featureGroupName;
    }

    /**
     * <p>
     * The name of the <code>Feature</code> whose value uniquely identifies a <code>Record</code> defined in the
     * <code>FeatureStore</code>. Only the latest record per identifier value will be stored in the
     * <code>OnlineStore</code>. <code>RecordIdentifierFeatureName</code> must be one of feature definitions' names.
     * </p>
     * <p>
     * You use the <code>RecordIdentifierFeatureName</code> to access data in a <code>FeatureStore</code>.
     * </p>
     * <p>
     * This name:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must start with an alphanumeric character.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can only contains alphanumeric characters, hyphens, underscores. Spaces are not allowed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the <code>Feature</code> whose value uniquely identifies a <code>Record</code> defined in the
     *         <code>FeatureStore</code>. Only the latest record per identifier value will be stored in the
     *         <code>OnlineStore</code>. <code>RecordIdentifierFeatureName</code> must be one of feature definitions'
     *         names.</p>
     *         <p>
     *         You use the <code>RecordIdentifierFeatureName</code> to access data in a <code>FeatureStore</code>.
     *         </p>
     *         <p>
     *         This name:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must start with an alphanumeric character.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can only contains alphanumeric characters, hyphens, underscores. Spaces are not allowed.
     *         </p>
     *         </li>
     */
    public final String recordIdentifierFeatureName() {
        return recordIdentifierFeatureName;
    }

    /**
     * <p>
     * The name of the feature that stores the <code>EventTime</code> of a <code>Record</code> in a
     * <code>FeatureGroup</code>.
     * </p>
     * <p>
     * An <code>EventTime</code> is a point in time when a new event occurs that corresponds to the creation or update
     * of a <code>Record</code> in a <code>FeatureGroup</code>. All <code>Records</code> in the
     * <code>FeatureGroup</code> must have a corresponding <code>EventTime</code>.
     * </p>
     * <p>
     * An <code>EventTime</code> can be a <code>String</code> or <code>Fractional</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Fractional</code>: <code>EventTime</code> feature values must be a Unix timestamp in seconds.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>String</code>: <code>EventTime</code> feature values must be an ISO-8601 string in the format. The
     * following formats are supported <code>yyyy-MM-dd'T'HH:mm:ssZ</code> and <code>yyyy-MM-dd'T'HH:mm:ss.SSSZ</code>
     * where <code>yyyy</code>, <code>MM</code>, and <code>dd</code> represent the year, month, and day respectively and
     * <code>HH</code>, <code>mm</code>, <code>ss</code>, and if applicable, <code>SSS</code> represent the hour, month,
     * second and milliseconds respsectively. <code>'T'</code> and <code>Z</code> are constants.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the feature that stores the <code>EventTime</code> of a <code>Record</code> in a
     *         <code>FeatureGroup</code>.</p>
     *         <p>
     *         An <code>EventTime</code> is a point in time when a new event occurs that corresponds to the creation or
     *         update of a <code>Record</code> in a <code>FeatureGroup</code>. All <code>Records</code> in the
     *         <code>FeatureGroup</code> must have a corresponding <code>EventTime</code>.
     *         </p>
     *         <p>
     *         An <code>EventTime</code> can be a <code>String</code> or <code>Fractional</code>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Fractional</code>: <code>EventTime</code> feature values must be a Unix timestamp in seconds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>String</code>: <code>EventTime</code> feature values must be an ISO-8601 string in the format. The
     *         following formats are supported <code>yyyy-MM-dd'T'HH:mm:ssZ</code> and
     *         <code>yyyy-MM-dd'T'HH:mm:ss.SSSZ</code> where <code>yyyy</code>, <code>MM</code>, and <code>dd</code>
     *         represent the year, month, and day respectively and <code>HH</code>, <code>mm</code>, <code>ss</code>,
     *         and if applicable, <code>SSS</code> represent the hour, month, second and milliseconds respsectively.
     *         <code>'T'</code> and <code>Z</code> are constants.
     *         </p>
     *         </li>
     */
    public final String eventTimeFeatureName() {
        return eventTimeFeatureName;
    }

    /**
     * For responses, this returns true if the service returned a value for the FeatureDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFeatureDefinitions() {
        return featureDefinitions != null && !(featureDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>Feature</code> names and types. <code>Name</code> and <code>Type</code> is compulsory per
     * <code>Feature</code>.
     * </p>
     * <p>
     * Valid feature <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and
     * <code>String</code>.
     * </p>
     * <p>
     * <code>FeatureName</code>s cannot be any of the following: <code>is_deleted</code>, <code>write_time</code>,
     * <code>api_invocation_time</code>
     * </p>
     * <p>
     * You can create up to 2,500 <code>FeatureDefinition</code>s per <code>FeatureGroup</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatureDefinitions} method.
     * </p>
     * 
     * @return A list of <code>Feature</code> names and types. <code>Name</code> and <code>Type</code> is compulsory per
     *         <code>Feature</code>. </p>
     *         <p>
     *         Valid feature <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and
     *         <code>String</code>.
     *         </p>
     *         <p>
     *         <code>FeatureName</code>s cannot be any of the following: <code>is_deleted</code>,
     *         <code>write_time</code>, <code>api_invocation_time</code>
     *         </p>
     *         <p>
     *         You can create up to 2,500 <code>FeatureDefinition</code>s per <code>FeatureGroup</code>.
     */
    public final List<FeatureDefinition> featureDefinitions() {
        return featureDefinitions;
    }

    /**
     * <p>
     * You can turn the <code>OnlineStore</code> on or off by specifying <code>True</code> for the
     * <code>EnableOnlineStore</code> flag in <code>OnlineStoreConfig</code>.
     * </p>
     * <p>
     * You can also include an Amazon Web Services KMS key ID (<code>KMSKeyId</code>) for at-rest encryption of the
     * <code>OnlineStore</code>.
     * </p>
     * <p>
     * The default value is <code>False</code>.
     * </p>
     * 
     * @return You can turn the <code>OnlineStore</code> on or off by specifying <code>True</code> for the
     *         <code>EnableOnlineStore</code> flag in <code>OnlineStoreConfig</code>.</p>
     *         <p>
     *         You can also include an Amazon Web Services KMS key ID (<code>KMSKeyId</code>) for at-rest encryption of
     *         the <code>OnlineStore</code>.
     *         </p>
     *         <p>
     *         The default value is <code>False</code>.
     */
    public final OnlineStoreConfig onlineStoreConfig() {
        return onlineStoreConfig;
    }

    /**
     * <p>
     * Use this to configure an <code>OfflineFeatureStore</code>. This parameter allows you to specify:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The Amazon Simple Storage Service (Amazon S3) location of an <code>OfflineStore</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * A configuration for an Amazon Web Services Glue or Amazon Web Services Hive data catalog.
     * </p>
     * </li>
     * <li>
     * <p>
     * An KMS encryption key to encrypt the Amazon S3 location used for <code>OfflineStore</code>. If KMS encryption key
     * is not specified, by default we encrypt all data at rest using Amazon Web Services KMS key. By defining your <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-key.html">bucket-level key</a> for SSE, you
     * can reduce Amazon Web Services KMS requests costs by up to 99 percent.
     * </p>
     * </li>
     * <li>
     * <p>
     * Format for the offline store table. Supported formats are Glue (Default) and <a
     * href="https://iceberg.apache.org/">Apache Iceberg</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To learn more about this parameter, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OfflineStoreConfig.html"
     * >OfflineStoreConfig</a>.
     * </p>
     * 
     * @return Use this to configure an <code>OfflineFeatureStore</code>. This parameter allows you to specify:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The Amazon Simple Storage Service (Amazon S3) location of an <code>OfflineStore</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A configuration for an Amazon Web Services Glue or Amazon Web Services Hive data catalog.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An KMS encryption key to encrypt the Amazon S3 location used for <code>OfflineStore</code>. If KMS
     *         encryption key is not specified, by default we encrypt all data at rest using Amazon Web Services KMS
     *         key. By defining your <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-key.html">bucket-level key</a> for
     *         SSE, you can reduce Amazon Web Services KMS requests costs by up to 99 percent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Format for the offline store table. Supported formats are Glue (Default) and <a
     *         href="https://iceberg.apache.org/">Apache Iceberg</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To learn more about this parameter, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OfflineStoreConfig.html"
     *         >OfflineStoreConfig</a>.
     */
    public final OfflineStoreConfig offlineStoreConfig() {
        return offlineStoreConfig;
    }

    /**
     * Returns the value of the ThroughputConfig property for this object.
     * 
     * @return The value of the ThroughputConfig property for this object.
     */
    public final ThroughputConfig throughputConfig() {
        return throughputConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the <code>OfflineStore</code>
     * if an <code>OfflineStoreConfig</code> is provided.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the
     *         <code>OfflineStore</code> if an <code>OfflineStoreConfig</code> is provided.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * A free-form description of a <code>FeatureGroup</code>.
     * </p>
     * 
     * @return A free-form description of a <code>FeatureGroup</code>.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags used to identify <code>Features</code> in each <code>FeatureGroup</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags used to identify <code>Features</code> in each <code>FeatureGroup</code>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(recordIdentifierFeatureName());
        hashCode = 31 * hashCode + Objects.hashCode(eventTimeFeatureName());
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatureDefinitions() ? featureDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(onlineStoreConfig());
        hashCode = 31 * hashCode + Objects.hashCode(offlineStoreConfig());
        hashCode = 31 * hashCode + Objects.hashCode(throughputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFeatureGroupRequest)) {
            return false;
        }
        CreateFeatureGroupRequest other = (CreateFeatureGroupRequest) obj;
        return Objects.equals(featureGroupName(), other.featureGroupName())
                && Objects.equals(recordIdentifierFeatureName(), other.recordIdentifierFeatureName())
                && Objects.equals(eventTimeFeatureName(), other.eventTimeFeatureName())
                && hasFeatureDefinitions() == other.hasFeatureDefinitions()
                && Objects.equals(featureDefinitions(), other.featureDefinitions())
                && Objects.equals(onlineStoreConfig(), other.onlineStoreConfig())
                && Objects.equals(offlineStoreConfig(), other.offlineStoreConfig())
                && Objects.equals(throughputConfig(), other.throughputConfig()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFeatureGroupRequest").add("FeatureGroupName", featureGroupName())
                .add("RecordIdentifierFeatureName", recordIdentifierFeatureName())
                .add("EventTimeFeatureName", eventTimeFeatureName())
                .add("FeatureDefinitions", hasFeatureDefinitions() ? featureDefinitions() : null)
                .add("OnlineStoreConfig", onlineStoreConfig()).add("OfflineStoreConfig", offlineStoreConfig())
                .add("ThroughputConfig", throughputConfig()).add("RoleArn", roleArn()).add("Description", description())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeatureGroupName":
            return Optional.ofNullable(clazz.cast(featureGroupName()));
        case "RecordIdentifierFeatureName":
            return Optional.ofNullable(clazz.cast(recordIdentifierFeatureName()));
        case "EventTimeFeatureName":
            return Optional.ofNullable(clazz.cast(eventTimeFeatureName()));
        case "FeatureDefinitions":
            return Optional.ofNullable(clazz.cast(featureDefinitions()));
        case "OnlineStoreConfig":
            return Optional.ofNullable(clazz.cast(onlineStoreConfig()));
        case "OfflineStoreConfig":
            return Optional.ofNullable(clazz.cast(offlineStoreConfig()));
        case "ThroughputConfig":
            return Optional.ofNullable(clazz.cast(throughputConfig()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateFeatureGroupRequest, T> g) {
        return obj -> g.apply((CreateFeatureGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFeatureGroupRequest> {
        /**
         * <p>
         * The name of the <code>FeatureGroup</code>. The name must be unique within an Amazon Web Services Region in an
         * Amazon Web Services account.
         * </p>
         * <p>
         * The name:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must start with an alphanumeric character.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can only include alphanumeric characters, underscores, and hyphens. Spaces are not allowed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param featureGroupName
         *        The name of the <code>FeatureGroup</code>. The name must be unique within an Amazon Web Services
         *        Region in an Amazon Web Services account.</p>
         *        <p>
         *        The name:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must start with an alphanumeric character.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can only include alphanumeric characters, underscores, and hyphens. Spaces are not allowed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureGroupName(String featureGroupName);

        /**
         * <p>
         * The name of the <code>Feature</code> whose value uniquely identifies a <code>Record</code> defined in the
         * <code>FeatureStore</code>. Only the latest record per identifier value will be stored in the
         * <code>OnlineStore</code>. <code>RecordIdentifierFeatureName</code> must be one of feature definitions' names.
         * </p>
         * <p>
         * You use the <code>RecordIdentifierFeatureName</code> to access data in a <code>FeatureStore</code>.
         * </p>
         * <p>
         * This name:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must start with an alphanumeric character.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can only contains alphanumeric characters, hyphens, underscores. Spaces are not allowed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param recordIdentifierFeatureName
         *        The name of the <code>Feature</code> whose value uniquely identifies a <code>Record</code> defined in
         *        the <code>FeatureStore</code>. Only the latest record per identifier value will be stored in the
         *        <code>OnlineStore</code>. <code>RecordIdentifierFeatureName</code> must be one of feature definitions'
         *        names.</p>
         *        <p>
         *        You use the <code>RecordIdentifierFeatureName</code> to access data in a <code>FeatureStore</code>.
         *        </p>
         *        <p>
         *        This name:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must start with an alphanumeric character.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can only contains alphanumeric characters, hyphens, underscores. Spaces are not allowed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordIdentifierFeatureName(String recordIdentifierFeatureName);

        /**
         * <p>
         * The name of the feature that stores the <code>EventTime</code> of a <code>Record</code> in a
         * <code>FeatureGroup</code>.
         * </p>
         * <p>
         * An <code>EventTime</code> is a point in time when a new event occurs that corresponds to the creation or
         * update of a <code>Record</code> in a <code>FeatureGroup</code>. All <code>Records</code> in the
         * <code>FeatureGroup</code> must have a corresponding <code>EventTime</code>.
         * </p>
         * <p>
         * An <code>EventTime</code> can be a <code>String</code> or <code>Fractional</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Fractional</code>: <code>EventTime</code> feature values must be a Unix timestamp in seconds.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>String</code>: <code>EventTime</code> feature values must be an ISO-8601 string in the format. The
         * following formats are supported <code>yyyy-MM-dd'T'HH:mm:ssZ</code> and
         * <code>yyyy-MM-dd'T'HH:mm:ss.SSSZ</code> where <code>yyyy</code>, <code>MM</code>, and <code>dd</code>
         * represent the year, month, and day respectively and <code>HH</code>, <code>mm</code>, <code>ss</code>, and if
         * applicable, <code>SSS</code> represent the hour, month, second and milliseconds respsectively.
         * <code>'T'</code> and <code>Z</code> are constants.
         * </p>
         * </li>
         * </ul>
         * 
         * @param eventTimeFeatureName
         *        The name of the feature that stores the <code>EventTime</code> of a <code>Record</code> in a
         *        <code>FeatureGroup</code>.</p>
         *        <p>
         *        An <code>EventTime</code> is a point in time when a new event occurs that corresponds to the creation
         *        or update of a <code>Record</code> in a <code>FeatureGroup</code>. All <code>Records</code> in the
         *        <code>FeatureGroup</code> must have a corresponding <code>EventTime</code>.
         *        </p>
         *        <p>
         *        An <code>EventTime</code> can be a <code>String</code> or <code>Fractional</code>.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Fractional</code>: <code>EventTime</code> feature values must be a Unix timestamp in seconds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>String</code>: <code>EventTime</code> feature values must be an ISO-8601 string in the format.
         *        The following formats are supported <code>yyyy-MM-dd'T'HH:mm:ssZ</code> and
         *        <code>yyyy-MM-dd'T'HH:mm:ss.SSSZ</code> where <code>yyyy</code>, <code>MM</code>, and <code>dd</code>
         *        represent the year, month, and day respectively and <code>HH</code>, <code>mm</code>, <code>ss</code>,
         *        and if applicable, <code>SSS</code> represent the hour, month, second and milliseconds respsectively.
         *        <code>'T'</code> and <code>Z</code> are constants.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTimeFeatureName(String eventTimeFeatureName);

        /**
         * <p>
         * A list of <code>Feature</code> names and types. <code>Name</code> and <code>Type</code> is compulsory per
         * <code>Feature</code>.
         * </p>
         * <p>
         * Valid feature <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and
         * <code>String</code>.
         * </p>
         * <p>
         * <code>FeatureName</code>s cannot be any of the following: <code>is_deleted</code>, <code>write_time</code>,
         * <code>api_invocation_time</code>
         * </p>
         * <p>
         * You can create up to 2,500 <code>FeatureDefinition</code>s per <code>FeatureGroup</code>.
         * </p>
         * 
         * @param featureDefinitions
         *        A list of <code>Feature</code> names and types. <code>Name</code> and <code>Type</code> is compulsory
         *        per <code>Feature</code>. </p>
         *        <p>
         *        Valid feature <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and
         *        <code>String</code>.
         *        </p>
         *        <p>
         *        <code>FeatureName</code>s cannot be any of the following: <code>is_deleted</code>,
         *        <code>write_time</code>, <code>api_invocation_time</code>
         *        </p>
         *        <p>
         *        You can create up to 2,500 <code>FeatureDefinition</code>s per <code>FeatureGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureDefinitions(Collection<FeatureDefinition> featureDefinitions);

        /**
         * <p>
         * A list of <code>Feature</code> names and types. <code>Name</code> and <code>Type</code> is compulsory per
         * <code>Feature</code>.
         * </p>
         * <p>
         * Valid feature <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and
         * <code>String</code>.
         * </p>
         * <p>
         * <code>FeatureName</code>s cannot be any of the following: <code>is_deleted</code>, <code>write_time</code>,
         * <code>api_invocation_time</code>
         * </p>
         * <p>
         * You can create up to 2,500 <code>FeatureDefinition</code>s per <code>FeatureGroup</code>.
         * </p>
         * 
         * @param featureDefinitions
         *        A list of <code>Feature</code> names and types. <code>Name</code> and <code>Type</code> is compulsory
         *        per <code>Feature</code>. </p>
         *        <p>
         *        Valid feature <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and
         *        <code>String</code>.
         *        </p>
         *        <p>
         *        <code>FeatureName</code>s cannot be any of the following: <code>is_deleted</code>,
         *        <code>write_time</code>, <code>api_invocation_time</code>
         *        </p>
         *        <p>
         *        You can create up to 2,500 <code>FeatureDefinition</code>s per <code>FeatureGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureDefinitions(FeatureDefinition... featureDefinitions);

        /**
         * <p>
         * A list of <code>Feature</code> names and types. <code>Name</code> and <code>Type</code> is compulsory per
         * <code>Feature</code>.
         * </p>
         * <p>
         * Valid feature <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and
         * <code>String</code>.
         * </p>
         * <p>
         * <code>FeatureName</code>s cannot be any of the following: <code>is_deleted</code>, <code>write_time</code>,
         * <code>api_invocation_time</code>
         * </p>
         * <p>
         * You can create up to 2,500 <code>FeatureDefinition</code>s per <code>FeatureGroup</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.FeatureDefinition.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.sagemaker.model.FeatureDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.FeatureDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #featureDefinitions(List<FeatureDefinition>)}.
         * 
         * @param featureDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.FeatureDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #featureDefinitions(java.util.Collection<FeatureDefinition>)
         */
        Builder featureDefinitions(Consumer<FeatureDefinition.Builder>... featureDefinitions);

        /**
         * <p>
         * You can turn the <code>OnlineStore</code> on or off by specifying <code>True</code> for the
         * <code>EnableOnlineStore</code> flag in <code>OnlineStoreConfig</code>.
         * </p>
         * <p>
         * You can also include an Amazon Web Services KMS key ID (<code>KMSKeyId</code>) for at-rest encryption of the
         * <code>OnlineStore</code>.
         * </p>
         * <p>
         * The default value is <code>False</code>.
         * </p>
         * 
         * @param onlineStoreConfig
         *        You can turn the <code>OnlineStore</code> on or off by specifying <code>True</code> for the
         *        <code>EnableOnlineStore</code> flag in <code>OnlineStoreConfig</code>.</p>
         *        <p>
         *        You can also include an Amazon Web Services KMS key ID (<code>KMSKeyId</code>) for at-rest encryption
         *        of the <code>OnlineStore</code>.
         *        </p>
         *        <p>
         *        The default value is <code>False</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onlineStoreConfig(OnlineStoreConfig onlineStoreConfig);

        /**
         * <p>
         * You can turn the <code>OnlineStore</code> on or off by specifying <code>True</code> for the
         * <code>EnableOnlineStore</code> flag in <code>OnlineStoreConfig</code>.
         * </p>
         * <p>
         * You can also include an Amazon Web Services KMS key ID (<code>KMSKeyId</code>) for at-rest encryption of the
         * <code>OnlineStore</code>.
         * </p>
         * <p>
         * The default value is <code>False</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link OnlineStoreConfig.Builder} avoiding the
         * need to create one manually via {@link OnlineStoreConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnlineStoreConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #onlineStoreConfig(OnlineStoreConfig)}.
         * 
         * @param onlineStoreConfig
         *        a consumer that will call methods on {@link OnlineStoreConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onlineStoreConfig(OnlineStoreConfig)
         */
        default Builder onlineStoreConfig(Consumer<OnlineStoreConfig.Builder> onlineStoreConfig) {
            return onlineStoreConfig(OnlineStoreConfig.builder().applyMutation(onlineStoreConfig).build());
        }

        /**
         * <p>
         * Use this to configure an <code>OfflineFeatureStore</code>. This parameter allows you to specify:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The Amazon Simple Storage Service (Amazon S3) location of an <code>OfflineStore</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * A configuration for an Amazon Web Services Glue or Amazon Web Services Hive data catalog.
         * </p>
         * </li>
         * <li>
         * <p>
         * An KMS encryption key to encrypt the Amazon S3 location used for <code>OfflineStore</code>. If KMS encryption
         * key is not specified, by default we encrypt all data at rest using Amazon Web Services KMS key. By defining
         * your <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-key.html">bucket-level key</a> for
         * SSE, you can reduce Amazon Web Services KMS requests costs by up to 99 percent.
         * </p>
         * </li>
         * <li>
         * <p>
         * Format for the offline store table. Supported formats are Glue (Default) and <a
         * href="https://iceberg.apache.org/">Apache Iceberg</a>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * To learn more about this parameter, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OfflineStoreConfig.html"
         * >OfflineStoreConfig</a>.
         * </p>
         * 
         * @param offlineStoreConfig
         *        Use this to configure an <code>OfflineFeatureStore</code>. This parameter allows you to specify:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The Amazon Simple Storage Service (Amazon S3) location of an <code>OfflineStore</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A configuration for an Amazon Web Services Glue or Amazon Web Services Hive data catalog.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An KMS encryption key to encrypt the Amazon S3 location used for <code>OfflineStore</code>. If KMS
         *        encryption key is not specified, by default we encrypt all data at rest using Amazon Web Services KMS
         *        key. By defining your <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-key.html">bucket-level key</a> for
         *        SSE, you can reduce Amazon Web Services KMS requests costs by up to 99 percent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Format for the offline store table. Supported formats are Glue (Default) and <a
         *        href="https://iceberg.apache.org/">Apache Iceberg</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To learn more about this parameter, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OfflineStoreConfig.html"
         *        >OfflineStoreConfig</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offlineStoreConfig(OfflineStoreConfig offlineStoreConfig);

        /**
         * <p>
         * Use this to configure an <code>OfflineFeatureStore</code>. This parameter allows you to specify:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The Amazon Simple Storage Service (Amazon S3) location of an <code>OfflineStore</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * A configuration for an Amazon Web Services Glue or Amazon Web Services Hive data catalog.
         * </p>
         * </li>
         * <li>
         * <p>
         * An KMS encryption key to encrypt the Amazon S3 location used for <code>OfflineStore</code>. If KMS encryption
         * key is not specified, by default we encrypt all data at rest using Amazon Web Services KMS key. By defining
         * your <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-key.html">bucket-level key</a> for
         * SSE, you can reduce Amazon Web Services KMS requests costs by up to 99 percent.
         * </p>
         * </li>
         * <li>
         * <p>
         * Format for the offline store table. Supported formats are Glue (Default) and <a
         * href="https://iceberg.apache.org/">Apache Iceberg</a>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * To learn more about this parameter, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OfflineStoreConfig.html"
         * >OfflineStoreConfig</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link OfflineStoreConfig.Builder} avoiding the
         * need to create one manually via {@link OfflineStoreConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OfflineStoreConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #offlineStoreConfig(OfflineStoreConfig)}.
         * 
         * @param offlineStoreConfig
         *        a consumer that will call methods on {@link OfflineStoreConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offlineStoreConfig(OfflineStoreConfig)
         */
        default Builder offlineStoreConfig(Consumer<OfflineStoreConfig.Builder> offlineStoreConfig) {
            return offlineStoreConfig(OfflineStoreConfig.builder().applyMutation(offlineStoreConfig).build());
        }

        /**
         * Sets the value of the ThroughputConfig property for this object.
         *
         * @param throughputConfig
         *        The new value for the ThroughputConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughputConfig(ThroughputConfig throughputConfig);

        /**
         * Sets the value of the ThroughputConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ThroughputConfig.Builder} avoiding the
         * need to create one manually via {@link ThroughputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ThroughputConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #throughputConfig(ThroughputConfig)}.
         * 
         * @param throughputConfig
         *        a consumer that will call methods on {@link ThroughputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #throughputConfig(ThroughputConfig)
         */
        default Builder throughputConfig(Consumer<ThroughputConfig.Builder> throughputConfig) {
            return throughputConfig(ThroughputConfig.builder().applyMutation(throughputConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the
         * <code>OfflineStore</code> if an <code>OfflineStoreConfig</code> is provided.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the
         *        <code>OfflineStore</code> if an <code>OfflineStoreConfig</code> is provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A free-form description of a <code>FeatureGroup</code>.
         * </p>
         * 
         * @param description
         *        A free-form description of a <code>FeatureGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Tags used to identify <code>Features</code> in each <code>FeatureGroup</code>.
         * </p>
         * 
         * @param tags
         *        Tags used to identify <code>Features</code> in each <code>FeatureGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags used to identify <code>Features</code> in each <code>FeatureGroup</code>.
         * </p>
         * 
         * @param tags
         *        Tags used to identify <code>Features</code> in each <code>FeatureGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags used to identify <code>Features</code> in each <code>FeatureGroup</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String featureGroupName;

        private String recordIdentifierFeatureName;

        private String eventTimeFeatureName;

        private List<FeatureDefinition> featureDefinitions = DefaultSdkAutoConstructList.getInstance();

        private OnlineStoreConfig onlineStoreConfig;

        private OfflineStoreConfig offlineStoreConfig;

        private ThroughputConfig throughputConfig;

        private String roleArn;

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFeatureGroupRequest model) {
            super(model);
            featureGroupName(model.featureGroupName);
            recordIdentifierFeatureName(model.recordIdentifierFeatureName);
            eventTimeFeatureName(model.eventTimeFeatureName);
            featureDefinitions(model.featureDefinitions);
            onlineStoreConfig(model.onlineStoreConfig);
            offlineStoreConfig(model.offlineStoreConfig);
            throughputConfig(model.throughputConfig);
            roleArn(model.roleArn);
            description(model.description);
            tags(model.tags);
        }

        public final String getFeatureGroupName() {
            return featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final String getRecordIdentifierFeatureName() {
            return recordIdentifierFeatureName;
        }

        public final void setRecordIdentifierFeatureName(String recordIdentifierFeatureName) {
            this.recordIdentifierFeatureName = recordIdentifierFeatureName;
        }

        @Override
        public final Builder recordIdentifierFeatureName(String recordIdentifierFeatureName) {
            this.recordIdentifierFeatureName = recordIdentifierFeatureName;
            return this;
        }

        public final String getEventTimeFeatureName() {
            return eventTimeFeatureName;
        }

        public final void setEventTimeFeatureName(String eventTimeFeatureName) {
            this.eventTimeFeatureName = eventTimeFeatureName;
        }

        @Override
        public final Builder eventTimeFeatureName(String eventTimeFeatureName) {
            this.eventTimeFeatureName = eventTimeFeatureName;
            return this;
        }

        public final List<FeatureDefinition.Builder> getFeatureDefinitions() {
            List<FeatureDefinition.Builder> result = FeatureDefinitionsCopier.copyToBuilder(this.featureDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeatureDefinitions(Collection<FeatureDefinition.BuilderImpl> featureDefinitions) {
            this.featureDefinitions = FeatureDefinitionsCopier.copyFromBuilder(featureDefinitions);
        }

        @Override
        public final Builder featureDefinitions(Collection<FeatureDefinition> featureDefinitions) {
            this.featureDefinitions = FeatureDefinitionsCopier.copy(featureDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureDefinitions(FeatureDefinition... featureDefinitions) {
            featureDefinitions(Arrays.asList(featureDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureDefinitions(Consumer<FeatureDefinition.Builder>... featureDefinitions) {
            featureDefinitions(Stream.of(featureDefinitions).map(c -> FeatureDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final OnlineStoreConfig.Builder getOnlineStoreConfig() {
            return onlineStoreConfig != null ? onlineStoreConfig.toBuilder() : null;
        }

        public final void setOnlineStoreConfig(OnlineStoreConfig.BuilderImpl onlineStoreConfig) {
            this.onlineStoreConfig = onlineStoreConfig != null ? onlineStoreConfig.build() : null;
        }

        @Override
        public final Builder onlineStoreConfig(OnlineStoreConfig onlineStoreConfig) {
            this.onlineStoreConfig = onlineStoreConfig;
            return this;
        }

        public final OfflineStoreConfig.Builder getOfflineStoreConfig() {
            return offlineStoreConfig != null ? offlineStoreConfig.toBuilder() : null;
        }

        public final void setOfflineStoreConfig(OfflineStoreConfig.BuilderImpl offlineStoreConfig) {
            this.offlineStoreConfig = offlineStoreConfig != null ? offlineStoreConfig.build() : null;
        }

        @Override
        public final Builder offlineStoreConfig(OfflineStoreConfig offlineStoreConfig) {
            this.offlineStoreConfig = offlineStoreConfig;
            return this;
        }

        public final ThroughputConfig.Builder getThroughputConfig() {
            return throughputConfig != null ? throughputConfig.toBuilder() : null;
        }

        public final void setThroughputConfig(ThroughputConfig.BuilderImpl throughputConfig) {
            this.throughputConfig = throughputConfig != null ? throughputConfig.build() : null;
        }

        @Override
        public final Builder throughputConfig(ThroughputConfig throughputConfig) {
            this.throughputConfig = throughputConfig;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFeatureGroupRequest build() {
            return new CreateFeatureGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
