/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHubRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateHubRequest.Builder, CreateHubRequest> {
    private static final SdkField<String> HUB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubName").getter(getter(CreateHubRequest::hubName)).setter(setter(Builder::hubName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubName").build()).build();

    private static final SdkField<String> HUB_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubDescription").getter(getter(CreateHubRequest::hubDescription))
            .setter(setter(Builder::hubDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubDescription").build()).build();

    private static final SdkField<String> HUB_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubDisplayName").getter(getter(CreateHubRequest::hubDisplayName))
            .setter(setter(Builder::hubDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubDisplayName").build()).build();

    private static final SdkField<List<String>> HUB_SEARCH_KEYWORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HubSearchKeywords")
            .getter(getter(CreateHubRequest::hubSearchKeywords))
            .setter(setter(Builder::hubSearchKeywords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubSearchKeywords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<HubS3StorageConfig> S3_STORAGE_CONFIG_FIELD = SdkField
            .<HubS3StorageConfig> builder(MarshallingType.SDK_POJO).memberName("S3StorageConfig")
            .getter(getter(CreateHubRequest::s3StorageConfig)).setter(setter(Builder::s3StorageConfig))
            .constructor(HubS3StorageConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3StorageConfig").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateHubRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_NAME_FIELD,
            HUB_DESCRIPTION_FIELD, HUB_DISPLAY_NAME_FIELD, HUB_SEARCH_KEYWORDS_FIELD, S3_STORAGE_CONFIG_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("HubName", HUB_NAME_FIELD);
                    put("HubDescription", HUB_DESCRIPTION_FIELD);
                    put("HubDisplayName", HUB_DISPLAY_NAME_FIELD);
                    put("HubSearchKeywords", HUB_SEARCH_KEYWORDS_FIELD);
                    put("S3StorageConfig", S3_STORAGE_CONFIG_FIELD);
                    put("Tags", TAGS_FIELD);
                }
            });

    private final String hubName;

    private final String hubDescription;

    private final String hubDisplayName;

    private final List<String> hubSearchKeywords;

    private final HubS3StorageConfig s3StorageConfig;

    private final List<Tag> tags;

    private CreateHubRequest(BuilderImpl builder) {
        super(builder);
        this.hubName = builder.hubName;
        this.hubDescription = builder.hubDescription;
        this.hubDisplayName = builder.hubDisplayName;
        this.hubSearchKeywords = builder.hubSearchKeywords;
        this.s3StorageConfig = builder.s3StorageConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the hub to create.
     * </p>
     * 
     * @return The name of the hub to create.
     */
    public final String hubName() {
        return hubName;
    }

    /**
     * <p>
     * A description of the hub.
     * </p>
     * 
     * @return A description of the hub.
     */
    public final String hubDescription() {
        return hubDescription;
    }

    /**
     * <p>
     * The display name of the hub.
     * </p>
     * 
     * @return The display name of the hub.
     */
    public final String hubDisplayName() {
        return hubDisplayName;
    }

    /**
     * For responses, this returns true if the service returned a value for the HubSearchKeywords property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHubSearchKeywords() {
        return hubSearchKeywords != null && !(hubSearchKeywords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The searchable keywords for the hub.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHubSearchKeywords} method.
     * </p>
     * 
     * @return The searchable keywords for the hub.
     */
    public final List<String> hubSearchKeywords() {
        return hubSearchKeywords;
    }

    /**
     * <p>
     * The Amazon S3 storage configuration for the hub.
     * </p>
     * 
     * @return The Amazon S3 storage configuration for the hub.
     */
    public final HubS3StorageConfig s3StorageConfig() {
        return s3StorageConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags to associate with the hub.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags to associate with the hub.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hubName());
        hashCode = 31 * hashCode + Objects.hashCode(hubDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hubDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(hasHubSearchKeywords() ? hubSearchKeywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(s3StorageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHubRequest)) {
            return false;
        }
        CreateHubRequest other = (CreateHubRequest) obj;
        return Objects.equals(hubName(), other.hubName()) && Objects.equals(hubDescription(), other.hubDescription())
                && Objects.equals(hubDisplayName(), other.hubDisplayName())
                && hasHubSearchKeywords() == other.hasHubSearchKeywords()
                && Objects.equals(hubSearchKeywords(), other.hubSearchKeywords())
                && Objects.equals(s3StorageConfig(), other.s3StorageConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateHubRequest").add("HubName", hubName()).add("HubDescription", hubDescription())
                .add("HubDisplayName", hubDisplayName())
                .add("HubSearchKeywords", hasHubSearchKeywords() ? hubSearchKeywords() : null)
                .add("S3StorageConfig", s3StorageConfig()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HubName":
            return Optional.ofNullable(clazz.cast(hubName()));
        case "HubDescription":
            return Optional.ofNullable(clazz.cast(hubDescription()));
        case "HubDisplayName":
            return Optional.ofNullable(clazz.cast(hubDisplayName()));
        case "HubSearchKeywords":
            return Optional.ofNullable(clazz.cast(hubSearchKeywords()));
        case "S3StorageConfig":
            return Optional.ofNullable(clazz.cast(s3StorageConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateHubRequest, T> g) {
        return obj -> g.apply((CreateHubRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateHubRequest> {
        /**
         * <p>
         * The name of the hub to create.
         * </p>
         * 
         * @param hubName
         *        The name of the hub to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubName(String hubName);

        /**
         * <p>
         * A description of the hub.
         * </p>
         * 
         * @param hubDescription
         *        A description of the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubDescription(String hubDescription);

        /**
         * <p>
         * The display name of the hub.
         * </p>
         * 
         * @param hubDisplayName
         *        The display name of the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubDisplayName(String hubDisplayName);

        /**
         * <p>
         * The searchable keywords for the hub.
         * </p>
         * 
         * @param hubSearchKeywords
         *        The searchable keywords for the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubSearchKeywords(Collection<String> hubSearchKeywords);

        /**
         * <p>
         * The searchable keywords for the hub.
         * </p>
         * 
         * @param hubSearchKeywords
         *        The searchable keywords for the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubSearchKeywords(String... hubSearchKeywords);

        /**
         * <p>
         * The Amazon S3 storage configuration for the hub.
         * </p>
         * 
         * @param s3StorageConfig
         *        The Amazon S3 storage configuration for the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3StorageConfig(HubS3StorageConfig s3StorageConfig);

        /**
         * <p>
         * The Amazon S3 storage configuration for the hub.
         * </p>
         * This is a convenience method that creates an instance of the {@link HubS3StorageConfig.Builder} avoiding the
         * need to create one manually via {@link HubS3StorageConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HubS3StorageConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #s3StorageConfig(HubS3StorageConfig)}.
         * 
         * @param s3StorageConfig
         *        a consumer that will call methods on {@link HubS3StorageConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3StorageConfig(HubS3StorageConfig)
         */
        default Builder s3StorageConfig(Consumer<HubS3StorageConfig.Builder> s3StorageConfig) {
            return s3StorageConfig(HubS3StorageConfig.builder().applyMutation(s3StorageConfig).build());
        }

        /**
         * <p>
         * Any tags to associate with the hub.
         * </p>
         * 
         * @param tags
         *        Any tags to associate with the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags to associate with the hub.
         * </p>
         * 
         * @param tags
         *        Any tags to associate with the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags to associate with the hub.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String hubName;

        private String hubDescription;

        private String hubDisplayName;

        private List<String> hubSearchKeywords = DefaultSdkAutoConstructList.getInstance();

        private HubS3StorageConfig s3StorageConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHubRequest model) {
            super(model);
            hubName(model.hubName);
            hubDescription(model.hubDescription);
            hubDisplayName(model.hubDisplayName);
            hubSearchKeywords(model.hubSearchKeywords);
            s3StorageConfig(model.s3StorageConfig);
            tags(model.tags);
        }

        public final String getHubName() {
            return hubName;
        }

        public final void setHubName(String hubName) {
            this.hubName = hubName;
        }

        @Override
        public final Builder hubName(String hubName) {
            this.hubName = hubName;
            return this;
        }

        public final String getHubDescription() {
            return hubDescription;
        }

        public final void setHubDescription(String hubDescription) {
            this.hubDescription = hubDescription;
        }

        @Override
        public final Builder hubDescription(String hubDescription) {
            this.hubDescription = hubDescription;
            return this;
        }

        public final String getHubDisplayName() {
            return hubDisplayName;
        }

        public final void setHubDisplayName(String hubDisplayName) {
            this.hubDisplayName = hubDisplayName;
        }

        @Override
        public final Builder hubDisplayName(String hubDisplayName) {
            this.hubDisplayName = hubDisplayName;
            return this;
        }

        public final Collection<String> getHubSearchKeywords() {
            if (hubSearchKeywords instanceof SdkAutoConstructList) {
                return null;
            }
            return hubSearchKeywords;
        }

        public final void setHubSearchKeywords(Collection<String> hubSearchKeywords) {
            this.hubSearchKeywords = HubSearchKeywordListCopier.copy(hubSearchKeywords);
        }

        @Override
        public final Builder hubSearchKeywords(Collection<String> hubSearchKeywords) {
            this.hubSearchKeywords = HubSearchKeywordListCopier.copy(hubSearchKeywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubSearchKeywords(String... hubSearchKeywords) {
            hubSearchKeywords(Arrays.asList(hubSearchKeywords));
            return this;
        }

        public final HubS3StorageConfig.Builder getS3StorageConfig() {
            return s3StorageConfig != null ? s3StorageConfig.toBuilder() : null;
        }

        public final void setS3StorageConfig(HubS3StorageConfig.BuilderImpl s3StorageConfig) {
            this.s3StorageConfig = s3StorageConfig != null ? s3StorageConfig.build() : null;
        }

        @Override
        public final Builder s3StorageConfig(HubS3StorageConfig s3StorageConfig) {
            this.s3StorageConfig = s3StorageConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHubRequest build() {
            return new CreateHubRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
