/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInferenceRecommendationsJobRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateInferenceRecommendationsJobRequest.Builder, CreateInferenceRecommendationsJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(CreateInferenceRecommendationsJobRequest::jobName))
            .setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobType").getter(getter(CreateInferenceRecommendationsJobRequest::jobTypeAsString))
            .setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateInferenceRecommendationsJobRequest::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<RecommendationJobInputConfig> INPUT_CONFIG_FIELD = SdkField
            .<RecommendationJobInputConfig> builder(MarshallingType.SDK_POJO).memberName("InputConfig")
            .getter(getter(CreateInferenceRecommendationsJobRequest::inputConfig)).setter(setter(Builder::inputConfig))
            .constructor(RecommendationJobInputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()).build();

    private static final SdkField<String> JOB_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobDescription").getter(getter(CreateInferenceRecommendationsJobRequest::jobDescription))
            .setter(setter(Builder::jobDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDescription").build()).build();

    private static final SdkField<RecommendationJobStoppingConditions> STOPPING_CONDITIONS_FIELD = SdkField
            .<RecommendationJobStoppingConditions> builder(MarshallingType.SDK_POJO).memberName("StoppingConditions")
            .getter(getter(CreateInferenceRecommendationsJobRequest::stoppingConditions))
            .setter(setter(Builder::stoppingConditions)).constructor(RecommendationJobStoppingConditions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingConditions").build())
            .build();

    private static final SdkField<RecommendationJobOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<RecommendationJobOutputConfig> builder(MarshallingType.SDK_POJO).memberName("OutputConfig")
            .getter(getter(CreateInferenceRecommendationsJobRequest::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(RecommendationJobOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateInferenceRecommendationsJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            JOB_TYPE_FIELD, ROLE_ARN_FIELD, INPUT_CONFIG_FIELD, JOB_DESCRIPTION_FIELD, STOPPING_CONDITIONS_FIELD,
            OUTPUT_CONFIG_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("JobName", JOB_NAME_FIELD);
                    put("JobType", JOB_TYPE_FIELD);
                    put("RoleArn", ROLE_ARN_FIELD);
                    put("InputConfig", INPUT_CONFIG_FIELD);
                    put("JobDescription", JOB_DESCRIPTION_FIELD);
                    put("StoppingConditions", STOPPING_CONDITIONS_FIELD);
                    put("OutputConfig", OUTPUT_CONFIG_FIELD);
                    put("Tags", TAGS_FIELD);
                }
            });

    private final String jobName;

    private final String jobType;

    private final String roleArn;

    private final RecommendationJobInputConfig inputConfig;

    private final String jobDescription;

    private final RecommendationJobStoppingConditions stoppingConditions;

    private final RecommendationJobOutputConfig outputConfig;

    private final List<Tag> tags;

    private CreateInferenceRecommendationsJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.jobType = builder.jobType;
        this.roleArn = builder.roleArn;
        this.inputConfig = builder.inputConfig;
        this.jobDescription = builder.jobDescription;
        this.stoppingConditions = builder.stoppingConditions;
        this.outputConfig = builder.outputConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A name for the recommendation job. The name must be unique within the Amazon Web Services Region and within your
     * Amazon Web Services account. The job name is passed down to the resources created by the recommendation job. The
     * names of resources (such as the model, endpoint configuration, endpoint, and compilation) that are prefixed with
     * the job name are truncated at 40 characters.
     * </p>
     * 
     * @return A name for the recommendation job. The name must be unique within the Amazon Web Services Region and
     *         within your Amazon Web Services account. The job name is passed down to the resources created by the
     *         recommendation job. The names of resources (such as the model, endpoint configuration, endpoint, and
     *         compilation) that are prefixed with the job name are truncated at 40 characters.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * Defines the type of recommendation job. Specify <code>Default</code> to initiate an instance recommendation and
     * <code>Advanced</code> to initiate a load test. If left unspecified, Amazon SageMaker Inference Recommender will
     * run an instance recommendation (<code>DEFAULT</code>) job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link RecommendationJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #jobTypeAsString}.
     * </p>
     * 
     * @return Defines the type of recommendation job. Specify <code>Default</code> to initiate an instance
     *         recommendation and <code>Advanced</code> to initiate a load test. If left unspecified, Amazon SageMaker
     *         Inference Recommender will run an instance recommendation (<code>DEFAULT</code>) job.
     * @see RecommendationJobType
     */
    public final RecommendationJobType jobType() {
        return RecommendationJobType.fromValue(jobType);
    }

    /**
     * <p>
     * Defines the type of recommendation job. Specify <code>Default</code> to initiate an instance recommendation and
     * <code>Advanced</code> to initiate a load test. If left unspecified, Amazon SageMaker Inference Recommender will
     * run an instance recommendation (<code>DEFAULT</code>) job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link RecommendationJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #jobTypeAsString}.
     * </p>
     * 
     * @return Defines the type of recommendation job. Specify <code>Default</code> to initiate an instance
     *         recommendation and <code>Advanced</code> to initiate a load test. If left unspecified, Amazon SageMaker
     *         Inference Recommender will run an instance recommendation (<code>DEFAULT</code>) job.
     * @see RecommendationJobType
     */
    public final String jobTypeAsString() {
        return jobType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your
     *         behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Provides information about the versioned model package Amazon Resource Name (ARN), the traffic pattern, and
     * endpoint configurations.
     * </p>
     * 
     * @return Provides information about the versioned model package Amazon Resource Name (ARN), the traffic pattern,
     *         and endpoint configurations.
     */
    public final RecommendationJobInputConfig inputConfig() {
        return inputConfig;
    }

    /**
     * <p>
     * Description of the recommendation job.
     * </p>
     * 
     * @return Description of the recommendation job.
     */
    public final String jobDescription() {
        return jobDescription;
    }

    /**
     * <p>
     * A set of conditions for stopping a recommendation job. If any of the conditions are met, the job is automatically
     * stopped.
     * </p>
     * 
     * @return A set of conditions for stopping a recommendation job. If any of the conditions are met, the job is
     *         automatically stopped.
     */
    public final RecommendationJobStoppingConditions stoppingConditions() {
        return stoppingConditions;
    }

    /**
     * <p>
     * Provides information about the output artifacts and the KMS key to use for Amazon S3 server-side encryption.
     * </p>
     * 
     * @return Provides information about the output artifacts and the KMS key to use for Amazon S3 server-side
     *         encryption.
     */
    public final RecommendationJobOutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata that you apply to Amazon Web Services resources to help you categorize and organize them. Each tag
     * consists of a key and a value, both of which you define. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>
     * in the Amazon Web Services General Reference.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The metadata that you apply to Amazon Web Services resources to help you categorize and organize them.
     *         Each tag consists of a key and a value, both of which you define. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         Resources</a> in the Amazon Web Services General Reference.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobDescription());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingConditions());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInferenceRecommendationsJobRequest)) {
            return false;
        }
        CreateInferenceRecommendationsJobRequest other = (CreateInferenceRecommendationsJobRequest) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(jobTypeAsString(), other.jobTypeAsString())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(inputConfig(), other.inputConfig())
                && Objects.equals(jobDescription(), other.jobDescription())
                && Objects.equals(stoppingConditions(), other.stoppingConditions())
                && Objects.equals(outputConfig(), other.outputConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInferenceRecommendationsJobRequest").add("JobName", jobName())
                .add("JobType", jobTypeAsString()).add("RoleArn", roleArn()).add("InputConfig", inputConfig())
                .add("JobDescription", jobDescription()).add("StoppingConditions", stoppingConditions())
                .add("OutputConfig", outputConfig()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "JobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "InputConfig":
            return Optional.ofNullable(clazz.cast(inputConfig()));
        case "JobDescription":
            return Optional.ofNullable(clazz.cast(jobDescription()));
        case "StoppingConditions":
            return Optional.ofNullable(clazz.cast(stoppingConditions()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateInferenceRecommendationsJobRequest, T> g) {
        return obj -> g.apply((CreateInferenceRecommendationsJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateInferenceRecommendationsJobRequest> {
        /**
         * <p>
         * A name for the recommendation job. The name must be unique within the Amazon Web Services Region and within
         * your Amazon Web Services account. The job name is passed down to the resources created by the recommendation
         * job. The names of resources (such as the model, endpoint configuration, endpoint, and compilation) that are
         * prefixed with the job name are truncated at 40 characters.
         * </p>
         * 
         * @param jobName
         *        A name for the recommendation job. The name must be unique within the Amazon Web Services Region and
         *        within your Amazon Web Services account. The job name is passed down to the resources created by the
         *        recommendation job. The names of resources (such as the model, endpoint configuration, endpoint, and
         *        compilation) that are prefixed with the job name are truncated at 40 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * Defines the type of recommendation job. Specify <code>Default</code> to initiate an instance recommendation
         * and <code>Advanced</code> to initiate a load test. If left unspecified, Amazon SageMaker Inference
         * Recommender will run an instance recommendation (<code>DEFAULT</code>) job.
         * </p>
         * 
         * @param jobType
         *        Defines the type of recommendation job. Specify <code>Default</code> to initiate an instance
         *        recommendation and <code>Advanced</code> to initiate a load test. If left unspecified, Amazon
         *        SageMaker Inference Recommender will run an instance recommendation (<code>DEFAULT</code>) job.
         * @see RecommendationJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationJobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * Defines the type of recommendation job. Specify <code>Default</code> to initiate an instance recommendation
         * and <code>Advanced</code> to initiate a load test. If left unspecified, Amazon SageMaker Inference
         * Recommender will run an instance recommendation (<code>DEFAULT</code>) job.
         * </p>
         * 
         * @param jobType
         *        Defines the type of recommendation job. Specify <code>Default</code> to initiate an instance
         *        recommendation and <code>Advanced</code> to initiate a load test. If left unspecified, Amazon
         *        SageMaker Inference Recommender will run an instance recommendation (<code>DEFAULT</code>) job.
         * @see RecommendationJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationJobType
         */
        Builder jobType(RecommendationJobType jobType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your
         *        behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Provides information about the versioned model package Amazon Resource Name (ARN), the traffic pattern, and
         * endpoint configurations.
         * </p>
         * 
         * @param inputConfig
         *        Provides information about the versioned model package Amazon Resource Name (ARN), the traffic
         *        pattern, and endpoint configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfig(RecommendationJobInputConfig inputConfig);

        /**
         * <p>
         * Provides information about the versioned model package Amazon Resource Name (ARN), the traffic pattern, and
         * endpoint configurations.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecommendationJobInputConfig.Builder}
         * avoiding the need to create one manually via {@link RecommendationJobInputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationJobInputConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #inputConfig(RecommendationJobInputConfig)}.
         * 
         * @param inputConfig
         *        a consumer that will call methods on {@link RecommendationJobInputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConfig(RecommendationJobInputConfig)
         */
        default Builder inputConfig(Consumer<RecommendationJobInputConfig.Builder> inputConfig) {
            return inputConfig(RecommendationJobInputConfig.builder().applyMutation(inputConfig).build());
        }

        /**
         * <p>
         * Description of the recommendation job.
         * </p>
         * 
         * @param jobDescription
         *        Description of the recommendation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDescription(String jobDescription);

        /**
         * <p>
         * A set of conditions for stopping a recommendation job. If any of the conditions are met, the job is
         * automatically stopped.
         * </p>
         * 
         * @param stoppingConditions
         *        A set of conditions for stopping a recommendation job. If any of the conditions are met, the job is
         *        automatically stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingConditions(RecommendationJobStoppingConditions stoppingConditions);

        /**
         * <p>
         * A set of conditions for stopping a recommendation job. If any of the conditions are met, the job is
         * automatically stopped.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RecommendationJobStoppingConditions.Builder} avoiding the need to create one manually via
         * {@link RecommendationJobStoppingConditions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationJobStoppingConditions.Builder#build()} is called
         * immediately and its result is passed to {@link #stoppingConditions(RecommendationJobStoppingConditions)}.
         * 
         * @param stoppingConditions
         *        a consumer that will call methods on {@link RecommendationJobStoppingConditions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingConditions(RecommendationJobStoppingConditions)
         */
        default Builder stoppingConditions(Consumer<RecommendationJobStoppingConditions.Builder> stoppingConditions) {
            return stoppingConditions(RecommendationJobStoppingConditions.builder().applyMutation(stoppingConditions).build());
        }

        /**
         * <p>
         * Provides information about the output artifacts and the KMS key to use for Amazon S3 server-side encryption.
         * </p>
         * 
         * @param outputConfig
         *        Provides information about the output artifacts and the KMS key to use for Amazon S3 server-side
         *        encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(RecommendationJobOutputConfig outputConfig);

        /**
         * <p>
         * Provides information about the output artifacts and the KMS key to use for Amazon S3 server-side encryption.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecommendationJobOutputConfig.Builder}
         * avoiding the need to create one manually via {@link RecommendationJobOutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationJobOutputConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #outputConfig(RecommendationJobOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link RecommendationJobOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(RecommendationJobOutputConfig)
         */
        default Builder outputConfig(Consumer<RecommendationJobOutputConfig.Builder> outputConfig) {
            return outputConfig(RecommendationJobOutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * The metadata that you apply to Amazon Web Services resources to help you categorize and organize them. Each
         * tag consists of a key and a value, both of which you define. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a> in the Amazon Web Services General Reference.
         * </p>
         * 
         * @param tags
         *        The metadata that you apply to Amazon Web Services resources to help you categorize and organize them.
         *        Each tag consists of a key and a value, both of which you define. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a> in the Amazon Web Services General Reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The metadata that you apply to Amazon Web Services resources to help you categorize and organize them. Each
         * tag consists of a key and a value, both of which you define. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a> in the Amazon Web Services General Reference.
         * </p>
         * 
         * @param tags
         *        The metadata that you apply to Amazon Web Services resources to help you categorize and organize them.
         *        Each tag consists of a key and a value, both of which you define. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a> in the Amazon Web Services General Reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The metadata that you apply to Amazon Web Services resources to help you categorize and organize them. Each
         * tag consists of a key and a value, both of which you define. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a> in the Amazon Web Services General Reference.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String jobName;

        private String jobType;

        private String roleArn;

        private RecommendationJobInputConfig inputConfig;

        private String jobDescription;

        private RecommendationJobStoppingConditions stoppingConditions;

        private RecommendationJobOutputConfig outputConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInferenceRecommendationsJobRequest model) {
            super(model);
            jobName(model.jobName);
            jobType(model.jobType);
            roleArn(model.roleArn);
            inputConfig(model.inputConfig);
            jobDescription(model.jobDescription);
            stoppingConditions(model.stoppingConditions);
            outputConfig(model.outputConfig);
            tags(model.tags);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobType() {
            return jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(RecommendationJobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final RecommendationJobInputConfig.Builder getInputConfig() {
            return inputConfig != null ? inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(RecommendationJobInputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        public final Builder inputConfig(RecommendationJobInputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final String getJobDescription() {
            return jobDescription;
        }

        public final void setJobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
        }

        @Override
        public final Builder jobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
            return this;
        }

        public final RecommendationJobStoppingConditions.Builder getStoppingConditions() {
            return stoppingConditions != null ? stoppingConditions.toBuilder() : null;
        }

        public final void setStoppingConditions(RecommendationJobStoppingConditions.BuilderImpl stoppingConditions) {
            this.stoppingConditions = stoppingConditions != null ? stoppingConditions.build() : null;
        }

        @Override
        public final Builder stoppingConditions(RecommendationJobStoppingConditions stoppingConditions) {
            this.stoppingConditions = stoppingConditions;
            return this;
        }

        public final RecommendationJobOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(RecommendationJobOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(RecommendationJobOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInferenceRecommendationsJobRequest build() {
            return new CreateInferenceRecommendationsJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
