/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLabelingJobRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateLabelingJobRequest.Builder, CreateLabelingJobRequest> {
    private static final SdkField<String> LABELING_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelingJobName").getter(getter(CreateLabelingJobRequest::labelingJobName))
            .setter(setter(Builder::labelingJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobName").build()).build();

    private static final SdkField<String> LABEL_ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelAttributeName").getter(getter(CreateLabelingJobRequest::labelAttributeName))
            .setter(setter(Builder::labelAttributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelAttributeName").build())
            .build();

    private static final SdkField<LabelingJobInputConfig> INPUT_CONFIG_FIELD = SdkField
            .<LabelingJobInputConfig> builder(MarshallingType.SDK_POJO).memberName("InputConfig")
            .getter(getter(CreateLabelingJobRequest::inputConfig)).setter(setter(Builder::inputConfig))
            .constructor(LabelingJobInputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()).build();

    private static final SdkField<LabelingJobOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<LabelingJobOutputConfig> builder(MarshallingType.SDK_POJO).memberName("OutputConfig")
            .getter(getter(CreateLabelingJobRequest::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(LabelingJobOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateLabelingJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> LABEL_CATEGORY_CONFIG_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelCategoryConfigS3Uri").getter(getter(CreateLabelingJobRequest::labelCategoryConfigS3Uri))
            .setter(setter(Builder::labelCategoryConfigS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelCategoryConfigS3Uri").build())
            .build();

    private static final SdkField<LabelingJobStoppingConditions> STOPPING_CONDITIONS_FIELD = SdkField
            .<LabelingJobStoppingConditions> builder(MarshallingType.SDK_POJO).memberName("StoppingConditions")
            .getter(getter(CreateLabelingJobRequest::stoppingConditions)).setter(setter(Builder::stoppingConditions))
            .constructor(LabelingJobStoppingConditions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingConditions").build())
            .build();

    private static final SdkField<LabelingJobAlgorithmsConfig> LABELING_JOB_ALGORITHMS_CONFIG_FIELD = SdkField
            .<LabelingJobAlgorithmsConfig> builder(MarshallingType.SDK_POJO)
            .memberName("LabelingJobAlgorithmsConfig")
            .getter(getter(CreateLabelingJobRequest::labelingJobAlgorithmsConfig))
            .setter(setter(Builder::labelingJobAlgorithmsConfig))
            .constructor(LabelingJobAlgorithmsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobAlgorithmsConfig")
                    .build()).build();

    private static final SdkField<HumanTaskConfig> HUMAN_TASK_CONFIG_FIELD = SdkField
            .<HumanTaskConfig> builder(MarshallingType.SDK_POJO).memberName("HumanTaskConfig")
            .getter(getter(CreateLabelingJobRequest::humanTaskConfig)).setter(setter(Builder::humanTaskConfig))
            .constructor(HumanTaskConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanTaskConfig").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateLabelingJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELING_JOB_NAME_FIELD,
            LABEL_ATTRIBUTE_NAME_FIELD, INPUT_CONFIG_FIELD, OUTPUT_CONFIG_FIELD, ROLE_ARN_FIELD,
            LABEL_CATEGORY_CONFIG_S3_URI_FIELD, STOPPING_CONDITIONS_FIELD, LABELING_JOB_ALGORITHMS_CONFIG_FIELD,
            HUMAN_TASK_CONFIG_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("LabelingJobName", LABELING_JOB_NAME_FIELD);
                    put("LabelAttributeName", LABEL_ATTRIBUTE_NAME_FIELD);
                    put("InputConfig", INPUT_CONFIG_FIELD);
                    put("OutputConfig", OUTPUT_CONFIG_FIELD);
                    put("RoleArn", ROLE_ARN_FIELD);
                    put("LabelCategoryConfigS3Uri", LABEL_CATEGORY_CONFIG_S3_URI_FIELD);
                    put("StoppingConditions", STOPPING_CONDITIONS_FIELD);
                    put("LabelingJobAlgorithmsConfig", LABELING_JOB_ALGORITHMS_CONFIG_FIELD);
                    put("HumanTaskConfig", HUMAN_TASK_CONFIG_FIELD);
                    put("Tags", TAGS_FIELD);
                }
            });

    private final String labelingJobName;

    private final String labelAttributeName;

    private final LabelingJobInputConfig inputConfig;

    private final LabelingJobOutputConfig outputConfig;

    private final String roleArn;

    private final String labelCategoryConfigS3Uri;

    private final LabelingJobStoppingConditions stoppingConditions;

    private final LabelingJobAlgorithmsConfig labelingJobAlgorithmsConfig;

    private final HumanTaskConfig humanTaskConfig;

    private final List<Tag> tags;

    private CreateLabelingJobRequest(BuilderImpl builder) {
        super(builder);
        this.labelingJobName = builder.labelingJobName;
        this.labelAttributeName = builder.labelAttributeName;
        this.inputConfig = builder.inputConfig;
        this.outputConfig = builder.outputConfig;
        this.roleArn = builder.roleArn;
        this.labelCategoryConfigS3Uri = builder.labelCategoryConfigS3Uri;
        this.stoppingConditions = builder.stoppingConditions;
        this.labelingJobAlgorithmsConfig = builder.labelingJobAlgorithmsConfig;
        this.humanTaskConfig = builder.humanTaskConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the labeling job. This name is used to identify the job in a list of labeling jobs. Labeling job
     * names must be unique within an Amazon Web Services account and region. <code>LabelingJobName</code> is not case
     * sensitive. For example, Example-job and example-job are considered the same labeling job name by Ground Truth.
     * </p>
     * 
     * @return The name of the labeling job. This name is used to identify the job in a list of labeling jobs. Labeling
     *         job names must be unique within an Amazon Web Services account and region. <code>LabelingJobName</code>
     *         is not case sensitive. For example, Example-job and example-job are considered the same labeling job name
     *         by Ground Truth.
     */
    public final String labelingJobName() {
        return labelingJobName;
    }

    /**
     * <p>
     * The attribute name to use for the label in the output manifest file. This is the key for the key/value pair
     * formed with the label that a worker assigns to the object. The <code>LabelAttributeName</code> must meet the
     * following requirements.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The name can't end with "-metadata".
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are using one of the following <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a>, the attribute
     * name <i>must</i> end with "-ref". If the task type you are using is not listed below, the attribute name <i>must
     * not</i> end with "-ref".
     * </p>
     * <ul>
     * <li>
     * <p>
     * Image semantic segmentation (<code>SemanticSegmentation)</code>, and adjustment (
     * <code>AdjustmentSemanticSegmentation</code>) and verification (<code>VerificationSemanticSegmentation</code>)
     * labeling jobs for this task type.
     * </p>
     * </li>
     * <li>
     * <p>
     * Video frame object detection (<code>VideoObjectDetection</code>), and adjustment and verification (
     * <code>AdjustmentVideoObjectDetection</code>) labeling jobs for this task type.
     * </p>
     * </li>
     * <li>
     * <p>
     * Video frame object tracking (<code>VideoObjectTracking</code>), and adjustment and verification (
     * <code>AdjustmentVideoObjectTracking</code>) labeling jobs for this task type.
     * </p>
     * </li>
     * <li>
     * <p>
     * 3D point cloud semantic segmentation (<code>3DPointCloudSemanticSegmentation</code>), and adjustment and
     * verification (<code>Adjustment3DPointCloudSemanticSegmentation</code>) labeling jobs for this task type.
     * </p>
     * </li>
     * <li>
     * <p>
     * 3D point cloud object tracking (<code>3DPointCloudObjectTracking</code>), and adjustment and verification (
     * <code>Adjustment3DPointCloudObjectTracking</code>) labeling jobs for this task type.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p/>
     * <important>
     * <p>
     * If you are creating an adjustment or verification labeling job, you must use a <i>different</i>
     * <code>LabelAttributeName</code> than the one used in the original labeling job. The original labeling job is the
     * Ground Truth labeling job that produced the labels that you want verified or adjusted. To learn more about
     * adjustment and verification labeling jobs, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust Labels</a>.
     * </p>
     * </important>
     * 
     * @return The attribute name to use for the label in the output manifest file. This is the key for the key/value
     *         pair formed with the label that a worker assigns to the object. The <code>LabelAttributeName</code> must
     *         meet the following requirements.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The name can't end with "-metadata".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you are using one of the following <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a>, the
     *         attribute name <i>must</i> end with "-ref". If the task type you are using is not listed below, the
     *         attribute name <i>must not</i> end with "-ref".
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Image semantic segmentation (<code>SemanticSegmentation)</code>, and adjustment (
     *         <code>AdjustmentSemanticSegmentation</code>) and verification (
     *         <code>VerificationSemanticSegmentation</code>) labeling jobs for this task type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Video frame object detection (<code>VideoObjectDetection</code>), and adjustment and verification (
     *         <code>AdjustmentVideoObjectDetection</code>) labeling jobs for this task type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Video frame object tracking (<code>VideoObjectTracking</code>), and adjustment and verification (
     *         <code>AdjustmentVideoObjectTracking</code>) labeling jobs for this task type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         3D point cloud semantic segmentation (<code>3DPointCloudSemanticSegmentation</code>), and adjustment and
     *         verification (<code>Adjustment3DPointCloudSemanticSegmentation</code>) labeling jobs for this task type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         3D point cloud object tracking (<code>3DPointCloudObjectTracking</code>), and adjustment and verification
     *         (<code>Adjustment3DPointCloudObjectTracking</code>) labeling jobs for this task type.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p/>
     *         <important>
     *         <p>
     *         If you are creating an adjustment or verification labeling job, you must use a <i>different</i>
     *         <code>LabelAttributeName</code> than the one used in the original labeling job. The original labeling job
     *         is the Ground Truth labeling job that produced the labels that you want verified or adjusted. To learn
     *         more about adjustment and verification labeling jobs, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust
     *         Labels</a>.
     *         </p>
     */
    public final String labelAttributeName() {
        return labelAttributeName;
    }

    /**
     * <p>
     * Input data for the labeling job, such as the Amazon S3 location of the data objects and the location of the
     * manifest file that describes the data objects.
     * </p>
     * <p>
     * You must specify at least one of the following: <code>S3DataSource</code> or <code>SnsDataSource</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>SnsDataSource</code> to specify an SNS input topic for a streaming labeling job. If you do not specify
     * and SNS input topic ARN, Ground Truth will create a one-time labeling job that stops after all data objects in
     * the input manifest file have been labeled.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>S3DataSource</code> to specify an input manifest file for both streaming and one-time labeling jobs.
     * Adding an <code>S3DataSource</code> is optional if you use <code>SnsDataSource</code> to create a streaming
     * labeling job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you use the Amazon Mechanical Turk workforce, your input data should not include confidential information,
     * personal information or protected health information. Use <code>ContentClassifiers</code> to specify that your
     * data is free of personally identifiable information and adult content.
     * </p>
     * 
     * @return Input data for the labeling job, such as the Amazon S3 location of the data objects and the location of
     *         the manifest file that describes the data objects.</p>
     *         <p>
     *         You must specify at least one of the following: <code>S3DataSource</code> or <code>SnsDataSource</code>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Use <code>SnsDataSource</code> to specify an SNS input topic for a streaming labeling job. If you do not
     *         specify and SNS input topic ARN, Ground Truth will create a one-time labeling job that stops after all
     *         data objects in the input manifest file have been labeled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use <code>S3DataSource</code> to specify an input manifest file for both streaming and one-time labeling
     *         jobs. Adding an <code>S3DataSource</code> is optional if you use <code>SnsDataSource</code> to create a
     *         streaming labeling job.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you use the Amazon Mechanical Turk workforce, your input data should not include confidential
     *         information, personal information or protected health information. Use <code>ContentClassifiers</code> to
     *         specify that your data is free of personally identifiable information and adult content.
     */
    public final LabelingJobInputConfig inputConfig() {
        return inputConfig;
    }

    /**
     * <p>
     * The location of the output data and the Amazon Web Services Key Management Service key ID for the key used to
     * encrypt the output data, if any.
     * </p>
     * 
     * @return The location of the output data and the Amazon Web Services Key Management Service key ID for the key
     *         used to encrypt the output data, if any.
     */
    public final LabelingJobOutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during data
     * labeling. You must grant this role the necessary permissions so that Amazon SageMaker can successfully complete
     * data labeling.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during
     *         data labeling. You must grant this role the necessary permissions so that Amazon SageMaker can
     *         successfully complete data labeling.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The S3 URI of the file, referred to as a <i>label category configuration file</i>, that defines the categories
     * used to label the data objects.
     * </p>
     * <p>
     * For 3D point cloud and video frame task types, you can add label category attributes and frame attributes to your
     * label category configuration file. To learn how, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-label-category-config.html">Create a
     * Labeling Category Configuration File for 3D Point Cloud Labeling Jobs</a>.
     * </p>
     * <p>
     * For named entity recognition jobs, in addition to <code>"labels"</code>, you must provide worker instructions in
     * the label category configuration file using the <code>"instructions"</code> parameter:
     * <code>"instructions": {"shortInstruction":"&lt;h1&gt;Add header&lt;/h1&gt;&lt;p&gt;Add Instructions&lt;/p&gt;", "fullInstruction":"&lt;p&gt;Add additional instructions.&lt;/p&gt;"}</code>
     * . For details and an example, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-named-entity-recg.html#sms-creating-ner-api">Create a
     * Named Entity Recognition Labeling Job (API) </a>.
     * </p>
     * <p>
     * For all other <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task
     * types</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates.html">custom
     * tasks</a>, your label category configuration file must be a JSON file in the following format. Identify the
     * labels you want to use by replacing <code>label_1</code>, <code>label_2</code>,<code>...</code>,
     * <code>label_n</code> with your label categories.
     * </p>
     * <p>
     * <code>{ </code>
     * </p>
     * <p>
     * <code>"document-version": "2018-11-28",</code>
     * </p>
     * <p>
     * <code>"labels": [{"label": "label_1"},{"label": "label_2"},...{"label": "label_n"}]</code>
     * </p>
     * <p>
     * <code>}</code>
     * </p>
     * <p>
     * Note the following about the label category configuration file:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For image classification and text classification (single and multi-label) you must specify at least two label
     * categories. For all other task types, the minimum number of label categories required is one.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each label category must be unique, you cannot specify duplicate label categories.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you create a 3D point cloud or video frame adjustment or verification labeling job, you must include
     * <code>auditLabelAttributeName</code> in the label category configuration. Use this parameter to enter the <a
     * href=
     * "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateLabelingJob.html#sagemaker-CreateLabelingJob-request-LabelAttributeName"
     * > <code>LabelAttributeName</code> </a> of the labeling job you want to adjust or verify annotations of.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The S3 URI of the file, referred to as a <i>label category configuration file</i>, that defines the
     *         categories used to label the data objects.</p>
     *         <p>
     *         For 3D point cloud and video frame task types, you can add label category attributes and frame attributes
     *         to your label category configuration file. To learn how, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-label-category-config.html">Create
     *         a Labeling Category Configuration File for 3D Point Cloud Labeling Jobs</a>.
     *         </p>
     *         <p>
     *         For named entity recognition jobs, in addition to <code>"labels"</code>, you must provide worker
     *         instructions in the label category configuration file using the <code>"instructions"</code> parameter:
     *         <code>"instructions": {"shortInstruction":"&lt;h1&gt;Add header&lt;/h1&gt;&lt;p&gt;Add Instructions&lt;/p&gt;", "fullInstruction":"&lt;p&gt;Add additional instructions.&lt;/p&gt;"}</code>
     *         . For details and an example, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-named-entity-recg.html#sms-creating-ner-api"
     *         >Create a Named Entity Recognition Labeling Job (API) </a>.
     *         </p>
     *         <p>
     *         For all other <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task
     *         types</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates.html">custom
     *         tasks</a>, your label category configuration file must be a JSON file in the following format. Identify
     *         the labels you want to use by replacing <code>label_1</code>, <code>label_2</code>,<code>...</code>,
     *         <code>label_n</code> with your label categories.
     *         </p>
     *         <p>
     *         <code>{ </code>
     *         </p>
     *         <p>
     *         <code>"document-version": "2018-11-28",</code>
     *         </p>
     *         <p>
     *         <code>"labels": [{"label": "label_1"},{"label": "label_2"},...{"label": "label_n"}]</code>
     *         </p>
     *         <p>
     *         <code>}</code>
     *         </p>
     *         <p>
     *         Note the following about the label category configuration file:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For image classification and text classification (single and multi-label) you must specify at least two
     *         label categories. For all other task types, the minimum number of label categories required is one.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Each label category must be unique, you cannot specify duplicate label categories.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you create a 3D point cloud or video frame adjustment or verification labeling job, you must include
     *         <code>auditLabelAttributeName</code> in the label category configuration. Use this parameter to enter the
     *         <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateLabelingJob.html#sagemaker-CreateLabelingJob-request-LabelAttributeName"
     *         > <code>LabelAttributeName</code> </a> of the labeling job you want to adjust or verify annotations of.
     *         </p>
     *         </li>
     */
    public final String labelCategoryConfigS3Uri() {
        return labelCategoryConfigS3Uri;
    }

    /**
     * <p>
     * A set of conditions for stopping the labeling job. If any of the conditions are met, the job is automatically
     * stopped. You can use these conditions to control the cost of data labeling.
     * </p>
     * 
     * @return A set of conditions for stopping the labeling job. If any of the conditions are met, the job is
     *         automatically stopped. You can use these conditions to control the cost of data labeling.
     */
    public final LabelingJobStoppingConditions stoppingConditions() {
        return stoppingConditions;
    }

    /**
     * <p>
     * Configures the information required to perform automated data labeling.
     * </p>
     * 
     * @return Configures the information required to perform automated data labeling.
     */
    public final LabelingJobAlgorithmsConfig labelingJobAlgorithmsConfig() {
        return labelingJobAlgorithmsConfig;
    }

    /**
     * <p>
     * Configures the labeling task and how it is presented to workers; including, but not limited to price, keywords,
     * and batch size (task count).
     * </p>
     * 
     * @return Configures the labeling task and how it is presented to workers; including, but not limited to price,
     *         keywords, and batch size (task count).
     */
    public final HumanTaskConfig humanTaskConfig() {
        return humanTaskConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key/value pairs. For more information, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using
     * Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of key/value pairs. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
     *         >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(labelingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(labelAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(labelCategoryConfigS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingConditions());
        hashCode = 31 * hashCode + Objects.hashCode(labelingJobAlgorithmsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(humanTaskConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLabelingJobRequest)) {
            return false;
        }
        CreateLabelingJobRequest other = (CreateLabelingJobRequest) obj;
        return Objects.equals(labelingJobName(), other.labelingJobName())
                && Objects.equals(labelAttributeName(), other.labelAttributeName())
                && Objects.equals(inputConfig(), other.inputConfig()) && Objects.equals(outputConfig(), other.outputConfig())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(labelCategoryConfigS3Uri(), other.labelCategoryConfigS3Uri())
                && Objects.equals(stoppingConditions(), other.stoppingConditions())
                && Objects.equals(labelingJobAlgorithmsConfig(), other.labelingJobAlgorithmsConfig())
                && Objects.equals(humanTaskConfig(), other.humanTaskConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLabelingJobRequest").add("LabelingJobName", labelingJobName())
                .add("LabelAttributeName", labelAttributeName()).add("InputConfig", inputConfig())
                .add("OutputConfig", outputConfig()).add("RoleArn", roleArn())
                .add("LabelCategoryConfigS3Uri", labelCategoryConfigS3Uri()).add("StoppingConditions", stoppingConditions())
                .add("LabelingJobAlgorithmsConfig", labelingJobAlgorithmsConfig()).add("HumanTaskConfig", humanTaskConfig())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabelingJobName":
            return Optional.ofNullable(clazz.cast(labelingJobName()));
        case "LabelAttributeName":
            return Optional.ofNullable(clazz.cast(labelAttributeName()));
        case "InputConfig":
            return Optional.ofNullable(clazz.cast(inputConfig()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "LabelCategoryConfigS3Uri":
            return Optional.ofNullable(clazz.cast(labelCategoryConfigS3Uri()));
        case "StoppingConditions":
            return Optional.ofNullable(clazz.cast(stoppingConditions()));
        case "LabelingJobAlgorithmsConfig":
            return Optional.ofNullable(clazz.cast(labelingJobAlgorithmsConfig()));
        case "HumanTaskConfig":
            return Optional.ofNullable(clazz.cast(humanTaskConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateLabelingJobRequest, T> g) {
        return obj -> g.apply((CreateLabelingJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLabelingJobRequest> {
        /**
         * <p>
         * The name of the labeling job. This name is used to identify the job in a list of labeling jobs. Labeling job
         * names must be unique within an Amazon Web Services account and region. <code>LabelingJobName</code> is not
         * case sensitive. For example, Example-job and example-job are considered the same labeling job name by Ground
         * Truth.
         * </p>
         * 
         * @param labelingJobName
         *        The name of the labeling job. This name is used to identify the job in a list of labeling jobs.
         *        Labeling job names must be unique within an Amazon Web Services account and region.
         *        <code>LabelingJobName</code> is not case sensitive. For example, Example-job and example-job are
         *        considered the same labeling job name by Ground Truth.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelingJobName(String labelingJobName);

        /**
         * <p>
         * The attribute name to use for the label in the output manifest file. This is the key for the key/value pair
         * formed with the label that a worker assigns to the object. The <code>LabelAttributeName</code> must meet the
         * following requirements.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The name can't end with "-metadata".
         * </p>
         * </li>
         * <li>
         * <p>
         * If you are using one of the following <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a>, the
         * attribute name <i>must</i> end with "-ref". If the task type you are using is not listed below, the attribute
         * name <i>must not</i> end with "-ref".
         * </p>
         * <ul>
         * <li>
         * <p>
         * Image semantic segmentation (<code>SemanticSegmentation)</code>, and adjustment (
         * <code>AdjustmentSemanticSegmentation</code>) and verification (<code>VerificationSemanticSegmentation</code>)
         * labeling jobs for this task type.
         * </p>
         * </li>
         * <li>
         * <p>
         * Video frame object detection (<code>VideoObjectDetection</code>), and adjustment and verification (
         * <code>AdjustmentVideoObjectDetection</code>) labeling jobs for this task type.
         * </p>
         * </li>
         * <li>
         * <p>
         * Video frame object tracking (<code>VideoObjectTracking</code>), and adjustment and verification (
         * <code>AdjustmentVideoObjectTracking</code>) labeling jobs for this task type.
         * </p>
         * </li>
         * <li>
         * <p>
         * 3D point cloud semantic segmentation (<code>3DPointCloudSemanticSegmentation</code>), and adjustment and
         * verification (<code>Adjustment3DPointCloudSemanticSegmentation</code>) labeling jobs for this task type.
         * </p>
         * </li>
         * <li>
         * <p>
         * 3D point cloud object tracking (<code>3DPointCloudObjectTracking</code>), and adjustment and verification (
         * <code>Adjustment3DPointCloudObjectTracking</code>) labeling jobs for this task type.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p/>
         * <important>
         * <p>
         * If you are creating an adjustment or verification labeling job, you must use a <i>different</i>
         * <code>LabelAttributeName</code> than the one used in the original labeling job. The original labeling job is
         * the Ground Truth labeling job that produced the labels that you want verified or adjusted. To learn more
         * about adjustment and verification labeling jobs, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust
         * Labels</a>.
         * </p>
         * </important>
         * 
         * @param labelAttributeName
         *        The attribute name to use for the label in the output manifest file. This is the key for the key/value
         *        pair formed with the label that a worker assigns to the object. The <code>LabelAttributeName</code>
         *        must meet the following requirements.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The name can't end with "-metadata".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you are using one of the following <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a>,
         *        the attribute name <i>must</i> end with "-ref". If the task type you are using is not listed below,
         *        the attribute name <i>must not</i> end with "-ref".
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Image semantic segmentation (<code>SemanticSegmentation)</code>, and adjustment (
         *        <code>AdjustmentSemanticSegmentation</code>) and verification (
         *        <code>VerificationSemanticSegmentation</code>) labeling jobs for this task type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Video frame object detection (<code>VideoObjectDetection</code>), and adjustment and verification (
         *        <code>AdjustmentVideoObjectDetection</code>) labeling jobs for this task type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Video frame object tracking (<code>VideoObjectTracking</code>), and adjustment and verification (
         *        <code>AdjustmentVideoObjectTracking</code>) labeling jobs for this task type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        3D point cloud semantic segmentation (<code>3DPointCloudSemanticSegmentation</code>), and adjustment
         *        and verification (<code>Adjustment3DPointCloudSemanticSegmentation</code>) labeling jobs for this task
         *        type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        3D point cloud object tracking (<code>3DPointCloudObjectTracking</code>), and adjustment and
         *        verification (<code>Adjustment3DPointCloudObjectTracking</code>) labeling jobs for this task type.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p/>
         *        <important>
         *        <p>
         *        If you are creating an adjustment or verification labeling job, you must use a <i>different</i>
         *        <code>LabelAttributeName</code> than the one used in the original labeling job. The original labeling
         *        job is the Ground Truth labeling job that produced the labels that you want verified or adjusted. To
         *        learn more about adjustment and verification labeling jobs, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust
         *        Labels</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelAttributeName(String labelAttributeName);

        /**
         * <p>
         * Input data for the labeling job, such as the Amazon S3 location of the data objects and the location of the
         * manifest file that describes the data objects.
         * </p>
         * <p>
         * You must specify at least one of the following: <code>S3DataSource</code> or <code>SnsDataSource</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use <code>SnsDataSource</code> to specify an SNS input topic for a streaming labeling job. If you do not
         * specify and SNS input topic ARN, Ground Truth will create a one-time labeling job that stops after all data
         * objects in the input manifest file have been labeled.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>S3DataSource</code> to specify an input manifest file for both streaming and one-time labeling
         * jobs. Adding an <code>S3DataSource</code> is optional if you use <code>SnsDataSource</code> to create a
         * streaming labeling job.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you use the Amazon Mechanical Turk workforce, your input data should not include confidential information,
         * personal information or protected health information. Use <code>ContentClassifiers</code> to specify that
         * your data is free of personally identifiable information and adult content.
         * </p>
         * 
         * @param inputConfig
         *        Input data for the labeling job, such as the Amazon S3 location of the data objects and the location
         *        of the manifest file that describes the data objects.</p>
         *        <p>
         *        You must specify at least one of the following: <code>S3DataSource</code> or
         *        <code>SnsDataSource</code>.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Use <code>SnsDataSource</code> to specify an SNS input topic for a streaming labeling job. If you do
         *        not specify and SNS input topic ARN, Ground Truth will create a one-time labeling job that stops after
         *        all data objects in the input manifest file have been labeled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use <code>S3DataSource</code> to specify an input manifest file for both streaming and one-time
         *        labeling jobs. Adding an <code>S3DataSource</code> is optional if you use <code>SnsDataSource</code>
         *        to create a streaming labeling job.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you use the Amazon Mechanical Turk workforce, your input data should not include confidential
         *        information, personal information or protected health information. Use <code>ContentClassifiers</code>
         *        to specify that your data is free of personally identifiable information and adult content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfig(LabelingJobInputConfig inputConfig);

        /**
         * <p>
         * Input data for the labeling job, such as the Amazon S3 location of the data objects and the location of the
         * manifest file that describes the data objects.
         * </p>
         * <p>
         * You must specify at least one of the following: <code>S3DataSource</code> or <code>SnsDataSource</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use <code>SnsDataSource</code> to specify an SNS input topic for a streaming labeling job. If you do not
         * specify and SNS input topic ARN, Ground Truth will create a one-time labeling job that stops after all data
         * objects in the input manifest file have been labeled.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>S3DataSource</code> to specify an input manifest file for both streaming and one-time labeling
         * jobs. Adding an <code>S3DataSource</code> is optional if you use <code>SnsDataSource</code> to create a
         * streaming labeling job.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you use the Amazon Mechanical Turk workforce, your input data should not include confidential information,
         * personal information or protected health information. Use <code>ContentClassifiers</code> to specify that
         * your data is free of personally identifiable information and adult content.
         * </p>
         * This is a convenience method that creates an instance of the {@link LabelingJobInputConfig.Builder} avoiding
         * the need to create one manually via {@link LabelingJobInputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LabelingJobInputConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #inputConfig(LabelingJobInputConfig)}.
         * 
         * @param inputConfig
         *        a consumer that will call methods on {@link LabelingJobInputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConfig(LabelingJobInputConfig)
         */
        default Builder inputConfig(Consumer<LabelingJobInputConfig.Builder> inputConfig) {
            return inputConfig(LabelingJobInputConfig.builder().applyMutation(inputConfig).build());
        }

        /**
         * <p>
         * The location of the output data and the Amazon Web Services Key Management Service key ID for the key used to
         * encrypt the output data, if any.
         * </p>
         * 
         * @param outputConfig
         *        The location of the output data and the Amazon Web Services Key Management Service key ID for the key
         *        used to encrypt the output data, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(LabelingJobOutputConfig outputConfig);

        /**
         * <p>
         * The location of the output data and the Amazon Web Services Key Management Service key ID for the key used to
         * encrypt the output data, if any.
         * </p>
         * This is a convenience method that creates an instance of the {@link LabelingJobOutputConfig.Builder} avoiding
         * the need to create one manually via {@link LabelingJobOutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LabelingJobOutputConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #outputConfig(LabelingJobOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link LabelingJobOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(LabelingJobOutputConfig)
         */
        default Builder outputConfig(Consumer<LabelingJobOutputConfig.Builder> outputConfig) {
            return outputConfig(LabelingJobOutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Number (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during data
         * labeling. You must grant this role the necessary permissions so that Amazon SageMaker can successfully
         * complete data labeling.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Number (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during
         *        data labeling. You must grant this role the necessary permissions so that Amazon SageMaker can
         *        successfully complete data labeling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The S3 URI of the file, referred to as a <i>label category configuration file</i>, that defines the
         * categories used to label the data objects.
         * </p>
         * <p>
         * For 3D point cloud and video frame task types, you can add label category attributes and frame attributes to
         * your label category configuration file. To learn how, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-label-category-config.html">Create a
         * Labeling Category Configuration File for 3D Point Cloud Labeling Jobs</a>.
         * </p>
         * <p>
         * For named entity recognition jobs, in addition to <code>"labels"</code>, you must provide worker instructions
         * in the label category configuration file using the <code>"instructions"</code> parameter:
         * <code>"instructions": {"shortInstruction":"&lt;h1&gt;Add header&lt;/h1&gt;&lt;p&gt;Add Instructions&lt;/p&gt;", "fullInstruction":"&lt;p&gt;Add additional instructions.&lt;/p&gt;"}</code>
         * . For details and an example, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-named-entity-recg.html#sms-creating-ner-api">Create
         * a Named Entity Recognition Labeling Job (API) </a>.
         * </p>
         * <p>
         * For all other <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task
         * types</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates.html">custom
         * tasks</a>, your label category configuration file must be a JSON file in the following format. Identify the
         * labels you want to use by replacing <code>label_1</code>, <code>label_2</code>,<code>...</code>,
         * <code>label_n</code> with your label categories.
         * </p>
         * <p>
         * <code>{ </code>
         * </p>
         * <p>
         * <code>"document-version": "2018-11-28",</code>
         * </p>
         * <p>
         * <code>"labels": [{"label": "label_1"},{"label": "label_2"},...{"label": "label_n"}]</code>
         * </p>
         * <p>
         * <code>}</code>
         * </p>
         * <p>
         * Note the following about the label category configuration file:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For image classification and text classification (single and multi-label) you must specify at least two label
         * categories. For all other task types, the minimum number of label categories required is one.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each label category must be unique, you cannot specify duplicate label categories.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you create a 3D point cloud or video frame adjustment or verification labeling job, you must include
         * <code>auditLabelAttributeName</code> in the label category configuration. Use this parameter to enter the <a
         * href=
         * "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateLabelingJob.html#sagemaker-CreateLabelingJob-request-LabelAttributeName"
         * > <code>LabelAttributeName</code> </a> of the labeling job you want to adjust or verify annotations of.
         * </p>
         * </li>
         * </ul>
         * 
         * @param labelCategoryConfigS3Uri
         *        The S3 URI of the file, referred to as a <i>label category configuration file</i>, that defines the
         *        categories used to label the data objects.</p>
         *        <p>
         *        For 3D point cloud and video frame task types, you can add label category attributes and frame
         *        attributes to your label category configuration file. To learn how, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-label-category-config.html"
         *        >Create a Labeling Category Configuration File for 3D Point Cloud Labeling Jobs</a>.
         *        </p>
         *        <p>
         *        For named entity recognition jobs, in addition to <code>"labels"</code>, you must provide worker
         *        instructions in the label category configuration file using the <code>"instructions"</code> parameter:
         *        <code>"instructions": {"shortInstruction":"&lt;h1&gt;Add header&lt;/h1&gt;&lt;p&gt;Add Instructions&lt;/p&gt;", "fullInstruction":"&lt;p&gt;Add additional instructions.&lt;/p&gt;"}</code>
         *        . For details and an example, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/sms-named-entity-recg.html#sms-creating-ner-api"
         *        >Create a Named Entity Recognition Labeling Job (API) </a>.
         *        </p>
         *        <p>
         *        For all other <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in
         *        task types</a> and <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates.html">custom tasks</a>,
         *        your label category configuration file must be a JSON file in the following format. Identify the
         *        labels you want to use by replacing <code>label_1</code>, <code>label_2</code>,<code>...</code>,
         *        <code>label_n</code> with your label categories.
         *        </p>
         *        <p>
         *        <code>{ </code>
         *        </p>
         *        <p>
         *        <code>"document-version": "2018-11-28",</code>
         *        </p>
         *        <p>
         *        <code>"labels": [{"label": "label_1"},{"label": "label_2"},...{"label": "label_n"}]</code>
         *        </p>
         *        <p>
         *        <code>}</code>
         *        </p>
         *        <p>
         *        Note the following about the label category configuration file:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For image classification and text classification (single and multi-label) you must specify at least
         *        two label categories. For all other task types, the minimum number of label categories required is
         *        one.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each label category must be unique, you cannot specify duplicate label categories.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you create a 3D point cloud or video frame adjustment or verification labeling job, you must
         *        include <code>auditLabelAttributeName</code> in the label category configuration. Use this parameter
         *        to enter the <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateLabelingJob.html#sagemaker-CreateLabelingJob-request-LabelAttributeName"
         *        > <code>LabelAttributeName</code> </a> of the labeling job you want to adjust or verify annotations
         *        of.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelCategoryConfigS3Uri(String labelCategoryConfigS3Uri);

        /**
         * <p>
         * A set of conditions for stopping the labeling job. If any of the conditions are met, the job is automatically
         * stopped. You can use these conditions to control the cost of data labeling.
         * </p>
         * 
         * @param stoppingConditions
         *        A set of conditions for stopping the labeling job. If any of the conditions are met, the job is
         *        automatically stopped. You can use these conditions to control the cost of data labeling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingConditions(LabelingJobStoppingConditions stoppingConditions);

        /**
         * <p>
         * A set of conditions for stopping the labeling job. If any of the conditions are met, the job is automatically
         * stopped. You can use these conditions to control the cost of data labeling.
         * </p>
         * This is a convenience method that creates an instance of the {@link LabelingJobStoppingConditions.Builder}
         * avoiding the need to create one manually via {@link LabelingJobStoppingConditions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LabelingJobStoppingConditions.Builder#build()} is called
         * immediately and its result is passed to {@link #stoppingConditions(LabelingJobStoppingConditions)}.
         * 
         * @param stoppingConditions
         *        a consumer that will call methods on {@link LabelingJobStoppingConditions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingConditions(LabelingJobStoppingConditions)
         */
        default Builder stoppingConditions(Consumer<LabelingJobStoppingConditions.Builder> stoppingConditions) {
            return stoppingConditions(LabelingJobStoppingConditions.builder().applyMutation(stoppingConditions).build());
        }

        /**
         * <p>
         * Configures the information required to perform automated data labeling.
         * </p>
         * 
         * @param labelingJobAlgorithmsConfig
         *        Configures the information required to perform automated data labeling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelingJobAlgorithmsConfig(LabelingJobAlgorithmsConfig labelingJobAlgorithmsConfig);

        /**
         * <p>
         * Configures the information required to perform automated data labeling.
         * </p>
         * This is a convenience method that creates an instance of the {@link LabelingJobAlgorithmsConfig.Builder}
         * avoiding the need to create one manually via {@link LabelingJobAlgorithmsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LabelingJobAlgorithmsConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #labelingJobAlgorithmsConfig(LabelingJobAlgorithmsConfig)}.
         * 
         * @param labelingJobAlgorithmsConfig
         *        a consumer that will call methods on {@link LabelingJobAlgorithmsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelingJobAlgorithmsConfig(LabelingJobAlgorithmsConfig)
         */
        default Builder labelingJobAlgorithmsConfig(Consumer<LabelingJobAlgorithmsConfig.Builder> labelingJobAlgorithmsConfig) {
            return labelingJobAlgorithmsConfig(LabelingJobAlgorithmsConfig.builder().applyMutation(labelingJobAlgorithmsConfig)
                    .build());
        }

        /**
         * <p>
         * Configures the labeling task and how it is presented to workers; including, but not limited to price,
         * keywords, and batch size (task count).
         * </p>
         * 
         * @param humanTaskConfig
         *        Configures the labeling task and how it is presented to workers; including, but not limited to price,
         *        keywords, and batch size (task count).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanTaskConfig(HumanTaskConfig humanTaskConfig);

        /**
         * <p>
         * Configures the labeling task and how it is presented to workers; including, but not limited to price,
         * keywords, and batch size (task count).
         * </p>
         * This is a convenience method that creates an instance of the {@link HumanTaskConfig.Builder} avoiding the
         * need to create one manually via {@link HumanTaskConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HumanTaskConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #humanTaskConfig(HumanTaskConfig)}.
         * 
         * @param humanTaskConfig
         *        a consumer that will call methods on {@link HumanTaskConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #humanTaskConfig(HumanTaskConfig)
         */
        default Builder humanTaskConfig(Consumer<HumanTaskConfig.Builder> humanTaskConfig) {
            return humanTaskConfig(HumanTaskConfig.builder().applyMutation(humanTaskConfig).build());
        }

        /**
         * <p>
         * An array of key/value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
         * >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
         * </p>
         * 
         * @param tags
         *        An array of key/value pairs. For more information, see <a href=
         *        "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
         *        >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key/value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
         * >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
         * </p>
         * 
         * @param tags
         *        An array of key/value pairs. For more information, see <a href=
         *        "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
         *        >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key/value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
         * >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String labelingJobName;

        private String labelAttributeName;

        private LabelingJobInputConfig inputConfig;

        private LabelingJobOutputConfig outputConfig;

        private String roleArn;

        private String labelCategoryConfigS3Uri;

        private LabelingJobStoppingConditions stoppingConditions;

        private LabelingJobAlgorithmsConfig labelingJobAlgorithmsConfig;

        private HumanTaskConfig humanTaskConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLabelingJobRequest model) {
            super(model);
            labelingJobName(model.labelingJobName);
            labelAttributeName(model.labelAttributeName);
            inputConfig(model.inputConfig);
            outputConfig(model.outputConfig);
            roleArn(model.roleArn);
            labelCategoryConfigS3Uri(model.labelCategoryConfigS3Uri);
            stoppingConditions(model.stoppingConditions);
            labelingJobAlgorithmsConfig(model.labelingJobAlgorithmsConfig);
            humanTaskConfig(model.humanTaskConfig);
            tags(model.tags);
        }

        public final String getLabelingJobName() {
            return labelingJobName;
        }

        public final void setLabelingJobName(String labelingJobName) {
            this.labelingJobName = labelingJobName;
        }

        @Override
        public final Builder labelingJobName(String labelingJobName) {
            this.labelingJobName = labelingJobName;
            return this;
        }

        public final String getLabelAttributeName() {
            return labelAttributeName;
        }

        public final void setLabelAttributeName(String labelAttributeName) {
            this.labelAttributeName = labelAttributeName;
        }

        @Override
        public final Builder labelAttributeName(String labelAttributeName) {
            this.labelAttributeName = labelAttributeName;
            return this;
        }

        public final LabelingJobInputConfig.Builder getInputConfig() {
            return inputConfig != null ? inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(LabelingJobInputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        public final Builder inputConfig(LabelingJobInputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final LabelingJobOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(LabelingJobOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(LabelingJobOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getLabelCategoryConfigS3Uri() {
            return labelCategoryConfigS3Uri;
        }

        public final void setLabelCategoryConfigS3Uri(String labelCategoryConfigS3Uri) {
            this.labelCategoryConfigS3Uri = labelCategoryConfigS3Uri;
        }

        @Override
        public final Builder labelCategoryConfigS3Uri(String labelCategoryConfigS3Uri) {
            this.labelCategoryConfigS3Uri = labelCategoryConfigS3Uri;
            return this;
        }

        public final LabelingJobStoppingConditions.Builder getStoppingConditions() {
            return stoppingConditions != null ? stoppingConditions.toBuilder() : null;
        }

        public final void setStoppingConditions(LabelingJobStoppingConditions.BuilderImpl stoppingConditions) {
            this.stoppingConditions = stoppingConditions != null ? stoppingConditions.build() : null;
        }

        @Override
        public final Builder stoppingConditions(LabelingJobStoppingConditions stoppingConditions) {
            this.stoppingConditions = stoppingConditions;
            return this;
        }

        public final LabelingJobAlgorithmsConfig.Builder getLabelingJobAlgorithmsConfig() {
            return labelingJobAlgorithmsConfig != null ? labelingJobAlgorithmsConfig.toBuilder() : null;
        }

        public final void setLabelingJobAlgorithmsConfig(LabelingJobAlgorithmsConfig.BuilderImpl labelingJobAlgorithmsConfig) {
            this.labelingJobAlgorithmsConfig = labelingJobAlgorithmsConfig != null ? labelingJobAlgorithmsConfig.build() : null;
        }

        @Override
        public final Builder labelingJobAlgorithmsConfig(LabelingJobAlgorithmsConfig labelingJobAlgorithmsConfig) {
            this.labelingJobAlgorithmsConfig = labelingJobAlgorithmsConfig;
            return this;
        }

        public final HumanTaskConfig.Builder getHumanTaskConfig() {
            return humanTaskConfig != null ? humanTaskConfig.toBuilder() : null;
        }

        public final void setHumanTaskConfig(HumanTaskConfig.BuilderImpl humanTaskConfig) {
            this.humanTaskConfig = humanTaskConfig != null ? humanTaskConfig.build() : null;
        }

        @Override
        public final Builder humanTaskConfig(HumanTaskConfig humanTaskConfig) {
            this.humanTaskConfig = humanTaskConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLabelingJobRequest build() {
            return new CreateLabelingJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
