/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateModelCardRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateModelCardRequest.Builder, CreateModelCardRequest> {
    private static final SdkField<String> MODEL_CARD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardName").getter(getter(CreateModelCardRequest::modelCardName))
            .setter(setter(Builder::modelCardName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardName").build()).build();

    private static final SdkField<ModelCardSecurityConfig> SECURITY_CONFIG_FIELD = SdkField
            .<ModelCardSecurityConfig> builder(MarshallingType.SDK_POJO).memberName("SecurityConfig")
            .getter(getter(CreateModelCardRequest::securityConfig)).setter(setter(Builder::securityConfig))
            .constructor(ModelCardSecurityConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfig").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(CreateModelCardRequest::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> MODEL_CARD_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardStatus").getter(getter(CreateModelCardRequest::modelCardStatusAsString))
            .setter(setter(Builder::modelCardStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardStatus").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateModelCardRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_CARD_NAME_FIELD,
            SECURITY_CONFIG_FIELD, CONTENT_FIELD, MODEL_CARD_STATUS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ModelCardName", MODEL_CARD_NAME_FIELD);
                    put("SecurityConfig", SECURITY_CONFIG_FIELD);
                    put("Content", CONTENT_FIELD);
                    put("ModelCardStatus", MODEL_CARD_STATUS_FIELD);
                    put("Tags", TAGS_FIELD);
                }
            });

    private final String modelCardName;

    private final ModelCardSecurityConfig securityConfig;

    private final String content;

    private final String modelCardStatus;

    private final List<Tag> tags;

    private CreateModelCardRequest(BuilderImpl builder) {
        super(builder);
        this.modelCardName = builder.modelCardName;
        this.securityConfig = builder.securityConfig;
        this.content = builder.content;
        this.modelCardStatus = builder.modelCardStatus;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique name of the model card.
     * </p>
     * 
     * @return The unique name of the model card.
     */
    public final String modelCardName() {
        return modelCardName;
    }

    /**
     * <p>
     * An optional Key Management Service key to encrypt, decrypt, and re-encrypt model card content for regulated
     * workloads with highly sensitive data.
     * </p>
     * 
     * @return An optional Key Management Service key to encrypt, decrypt, and re-encrypt model card content for
     *         regulated workloads with highly sensitive data.
     */
    public final ModelCardSecurityConfig securityConfig() {
        return securityConfig;
    }

    /**
     * <p>
     * The content of the model card. Content must be in <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html#model-cards-json-schema">model card JSON
     * schema</a> and provided as a string.
     * </p>
     * 
     * @return The content of the model card. Content must be in <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html#model-cards-json-schema">model
     *         card JSON schema</a> and provided as a string.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The approval status of the model card within your organization. Different organizations might have different
     * criteria for model card review and approval.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Draft</code>: The model card is a work in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PendingReview</code>: The model card is pending review.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Approved</code>: The model card is approved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but it can
     * still be exported.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelCardStatus}
     * will return {@link ModelCardStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #modelCardStatusAsString}.
     * </p>
     * 
     * @return The approval status of the model card within your organization. Different organizations might have
     *         different criteria for model card review and approval.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Draft</code>: The model card is a work in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PendingReview</code>: The model card is pending review.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Approved</code>: The model card is approved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but
     *         it can still be exported.
     *         </p>
     *         </li>
     * @see ModelCardStatus
     */
    public final ModelCardStatus modelCardStatus() {
        return ModelCardStatus.fromValue(modelCardStatus);
    }

    /**
     * <p>
     * The approval status of the model card within your organization. Different organizations might have different
     * criteria for model card review and approval.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Draft</code>: The model card is a work in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PendingReview</code>: The model card is pending review.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Approved</code>: The model card is approved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but it can
     * still be exported.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelCardStatus}
     * will return {@link ModelCardStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #modelCardStatusAsString}.
     * </p>
     * 
     * @return The approval status of the model card within your organization. Different organizations might have
     *         different criteria for model card review and approval.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Draft</code>: The model card is a work in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PendingReview</code>: The model card is pending review.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Approved</code>: The model card is approved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but
     *         it can still be exported.
     *         </p>
     *         </li>
     * @see ModelCardStatus
     */
    public final String modelCardStatusAsString() {
        return modelCardStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Key-value pairs used to manage metadata for model cards.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Key-value pairs used to manage metadata for model cards.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelCardName());
        hashCode = 31 * hashCode + Objects.hashCode(securityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelCardRequest)) {
            return false;
        }
        CreateModelCardRequest other = (CreateModelCardRequest) obj;
        return Objects.equals(modelCardName(), other.modelCardName()) && Objects.equals(securityConfig(), other.securityConfig())
                && Objects.equals(content(), other.content())
                && Objects.equals(modelCardStatusAsString(), other.modelCardStatusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateModelCardRequest").add("ModelCardName", modelCardName())
                .add("SecurityConfig", securityConfig())
                .add("Content", content() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ModelCardStatus", modelCardStatusAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelCardName":
            return Optional.ofNullable(clazz.cast(modelCardName()));
        case "SecurityConfig":
            return Optional.ofNullable(clazz.cast(securityConfig()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "ModelCardStatus":
            return Optional.ofNullable(clazz.cast(modelCardStatusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelCardRequest, T> g) {
        return obj -> g.apply((CreateModelCardRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateModelCardRequest> {
        /**
         * <p>
         * The unique name of the model card.
         * </p>
         * 
         * @param modelCardName
         *        The unique name of the model card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardName(String modelCardName);

        /**
         * <p>
         * An optional Key Management Service key to encrypt, decrypt, and re-encrypt model card content for regulated
         * workloads with highly sensitive data.
         * </p>
         * 
         * @param securityConfig
         *        An optional Key Management Service key to encrypt, decrypt, and re-encrypt model card content for
         *        regulated workloads with highly sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfig(ModelCardSecurityConfig securityConfig);

        /**
         * <p>
         * An optional Key Management Service key to encrypt, decrypt, and re-encrypt model card content for regulated
         * workloads with highly sensitive data.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelCardSecurityConfig.Builder} avoiding
         * the need to create one manually via {@link ModelCardSecurityConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelCardSecurityConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #securityConfig(ModelCardSecurityConfig)}.
         * 
         * @param securityConfig
         *        a consumer that will call methods on {@link ModelCardSecurityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityConfig(ModelCardSecurityConfig)
         */
        default Builder securityConfig(Consumer<ModelCardSecurityConfig.Builder> securityConfig) {
            return securityConfig(ModelCardSecurityConfig.builder().applyMutation(securityConfig).build());
        }

        /**
         * <p>
         * The content of the model card. Content must be in <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html#model-cards-json-schema">model card
         * JSON schema</a> and provided as a string.
         * </p>
         * 
         * @param content
         *        The content of the model card. Content must be in <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html#model-cards-json-schema">model
         *        card JSON schema</a> and provided as a string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The approval status of the model card within your organization. Different organizations might have different
         * criteria for model card review and approval.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Draft</code>: The model card is a work in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PendingReview</code>: The model card is pending review.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Approved</code>: The model card is approved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but it
         * can still be exported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelCardStatus
         *        The approval status of the model card within your organization. Different organizations might have
         *        different criteria for model card review and approval.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Draft</code>: The model card is a work in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PendingReview</code>: The model card is pending review.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Approved</code>: The model card is approved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Archived</code>: The model card is archived. No more updates should be made to the model card,
         *        but it can still be exported.
         *        </p>
         *        </li>
         * @see ModelCardStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardStatus
         */
        Builder modelCardStatus(String modelCardStatus);

        /**
         * <p>
         * The approval status of the model card within your organization. Different organizations might have different
         * criteria for model card review and approval.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Draft</code>: The model card is a work in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PendingReview</code>: The model card is pending review.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Approved</code>: The model card is approved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but it
         * can still be exported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelCardStatus
         *        The approval status of the model card within your organization. Different organizations might have
         *        different criteria for model card review and approval.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Draft</code>: The model card is a work in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PendingReview</code>: The model card is pending review.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Approved</code>: The model card is approved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Archived</code>: The model card is archived. No more updates should be made to the model card,
         *        but it can still be exported.
         *        </p>
         *        </li>
         * @see ModelCardStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardStatus
         */
        Builder modelCardStatus(ModelCardStatus modelCardStatus);

        /**
         * <p>
         * Key-value pairs used to manage metadata for model cards.
         * </p>
         * 
         * @param tags
         *        Key-value pairs used to manage metadata for model cards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Key-value pairs used to manage metadata for model cards.
         * </p>
         * 
         * @param tags
         *        Key-value pairs used to manage metadata for model cards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Key-value pairs used to manage metadata for model cards.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String modelCardName;

        private ModelCardSecurityConfig securityConfig;

        private String content;

        private String modelCardStatus;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelCardRequest model) {
            super(model);
            modelCardName(model.modelCardName);
            securityConfig(model.securityConfig);
            content(model.content);
            modelCardStatus(model.modelCardStatus);
            tags(model.tags);
        }

        public final String getModelCardName() {
            return modelCardName;
        }

        public final void setModelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
        }

        @Override
        public final Builder modelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
            return this;
        }

        public final ModelCardSecurityConfig.Builder getSecurityConfig() {
            return securityConfig != null ? securityConfig.toBuilder() : null;
        }

        public final void setSecurityConfig(ModelCardSecurityConfig.BuilderImpl securityConfig) {
            this.securityConfig = securityConfig != null ? securityConfig.build() : null;
        }

        @Override
        public final Builder securityConfig(ModelCardSecurityConfig securityConfig) {
            this.securityConfig = securityConfig;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getModelCardStatus() {
            return modelCardStatus;
        }

        public final void setModelCardStatus(String modelCardStatus) {
            this.modelCardStatus = modelCardStatus;
        }

        @Override
        public final Builder modelCardStatus(String modelCardStatus) {
            this.modelCardStatus = modelCardStatus;
            return this;
        }

        @Override
        public final Builder modelCardStatus(ModelCardStatus modelCardStatus) {
            this.modelCardStatus(modelCardStatus == null ? null : modelCardStatus.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelCardRequest build() {
            return new CreateModelCardRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
