/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNotebookInstanceRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateNotebookInstanceRequest.Builder, CreateNotebookInstanceRequest> {
    private static final SdkField<String> NOTEBOOK_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotebookInstanceName").getter(getter(CreateNotebookInstanceRequest::notebookInstanceName))
            .setter(setter(Builder::notebookInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceName").build())
            .build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(CreateNotebookInstanceRequest::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(CreateNotebookInstanceRequest::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(CreateNotebookInstanceRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateNotebookInstanceRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateNotebookInstanceRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateNotebookInstanceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LIFECYCLE_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LifecycleConfigName").getter(getter(CreateNotebookInstanceRequest::lifecycleConfigName))
            .setter(setter(Builder::lifecycleConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleConfigName").build())
            .build();

    private static final SdkField<String> DIRECT_INTERNET_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectInternetAccess").getter(getter(CreateNotebookInstanceRequest::directInternetAccessAsString))
            .setter(setter(Builder::directInternetAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectInternetAccess").build())
            .build();

    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumeSizeInGB").getter(getter(CreateNotebookInstanceRequest::volumeSizeInGB))
            .setter(setter(Builder::volumeSizeInGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInGB").build()).build();

    private static final SdkField<List<String>> ACCELERATOR_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AcceleratorTypes")
            .getter(getter(CreateNotebookInstanceRequest::acceleratorTypesAsStrings))
            .setter(setter(Builder::acceleratorTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_CODE_REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultCodeRepository").getter(getter(CreateNotebookInstanceRequest::defaultCodeRepository))
            .setter(setter(Builder::defaultCodeRepository))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCodeRepository").build())
            .build();

    private static final SdkField<List<String>> ADDITIONAL_CODE_REPOSITORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalCodeRepositories")
            .getter(getter(CreateNotebookInstanceRequest::additionalCodeRepositories))
            .setter(setter(Builder::additionalCodeRepositories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalCodeRepositories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROOT_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RootAccess").getter(getter(CreateNotebookInstanceRequest::rootAccessAsString))
            .setter(setter(Builder::rootAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootAccess").build()).build();

    private static final SdkField<String> PLATFORM_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformIdentifier").getter(getter(CreateNotebookInstanceRequest::platformIdentifier))
            .setter(setter(Builder::platformIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformIdentifier").build())
            .build();

    private static final SdkField<InstanceMetadataServiceConfiguration> INSTANCE_METADATA_SERVICE_CONFIGURATION_FIELD = SdkField
            .<InstanceMetadataServiceConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceMetadataServiceConfiguration")
            .getter(getter(CreateNotebookInstanceRequest::instanceMetadataServiceConfiguration))
            .setter(setter(Builder::instanceMetadataServiceConfiguration))
            .constructor(InstanceMetadataServiceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("InstanceMetadataServiceConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_INSTANCE_NAME_FIELD,
            INSTANCE_TYPE_FIELD, SUBNET_ID_FIELD, SECURITY_GROUP_IDS_FIELD, ROLE_ARN_FIELD, KMS_KEY_ID_FIELD, TAGS_FIELD,
            LIFECYCLE_CONFIG_NAME_FIELD, DIRECT_INTERNET_ACCESS_FIELD, VOLUME_SIZE_IN_GB_FIELD, ACCELERATOR_TYPES_FIELD,
            DEFAULT_CODE_REPOSITORY_FIELD, ADDITIONAL_CODE_REPOSITORIES_FIELD, ROOT_ACCESS_FIELD, PLATFORM_IDENTIFIER_FIELD,
            INSTANCE_METADATA_SERVICE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("NotebookInstanceName", NOTEBOOK_INSTANCE_NAME_FIELD);
                    put("InstanceType", INSTANCE_TYPE_FIELD);
                    put("SubnetId", SUBNET_ID_FIELD);
                    put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
                    put("RoleArn", ROLE_ARN_FIELD);
                    put("KmsKeyId", KMS_KEY_ID_FIELD);
                    put("Tags", TAGS_FIELD);
                    put("LifecycleConfigName", LIFECYCLE_CONFIG_NAME_FIELD);
                    put("DirectInternetAccess", DIRECT_INTERNET_ACCESS_FIELD);
                    put("VolumeSizeInGB", VOLUME_SIZE_IN_GB_FIELD);
                    put("AcceleratorTypes", ACCELERATOR_TYPES_FIELD);
                    put("DefaultCodeRepository", DEFAULT_CODE_REPOSITORY_FIELD);
                    put("AdditionalCodeRepositories", ADDITIONAL_CODE_REPOSITORIES_FIELD);
                    put("RootAccess", ROOT_ACCESS_FIELD);
                    put("PlatformIdentifier", PLATFORM_IDENTIFIER_FIELD);
                    put("InstanceMetadataServiceConfiguration", INSTANCE_METADATA_SERVICE_CONFIGURATION_FIELD);
                }
            });

    private final String notebookInstanceName;

    private final String instanceType;

    private final String subnetId;

    private final List<String> securityGroupIds;

    private final String roleArn;

    private final String kmsKeyId;

    private final List<Tag> tags;

    private final String lifecycleConfigName;

    private final String directInternetAccess;

    private final Integer volumeSizeInGB;

    private final List<String> acceleratorTypes;

    private final String defaultCodeRepository;

    private final List<String> additionalCodeRepositories;

    private final String rootAccess;

    private final String platformIdentifier;

    private final InstanceMetadataServiceConfiguration instanceMetadataServiceConfiguration;

    private CreateNotebookInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.notebookInstanceName = builder.notebookInstanceName;
        this.instanceType = builder.instanceType;
        this.subnetId = builder.subnetId;
        this.securityGroupIds = builder.securityGroupIds;
        this.roleArn = builder.roleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
        this.lifecycleConfigName = builder.lifecycleConfigName;
        this.directInternetAccess = builder.directInternetAccess;
        this.volumeSizeInGB = builder.volumeSizeInGB;
        this.acceleratorTypes = builder.acceleratorTypes;
        this.defaultCodeRepository = builder.defaultCodeRepository;
        this.additionalCodeRepositories = builder.additionalCodeRepositories;
        this.rootAccess = builder.rootAccess;
        this.platformIdentifier = builder.platformIdentifier;
        this.instanceMetadataServiceConfiguration = builder.instanceMetadataServiceConfiguration;
    }

    /**
     * <p>
     * The name of the new notebook instance.
     * </p>
     * 
     * @return The name of the new notebook instance.
     */
    public final String notebookInstanceName() {
        return notebookInstanceName;
    }

    /**
     * <p>
     * The type of ML compute instance to launch for the notebook instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type of ML compute instance to launch for the notebook instance.
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The type of ML compute instance to launch for the notebook instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type of ML compute instance to launch for the notebook instance.
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the subnet in a VPC to which you would like to have a connectivity from your ML compute instance.
     * </p>
     * 
     * @return The ID of the subnet in a VPC to which you would like to have a connectivity from your ML compute
     *         instance.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be for the same VPC as specified in
     * the subnet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be for the same VPC as
     *         specified in the subnet.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * When you send any requests to Amazon Web Services resources from the notebook instance, SageMaker assumes this
     * role to perform tasks on your behalf. You must grant this role necessary permissions so SageMaker can perform
     * these tasks. The policy must allow the SageMaker service principal (sagemaker.amazonaws.com) permissions to
     * assume this role. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">SageMaker Roles</a>.
     * </p>
     * <note>
     * <p>
     * To be able to pass this role to SageMaker, the caller of this API must have the <code>iam:PassRole</code>
     * permission.
     * </p>
     * </note>
     * 
     * @return When you send any requests to Amazon Web Services resources from the notebook instance, SageMaker assumes
     *         this role to perform tasks on your behalf. You must grant this role necessary permissions so SageMaker
     *         can perform these tasks. The policy must allow the SageMaker service principal (sagemaker.amazonaws.com)
     *         permissions to assume this role. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">SageMaker Roles</a>. </p>
     *         <note>
     *         <p>
     *         To be able to pass this role to SageMaker, the caller of this API must have the <code>iam:PassRole</code>
     *         permission.
     *         </p>
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that SageMaker uses to encrypt
     * data on the storage volume attached to your notebook instance. The KMS key you provide must be enabled. For
     * information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and
     * Disabling Keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that SageMaker uses to
     *         encrypt data on the storage volume attached to your notebook instance. The KMS key you provide must be
     *         enabled. For information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and Disabling
     *         Keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways,
     * for example, by purpose, owner, or environment. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
     *         different ways, for example, by purpose, owner, or environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         Resources</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The name of a lifecycle configuration to associate with the notebook instance. For information about lifestyle
     * configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step
     * 2.1: (Optional) Customize a Notebook Instance</a>.
     * </p>
     * 
     * @return The name of a lifecycle configuration to associate with the notebook instance. For information about
     *         lifestyle configurations, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1:
     *         (Optional) Customize a Notebook Instance</a>.
     */
    public final String lifecycleConfigName() {
        return lifecycleConfigName;
    }

    /**
     * <p>
     * Sets whether SageMaker provides internet access to the notebook instance. If you set this to
     * <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not be able to
     * connect to SageMaker training and endpoint services unless you configure a NAT Gateway in your VPC.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
     * >Notebook Instances Are Internet-Enabled by Default</a>. You can set the value of this parameter to
     * <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #directInternetAccess} will return {@link DirectInternetAccess#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #directInternetAccessAsString}.
     * </p>
     * 
     * @return Sets whether SageMaker provides internet access to the notebook instance. If you set this to
     *         <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not be
     *         able to connect to SageMaker training and endpoint services unless you configure a NAT Gateway in your
     *         VPC.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
     *         >Notebook Instances Are Internet-Enabled by Default</a>. You can set the value of this parameter to
     *         <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.
     * @see DirectInternetAccess
     */
    public final DirectInternetAccess directInternetAccess() {
        return DirectInternetAccess.fromValue(directInternetAccess);
    }

    /**
     * <p>
     * Sets whether SageMaker provides internet access to the notebook instance. If you set this to
     * <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not be able to
     * connect to SageMaker training and endpoint services unless you configure a NAT Gateway in your VPC.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
     * >Notebook Instances Are Internet-Enabled by Default</a>. You can set the value of this parameter to
     * <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #directInternetAccess} will return {@link DirectInternetAccess#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #directInternetAccessAsString}.
     * </p>
     * 
     * @return Sets whether SageMaker provides internet access to the notebook instance. If you set this to
     *         <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not be
     *         able to connect to SageMaker training and endpoint services unless you configure a NAT Gateway in your
     *         VPC.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
     *         >Notebook Instances Are Internet-Enabled by Default</a>. You can set the value of this parameter to
     *         <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.
     * @see DirectInternetAccess
     */
    public final String directInternetAccessAsString() {
        return directInternetAccess;
    }

    /**
     * <p>
     * The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB.
     * </p>
     * 
     * @return The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB.
     */
    public final Integer volumeSizeInGB() {
        return volumeSizeInGB;
    }

    /**
     * <p>
     * This parameter is no longer supported. Elastic Inference (EI) is no longer available.
     * </p>
     * <p>
     * This parameter was used to specify a list of EI instance types to associate with this notebook instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAcceleratorTypes} method.
     * </p>
     * 
     * @return This parameter is no longer supported. Elastic Inference (EI) is no longer available.</p>
     *         <p>
     *         This parameter was used to specify a list of EI instance types to associate with this notebook instance.
     */
    public final List<NotebookInstanceAcceleratorType> acceleratorTypes() {
        return NotebookInstanceAcceleratorTypesCopier.copyStringToEnum(acceleratorTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the AcceleratorTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAcceleratorTypes() {
        return acceleratorTypes != null && !(acceleratorTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This parameter is no longer supported. Elastic Inference (EI) is no longer available.
     * </p>
     * <p>
     * This parameter was used to specify a list of EI instance types to associate with this notebook instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAcceleratorTypes} method.
     * </p>
     * 
     * @return This parameter is no longer supported. Elastic Inference (EI) is no longer available.</p>
     *         <p>
     *         This parameter was used to specify a list of EI instance types to associate with this notebook instance.
     */
    public final List<String> acceleratorTypesAsStrings() {
        return acceleratorTypes;
    }

    /**
     * <p>
     * A Git repository to associate with the notebook instance as its default code repository. This can be either the
     * name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or
     * in any other Git repository. When you open a notebook instance, it opens in the directory that contains this
     * repository. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with
     * SageMaker Notebook Instances</a>.
     * </p>
     * 
     * @return A Git repository to associate with the notebook instance as its default code repository. This can be
     *         either the name of a Git repository stored as a resource in your account, or the URL of a Git repository
     *         in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services
     *         CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the
     *         directory that contains this repository. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
     *         with SageMaker Notebook Instances</a>.
     */
    public final String defaultCodeRepository() {
        return defaultCodeRepository;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalCodeRepositories property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalCodeRepositories() {
        return additionalCodeRepositories != null && !(additionalCodeRepositories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of up to three Git repositories to associate with the notebook instance. These can be either the names
     * of Git repositories stored as resources in your account, or the URL of Git repositories in <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or
     * in any other Git repository. These repositories are cloned at the same level as the default repository of your
     * notebook instance. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with
     * SageMaker Notebook Instances</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalCodeRepositories} method.
     * </p>
     * 
     * @return An array of up to three Git repositories to associate with the notebook instance. These can be either the
     *         names of Git repositories stored as resources in your account, or the URL of Git repositories in <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services
     *         CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the
     *         default repository of your notebook instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
     *         with SageMaker Notebook Instances</a>.
     */
    public final List<String> additionalCodeRepositories() {
        return additionalCodeRepositories;
    }

    /**
     * <p>
     * Whether root access is enabled or disabled for users of the notebook instance. The default value is
     * <code>Enabled</code>.
     * </p>
     * <note>
     * <p>
     * Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle
     * configurations associated with a notebook instance always run with root access even if you disable root access
     * for users.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootAccess} will
     * return {@link RootAccess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rootAccessAsString}.
     * </p>
     * 
     * @return Whether root access is enabled or disabled for users of the notebook instance. The default value is
     *         <code>Enabled</code>.</p> <note>
     *         <p>
     *         Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
     *         lifecycle configurations associated with a notebook instance always run with root access even if you
     *         disable root access for users.
     *         </p>
     * @see RootAccess
     */
    public final RootAccess rootAccess() {
        return RootAccess.fromValue(rootAccess);
    }

    /**
     * <p>
     * Whether root access is enabled or disabled for users of the notebook instance. The default value is
     * <code>Enabled</code>.
     * </p>
     * <note>
     * <p>
     * Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle
     * configurations associated with a notebook instance always run with root access even if you disable root access
     * for users.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootAccess} will
     * return {@link RootAccess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rootAccessAsString}.
     * </p>
     * 
     * @return Whether root access is enabled or disabled for users of the notebook instance. The default value is
     *         <code>Enabled</code>.</p> <note>
     *         <p>
     *         Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
     *         lifecycle configurations associated with a notebook instance always run with root access even if you
     *         disable root access for users.
     *         </p>
     * @see RootAccess
     */
    public final String rootAccessAsString() {
        return rootAccess;
    }

    /**
     * <p>
     * The platform identifier of the notebook instance runtime environment.
     * </p>
     * 
     * @return The platform identifier of the notebook instance runtime environment.
     */
    public final String platformIdentifier() {
        return platformIdentifier;
    }

    /**
     * <p>
     * Information on the IMDS configuration of the notebook instance
     * </p>
     * 
     * @return Information on the IMDS configuration of the notebook instance
     */
    public final InstanceMetadataServiceConfiguration instanceMetadataServiceConfiguration() {
        return instanceMetadataServiceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(directInternetAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(hasAcceleratorTypes() ? acceleratorTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultCodeRepository());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalCodeRepositories() ? additionalCodeRepositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(rootAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(platformIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(instanceMetadataServiceConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNotebookInstanceRequest)) {
            return false;
        }
        CreateNotebookInstanceRequest other = (CreateNotebookInstanceRequest) obj;
        return Objects.equals(notebookInstanceName(), other.notebookInstanceName())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(subnetId(), other.subnetId()) && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(lifecycleConfigName(), other.lifecycleConfigName())
                && Objects.equals(directInternetAccessAsString(), other.directInternetAccessAsString())
                && Objects.equals(volumeSizeInGB(), other.volumeSizeInGB())
                && hasAcceleratorTypes() == other.hasAcceleratorTypes()
                && Objects.equals(acceleratorTypesAsStrings(), other.acceleratorTypesAsStrings())
                && Objects.equals(defaultCodeRepository(), other.defaultCodeRepository())
                && hasAdditionalCodeRepositories() == other.hasAdditionalCodeRepositories()
                && Objects.equals(additionalCodeRepositories(), other.additionalCodeRepositories())
                && Objects.equals(rootAccessAsString(), other.rootAccessAsString())
                && Objects.equals(platformIdentifier(), other.platformIdentifier())
                && Objects.equals(instanceMetadataServiceConfiguration(), other.instanceMetadataServiceConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNotebookInstanceRequest").add("NotebookInstanceName", notebookInstanceName())
                .add("InstanceType", instanceTypeAsString()).add("SubnetId", subnetId())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null).add("RoleArn", roleArn())
                .add("KmsKeyId", kmsKeyId()).add("Tags", hasTags() ? tags() : null)
                .add("LifecycleConfigName", lifecycleConfigName()).add("DirectInternetAccess", directInternetAccessAsString())
                .add("VolumeSizeInGB", volumeSizeInGB())
                .add("AcceleratorTypes", hasAcceleratorTypes() ? acceleratorTypesAsStrings() : null)
                .add("DefaultCodeRepository", defaultCodeRepository())
                .add("AdditionalCodeRepositories", hasAdditionalCodeRepositories() ? additionalCodeRepositories() : null)
                .add("RootAccess", rootAccessAsString()).add("PlatformIdentifier", platformIdentifier())
                .add("InstanceMetadataServiceConfiguration", instanceMetadataServiceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotebookInstanceName":
            return Optional.ofNullable(clazz.cast(notebookInstanceName()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "LifecycleConfigName":
            return Optional.ofNullable(clazz.cast(lifecycleConfigName()));
        case "DirectInternetAccess":
            return Optional.ofNullable(clazz.cast(directInternetAccessAsString()));
        case "VolumeSizeInGB":
            return Optional.ofNullable(clazz.cast(volumeSizeInGB()));
        case "AcceleratorTypes":
            return Optional.ofNullable(clazz.cast(acceleratorTypesAsStrings()));
        case "DefaultCodeRepository":
            return Optional.ofNullable(clazz.cast(defaultCodeRepository()));
        case "AdditionalCodeRepositories":
            return Optional.ofNullable(clazz.cast(additionalCodeRepositories()));
        case "RootAccess":
            return Optional.ofNullable(clazz.cast(rootAccessAsString()));
        case "PlatformIdentifier":
            return Optional.ofNullable(clazz.cast(platformIdentifier()));
        case "InstanceMetadataServiceConfiguration":
            return Optional.ofNullable(clazz.cast(instanceMetadataServiceConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateNotebookInstanceRequest, T> g) {
        return obj -> g.apply((CreateNotebookInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateNotebookInstanceRequest> {
        /**
         * <p>
         * The name of the new notebook instance.
         * </p>
         * 
         * @param notebookInstanceName
         *        The name of the new notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceName(String notebookInstanceName);

        /**
         * <p>
         * The type of ML compute instance to launch for the notebook instance.
         * </p>
         * 
         * @param instanceType
         *        The type of ML compute instance to launch for the notebook instance.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The type of ML compute instance to launch for the notebook instance.
         * </p>
         * 
         * @param instanceType
         *        The type of ML compute instance to launch for the notebook instance.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The ID of the subnet in a VPC to which you would like to have a connectivity from your ML compute instance.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet in a VPC to which you would like to have a connectivity from your ML compute
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be for the same VPC as
         * specified in the subnet.
         * </p>
         * 
         * @param securityGroupIds
         *        The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be for the same VPC as
         *        specified in the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be for the same VPC as
         * specified in the subnet.
         * </p>
         * 
         * @param securityGroupIds
         *        The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be for the same VPC as
         *        specified in the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * When you send any requests to Amazon Web Services resources from the notebook instance, SageMaker assumes
         * this role to perform tasks on your behalf. You must grant this role necessary permissions so SageMaker can
         * perform these tasks. The policy must allow the SageMaker service principal (sagemaker.amazonaws.com)
         * permissions to assume this role. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">SageMaker Roles</a>.
         * </p>
         * <note>
         * <p>
         * To be able to pass this role to SageMaker, the caller of this API must have the <code>iam:PassRole</code>
         * permission.
         * </p>
         * </note>
         * 
         * @param roleArn
         *        When you send any requests to Amazon Web Services resources from the notebook instance, SageMaker
         *        assumes this role to perform tasks on your behalf. You must grant this role necessary permissions so
         *        SageMaker can perform these tasks. The policy must allow the SageMaker service principal
         *        (sagemaker.amazonaws.com) permissions to assume this role. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">SageMaker Roles</a>. </p>
         *        <note>
         *        <p>
         *        To be able to pass this role to SageMaker, the caller of this API must have the
         *        <code>iam:PassRole</code> permission.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that SageMaker uses to
         * encrypt data on the storage volume attached to your notebook instance. The KMS key you provide must be
         * enabled. For information, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and Disabling
         * Keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that SageMaker uses
         *        to encrypt data on the storage volume attached to your notebook instance. The KMS key you provide must
         *        be enabled. For information, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and Disabling
         *        Keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         *        different ways, for example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         *        different ways, for example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The name of a lifecycle configuration to associate with the notebook instance. For information about
         * lifestyle configurations, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
         * Customize a Notebook Instance</a>.
         * </p>
         * 
         * @param lifecycleConfigName
         *        The name of a lifecycle configuration to associate with the notebook instance. For information about
         *        lifestyle configurations, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1:
         *        (Optional) Customize a Notebook Instance</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleConfigName(String lifecycleConfigName);

        /**
         * <p>
         * Sets whether SageMaker provides internet access to the notebook instance. If you set this to
         * <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not be able
         * to connect to SageMaker training and endpoint services unless you configure a NAT Gateway in your VPC.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
         * >Notebook Instances Are Internet-Enabled by Default</a>. You can set the value of this parameter to
         * <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.
         * </p>
         * 
         * @param directInternetAccess
         *        Sets whether SageMaker provides internet access to the notebook instance. If you set this to
         *        <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not
         *        be able to connect to SageMaker training and endpoint services unless you configure a NAT Gateway in
         *        your VPC.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
         *        >Notebook Instances Are Internet-Enabled by Default</a>. You can set the value of this parameter to
         *        <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.
         * @see DirectInternetAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectInternetAccess
         */
        Builder directInternetAccess(String directInternetAccess);

        /**
         * <p>
         * Sets whether SageMaker provides internet access to the notebook instance. If you set this to
         * <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not be able
         * to connect to SageMaker training and endpoint services unless you configure a NAT Gateway in your VPC.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
         * >Notebook Instances Are Internet-Enabled by Default</a>. You can set the value of this parameter to
         * <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.
         * </p>
         * 
         * @param directInternetAccess
         *        Sets whether SageMaker provides internet access to the notebook instance. If you set this to
         *        <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not
         *        be able to connect to SageMaker training and endpoint services unless you configure a NAT Gateway in
         *        your VPC.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
         *        >Notebook Instances Are Internet-Enabled by Default</a>. You can set the value of this parameter to
         *        <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.
         * @see DirectInternetAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectInternetAccess
         */
        Builder directInternetAccess(DirectInternetAccess directInternetAccess);

        /**
         * <p>
         * The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB.
         * </p>
         * 
         * @param volumeSizeInGB
         *        The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5
         *        GB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSizeInGB(Integer volumeSizeInGB);

        /**
         * <p>
         * This parameter is no longer supported. Elastic Inference (EI) is no longer available.
         * </p>
         * <p>
         * This parameter was used to specify a list of EI instance types to associate with this notebook instance.
         * </p>
         * 
         * @param acceleratorTypes
         *        This parameter is no longer supported. Elastic Inference (EI) is no longer available.</p>
         *        <p>
         *        This parameter was used to specify a list of EI instance types to associate with this notebook
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypesWithStrings(Collection<String> acceleratorTypes);

        /**
         * <p>
         * This parameter is no longer supported. Elastic Inference (EI) is no longer available.
         * </p>
         * <p>
         * This parameter was used to specify a list of EI instance types to associate with this notebook instance.
         * </p>
         * 
         * @param acceleratorTypes
         *        This parameter is no longer supported. Elastic Inference (EI) is no longer available.</p>
         *        <p>
         *        This parameter was used to specify a list of EI instance types to associate with this notebook
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypesWithStrings(String... acceleratorTypes);

        /**
         * <p>
         * This parameter is no longer supported. Elastic Inference (EI) is no longer available.
         * </p>
         * <p>
         * This parameter was used to specify a list of EI instance types to associate with this notebook instance.
         * </p>
         * 
         * @param acceleratorTypes
         *        This parameter is no longer supported. Elastic Inference (EI) is no longer available.</p>
         *        <p>
         *        This parameter was used to specify a list of EI instance types to associate with this notebook
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypes(Collection<NotebookInstanceAcceleratorType> acceleratorTypes);

        /**
         * <p>
         * This parameter is no longer supported. Elastic Inference (EI) is no longer available.
         * </p>
         * <p>
         * This parameter was used to specify a list of EI instance types to associate with this notebook instance.
         * </p>
         * 
         * @param acceleratorTypes
         *        This parameter is no longer supported. Elastic Inference (EI) is no longer available.</p>
         *        <p>
         *        This parameter was used to specify a list of EI instance types to associate with this notebook
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypes(NotebookInstanceAcceleratorType... acceleratorTypes);

        /**
         * <p>
         * A Git repository to associate with the notebook instance as its default code repository. This can be either
         * the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a
         * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services
         * CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory
         * that contains this repository. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with
         * SageMaker Notebook Instances</a>.
         * </p>
         * 
         * @param defaultCodeRepository
         *        A Git repository to associate with the notebook instance as its default code repository. This can be
         *        either the name of a Git repository stored as a resource in your account, or the URL of a Git
         *        repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon
         *        Web Services CodeCommit</a> or in any other Git repository. When you open a notebook instance, it
         *        opens in the directory that contains this repository. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
         *        with SageMaker Notebook Instances</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCodeRepository(String defaultCodeRepository);

        /**
         * <p>
         * An array of up to three Git repositories to associate with the notebook instance. These can be either the
         * names of Git repositories stored as resources in your account, or the URL of Git repositories in <a
         * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services
         * CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default
         * repository of your notebook instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with
         * SageMaker Notebook Instances</a>.
         * </p>
         * 
         * @param additionalCodeRepositories
         *        An array of up to three Git repositories to associate with the notebook instance. These can be either
         *        the names of Git repositories stored as resources in your account, or the URL of Git repositories in
         *        <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services
         *        CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the
         *        default repository of your notebook instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
         *        with SageMaker Notebook Instances</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalCodeRepositories(Collection<String> additionalCodeRepositories);

        /**
         * <p>
         * An array of up to three Git repositories to associate with the notebook instance. These can be either the
         * names of Git repositories stored as resources in your account, or the URL of Git repositories in <a
         * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services
         * CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default
         * repository of your notebook instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with
         * SageMaker Notebook Instances</a>.
         * </p>
         * 
         * @param additionalCodeRepositories
         *        An array of up to three Git repositories to associate with the notebook instance. These can be either
         *        the names of Git repositories stored as resources in your account, or the URL of Git repositories in
         *        <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services
         *        CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the
         *        default repository of your notebook instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
         *        with SageMaker Notebook Instances</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalCodeRepositories(String... additionalCodeRepositories);

        /**
         * <p>
         * Whether root access is enabled or disabled for users of the notebook instance. The default value is
         * <code>Enabled</code>.
         * </p>
         * <note>
         * <p>
         * Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
         * lifecycle configurations associated with a notebook instance always run with root access even if you disable
         * root access for users.
         * </p>
         * </note>
         * 
         * @param rootAccess
         *        Whether root access is enabled or disabled for users of the notebook instance. The default value is
         *        <code>Enabled</code>.</p> <note>
         *        <p>
         *        Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
         *        lifecycle configurations associated with a notebook instance always run with root access even if you
         *        disable root access for users.
         *        </p>
         * @see RootAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootAccess
         */
        Builder rootAccess(String rootAccess);

        /**
         * <p>
         * Whether root access is enabled or disabled for users of the notebook instance. The default value is
         * <code>Enabled</code>.
         * </p>
         * <note>
         * <p>
         * Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
         * lifecycle configurations associated with a notebook instance always run with root access even if you disable
         * root access for users.
         * </p>
         * </note>
         * 
         * @param rootAccess
         *        Whether root access is enabled or disabled for users of the notebook instance. The default value is
         *        <code>Enabled</code>.</p> <note>
         *        <p>
         *        Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
         *        lifecycle configurations associated with a notebook instance always run with root access even if you
         *        disable root access for users.
         *        </p>
         * @see RootAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootAccess
         */
        Builder rootAccess(RootAccess rootAccess);

        /**
         * <p>
         * The platform identifier of the notebook instance runtime environment.
         * </p>
         * 
         * @param platformIdentifier
         *        The platform identifier of the notebook instance runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformIdentifier(String platformIdentifier);

        /**
         * <p>
         * Information on the IMDS configuration of the notebook instance
         * </p>
         * 
         * @param instanceMetadataServiceConfiguration
         *        Information on the IMDS configuration of the notebook instance
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMetadataServiceConfiguration(InstanceMetadataServiceConfiguration instanceMetadataServiceConfiguration);

        /**
         * <p>
         * Information on the IMDS configuration of the notebook instance
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InstanceMetadataServiceConfiguration.Builder} avoiding the need to create one manually via
         * {@link InstanceMetadataServiceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceMetadataServiceConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #instanceMetadataServiceConfiguration(InstanceMetadataServiceConfiguration)}.
         * 
         * @param instanceMetadataServiceConfiguration
         *        a consumer that will call methods on {@link InstanceMetadataServiceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceMetadataServiceConfiguration(InstanceMetadataServiceConfiguration)
         */
        default Builder instanceMetadataServiceConfiguration(
                Consumer<InstanceMetadataServiceConfiguration.Builder> instanceMetadataServiceConfiguration) {
            return instanceMetadataServiceConfiguration(InstanceMetadataServiceConfiguration.builder()
                    .applyMutation(instanceMetadataServiceConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String notebookInstanceName;

        private String instanceType;

        private String subnetId;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private String kmsKeyId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String lifecycleConfigName;

        private String directInternetAccess;

        private Integer volumeSizeInGB;

        private List<String> acceleratorTypes = DefaultSdkAutoConstructList.getInstance();

        private String defaultCodeRepository;

        private List<String> additionalCodeRepositories = DefaultSdkAutoConstructList.getInstance();

        private String rootAccess;

        private String platformIdentifier;

        private InstanceMetadataServiceConfiguration instanceMetadataServiceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNotebookInstanceRequest model) {
            super(model);
            notebookInstanceName(model.notebookInstanceName);
            instanceType(model.instanceType);
            subnetId(model.subnetId);
            securityGroupIds(model.securityGroupIds);
            roleArn(model.roleArn);
            kmsKeyId(model.kmsKeyId);
            tags(model.tags);
            lifecycleConfigName(model.lifecycleConfigName);
            directInternetAccess(model.directInternetAccess);
            volumeSizeInGB(model.volumeSizeInGB);
            acceleratorTypesWithStrings(model.acceleratorTypes);
            defaultCodeRepository(model.defaultCodeRepository);
            additionalCodeRepositories(model.additionalCodeRepositories);
            rootAccess(model.rootAccess);
            platformIdentifier(model.platformIdentifier);
            instanceMetadataServiceConfiguration(model.instanceMetadataServiceConfiguration);
        }

        public final String getNotebookInstanceName() {
            return notebookInstanceName;
        }

        public final void setNotebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
        }

        @Override
        public final Builder notebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLifecycleConfigName() {
            return lifecycleConfigName;
        }

        public final void setLifecycleConfigName(String lifecycleConfigName) {
            this.lifecycleConfigName = lifecycleConfigName;
        }

        @Override
        public final Builder lifecycleConfigName(String lifecycleConfigName) {
            this.lifecycleConfigName = lifecycleConfigName;
            return this;
        }

        public final String getDirectInternetAccess() {
            return directInternetAccess;
        }

        public final void setDirectInternetAccess(String directInternetAccess) {
            this.directInternetAccess = directInternetAccess;
        }

        @Override
        public final Builder directInternetAccess(String directInternetAccess) {
            this.directInternetAccess = directInternetAccess;
            return this;
        }

        @Override
        public final Builder directInternetAccess(DirectInternetAccess directInternetAccess) {
            this.directInternetAccess(directInternetAccess == null ? null : directInternetAccess.toString());
            return this;
        }

        public final Integer getVolumeSizeInGB() {
            return volumeSizeInGB;
        }

        public final void setVolumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
        }

        @Override
        public final Builder volumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
            return this;
        }

        public final Collection<String> getAcceleratorTypes() {
            if (acceleratorTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return acceleratorTypes;
        }

        public final void setAcceleratorTypes(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copy(acceleratorTypes);
        }

        @Override
        public final Builder acceleratorTypesWithStrings(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copy(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypesWithStrings(String... acceleratorTypes) {
            acceleratorTypesWithStrings(Arrays.asList(acceleratorTypes));
            return this;
        }

        @Override
        public final Builder acceleratorTypes(Collection<NotebookInstanceAcceleratorType> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copyEnumToString(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypes(NotebookInstanceAcceleratorType... acceleratorTypes) {
            acceleratorTypes(Arrays.asList(acceleratorTypes));
            return this;
        }

        public final String getDefaultCodeRepository() {
            return defaultCodeRepository;
        }

        public final void setDefaultCodeRepository(String defaultCodeRepository) {
            this.defaultCodeRepository = defaultCodeRepository;
        }

        @Override
        public final Builder defaultCodeRepository(String defaultCodeRepository) {
            this.defaultCodeRepository = defaultCodeRepository;
            return this;
        }

        public final Collection<String> getAdditionalCodeRepositories() {
            if (additionalCodeRepositories instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalCodeRepositories;
        }

        public final void setAdditionalCodeRepositories(Collection<String> additionalCodeRepositories) {
            this.additionalCodeRepositories = AdditionalCodeRepositoryNamesOrUrlsCopier.copy(additionalCodeRepositories);
        }

        @Override
        public final Builder additionalCodeRepositories(Collection<String> additionalCodeRepositories) {
            this.additionalCodeRepositories = AdditionalCodeRepositoryNamesOrUrlsCopier.copy(additionalCodeRepositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalCodeRepositories(String... additionalCodeRepositories) {
            additionalCodeRepositories(Arrays.asList(additionalCodeRepositories));
            return this;
        }

        public final String getRootAccess() {
            return rootAccess;
        }

        public final void setRootAccess(String rootAccess) {
            this.rootAccess = rootAccess;
        }

        @Override
        public final Builder rootAccess(String rootAccess) {
            this.rootAccess = rootAccess;
            return this;
        }

        @Override
        public final Builder rootAccess(RootAccess rootAccess) {
            this.rootAccess(rootAccess == null ? null : rootAccess.toString());
            return this;
        }

        public final String getPlatformIdentifier() {
            return platformIdentifier;
        }

        public final void setPlatformIdentifier(String platformIdentifier) {
            this.platformIdentifier = platformIdentifier;
        }

        @Override
        public final Builder platformIdentifier(String platformIdentifier) {
            this.platformIdentifier = platformIdentifier;
            return this;
        }

        public final InstanceMetadataServiceConfiguration.Builder getInstanceMetadataServiceConfiguration() {
            return instanceMetadataServiceConfiguration != null ? instanceMetadataServiceConfiguration.toBuilder() : null;
        }

        public final void setInstanceMetadataServiceConfiguration(
                InstanceMetadataServiceConfiguration.BuilderImpl instanceMetadataServiceConfiguration) {
            this.instanceMetadataServiceConfiguration = instanceMetadataServiceConfiguration != null ? instanceMetadataServiceConfiguration
                    .build() : null;
        }

        @Override
        public final Builder instanceMetadataServiceConfiguration(
                InstanceMetadataServiceConfiguration instanceMetadataServiceConfiguration) {
            this.instanceMetadataServiceConfiguration = instanceMetadataServiceConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNotebookInstanceRequest build() {
            return new CreateNotebookInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
