/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePipelineRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreatePipelineRequest.Builder, CreatePipelineRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineName").getter(getter(CreatePipelineRequest::pipelineName)).setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineName").build()).build();

    private static final SdkField<String> PIPELINE_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineDisplayName").getter(getter(CreatePipelineRequest::pipelineDisplayName))
            .setter(setter(Builder::pipelineDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDisplayName").build())
            .build();

    private static final SdkField<String> PIPELINE_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineDefinition").getter(getter(CreatePipelineRequest::pipelineDefinition))
            .setter(setter(Builder::pipelineDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDefinition").build())
            .build();

    private static final SdkField<PipelineDefinitionS3Location> PIPELINE_DEFINITION_S3_LOCATION_FIELD = SdkField
            .<PipelineDefinitionS3Location> builder(MarshallingType.SDK_POJO)
            .memberName("PipelineDefinitionS3Location")
            .getter(getter(CreatePipelineRequest::pipelineDefinitionS3Location))
            .setter(setter(Builder::pipelineDefinitionS3Location))
            .constructor(PipelineDefinitionS3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDefinitionS3Location")
                    .build()).build();

    private static final SdkField<String> PIPELINE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineDescription").getter(getter(CreatePipelineRequest::pipelineDescription))
            .setter(setter(Builder::pipelineDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDescription").build())
            .build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreatePipelineRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreatePipelineRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreatePipelineRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ParallelismConfiguration> PARALLELISM_CONFIGURATION_FIELD = SdkField
            .<ParallelismConfiguration> builder(MarshallingType.SDK_POJO).memberName("ParallelismConfiguration")
            .getter(getter(CreatePipelineRequest::parallelismConfiguration)).setter(setter(Builder::parallelismConfiguration))
            .constructor(ParallelismConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelismConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD,
            PIPELINE_DISPLAY_NAME_FIELD, PIPELINE_DEFINITION_FIELD, PIPELINE_DEFINITION_S3_LOCATION_FIELD,
            PIPELINE_DESCRIPTION_FIELD, CLIENT_REQUEST_TOKEN_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, PARALLELISM_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("PipelineName", PIPELINE_NAME_FIELD);
                    put("PipelineDisplayName", PIPELINE_DISPLAY_NAME_FIELD);
                    put("PipelineDefinition", PIPELINE_DEFINITION_FIELD);
                    put("PipelineDefinitionS3Location", PIPELINE_DEFINITION_S3_LOCATION_FIELD);
                    put("PipelineDescription", PIPELINE_DESCRIPTION_FIELD);
                    put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
                    put("RoleArn", ROLE_ARN_FIELD);
                    put("Tags", TAGS_FIELD);
                    put("ParallelismConfiguration", PARALLELISM_CONFIGURATION_FIELD);
                }
            });

    private final String pipelineName;

    private final String pipelineDisplayName;

    private final String pipelineDefinition;

    private final PipelineDefinitionS3Location pipelineDefinitionS3Location;

    private final String pipelineDescription;

    private final String clientRequestToken;

    private final String roleArn;

    private final List<Tag> tags;

    private final ParallelismConfiguration parallelismConfiguration;

    private CreatePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.pipelineDisplayName = builder.pipelineDisplayName;
        this.pipelineDefinition = builder.pipelineDefinition;
        this.pipelineDefinitionS3Location = builder.pipelineDefinitionS3Location;
        this.pipelineDescription = builder.pipelineDescription;
        this.clientRequestToken = builder.clientRequestToken;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.parallelismConfiguration = builder.parallelismConfiguration;
    }

    /**
     * <p>
     * The name of the pipeline.
     * </p>
     * 
     * @return The name of the pipeline.
     */
    public final String pipelineName() {
        return pipelineName;
    }

    /**
     * <p>
     * The display name of the pipeline.
     * </p>
     * 
     * @return The display name of the pipeline.
     */
    public final String pipelineDisplayName() {
        return pipelineDisplayName;
    }

    /**
     * <p>
     * The <a
     * href="https://aws-sagemaker-mlops.github.io/sagemaker-model-building-pipeline-definition-JSON-schema/">JSON
     * pipeline definition</a> of the pipeline.
     * </p>
     * 
     * @return The <a
     *         href="https://aws-sagemaker-mlops.github.io/sagemaker-model-building-pipeline-definition-JSON-schema/"
     *         >JSON pipeline definition</a> of the pipeline.
     */
    public final String pipelineDefinition() {
        return pipelineDefinition;
    }

    /**
     * <p>
     * The location of the pipeline definition stored in Amazon S3. If specified, SageMaker will retrieve the pipeline
     * definition from this location.
     * </p>
     * 
     * @return The location of the pipeline definition stored in Amazon S3. If specified, SageMaker will retrieve the
     *         pipeline definition from this location.
     */
    public final PipelineDefinitionS3Location pipelineDefinitionS3Location() {
        return pipelineDefinitionS3Location;
    }

    /**
     * <p>
     * A description of the pipeline.
     * </p>
     * 
     * @return A description of the pipeline.
     */
    public final String pipelineDescription() {
        return pipelineDescription;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent
     * operation completes no more than one time.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
     *         idempotent operation completes no more than one time.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role used by the pipeline to access and create resources.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role used by the pipeline to access and create resources.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to apply to the created pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags to apply to the created pipeline.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * This is the configuration that controls the parallelism of the pipeline. If specified, it applies to all runs of
     * this pipeline by default.
     * </p>
     * 
     * @return This is the configuration that controls the parallelism of the pipeline. If specified, it applies to all
     *         runs of this pipeline by default.
     */
    public final ParallelismConfiguration parallelismConfiguration() {
        return parallelismConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineDefinitionS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineDescription());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(parallelismConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePipelineRequest)) {
            return false;
        }
        CreatePipelineRequest other = (CreatePipelineRequest) obj;
        return Objects.equals(pipelineName(), other.pipelineName())
                && Objects.equals(pipelineDisplayName(), other.pipelineDisplayName())
                && Objects.equals(pipelineDefinition(), other.pipelineDefinition())
                && Objects.equals(pipelineDefinitionS3Location(), other.pipelineDefinitionS3Location())
                && Objects.equals(pipelineDescription(), other.pipelineDescription())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && Objects.equals(roleArn(), other.roleArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(parallelismConfiguration(), other.parallelismConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePipelineRequest").add("PipelineName", pipelineName())
                .add("PipelineDisplayName", pipelineDisplayName()).add("PipelineDefinition", pipelineDefinition())
                .add("PipelineDefinitionS3Location", pipelineDefinitionS3Location())
                .add("PipelineDescription", pipelineDescription()).add("ClientRequestToken", clientRequestToken())
                .add("RoleArn", roleArn()).add("Tags", hasTags() ? tags() : null)
                .add("ParallelismConfiguration", parallelismConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "PipelineDisplayName":
            return Optional.ofNullable(clazz.cast(pipelineDisplayName()));
        case "PipelineDefinition":
            return Optional.ofNullable(clazz.cast(pipelineDefinition()));
        case "PipelineDefinitionS3Location":
            return Optional.ofNullable(clazz.cast(pipelineDefinitionS3Location()));
        case "PipelineDescription":
            return Optional.ofNullable(clazz.cast(pipelineDescription()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ParallelismConfiguration":
            return Optional.ofNullable(clazz.cast(parallelismConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreatePipelineRequest, T> g) {
        return obj -> g.apply((CreatePipelineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePipelineRequest> {
        /**
         * <p>
         * The name of the pipeline.
         * </p>
         * 
         * @param pipelineName
         *        The name of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * The display name of the pipeline.
         * </p>
         * 
         * @param pipelineDisplayName
         *        The display name of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineDisplayName(String pipelineDisplayName);

        /**
         * <p>
         * The <a
         * href="https://aws-sagemaker-mlops.github.io/sagemaker-model-building-pipeline-definition-JSON-schema/">JSON
         * pipeline definition</a> of the pipeline.
         * </p>
         * 
         * @param pipelineDefinition
         *        The <a href=
         *        "https://aws-sagemaker-mlops.github.io/sagemaker-model-building-pipeline-definition-JSON-schema/">JSON
         *        pipeline definition</a> of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineDefinition(String pipelineDefinition);

        /**
         * <p>
         * The location of the pipeline definition stored in Amazon S3. If specified, SageMaker will retrieve the
         * pipeline definition from this location.
         * </p>
         * 
         * @param pipelineDefinitionS3Location
         *        The location of the pipeline definition stored in Amazon S3. If specified, SageMaker will retrieve the
         *        pipeline definition from this location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineDefinitionS3Location(PipelineDefinitionS3Location pipelineDefinitionS3Location);

        /**
         * <p>
         * The location of the pipeline definition stored in Amazon S3. If specified, SageMaker will retrieve the
         * pipeline definition from this location.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipelineDefinitionS3Location.Builder}
         * avoiding the need to create one manually via {@link PipelineDefinitionS3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipelineDefinitionS3Location.Builder#build()} is called
         * immediately and its result is passed to {@link #pipelineDefinitionS3Location(PipelineDefinitionS3Location)}.
         * 
         * @param pipelineDefinitionS3Location
         *        a consumer that will call methods on {@link PipelineDefinitionS3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineDefinitionS3Location(PipelineDefinitionS3Location)
         */
        default Builder pipelineDefinitionS3Location(Consumer<PipelineDefinitionS3Location.Builder> pipelineDefinitionS3Location) {
            return pipelineDefinitionS3Location(PipelineDefinitionS3Location.builder()
                    .applyMutation(pipelineDefinitionS3Location).build());
        }

        /**
         * <p>
         * A description of the pipeline.
         * </p>
         * 
         * @param pipelineDescription
         *        A description of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineDescription(String pipelineDescription);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
         * idempotent operation completes no more than one time.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
         *        idempotent operation completes no more than one time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role used by the pipeline to access and create resources.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role used by the pipeline to access and create resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A list of tags to apply to the created pipeline.
         * </p>
         * 
         * @param tags
         *        A list of tags to apply to the created pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to apply to the created pipeline.
         * </p>
         * 
         * @param tags
         *        A list of tags to apply to the created pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to apply to the created pipeline.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * This is the configuration that controls the parallelism of the pipeline. If specified, it applies to all runs
         * of this pipeline by default.
         * </p>
         * 
         * @param parallelismConfiguration
         *        This is the configuration that controls the parallelism of the pipeline. If specified, it applies to
         *        all runs of this pipeline by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelismConfiguration(ParallelismConfiguration parallelismConfiguration);

        /**
         * <p>
         * This is the configuration that controls the parallelism of the pipeline. If specified, it applies to all runs
         * of this pipeline by default.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParallelismConfiguration.Builder}
         * avoiding the need to create one manually via {@link ParallelismConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParallelismConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #parallelismConfiguration(ParallelismConfiguration)}.
         * 
         * @param parallelismConfiguration
         *        a consumer that will call methods on {@link ParallelismConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parallelismConfiguration(ParallelismConfiguration)
         */
        default Builder parallelismConfiguration(Consumer<ParallelismConfiguration.Builder> parallelismConfiguration) {
            return parallelismConfiguration(ParallelismConfiguration.builder().applyMutation(parallelismConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String pipelineName;

        private String pipelineDisplayName;

        private String pipelineDefinition;

        private PipelineDefinitionS3Location pipelineDefinitionS3Location;

        private String pipelineDescription;

        private String clientRequestToken;

        private String roleArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private ParallelismConfiguration parallelismConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePipelineRequest model) {
            super(model);
            pipelineName(model.pipelineName);
            pipelineDisplayName(model.pipelineDisplayName);
            pipelineDefinition(model.pipelineDefinition);
            pipelineDefinitionS3Location(model.pipelineDefinitionS3Location);
            pipelineDescription(model.pipelineDescription);
            clientRequestToken(model.clientRequestToken);
            roleArn(model.roleArn);
            tags(model.tags);
            parallelismConfiguration(model.parallelismConfiguration);
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final String getPipelineDisplayName() {
            return pipelineDisplayName;
        }

        public final void setPipelineDisplayName(String pipelineDisplayName) {
            this.pipelineDisplayName = pipelineDisplayName;
        }

        @Override
        public final Builder pipelineDisplayName(String pipelineDisplayName) {
            this.pipelineDisplayName = pipelineDisplayName;
            return this;
        }

        public final String getPipelineDefinition() {
            return pipelineDefinition;
        }

        public final void setPipelineDefinition(String pipelineDefinition) {
            this.pipelineDefinition = pipelineDefinition;
        }

        @Override
        public final Builder pipelineDefinition(String pipelineDefinition) {
            this.pipelineDefinition = pipelineDefinition;
            return this;
        }

        public final PipelineDefinitionS3Location.Builder getPipelineDefinitionS3Location() {
            return pipelineDefinitionS3Location != null ? pipelineDefinitionS3Location.toBuilder() : null;
        }

        public final void setPipelineDefinitionS3Location(PipelineDefinitionS3Location.BuilderImpl pipelineDefinitionS3Location) {
            this.pipelineDefinitionS3Location = pipelineDefinitionS3Location != null ? pipelineDefinitionS3Location.build()
                    : null;
        }

        @Override
        public final Builder pipelineDefinitionS3Location(PipelineDefinitionS3Location pipelineDefinitionS3Location) {
            this.pipelineDefinitionS3Location = pipelineDefinitionS3Location;
            return this;
        }

        public final String getPipelineDescription() {
            return pipelineDescription;
        }

        public final void setPipelineDescription(String pipelineDescription) {
            this.pipelineDescription = pipelineDescription;
        }

        @Override
        public final Builder pipelineDescription(String pipelineDescription) {
            this.pipelineDescription = pipelineDescription;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ParallelismConfiguration.Builder getParallelismConfiguration() {
            return parallelismConfiguration != null ? parallelismConfiguration.toBuilder() : null;
        }

        public final void setParallelismConfiguration(ParallelismConfiguration.BuilderImpl parallelismConfiguration) {
            this.parallelismConfiguration = parallelismConfiguration != null ? parallelismConfiguration.build() : null;
        }

        @Override
        public final Builder parallelismConfiguration(ParallelismConfiguration parallelismConfiguration) {
            this.parallelismConfiguration = parallelismConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePipelineRequest build() {
            return new CreatePipelineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
