/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkforceRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateWorkforceRequest.Builder, CreateWorkforceRequest> {
    private static final SdkField<CognitoConfig> COGNITO_CONFIG_FIELD = SdkField
            .<CognitoConfig> builder(MarshallingType.SDK_POJO).memberName("CognitoConfig")
            .getter(getter(CreateWorkforceRequest::cognitoConfig)).setter(setter(Builder::cognitoConfig))
            .constructor(CognitoConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoConfig").build()).build();

    private static final SdkField<OidcConfig> OIDC_CONFIG_FIELD = SdkField.<OidcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OidcConfig").getter(getter(CreateWorkforceRequest::oidcConfig)).setter(setter(Builder::oidcConfig))
            .constructor(OidcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OidcConfig").build()).build();

    private static final SdkField<SourceIpConfig> SOURCE_IP_CONFIG_FIELD = SdkField
            .<SourceIpConfig> builder(MarshallingType.SDK_POJO).memberName("SourceIpConfig")
            .getter(getter(CreateWorkforceRequest::sourceIpConfig)).setter(setter(Builder::sourceIpConfig))
            .constructor(SourceIpConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIpConfig").build()).build();

    private static final SdkField<String> WORKFORCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkforceName").getter(getter(CreateWorkforceRequest::workforceName))
            .setter(setter(Builder::workforceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkforceName").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateWorkforceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<WorkforceVpcConfigRequest> WORKFORCE_VPC_CONFIG_FIELD = SdkField
            .<WorkforceVpcConfigRequest> builder(MarshallingType.SDK_POJO).memberName("WorkforceVpcConfig")
            .getter(getter(CreateWorkforceRequest::workforceVpcConfig)).setter(setter(Builder::workforceVpcConfig))
            .constructor(WorkforceVpcConfigRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkforceVpcConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COGNITO_CONFIG_FIELD,
            OIDC_CONFIG_FIELD, SOURCE_IP_CONFIG_FIELD, WORKFORCE_NAME_FIELD, TAGS_FIELD, WORKFORCE_VPC_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CognitoConfig", COGNITO_CONFIG_FIELD);
                    put("OidcConfig", OIDC_CONFIG_FIELD);
                    put("SourceIpConfig", SOURCE_IP_CONFIG_FIELD);
                    put("WorkforceName", WORKFORCE_NAME_FIELD);
                    put("Tags", TAGS_FIELD);
                    put("WorkforceVpcConfig", WORKFORCE_VPC_CONFIG_FIELD);
                }
            });

    private final CognitoConfig cognitoConfig;

    private final OidcConfig oidcConfig;

    private final SourceIpConfig sourceIpConfig;

    private final String workforceName;

    private final List<Tag> tags;

    private final WorkforceVpcConfigRequest workforceVpcConfig;

    private CreateWorkforceRequest(BuilderImpl builder) {
        super(builder);
        this.cognitoConfig = builder.cognitoConfig;
        this.oidcConfig = builder.oidcConfig;
        this.sourceIpConfig = builder.sourceIpConfig;
        this.workforceName = builder.workforceName;
        this.tags = builder.tags;
        this.workforceVpcConfig = builder.workforceVpcConfig;
    }

    /**
     * <p>
     * Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is created using
     * and corresponds to a single <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> Amazon Cognito
     * user pool</a>.
     * </p>
     * <p>
     * Do not use <code>OidcConfig</code> if you specify values for <code>CognitoConfig</code>.
     * </p>
     * 
     * @return Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is
     *         created using and corresponds to a single <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> Amazon
     *         Cognito user pool</a>.</p>
     *         <p>
     *         Do not use <code>OidcConfig</code> if you specify values for <code>CognitoConfig</code>.
     */
    public final CognitoConfig cognitoConfig() {
        return cognitoConfig;
    }

    /**
     * <p>
     * Use this parameter to configure a private workforce using your own OIDC Identity Provider.
     * </p>
     * <p>
     * Do not use <code>CognitoConfig</code> if you specify values for <code>OidcConfig</code>.
     * </p>
     * 
     * @return Use this parameter to configure a private workforce using your own OIDC Identity Provider.</p>
     *         <p>
     *         Do not use <code>CognitoConfig</code> if you specify values for <code>OidcConfig</code>.
     */
    public final OidcConfig oidcConfig() {
        return oidcConfig;
    }

    /**
     * Returns the value of the SourceIpConfig property for this object.
     * 
     * @return The value of the SourceIpConfig property for this object.
     */
    public final SourceIpConfig sourceIpConfig() {
        return sourceIpConfig;
    }

    /**
     * <p>
     * The name of the private workforce.
     * </p>
     * 
     * @return The name of the private workforce.
     */
    public final String workforceName() {
        return workforceName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs that contain metadata to help you categorize and organize our workforce. Each tag
     * consists of a key and a value, both of which you define.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of key-value pairs that contain metadata to help you categorize and organize our workforce. Each
     *         tag consists of a key and a value, both of which you define.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Use this parameter to configure a workforce using VPC.
     * </p>
     * 
     * @return Use this parameter to configure a workforce using VPC.
     */
    public final WorkforceVpcConfigRequest workforceVpcConfig() {
        return workforceVpcConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cognitoConfig());
        hashCode = 31 * hashCode + Objects.hashCode(oidcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(sourceIpConfig());
        hashCode = 31 * hashCode + Objects.hashCode(workforceName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workforceVpcConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkforceRequest)) {
            return false;
        }
        CreateWorkforceRequest other = (CreateWorkforceRequest) obj;
        return Objects.equals(cognitoConfig(), other.cognitoConfig()) && Objects.equals(oidcConfig(), other.oidcConfig())
                && Objects.equals(sourceIpConfig(), other.sourceIpConfig())
                && Objects.equals(workforceName(), other.workforceName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(workforceVpcConfig(), other.workforceVpcConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkforceRequest").add("CognitoConfig", cognitoConfig()).add("OidcConfig", oidcConfig())
                .add("SourceIpConfig", sourceIpConfig()).add("WorkforceName", workforceName())
                .add("Tags", hasTags() ? tags() : null).add("WorkforceVpcConfig", workforceVpcConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CognitoConfig":
            return Optional.ofNullable(clazz.cast(cognitoConfig()));
        case "OidcConfig":
            return Optional.ofNullable(clazz.cast(oidcConfig()));
        case "SourceIpConfig":
            return Optional.ofNullable(clazz.cast(sourceIpConfig()));
        case "WorkforceName":
            return Optional.ofNullable(clazz.cast(workforceName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "WorkforceVpcConfig":
            return Optional.ofNullable(clazz.cast(workforceVpcConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkforceRequest, T> g) {
        return obj -> g.apply((CreateWorkforceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWorkforceRequest> {
        /**
         * <p>
         * Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is created
         * using and corresponds to a single <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> Amazon
         * Cognito user pool</a>.
         * </p>
         * <p>
         * Do not use <code>OidcConfig</code> if you specify values for <code>CognitoConfig</code>.
         * </p>
         * 
         * @param cognitoConfig
         *        Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is
         *        created using and corresponds to a single <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">
         *        Amazon Cognito user pool</a>.</p>
         *        <p>
         *        Do not use <code>OidcConfig</code> if you specify values for <code>CognitoConfig</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cognitoConfig(CognitoConfig cognitoConfig);

        /**
         * <p>
         * Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is created
         * using and corresponds to a single <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> Amazon
         * Cognito user pool</a>.
         * </p>
         * <p>
         * Do not use <code>OidcConfig</code> if you specify values for <code>CognitoConfig</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CognitoConfig.Builder} avoiding the need
         * to create one manually via {@link CognitoConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CognitoConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #cognitoConfig(CognitoConfig)}.
         * 
         * @param cognitoConfig
         *        a consumer that will call methods on {@link CognitoConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cognitoConfig(CognitoConfig)
         */
        default Builder cognitoConfig(Consumer<CognitoConfig.Builder> cognitoConfig) {
            return cognitoConfig(CognitoConfig.builder().applyMutation(cognitoConfig).build());
        }

        /**
         * <p>
         * Use this parameter to configure a private workforce using your own OIDC Identity Provider.
         * </p>
         * <p>
         * Do not use <code>CognitoConfig</code> if you specify values for <code>OidcConfig</code>.
         * </p>
         * 
         * @param oidcConfig
         *        Use this parameter to configure a private workforce using your own OIDC Identity Provider.</p>
         *        <p>
         *        Do not use <code>CognitoConfig</code> if you specify values for <code>OidcConfig</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oidcConfig(OidcConfig oidcConfig);

        /**
         * <p>
         * Use this parameter to configure a private workforce using your own OIDC Identity Provider.
         * </p>
         * <p>
         * Do not use <code>CognitoConfig</code> if you specify values for <code>OidcConfig</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link OidcConfig.Builder} avoiding the need to
         * create one manually via {@link OidcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OidcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #oidcConfig(OidcConfig)}.
         * 
         * @param oidcConfig
         *        a consumer that will call methods on {@link OidcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oidcConfig(OidcConfig)
         */
        default Builder oidcConfig(Consumer<OidcConfig.Builder> oidcConfig) {
            return oidcConfig(OidcConfig.builder().applyMutation(oidcConfig).build());
        }

        /**
         * Sets the value of the SourceIpConfig property for this object.
         *
         * @param sourceIpConfig
         *        The new value for the SourceIpConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIpConfig(SourceIpConfig sourceIpConfig);

        /**
         * Sets the value of the SourceIpConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SourceIpConfig.Builder} avoiding the need
         * to create one manually via {@link SourceIpConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceIpConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceIpConfig(SourceIpConfig)}.
         * 
         * @param sourceIpConfig
         *        a consumer that will call methods on {@link SourceIpConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceIpConfig(SourceIpConfig)
         */
        default Builder sourceIpConfig(Consumer<SourceIpConfig.Builder> sourceIpConfig) {
            return sourceIpConfig(SourceIpConfig.builder().applyMutation(sourceIpConfig).build());
        }

        /**
         * <p>
         * The name of the private workforce.
         * </p>
         * 
         * @param workforceName
         *        The name of the private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workforceName(String workforceName);

        /**
         * <p>
         * An array of key-value pairs that contain metadata to help you categorize and organize our workforce. Each tag
         * consists of a key and a value, both of which you define.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs that contain metadata to help you categorize and organize our workforce.
         *        Each tag consists of a key and a value, both of which you define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key-value pairs that contain metadata to help you categorize and organize our workforce. Each tag
         * consists of a key and a value, both of which you define.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs that contain metadata to help you categorize and organize our workforce.
         *        Each tag consists of a key and a value, both of which you define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key-value pairs that contain metadata to help you categorize and organize our workforce. Each tag
         * consists of a key and a value, both of which you define.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Use this parameter to configure a workforce using VPC.
         * </p>
         * 
         * @param workforceVpcConfig
         *        Use this parameter to configure a workforce using VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workforceVpcConfig(WorkforceVpcConfigRequest workforceVpcConfig);

        /**
         * <p>
         * Use this parameter to configure a workforce using VPC.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkforceVpcConfigRequest.Builder}
         * avoiding the need to create one manually via {@link WorkforceVpcConfigRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkforceVpcConfigRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #workforceVpcConfig(WorkforceVpcConfigRequest)}.
         * 
         * @param workforceVpcConfig
         *        a consumer that will call methods on {@link WorkforceVpcConfigRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workforceVpcConfig(WorkforceVpcConfigRequest)
         */
        default Builder workforceVpcConfig(Consumer<WorkforceVpcConfigRequest.Builder> workforceVpcConfig) {
            return workforceVpcConfig(WorkforceVpcConfigRequest.builder().applyMutation(workforceVpcConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private CognitoConfig cognitoConfig;

        private OidcConfig oidcConfig;

        private SourceIpConfig sourceIpConfig;

        private String workforceName;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private WorkforceVpcConfigRequest workforceVpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkforceRequest model) {
            super(model);
            cognitoConfig(model.cognitoConfig);
            oidcConfig(model.oidcConfig);
            sourceIpConfig(model.sourceIpConfig);
            workforceName(model.workforceName);
            tags(model.tags);
            workforceVpcConfig(model.workforceVpcConfig);
        }

        public final CognitoConfig.Builder getCognitoConfig() {
            return cognitoConfig != null ? cognitoConfig.toBuilder() : null;
        }

        public final void setCognitoConfig(CognitoConfig.BuilderImpl cognitoConfig) {
            this.cognitoConfig = cognitoConfig != null ? cognitoConfig.build() : null;
        }

        @Override
        public final Builder cognitoConfig(CognitoConfig cognitoConfig) {
            this.cognitoConfig = cognitoConfig;
            return this;
        }

        public final OidcConfig.Builder getOidcConfig() {
            return oidcConfig != null ? oidcConfig.toBuilder() : null;
        }

        public final void setOidcConfig(OidcConfig.BuilderImpl oidcConfig) {
            this.oidcConfig = oidcConfig != null ? oidcConfig.build() : null;
        }

        @Override
        public final Builder oidcConfig(OidcConfig oidcConfig) {
            this.oidcConfig = oidcConfig;
            return this;
        }

        public final SourceIpConfig.Builder getSourceIpConfig() {
            return sourceIpConfig != null ? sourceIpConfig.toBuilder() : null;
        }

        public final void setSourceIpConfig(SourceIpConfig.BuilderImpl sourceIpConfig) {
            this.sourceIpConfig = sourceIpConfig != null ? sourceIpConfig.build() : null;
        }

        @Override
        public final Builder sourceIpConfig(SourceIpConfig sourceIpConfig) {
            this.sourceIpConfig = sourceIpConfig;
            return this;
        }

        public final String getWorkforceName() {
            return workforceName;
        }

        public final void setWorkforceName(String workforceName) {
            this.workforceName = workforceName;
        }

        @Override
        public final Builder workforceName(String workforceName) {
            this.workforceName = workforceName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final WorkforceVpcConfigRequest.Builder getWorkforceVpcConfig() {
            return workforceVpcConfig != null ? workforceVpcConfig.toBuilder() : null;
        }

        public final void setWorkforceVpcConfig(WorkforceVpcConfigRequest.BuilderImpl workforceVpcConfig) {
            this.workforceVpcConfig = workforceVpcConfig != null ? workforceVpcConfig.build() : null;
        }

        @Override
        public final Builder workforceVpcConfig(WorkforceVpcConfigRequest workforceVpcConfig) {
            this.workforceVpcConfig = workforceVpcConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkforceRequest build() {
            return new CreateWorkforceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
