/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The default storage settings for a space.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultSpaceStorageSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultSpaceStorageSettings.Builder, DefaultSpaceStorageSettings> {
    private static final SdkField<DefaultEbsStorageSettings> DEFAULT_EBS_STORAGE_SETTINGS_FIELD = SdkField
            .<DefaultEbsStorageSettings> builder(MarshallingType.SDK_POJO).memberName("DefaultEbsStorageSettings")
            .getter(getter(DefaultSpaceStorageSettings::defaultEbsStorageSettings))
            .setter(setter(Builder::defaultEbsStorageSettings)).constructor(DefaultEbsStorageSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultEbsStorageSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DEFAULT_EBS_STORAGE_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DefaultEbsStorageSettings", DEFAULT_EBS_STORAGE_SETTINGS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final DefaultEbsStorageSettings defaultEbsStorageSettings;

    private DefaultSpaceStorageSettings(BuilderImpl builder) {
        this.defaultEbsStorageSettings = builder.defaultEbsStorageSettings;
    }

    /**
     * <p>
     * The default EBS storage settings for a space.
     * </p>
     * 
     * @return The default EBS storage settings for a space.
     */
    public final DefaultEbsStorageSettings defaultEbsStorageSettings() {
        return defaultEbsStorageSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultEbsStorageSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultSpaceStorageSettings)) {
            return false;
        }
        DefaultSpaceStorageSettings other = (DefaultSpaceStorageSettings) obj;
        return Objects.equals(defaultEbsStorageSettings(), other.defaultEbsStorageSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultSpaceStorageSettings").add("DefaultEbsStorageSettings", defaultEbsStorageSettings())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultEbsStorageSettings":
            return Optional.ofNullable(clazz.cast(defaultEbsStorageSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DefaultSpaceStorageSettings, T> g) {
        return obj -> g.apply((DefaultSpaceStorageSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultSpaceStorageSettings> {
        /**
         * <p>
         * The default EBS storage settings for a space.
         * </p>
         * 
         * @param defaultEbsStorageSettings
         *        The default EBS storage settings for a space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultEbsStorageSettings(DefaultEbsStorageSettings defaultEbsStorageSettings);

        /**
         * <p>
         * The default EBS storage settings for a space.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultEbsStorageSettings.Builder}
         * avoiding the need to create one manually via {@link DefaultEbsStorageSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultEbsStorageSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #defaultEbsStorageSettings(DefaultEbsStorageSettings)}.
         * 
         * @param defaultEbsStorageSettings
         *        a consumer that will call methods on {@link DefaultEbsStorageSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultEbsStorageSettings(DefaultEbsStorageSettings)
         */
        default Builder defaultEbsStorageSettings(Consumer<DefaultEbsStorageSettings.Builder> defaultEbsStorageSettings) {
            return defaultEbsStorageSettings(DefaultEbsStorageSettings.builder().applyMutation(defaultEbsStorageSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DefaultEbsStorageSettings defaultEbsStorageSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultSpaceStorageSettings model) {
            defaultEbsStorageSettings(model.defaultEbsStorageSettings);
        }

        public final DefaultEbsStorageSettings.Builder getDefaultEbsStorageSettings() {
            return defaultEbsStorageSettings != null ? defaultEbsStorageSettings.toBuilder() : null;
        }

        public final void setDefaultEbsStorageSettings(DefaultEbsStorageSettings.BuilderImpl defaultEbsStorageSettings) {
            this.defaultEbsStorageSettings = defaultEbsStorageSettings != null ? defaultEbsStorageSettings.build() : null;
        }

        @Override
        public final Builder defaultEbsStorageSettings(DefaultEbsStorageSettings defaultEbsStorageSettings) {
            this.defaultEbsStorageSettings = defaultEbsStorageSettings;
            return this;
        }

        @Override
        public DefaultSpaceStorageSettings build() {
            return new DefaultSpaceStorageSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
