/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a stage in an edge deployment plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentStage implements SdkPojo, Serializable, ToCopyableBuilder<DeploymentStage.Builder, DeploymentStage> {
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StageName").getter(getter(DeploymentStage::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageName").build()).build();

    private static final SdkField<DeviceSelectionConfig> DEVICE_SELECTION_CONFIG_FIELD = SdkField
            .<DeviceSelectionConfig> builder(MarshallingType.SDK_POJO).memberName("DeviceSelectionConfig")
            .getter(getter(DeploymentStage::deviceSelectionConfig)).setter(setter(Builder::deviceSelectionConfig))
            .constructor(DeviceSelectionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceSelectionConfig").build())
            .build();

    private static final SdkField<EdgeDeploymentConfig> DEPLOYMENT_CONFIG_FIELD = SdkField
            .<EdgeDeploymentConfig> builder(MarshallingType.SDK_POJO).memberName("DeploymentConfig")
            .getter(getter(DeploymentStage::deploymentConfig)).setter(setter(Builder::deploymentConfig))
            .constructor(EdgeDeploymentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_NAME_FIELD,
            DEVICE_SELECTION_CONFIG_FIELD, DEPLOYMENT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("StageName", STAGE_NAME_FIELD);
                    put("DeviceSelectionConfig", DEVICE_SELECTION_CONFIG_FIELD);
                    put("DeploymentConfig", DEPLOYMENT_CONFIG_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String stageName;

    private final DeviceSelectionConfig deviceSelectionConfig;

    private final EdgeDeploymentConfig deploymentConfig;

    private DeploymentStage(BuilderImpl builder) {
        this.stageName = builder.stageName;
        this.deviceSelectionConfig = builder.deviceSelectionConfig;
        this.deploymentConfig = builder.deploymentConfig;
    }

    /**
     * <p>
     * The name of the stage.
     * </p>
     * 
     * @return The name of the stage.
     */
    public final String stageName() {
        return stageName;
    }

    /**
     * <p>
     * Configuration of the devices in the stage.
     * </p>
     * 
     * @return Configuration of the devices in the stage.
     */
    public final DeviceSelectionConfig deviceSelectionConfig() {
        return deviceSelectionConfig;
    }

    /**
     * <p>
     * Configuration of the deployment details.
     * </p>
     * 
     * @return Configuration of the deployment details.
     */
    public final EdgeDeploymentConfig deploymentConfig() {
        return deploymentConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceSelectionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentStage)) {
            return false;
        }
        DeploymentStage other = (DeploymentStage) obj;
        return Objects.equals(stageName(), other.stageName())
                && Objects.equals(deviceSelectionConfig(), other.deviceSelectionConfig())
                && Objects.equals(deploymentConfig(), other.deploymentConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeploymentStage").add("StageName", stageName())
                .add("DeviceSelectionConfig", deviceSelectionConfig()).add("DeploymentConfig", deploymentConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "DeviceSelectionConfig":
            return Optional.ofNullable(clazz.cast(deviceSelectionConfig()));
        case "DeploymentConfig":
            return Optional.ofNullable(clazz.cast(deploymentConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentStage, T> g) {
        return obj -> g.apply((DeploymentStage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentStage> {
        /**
         * <p>
         * The name of the stage.
         * </p>
         * 
         * @param stageName
         *        The name of the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * Configuration of the devices in the stage.
         * </p>
         * 
         * @param deviceSelectionConfig
         *        Configuration of the devices in the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceSelectionConfig(DeviceSelectionConfig deviceSelectionConfig);

        /**
         * <p>
         * Configuration of the devices in the stage.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeviceSelectionConfig.Builder} avoiding
         * the need to create one manually via {@link DeviceSelectionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeviceSelectionConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #deviceSelectionConfig(DeviceSelectionConfig)}.
         * 
         * @param deviceSelectionConfig
         *        a consumer that will call methods on {@link DeviceSelectionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceSelectionConfig(DeviceSelectionConfig)
         */
        default Builder deviceSelectionConfig(Consumer<DeviceSelectionConfig.Builder> deviceSelectionConfig) {
            return deviceSelectionConfig(DeviceSelectionConfig.builder().applyMutation(deviceSelectionConfig).build());
        }

        /**
         * <p>
         * Configuration of the deployment details.
         * </p>
         * 
         * @param deploymentConfig
         *        Configuration of the deployment details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfig(EdgeDeploymentConfig deploymentConfig);

        /**
         * <p>
         * Configuration of the deployment details.
         * </p>
         * This is a convenience method that creates an instance of the {@link EdgeDeploymentConfig.Builder} avoiding
         * the need to create one manually via {@link EdgeDeploymentConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EdgeDeploymentConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #deploymentConfig(EdgeDeploymentConfig)}.
         * 
         * @param deploymentConfig
         *        a consumer that will call methods on {@link EdgeDeploymentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentConfig(EdgeDeploymentConfig)
         */
        default Builder deploymentConfig(Consumer<EdgeDeploymentConfig.Builder> deploymentConfig) {
            return deploymentConfig(EdgeDeploymentConfig.builder().applyMutation(deploymentConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String stageName;

        private DeviceSelectionConfig deviceSelectionConfig;

        private EdgeDeploymentConfig deploymentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentStage model) {
            stageName(model.stageName);
            deviceSelectionConfig(model.deviceSelectionConfig);
            deploymentConfig(model.deploymentConfig);
        }

        public final String getStageName() {
            return stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final DeviceSelectionConfig.Builder getDeviceSelectionConfig() {
            return deviceSelectionConfig != null ? deviceSelectionConfig.toBuilder() : null;
        }

        public final void setDeviceSelectionConfig(DeviceSelectionConfig.BuilderImpl deviceSelectionConfig) {
            this.deviceSelectionConfig = deviceSelectionConfig != null ? deviceSelectionConfig.build() : null;
        }

        @Override
        public final Builder deviceSelectionConfig(DeviceSelectionConfig deviceSelectionConfig) {
            this.deviceSelectionConfig = deviceSelectionConfig;
            return this;
        }

        public final EdgeDeploymentConfig.Builder getDeploymentConfig() {
            return deploymentConfig != null ? deploymentConfig.toBuilder() : null;
        }

        public final void setDeploymentConfig(EdgeDeploymentConfig.BuilderImpl deploymentConfig) {
            this.deploymentConfig = deploymentConfig != null ? deploymentConfig.build() : null;
        }

        @Override
        public final Builder deploymentConfig(EdgeDeploymentConfig deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        @Override
        public DeploymentStage build() {
            return new DeploymentStage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
