/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeClusterResponse.Builder, DescribeClusterResponse> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(DescribeClusterResponse::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()).build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(DescribeClusterResponse::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()).build();

    private static final SdkField<String> CLUSTER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterStatus").getter(getter(DescribeClusterResponse::clusterStatusAsString))
            .setter(setter(Builder::clusterStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterStatus").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeClusterResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureMessage").getter(getter(DescribeClusterResponse::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()).build();

    private static final SdkField<List<ClusterInstanceGroupDetails>> INSTANCE_GROUPS_FIELD = SdkField
            .<List<ClusterInstanceGroupDetails>> builder(MarshallingType.LIST)
            .memberName("InstanceGroups")
            .getter(getter(DescribeClusterResponse::instanceGroups))
            .setter(setter(Builder::instanceGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusterInstanceGroupDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterInstanceGroupDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(DescribeClusterResponse::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<ClusterOrchestrator> ORCHESTRATOR_FIELD = SdkField
            .<ClusterOrchestrator> builder(MarshallingType.SDK_POJO).memberName("Orchestrator")
            .getter(getter(DescribeClusterResponse::orchestrator)).setter(setter(Builder::orchestrator))
            .constructor(ClusterOrchestrator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Orchestrator").build()).build();

    private static final SdkField<String> NODE_RECOVERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeRecovery").getter(getter(DescribeClusterResponse::nodeRecoveryAsString))
            .setter(setter(Builder::nodeRecovery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeRecovery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            CLUSTER_NAME_FIELD, CLUSTER_STATUS_FIELD, CREATION_TIME_FIELD, FAILURE_MESSAGE_FIELD, INSTANCE_GROUPS_FIELD,
            VPC_CONFIG_FIELD, ORCHESTRATOR_FIELD, NODE_RECOVERY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ClusterArn", CLUSTER_ARN_FIELD);
                    put("ClusterName", CLUSTER_NAME_FIELD);
                    put("ClusterStatus", CLUSTER_STATUS_FIELD);
                    put("CreationTime", CREATION_TIME_FIELD);
                    put("FailureMessage", FAILURE_MESSAGE_FIELD);
                    put("InstanceGroups", INSTANCE_GROUPS_FIELD);
                    put("VpcConfig", VPC_CONFIG_FIELD);
                    put("Orchestrator", ORCHESTRATOR_FIELD);
                    put("NodeRecovery", NODE_RECOVERY_FIELD);
                }
            });

    private final String clusterArn;

    private final String clusterName;

    private final String clusterStatus;

    private final Instant creationTime;

    private final String failureMessage;

    private final List<ClusterInstanceGroupDetails> instanceGroups;

    private final VpcConfig vpcConfig;

    private final ClusterOrchestrator orchestrator;

    private final String nodeRecovery;

    private DescribeClusterResponse(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.clusterName = builder.clusterName;
        this.clusterStatus = builder.clusterStatus;
        this.creationTime = builder.creationTime;
        this.failureMessage = builder.failureMessage;
        this.instanceGroups = builder.instanceGroups;
        this.vpcConfig = builder.vpcConfig;
        this.orchestrator = builder.orchestrator;
        this.nodeRecovery = builder.nodeRecovery;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * The name of the SageMaker HyperPod cluster.
     * </p>
     * 
     * @return The name of the SageMaker HyperPod cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The status of the SageMaker HyperPod cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterStatus}
     * will return {@link ClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterStatusAsString}.
     * </p>
     * 
     * @return The status of the SageMaker HyperPod cluster.
     * @see ClusterStatus
     */
    public final ClusterStatus clusterStatus() {
        return ClusterStatus.fromValue(clusterStatus);
    }

    /**
     * <p>
     * The status of the SageMaker HyperPod cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterStatus}
     * will return {@link ClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterStatusAsString}.
     * </p>
     * 
     * @return The status of the SageMaker HyperPod cluster.
     * @see ClusterStatus
     */
    public final String clusterStatusAsString() {
        return clusterStatus;
    }

    /**
     * <p>
     * The time when the SageMaker Cluster is created.
     * </p>
     * 
     * @return The time when the SageMaker Cluster is created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The failure message of the SageMaker HyperPod cluster.
     * </p>
     * 
     * @return The failure message of the SageMaker HyperPod cluster.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceGroups() {
        return instanceGroups != null && !(instanceGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instance groups of the SageMaker HyperPod cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceGroups} method.
     * </p>
     * 
     * @return The instance groups of the SageMaker HyperPod cluster.
     */
    public final List<ClusterInstanceGroupDetails> instanceGroups() {
        return instanceGroups;
    }

    /**
     * Returns the value of the VpcConfig property for this object.
     * 
     * @return The value of the VpcConfig property for this object.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The type of orchestrator used for the SageMaker HyperPod cluster.
     * </p>
     * 
     * @return The type of orchestrator used for the SageMaker HyperPod cluster.
     */
    public final ClusterOrchestrator orchestrator() {
        return orchestrator;
    }

    /**
     * <p>
     * The node recovery mode configured for the SageMaker HyperPod cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeRecovery} will
     * return {@link ClusterNodeRecovery#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nodeRecoveryAsString}.
     * </p>
     * 
     * @return The node recovery mode configured for the SageMaker HyperPod cluster.
     * @see ClusterNodeRecovery
     */
    public final ClusterNodeRecovery nodeRecovery() {
        return ClusterNodeRecovery.fromValue(nodeRecovery);
    }

    /**
     * <p>
     * The node recovery mode configured for the SageMaker HyperPod cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeRecovery} will
     * return {@link ClusterNodeRecovery#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nodeRecoveryAsString}.
     * </p>
     * 
     * @return The node recovery mode configured for the SageMaker HyperPod cluster.
     * @see ClusterNodeRecovery
     */
    public final String nodeRecoveryAsString() {
        return nodeRecovery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(clusterStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceGroups() ? instanceGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(orchestrator());
        hashCode = 31 * hashCode + Objects.hashCode(nodeRecoveryAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterResponse)) {
            return false;
        }
        DescribeClusterResponse other = (DescribeClusterResponse) obj;
        return Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(clusterStatusAsString(), other.clusterStatusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(failureMessage(), other.failureMessage()) && hasInstanceGroups() == other.hasInstanceGroups()
                && Objects.equals(instanceGroups(), other.instanceGroups()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(orchestrator(), other.orchestrator())
                && Objects.equals(nodeRecoveryAsString(), other.nodeRecoveryAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClusterResponse").add("ClusterArn", clusterArn()).add("ClusterName", clusterName())
                .add("ClusterStatus", clusterStatusAsString()).add("CreationTime", creationTime())
                .add("FailureMessage", failureMessage()).add("InstanceGroups", hasInstanceGroups() ? instanceGroups() : null)
                .add("VpcConfig", vpcConfig()).add("Orchestrator", orchestrator()).add("NodeRecovery", nodeRecoveryAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "ClusterStatus":
            return Optional.ofNullable(clazz.cast(clusterStatusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "FailureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "InstanceGroups":
            return Optional.ofNullable(clazz.cast(instanceGroups()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "Orchestrator":
            return Optional.ofNullable(clazz.cast(orchestrator()));
        case "NodeRecovery":
            return Optional.ofNullable(clazz.cast(nodeRecoveryAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterResponse, T> g) {
        return obj -> g.apply((DescribeClusterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClusterResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param clusterArn
         *        The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * The name of the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of the SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The status of the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param clusterStatus
         *        The status of the SageMaker HyperPod cluster.
         * @see ClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterStatus
         */
        Builder clusterStatus(String clusterStatus);

        /**
         * <p>
         * The status of the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param clusterStatus
         *        The status of the SageMaker HyperPod cluster.
         * @see ClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterStatus
         */
        Builder clusterStatus(ClusterStatus clusterStatus);

        /**
         * <p>
         * The time when the SageMaker Cluster is created.
         * </p>
         * 
         * @param creationTime
         *        The time when the SageMaker Cluster is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The failure message of the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param failureMessage
         *        The failure message of the SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * The instance groups of the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param instanceGroups
         *        The instance groups of the SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroups(Collection<ClusterInstanceGroupDetails> instanceGroups);

        /**
         * <p>
         * The instance groups of the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param instanceGroups
         *        The instance groups of the SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroups(ClusterInstanceGroupDetails... instanceGroups);

        /**
         * <p>
         * The instance groups of the SageMaker HyperPod cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupDetails.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceGroups(List<ClusterInstanceGroupDetails>)}.
         * 
         * @param instanceGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceGroups(java.util.Collection<ClusterInstanceGroupDetails>)
         */
        Builder instanceGroups(Consumer<ClusterInstanceGroupDetails.Builder>... instanceGroups);

        /**
         * Sets the value of the VpcConfig property for this object.
         *
         * @param vpcConfig
         *        The new value for the VpcConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * Sets the value of the VpcConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VpcConfig.Builder} avoiding the need to
         * create one manually via {@link VpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * The type of orchestrator used for the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param orchestrator
         *        The type of orchestrator used for the SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orchestrator(ClusterOrchestrator orchestrator);

        /**
         * <p>
         * The type of orchestrator used for the SageMaker HyperPod cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterOrchestrator.Builder} avoiding the
         * need to create one manually via {@link ClusterOrchestrator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterOrchestrator.Builder#build()} is called immediately and
         * its result is passed to {@link #orchestrator(ClusterOrchestrator)}.
         * 
         * @param orchestrator
         *        a consumer that will call methods on {@link ClusterOrchestrator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orchestrator(ClusterOrchestrator)
         */
        default Builder orchestrator(Consumer<ClusterOrchestrator.Builder> orchestrator) {
            return orchestrator(ClusterOrchestrator.builder().applyMutation(orchestrator).build());
        }

        /**
         * <p>
         * The node recovery mode configured for the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param nodeRecovery
         *        The node recovery mode configured for the SageMaker HyperPod cluster.
         * @see ClusterNodeRecovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterNodeRecovery
         */
        Builder nodeRecovery(String nodeRecovery);

        /**
         * <p>
         * The node recovery mode configured for the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param nodeRecovery
         *        The node recovery mode configured for the SageMaker HyperPod cluster.
         * @see ClusterNodeRecovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterNodeRecovery
         */
        Builder nodeRecovery(ClusterNodeRecovery nodeRecovery);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String clusterArn;

        private String clusterName;

        private String clusterStatus;

        private Instant creationTime;

        private String failureMessage;

        private List<ClusterInstanceGroupDetails> instanceGroups = DefaultSdkAutoConstructList.getInstance();

        private VpcConfig vpcConfig;

        private ClusterOrchestrator orchestrator;

        private String nodeRecovery;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterResponse model) {
            super(model);
            clusterArn(model.clusterArn);
            clusterName(model.clusterName);
            clusterStatus(model.clusterStatus);
            creationTime(model.creationTime);
            failureMessage(model.failureMessage);
            instanceGroups(model.instanceGroups);
            vpcConfig(model.vpcConfig);
            orchestrator(model.orchestrator);
            nodeRecovery(model.nodeRecovery);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getClusterStatus() {
            return clusterStatus;
        }

        public final void setClusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
        }

        @Override
        public final Builder clusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
            return this;
        }

        @Override
        public final Builder clusterStatus(ClusterStatus clusterStatus) {
            this.clusterStatus(clusterStatus == null ? null : clusterStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final List<ClusterInstanceGroupDetails.Builder> getInstanceGroups() {
            List<ClusterInstanceGroupDetails.Builder> result = ClusterInstanceGroupDetailsListCopier
                    .copyToBuilder(this.instanceGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceGroups(Collection<ClusterInstanceGroupDetails.BuilderImpl> instanceGroups) {
            this.instanceGroups = ClusterInstanceGroupDetailsListCopier.copyFromBuilder(instanceGroups);
        }

        @Override
        public final Builder instanceGroups(Collection<ClusterInstanceGroupDetails> instanceGroups) {
            this.instanceGroups = ClusterInstanceGroupDetailsListCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(ClusterInstanceGroupDetails... instanceGroups) {
            instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(Consumer<ClusterInstanceGroupDetails.Builder>... instanceGroups) {
            instanceGroups(Stream.of(instanceGroups).map(c -> ClusterInstanceGroupDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final ClusterOrchestrator.Builder getOrchestrator() {
            return orchestrator != null ? orchestrator.toBuilder() : null;
        }

        public final void setOrchestrator(ClusterOrchestrator.BuilderImpl orchestrator) {
            this.orchestrator = orchestrator != null ? orchestrator.build() : null;
        }

        @Override
        public final Builder orchestrator(ClusterOrchestrator orchestrator) {
            this.orchestrator = orchestrator;
            return this;
        }

        public final String getNodeRecovery() {
            return nodeRecovery;
        }

        public final void setNodeRecovery(String nodeRecovery) {
            this.nodeRecovery = nodeRecovery;
        }

        @Override
        public final Builder nodeRecovery(String nodeRecovery) {
            this.nodeRecovery = nodeRecovery;
            return this;
        }

        @Override
        public final Builder nodeRecovery(ClusterNodeRecovery nodeRecovery) {
            this.nodeRecovery(nodeRecovery == null ? null : nodeRecovery.toString());
            return this;
        }

        @Override
        public DescribeClusterResponse build() {
            return new DescribeClusterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
