/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterSchedulerConfigRequest extends SageMakerRequest implements
        ToCopyableBuilder<DescribeClusterSchedulerConfigRequest.Builder, DescribeClusterSchedulerConfigRequest> {
    private static final SdkField<String> CLUSTER_SCHEDULER_CONFIG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterSchedulerConfigId")
            .getter(getter(DescribeClusterSchedulerConfigRequest::clusterSchedulerConfigId))
            .setter(setter(Builder::clusterSchedulerConfigId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSchedulerConfigId").build())
            .build();

    private static final SdkField<Integer> CLUSTER_SCHEDULER_CONFIG_VERSION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ClusterSchedulerConfigVersion")
            .getter(getter(DescribeClusterSchedulerConfigRequest::clusterSchedulerConfigVersion))
            .setter(setter(Builder::clusterSchedulerConfigVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSchedulerConfigVersion")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLUSTER_SCHEDULER_CONFIG_ID_FIELD, CLUSTER_SCHEDULER_CONFIG_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ClusterSchedulerConfigId", CLUSTER_SCHEDULER_CONFIG_ID_FIELD);
                    put("ClusterSchedulerConfigVersion", CLUSTER_SCHEDULER_CONFIG_VERSION_FIELD);
                }
            });

    private final String clusterSchedulerConfigId;

    private final Integer clusterSchedulerConfigVersion;

    private DescribeClusterSchedulerConfigRequest(BuilderImpl builder) {
        super(builder);
        this.clusterSchedulerConfigId = builder.clusterSchedulerConfigId;
        this.clusterSchedulerConfigVersion = builder.clusterSchedulerConfigVersion;
    }

    /**
     * <p>
     * ID of the cluster policy.
     * </p>
     * 
     * @return ID of the cluster policy.
     */
    public final String clusterSchedulerConfigId() {
        return clusterSchedulerConfigId;
    }

    /**
     * <p>
     * Version of the cluster policy.
     * </p>
     * 
     * @return Version of the cluster policy.
     */
    public final Integer clusterSchedulerConfigVersion() {
        return clusterSchedulerConfigVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterSchedulerConfigId());
        hashCode = 31 * hashCode + Objects.hashCode(clusterSchedulerConfigVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterSchedulerConfigRequest)) {
            return false;
        }
        DescribeClusterSchedulerConfigRequest other = (DescribeClusterSchedulerConfigRequest) obj;
        return Objects.equals(clusterSchedulerConfigId(), other.clusterSchedulerConfigId())
                && Objects.equals(clusterSchedulerConfigVersion(), other.clusterSchedulerConfigVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClusterSchedulerConfigRequest")
                .add("ClusterSchedulerConfigId", clusterSchedulerConfigId())
                .add("ClusterSchedulerConfigVersion", clusterSchedulerConfigVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterSchedulerConfigId":
            return Optional.ofNullable(clazz.cast(clusterSchedulerConfigId()));
        case "ClusterSchedulerConfigVersion":
            return Optional.ofNullable(clazz.cast(clusterSchedulerConfigVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterSchedulerConfigRequest, T> g) {
        return obj -> g.apply((DescribeClusterSchedulerConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeClusterSchedulerConfigRequest> {
        /**
         * <p>
         * ID of the cluster policy.
         * </p>
         * 
         * @param clusterSchedulerConfigId
         *        ID of the cluster policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSchedulerConfigId(String clusterSchedulerConfigId);

        /**
         * <p>
         * Version of the cluster policy.
         * </p>
         * 
         * @param clusterSchedulerConfigVersion
         *        Version of the cluster policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSchedulerConfigVersion(Integer clusterSchedulerConfigVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String clusterSchedulerConfigId;

        private Integer clusterSchedulerConfigVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterSchedulerConfigRequest model) {
            super(model);
            clusterSchedulerConfigId(model.clusterSchedulerConfigId);
            clusterSchedulerConfigVersion(model.clusterSchedulerConfigVersion);
        }

        public final String getClusterSchedulerConfigId() {
            return clusterSchedulerConfigId;
        }

        public final void setClusterSchedulerConfigId(String clusterSchedulerConfigId) {
            this.clusterSchedulerConfigId = clusterSchedulerConfigId;
        }

        @Override
        public final Builder clusterSchedulerConfigId(String clusterSchedulerConfigId) {
            this.clusterSchedulerConfigId = clusterSchedulerConfigId;
            return this;
        }

        public final Integer getClusterSchedulerConfigVersion() {
            return clusterSchedulerConfigVersion;
        }

        public final void setClusterSchedulerConfigVersion(Integer clusterSchedulerConfigVersion) {
            this.clusterSchedulerConfigVersion = clusterSchedulerConfigVersion;
        }

        @Override
        public final Builder clusterSchedulerConfigVersion(Integer clusterSchedulerConfigVersion) {
            this.clusterSchedulerConfigVersion = clusterSchedulerConfigVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeClusterSchedulerConfigRequest build() {
            return new DescribeClusterSchedulerConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
