/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterSchedulerConfigResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeClusterSchedulerConfigResponse.Builder, DescribeClusterSchedulerConfigResponse> {
    private static final SdkField<String> CLUSTER_SCHEDULER_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterSchedulerConfigArn")
            .getter(getter(DescribeClusterSchedulerConfigResponse::clusterSchedulerConfigArn))
            .setter(setter(Builder::clusterSchedulerConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSchedulerConfigArn").build())
            .build();

    private static final SdkField<String> CLUSTER_SCHEDULER_CONFIG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterSchedulerConfigId")
            .getter(getter(DescribeClusterSchedulerConfigResponse::clusterSchedulerConfigId))
            .setter(setter(Builder::clusterSchedulerConfigId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSchedulerConfigId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeClusterSchedulerConfigResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> CLUSTER_SCHEDULER_CONFIG_VERSION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ClusterSchedulerConfigVersion")
            .getter(getter(DescribeClusterSchedulerConfigResponse::clusterSchedulerConfigVersion))
            .setter(setter(Builder::clusterSchedulerConfigVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSchedulerConfigVersion")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeClusterSchedulerConfigResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeClusterSchedulerConfigResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(DescribeClusterSchedulerConfigResponse::clusterArn))
            .setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()).build();

    private static final SdkField<SchedulerConfig> SCHEDULER_CONFIG_FIELD = SdkField
            .<SchedulerConfig> builder(MarshallingType.SDK_POJO).memberName("SchedulerConfig")
            .getter(getter(DescribeClusterSchedulerConfigResponse::schedulerConfig)).setter(setter(Builder::schedulerConfig))
            .constructor(SchedulerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchedulerConfig").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeClusterSchedulerConfigResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeClusterSchedulerConfigResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(DescribeClusterSchedulerConfigResponse::createdBy))
            .setter(setter(Builder::createdBy)).constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeClusterSchedulerConfigResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("LastModifiedBy").getter(getter(DescribeClusterSchedulerConfigResponse::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy)).constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLUSTER_SCHEDULER_CONFIG_ARN_FIELD, CLUSTER_SCHEDULER_CONFIG_ID_FIELD, NAME_FIELD,
            CLUSTER_SCHEDULER_CONFIG_VERSION_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD, CLUSTER_ARN_FIELD,
            SCHEDULER_CONFIG_FIELD, DESCRIPTION_FIELD, CREATION_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_TIME_FIELD,
            LAST_MODIFIED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ClusterSchedulerConfigArn", CLUSTER_SCHEDULER_CONFIG_ARN_FIELD);
                    put("ClusterSchedulerConfigId", CLUSTER_SCHEDULER_CONFIG_ID_FIELD);
                    put("Name", NAME_FIELD);
                    put("ClusterSchedulerConfigVersion", CLUSTER_SCHEDULER_CONFIG_VERSION_FIELD);
                    put("Status", STATUS_FIELD);
                    put("FailureReason", FAILURE_REASON_FIELD);
                    put("ClusterArn", CLUSTER_ARN_FIELD);
                    put("SchedulerConfig", SCHEDULER_CONFIG_FIELD);
                    put("Description", DESCRIPTION_FIELD);
                    put("CreationTime", CREATION_TIME_FIELD);
                    put("CreatedBy", CREATED_BY_FIELD);
                    put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
                    put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
                }
            });

    private final String clusterSchedulerConfigArn;

    private final String clusterSchedulerConfigId;

    private final String name;

    private final Integer clusterSchedulerConfigVersion;

    private final String status;

    private final String failureReason;

    private final String clusterArn;

    private final SchedulerConfig schedulerConfig;

    private final String description;

    private final Instant creationTime;

    private final UserContext createdBy;

    private final Instant lastModifiedTime;

    private final UserContext lastModifiedBy;

    private DescribeClusterSchedulerConfigResponse(BuilderImpl builder) {
        super(builder);
        this.clusterSchedulerConfigArn = builder.clusterSchedulerConfigArn;
        this.clusterSchedulerConfigId = builder.clusterSchedulerConfigId;
        this.name = builder.name;
        this.clusterSchedulerConfigVersion = builder.clusterSchedulerConfigVersion;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.clusterArn = builder.clusterArn;
        this.schedulerConfig = builder.schedulerConfig;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
    }

    /**
     * <p>
     * ARN of the cluster policy.
     * </p>
     * 
     * @return ARN of the cluster policy.
     */
    public final String clusterSchedulerConfigArn() {
        return clusterSchedulerConfigArn;
    }

    /**
     * <p>
     * ID of the cluster policy.
     * </p>
     * 
     * @return ID of the cluster policy.
     */
    public final String clusterSchedulerConfigId() {
        return clusterSchedulerConfigId;
    }

    /**
     * <p>
     * Name of the cluster policy.
     * </p>
     * 
     * @return Name of the cluster policy.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Version of the cluster policy.
     * </p>
     * 
     * @return Version of the cluster policy.
     */
    public final Integer clusterSchedulerConfigVersion() {
        return clusterSchedulerConfigVersion;
    }

    /**
     * <p>
     * Status of the cluster policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SchedulerResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the cluster policy.
     * @see SchedulerResourceStatus
     */
    public final SchedulerResourceStatus status() {
        return SchedulerResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the cluster policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SchedulerResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the cluster policy.
     * @see SchedulerResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Failure reason of the cluster policy.
     * </p>
     * 
     * @return Failure reason of the cluster policy.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * ARN of the cluster where the cluster policy is applied.
     * </p>
     * 
     * @return ARN of the cluster where the cluster policy is applied.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * Cluster policy configuration. This policy is used for task prioritization and fair-share allocation. This helps
     * prioritize critical workloads and distributes idle compute across entities.
     * </p>
     * 
     * @return Cluster policy configuration. This policy is used for task prioritization and fair-share allocation. This
     *         helps prioritize critical workloads and distributes idle compute across entities.
     */
    public final SchedulerConfig schedulerConfig() {
        return schedulerConfig;
    }

    /**
     * <p>
     * Description of the cluster policy.
     * </p>
     * 
     * @return Description of the cluster policy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Creation time of the cluster policy.
     * </p>
     * 
     * @return Creation time of the cluster policy.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the CreatedBy property for this object.
     * 
     * @return The value of the CreatedBy property for this object.
     */
    public final UserContext createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * Last modified time of the cluster policy.
     * </p>
     * 
     * @return Last modified time of the cluster policy.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns the value of the LastModifiedBy property for this object.
     * 
     * @return The value of the LastModifiedBy property for this object.
     */
    public final UserContext lastModifiedBy() {
        return lastModifiedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterSchedulerConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterSchedulerConfigId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(clusterSchedulerConfigVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(schedulerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterSchedulerConfigResponse)) {
            return false;
        }
        DescribeClusterSchedulerConfigResponse other = (DescribeClusterSchedulerConfigResponse) obj;
        return Objects.equals(clusterSchedulerConfigArn(), other.clusterSchedulerConfigArn())
                && Objects.equals(clusterSchedulerConfigId(), other.clusterSchedulerConfigId())
                && Objects.equals(name(), other.name())
                && Objects.equals(clusterSchedulerConfigVersion(), other.clusterSchedulerConfigVersion())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(clusterArn(), other.clusterArn())
                && Objects.equals(schedulerConfig(), other.schedulerConfig())
                && Objects.equals(description(), other.description()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClusterSchedulerConfigResponse")
                .add("ClusterSchedulerConfigArn", clusterSchedulerConfigArn())
                .add("ClusterSchedulerConfigId", clusterSchedulerConfigId()).add("Name", name())
                .add("ClusterSchedulerConfigVersion", clusterSchedulerConfigVersion()).add("Status", statusAsString())
                .add("FailureReason", failureReason()).add("ClusterArn", clusterArn()).add("SchedulerConfig", schedulerConfig())
                .add("Description", description()).add("CreationTime", creationTime()).add("CreatedBy", createdBy())
                .add("LastModifiedTime", lastModifiedTime()).add("LastModifiedBy", lastModifiedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterSchedulerConfigArn":
            return Optional.ofNullable(clazz.cast(clusterSchedulerConfigArn()));
        case "ClusterSchedulerConfigId":
            return Optional.ofNullable(clazz.cast(clusterSchedulerConfigId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ClusterSchedulerConfigVersion":
            return Optional.ofNullable(clazz.cast(clusterSchedulerConfigVersion()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "SchedulerConfig":
            return Optional.ofNullable(clazz.cast(schedulerConfig()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterSchedulerConfigResponse, T> g) {
        return obj -> g.apply((DescribeClusterSchedulerConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeClusterSchedulerConfigResponse> {
        /**
         * <p>
         * ARN of the cluster policy.
         * </p>
         * 
         * @param clusterSchedulerConfigArn
         *        ARN of the cluster policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSchedulerConfigArn(String clusterSchedulerConfigArn);

        /**
         * <p>
         * ID of the cluster policy.
         * </p>
         * 
         * @param clusterSchedulerConfigId
         *        ID of the cluster policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSchedulerConfigId(String clusterSchedulerConfigId);

        /**
         * <p>
         * Name of the cluster policy.
         * </p>
         * 
         * @param name
         *        Name of the cluster policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Version of the cluster policy.
         * </p>
         * 
         * @param clusterSchedulerConfigVersion
         *        Version of the cluster policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSchedulerConfigVersion(Integer clusterSchedulerConfigVersion);

        /**
         * <p>
         * Status of the cluster policy.
         * </p>
         * 
         * @param status
         *        Status of the cluster policy.
         * @see SchedulerResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulerResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the cluster policy.
         * </p>
         * 
         * @param status
         *        Status of the cluster policy.
         * @see SchedulerResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulerResourceStatus
         */
        Builder status(SchedulerResourceStatus status);

        /**
         * <p>
         * Failure reason of the cluster policy.
         * </p>
         * 
         * @param failureReason
         *        Failure reason of the cluster policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * ARN of the cluster where the cluster policy is applied.
         * </p>
         * 
         * @param clusterArn
         *        ARN of the cluster where the cluster policy is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * Cluster policy configuration. This policy is used for task prioritization and fair-share allocation. This
         * helps prioritize critical workloads and distributes idle compute across entities.
         * </p>
         * 
         * @param schedulerConfig
         *        Cluster policy configuration. This policy is used for task prioritization and fair-share allocation.
         *        This helps prioritize critical workloads and distributes idle compute across entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedulerConfig(SchedulerConfig schedulerConfig);

        /**
         * <p>
         * Cluster policy configuration. This policy is used for task prioritization and fair-share allocation. This
         * helps prioritize critical workloads and distributes idle compute across entities.
         * </p>
         * This is a convenience method that creates an instance of the {@link SchedulerConfig.Builder} avoiding the
         * need to create one manually via {@link SchedulerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchedulerConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #schedulerConfig(SchedulerConfig)}.
         * 
         * @param schedulerConfig
         *        a consumer that will call methods on {@link SchedulerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedulerConfig(SchedulerConfig)
         */
        default Builder schedulerConfig(Consumer<SchedulerConfig.Builder> schedulerConfig) {
            return schedulerConfig(SchedulerConfig.builder().applyMutation(schedulerConfig).build());
        }

        /**
         * <p>
         * Description of the cluster policy.
         * </p>
         * 
         * @param description
         *        Description of the cluster policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Creation time of the cluster policy.
         * </p>
         * 
         * @param creationTime
         *        Creation time of the cluster policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * @param createdBy
         *        The new value for the CreatedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * Last modified time of the cluster policy.
         * </p>
         * 
         * @param lastModifiedTime
         *        Last modified time of the cluster policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * @param lastModifiedBy
         *        The new value for the LastModifiedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(UserContext lastModifiedBy);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #lastModifiedBy(UserContext)}.
         * 
         * @param lastModifiedBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedBy(UserContext)
         */
        default Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return lastModifiedBy(UserContext.builder().applyMutation(lastModifiedBy).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String clusterSchedulerConfigArn;

        private String clusterSchedulerConfigId;

        private String name;

        private Integer clusterSchedulerConfigVersion;

        private String status;

        private String failureReason;

        private String clusterArn;

        private SchedulerConfig schedulerConfig;

        private String description;

        private Instant creationTime;

        private UserContext createdBy;

        private Instant lastModifiedTime;

        private UserContext lastModifiedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterSchedulerConfigResponse model) {
            super(model);
            clusterSchedulerConfigArn(model.clusterSchedulerConfigArn);
            clusterSchedulerConfigId(model.clusterSchedulerConfigId);
            name(model.name);
            clusterSchedulerConfigVersion(model.clusterSchedulerConfigVersion);
            status(model.status);
            failureReason(model.failureReason);
            clusterArn(model.clusterArn);
            schedulerConfig(model.schedulerConfig);
            description(model.description);
            creationTime(model.creationTime);
            createdBy(model.createdBy);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedBy(model.lastModifiedBy);
        }

        public final String getClusterSchedulerConfigArn() {
            return clusterSchedulerConfigArn;
        }

        public final void setClusterSchedulerConfigArn(String clusterSchedulerConfigArn) {
            this.clusterSchedulerConfigArn = clusterSchedulerConfigArn;
        }

        @Override
        public final Builder clusterSchedulerConfigArn(String clusterSchedulerConfigArn) {
            this.clusterSchedulerConfigArn = clusterSchedulerConfigArn;
            return this;
        }

        public final String getClusterSchedulerConfigId() {
            return clusterSchedulerConfigId;
        }

        public final void setClusterSchedulerConfigId(String clusterSchedulerConfigId) {
            this.clusterSchedulerConfigId = clusterSchedulerConfigId;
        }

        @Override
        public final Builder clusterSchedulerConfigId(String clusterSchedulerConfigId) {
            this.clusterSchedulerConfigId = clusterSchedulerConfigId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getClusterSchedulerConfigVersion() {
            return clusterSchedulerConfigVersion;
        }

        public final void setClusterSchedulerConfigVersion(Integer clusterSchedulerConfigVersion) {
            this.clusterSchedulerConfigVersion = clusterSchedulerConfigVersion;
        }

        @Override
        public final Builder clusterSchedulerConfigVersion(Integer clusterSchedulerConfigVersion) {
            this.clusterSchedulerConfigVersion = clusterSchedulerConfigVersion;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SchedulerResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final SchedulerConfig.Builder getSchedulerConfig() {
            return schedulerConfig != null ? schedulerConfig.toBuilder() : null;
        }

        public final void setSchedulerConfig(SchedulerConfig.BuilderImpl schedulerConfig) {
            this.schedulerConfig = schedulerConfig != null ? schedulerConfig.build() : null;
        }

        @Override
        public final Builder schedulerConfig(SchedulerConfig schedulerConfig) {
            this.schedulerConfig = schedulerConfig;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return lastModifiedBy != null ? lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        @Override
        public DescribeClusterSchedulerConfigResponse build() {
            return new DescribeClusterSchedulerConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
