/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCodeRepositoryResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeCodeRepositoryResponse.Builder, DescribeCodeRepositoryResponse> {
    private static final SdkField<String> CODE_REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeRepositoryName").getter(getter(DescribeCodeRepositoryResponse::codeRepositoryName))
            .setter(setter(Builder::codeRepositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeRepositoryName").build())
            .build();

    private static final SdkField<String> CODE_REPOSITORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeRepositoryArn").getter(getter(DescribeCodeRepositoryResponse::codeRepositoryArn))
            .setter(setter(Builder::codeRepositoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeRepositoryArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeCodeRepositoryResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeCodeRepositoryResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<GitConfig> GIT_CONFIG_FIELD = SdkField.<GitConfig> builder(MarshallingType.SDK_POJO)
            .memberName("GitConfig").getter(getter(DescribeCodeRepositoryResponse::gitConfig)).setter(setter(Builder::gitConfig))
            .constructor(GitConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GitConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_REPOSITORY_NAME_FIELD,
            CODE_REPOSITORY_ARN_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, GIT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CodeRepositoryName", CODE_REPOSITORY_NAME_FIELD);
                    put("CodeRepositoryArn", CODE_REPOSITORY_ARN_FIELD);
                    put("CreationTime", CREATION_TIME_FIELD);
                    put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
                    put("GitConfig", GIT_CONFIG_FIELD);
                }
            });

    private final String codeRepositoryName;

    private final String codeRepositoryArn;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final GitConfig gitConfig;

    private DescribeCodeRepositoryResponse(BuilderImpl builder) {
        super(builder);
        this.codeRepositoryName = builder.codeRepositoryName;
        this.codeRepositoryArn = builder.codeRepositoryArn;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.gitConfig = builder.gitConfig;
    }

    /**
     * <p>
     * The name of the Git repository.
     * </p>
     * 
     * @return The name of the Git repository.
     */
    public final String codeRepositoryName() {
        return codeRepositoryName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Git repository.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Git repository.
     */
    public final String codeRepositoryArn() {
        return codeRepositoryArn;
    }

    /**
     * <p>
     * The date and time that the repository was created.
     * </p>
     * 
     * @return The date and time that the repository was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time that the repository was last changed.
     * </p>
     * 
     * @return The date and time that the repository was last changed.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * Configuration details about the repository, including the URL where the repository is located, the default
     * branch, and the Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that contains the
     * credentials used to access the repository.
     * </p>
     * 
     * @return Configuration details about the repository, including the URL where the repository is located, the
     *         default branch, and the Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that
     *         contains the credentials used to access the repository.
     */
    public final GitConfig gitConfig() {
        return gitConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeRepositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(codeRepositoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(gitConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCodeRepositoryResponse)) {
            return false;
        }
        DescribeCodeRepositoryResponse other = (DescribeCodeRepositoryResponse) obj;
        return Objects.equals(codeRepositoryName(), other.codeRepositoryName())
                && Objects.equals(codeRepositoryArn(), other.codeRepositoryArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(gitConfig(), other.gitConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCodeRepositoryResponse").add("CodeRepositoryName", codeRepositoryName())
                .add("CodeRepositoryArn", codeRepositoryArn()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("GitConfig", gitConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeRepositoryName":
            return Optional.ofNullable(clazz.cast(codeRepositoryName()));
        case "CodeRepositoryArn":
            return Optional.ofNullable(clazz.cast(codeRepositoryArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "GitConfig":
            return Optional.ofNullable(clazz.cast(gitConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCodeRepositoryResponse, T> g) {
        return obj -> g.apply((DescribeCodeRepositoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCodeRepositoryResponse> {
        /**
         * <p>
         * The name of the Git repository.
         * </p>
         * 
         * @param codeRepositoryName
         *        The name of the Git repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeRepositoryName(String codeRepositoryName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Git repository.
         * </p>
         * 
         * @param codeRepositoryArn
         *        The Amazon Resource Name (ARN) of the Git repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeRepositoryArn(String codeRepositoryArn);

        /**
         * <p>
         * The date and time that the repository was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time that the repository was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time that the repository was last changed.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time that the repository was last changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * Configuration details about the repository, including the URL where the repository is located, the default
         * branch, and the Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that contains
         * the credentials used to access the repository.
         * </p>
         * 
         * @param gitConfig
         *        Configuration details about the repository, including the URL where the repository is located, the
         *        default branch, and the Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret
         *        that contains the credentials used to access the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitConfig(GitConfig gitConfig);

        /**
         * <p>
         * Configuration details about the repository, including the URL where the repository is located, the default
         * branch, and the Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that contains
         * the credentials used to access the repository.
         * </p>
         * This is a convenience method that creates an instance of the {@link GitConfig.Builder} avoiding the need to
         * create one manually via {@link GitConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GitConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #gitConfig(GitConfig)}.
         * 
         * @param gitConfig
         *        a consumer that will call methods on {@link GitConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gitConfig(GitConfig)
         */
        default Builder gitConfig(Consumer<GitConfig.Builder> gitConfig) {
            return gitConfig(GitConfig.builder().applyMutation(gitConfig).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String codeRepositoryName;

        private String codeRepositoryArn;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private GitConfig gitConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCodeRepositoryResponse model) {
            super(model);
            codeRepositoryName(model.codeRepositoryName);
            codeRepositoryArn(model.codeRepositoryArn);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            gitConfig(model.gitConfig);
        }

        public final String getCodeRepositoryName() {
            return codeRepositoryName;
        }

        public final void setCodeRepositoryName(String codeRepositoryName) {
            this.codeRepositoryName = codeRepositoryName;
        }

        @Override
        public final Builder codeRepositoryName(String codeRepositoryName) {
            this.codeRepositoryName = codeRepositoryName;
            return this;
        }

        public final String getCodeRepositoryArn() {
            return codeRepositoryArn;
        }

        public final void setCodeRepositoryArn(String codeRepositoryArn) {
            this.codeRepositoryArn = codeRepositoryArn;
        }

        @Override
        public final Builder codeRepositoryArn(String codeRepositoryArn) {
            this.codeRepositoryArn = codeRepositoryArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final GitConfig.Builder getGitConfig() {
            return gitConfig != null ? gitConfig.toBuilder() : null;
        }

        public final void setGitConfig(GitConfig.BuilderImpl gitConfig) {
            this.gitConfig = gitConfig != null ? gitConfig.build() : null;
        }

        @Override
        public final Builder gitConfig(GitConfig gitConfig) {
            this.gitConfig = gitConfig;
            return this;
        }

        @Override
        public DescribeCodeRepositoryResponse build() {
            return new DescribeCodeRepositoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
