/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeComputeQuotaResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeComputeQuotaResponse.Builder, DescribeComputeQuotaResponse> {
    private static final SdkField<String> COMPUTE_QUOTA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputeQuotaArn").getter(getter(DescribeComputeQuotaResponse::computeQuotaArn))
            .setter(setter(Builder::computeQuotaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaArn").build()).build();

    private static final SdkField<String> COMPUTE_QUOTA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputeQuotaId").getter(getter(DescribeComputeQuotaResponse::computeQuotaId))
            .setter(setter(Builder::computeQuotaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeComputeQuotaResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeComputeQuotaResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> COMPUTE_QUOTA_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ComputeQuotaVersion").getter(getter(DescribeComputeQuotaResponse::computeQuotaVersion))
            .setter(setter(Builder::computeQuotaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaVersion").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeComputeQuotaResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeComputeQuotaResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(DescribeComputeQuotaResponse::clusterArn))
            .setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()).build();

    private static final SdkField<ComputeQuotaConfig> COMPUTE_QUOTA_CONFIG_FIELD = SdkField
            .<ComputeQuotaConfig> builder(MarshallingType.SDK_POJO).memberName("ComputeQuotaConfig")
            .getter(getter(DescribeComputeQuotaResponse::computeQuotaConfig)).setter(setter(Builder::computeQuotaConfig))
            .constructor(ComputeQuotaConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaConfig").build())
            .build();

    private static final SdkField<ComputeQuotaTarget> COMPUTE_QUOTA_TARGET_FIELD = SdkField
            .<ComputeQuotaTarget> builder(MarshallingType.SDK_POJO).memberName("ComputeQuotaTarget")
            .getter(getter(DescribeComputeQuotaResponse::computeQuotaTarget)).setter(setter(Builder::computeQuotaTarget))
            .constructor(ComputeQuotaTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaTarget").build())
            .build();

    private static final SdkField<String> ACTIVATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActivationState").getter(getter(DescribeComputeQuotaResponse::activationStateAsString))
            .setter(setter(Builder::activationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationState").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeComputeQuotaResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(DescribeComputeQuotaResponse::createdBy)).setter(setter(Builder::createdBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeComputeQuotaResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("LastModifiedBy").getter(getter(DescribeComputeQuotaResponse::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy)).constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_QUOTA_ARN_FIELD,
            COMPUTE_QUOTA_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, COMPUTE_QUOTA_VERSION_FIELD, STATUS_FIELD,
            FAILURE_REASON_FIELD, CLUSTER_ARN_FIELD, COMPUTE_QUOTA_CONFIG_FIELD, COMPUTE_QUOTA_TARGET_FIELD,
            ACTIVATION_STATE_FIELD, CREATION_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ComputeQuotaArn", COMPUTE_QUOTA_ARN_FIELD);
                    put("ComputeQuotaId", COMPUTE_QUOTA_ID_FIELD);
                    put("Name", NAME_FIELD);
                    put("Description", DESCRIPTION_FIELD);
                    put("ComputeQuotaVersion", COMPUTE_QUOTA_VERSION_FIELD);
                    put("Status", STATUS_FIELD);
                    put("FailureReason", FAILURE_REASON_FIELD);
                    put("ClusterArn", CLUSTER_ARN_FIELD);
                    put("ComputeQuotaConfig", COMPUTE_QUOTA_CONFIG_FIELD);
                    put("ComputeQuotaTarget", COMPUTE_QUOTA_TARGET_FIELD);
                    put("ActivationState", ACTIVATION_STATE_FIELD);
                    put("CreationTime", CREATION_TIME_FIELD);
                    put("CreatedBy", CREATED_BY_FIELD);
                    put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
                    put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
                }
            });

    private final String computeQuotaArn;

    private final String computeQuotaId;

    private final String name;

    private final String description;

    private final Integer computeQuotaVersion;

    private final String status;

    private final String failureReason;

    private final String clusterArn;

    private final ComputeQuotaConfig computeQuotaConfig;

    private final ComputeQuotaTarget computeQuotaTarget;

    private final String activationState;

    private final Instant creationTime;

    private final UserContext createdBy;

    private final Instant lastModifiedTime;

    private final UserContext lastModifiedBy;

    private DescribeComputeQuotaResponse(BuilderImpl builder) {
        super(builder);
        this.computeQuotaArn = builder.computeQuotaArn;
        this.computeQuotaId = builder.computeQuotaId;
        this.name = builder.name;
        this.description = builder.description;
        this.computeQuotaVersion = builder.computeQuotaVersion;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.clusterArn = builder.clusterArn;
        this.computeQuotaConfig = builder.computeQuotaConfig;
        this.computeQuotaTarget = builder.computeQuotaTarget;
        this.activationState = builder.activationState;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
    }

    /**
     * <p>
     * ARN of the compute allocation definition.
     * </p>
     * 
     * @return ARN of the compute allocation definition.
     */
    public final String computeQuotaArn() {
        return computeQuotaArn;
    }

    /**
     * <p>
     * ID of the compute allocation definition.
     * </p>
     * 
     * @return ID of the compute allocation definition.
     */
    public final String computeQuotaId() {
        return computeQuotaId;
    }

    /**
     * <p>
     * Name of the compute allocation definition.
     * </p>
     * 
     * @return Name of the compute allocation definition.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Description of the compute allocation definition.
     * </p>
     * 
     * @return Description of the compute allocation definition.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Version of the compute allocation definition.
     * </p>
     * 
     * @return Version of the compute allocation definition.
     */
    public final Integer computeQuotaVersion() {
        return computeQuotaVersion;
    }

    /**
     * <p>
     * Status of the compute allocation definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SchedulerResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the compute allocation definition.
     * @see SchedulerResourceStatus
     */
    public final SchedulerResourceStatus status() {
        return SchedulerResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the compute allocation definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SchedulerResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the compute allocation definition.
     * @see SchedulerResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Failure reason of the compute allocation definition.
     * </p>
     * 
     * @return Failure reason of the compute allocation definition.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * ARN of the cluster.
     * </p>
     * 
     * @return ARN of the cluster.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * Configuration of the compute allocation definition. This includes the resource sharing option, and the setting to
     * preempt low priority tasks.
     * </p>
     * 
     * @return Configuration of the compute allocation definition. This includes the resource sharing option, and the
     *         setting to preempt low priority tasks.
     */
    public final ComputeQuotaConfig computeQuotaConfig() {
        return computeQuotaConfig;
    }

    /**
     * <p>
     * The target entity to allocate compute resources to.
     * </p>
     * 
     * @return The target entity to allocate compute resources to.
     */
    public final ComputeQuotaTarget computeQuotaTarget() {
        return computeQuotaTarget;
    }

    /**
     * <p>
     * The state of the compute allocation being described. Use to enable or disable compute allocation.
     * </p>
     * <p>
     * Default is <code>Enabled</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #activationState}
     * will return {@link ActivationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #activationStateAsString}.
     * </p>
     * 
     * @return The state of the compute allocation being described. Use to enable or disable compute allocation.</p>
     *         <p>
     *         Default is <code>Enabled</code>.
     * @see ActivationState
     */
    public final ActivationState activationState() {
        return ActivationState.fromValue(activationState);
    }

    /**
     * <p>
     * The state of the compute allocation being described. Use to enable or disable compute allocation.
     * </p>
     * <p>
     * Default is <code>Enabled</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #activationState}
     * will return {@link ActivationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #activationStateAsString}.
     * </p>
     * 
     * @return The state of the compute allocation being described. Use to enable or disable compute allocation.</p>
     *         <p>
     *         Default is <code>Enabled</code>.
     * @see ActivationState
     */
    public final String activationStateAsString() {
        return activationState;
    }

    /**
     * <p>
     * Creation time of the compute allocation configuration.
     * </p>
     * 
     * @return Creation time of the compute allocation configuration.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the CreatedBy property for this object.
     * 
     * @return The value of the CreatedBy property for this object.
     */
    public final UserContext createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * Last modified time of the compute allocation configuration.
     * </p>
     * 
     * @return Last modified time of the compute allocation configuration.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns the value of the LastModifiedBy property for this object.
     * 
     * @return The value of the LastModifiedBy property for this object.
     */
    public final UserContext lastModifiedBy() {
        return lastModifiedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(computeQuotaArn());
        hashCode = 31 * hashCode + Objects.hashCode(computeQuotaId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(computeQuotaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(computeQuotaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(computeQuotaTarget());
        hashCode = 31 * hashCode + Objects.hashCode(activationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComputeQuotaResponse)) {
            return false;
        }
        DescribeComputeQuotaResponse other = (DescribeComputeQuotaResponse) obj;
        return Objects.equals(computeQuotaArn(), other.computeQuotaArn())
                && Objects.equals(computeQuotaId(), other.computeQuotaId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(computeQuotaVersion(), other.computeQuotaVersion())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(clusterArn(), other.clusterArn())
                && Objects.equals(computeQuotaConfig(), other.computeQuotaConfig())
                && Objects.equals(computeQuotaTarget(), other.computeQuotaTarget())
                && Objects.equals(activationStateAsString(), other.activationStateAsString())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeComputeQuotaResponse").add("ComputeQuotaArn", computeQuotaArn())
                .add("ComputeQuotaId", computeQuotaId()).add("Name", name()).add("Description", description())
                .add("ComputeQuotaVersion", computeQuotaVersion()).add("Status", statusAsString())
                .add("FailureReason", failureReason()).add("ClusterArn", clusterArn())
                .add("ComputeQuotaConfig", computeQuotaConfig()).add("ComputeQuotaTarget", computeQuotaTarget())
                .add("ActivationState", activationStateAsString()).add("CreationTime", creationTime())
                .add("CreatedBy", createdBy()).add("LastModifiedTime", lastModifiedTime())
                .add("LastModifiedBy", lastModifiedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComputeQuotaArn":
            return Optional.ofNullable(clazz.cast(computeQuotaArn()));
        case "ComputeQuotaId":
            return Optional.ofNullable(clazz.cast(computeQuotaId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ComputeQuotaVersion":
            return Optional.ofNullable(clazz.cast(computeQuotaVersion()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "ComputeQuotaConfig":
            return Optional.ofNullable(clazz.cast(computeQuotaConfig()));
        case "ComputeQuotaTarget":
            return Optional.ofNullable(clazz.cast(computeQuotaTarget()));
        case "ActivationState":
            return Optional.ofNullable(clazz.cast(activationStateAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeComputeQuotaResponse, T> g) {
        return obj -> g.apply((DescribeComputeQuotaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeComputeQuotaResponse> {
        /**
         * <p>
         * ARN of the compute allocation definition.
         * </p>
         * 
         * @param computeQuotaArn
         *        ARN of the compute allocation definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeQuotaArn(String computeQuotaArn);

        /**
         * <p>
         * ID of the compute allocation definition.
         * </p>
         * 
         * @param computeQuotaId
         *        ID of the compute allocation definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeQuotaId(String computeQuotaId);

        /**
         * <p>
         * Name of the compute allocation definition.
         * </p>
         * 
         * @param name
         *        Name of the compute allocation definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Description of the compute allocation definition.
         * </p>
         * 
         * @param description
         *        Description of the compute allocation definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Version of the compute allocation definition.
         * </p>
         * 
         * @param computeQuotaVersion
         *        Version of the compute allocation definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeQuotaVersion(Integer computeQuotaVersion);

        /**
         * <p>
         * Status of the compute allocation definition.
         * </p>
         * 
         * @param status
         *        Status of the compute allocation definition.
         * @see SchedulerResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulerResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the compute allocation definition.
         * </p>
         * 
         * @param status
         *        Status of the compute allocation definition.
         * @see SchedulerResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulerResourceStatus
         */
        Builder status(SchedulerResourceStatus status);

        /**
         * <p>
         * Failure reason of the compute allocation definition.
         * </p>
         * 
         * @param failureReason
         *        Failure reason of the compute allocation definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * ARN of the cluster.
         * </p>
         * 
         * @param clusterArn
         *        ARN of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * Configuration of the compute allocation definition. This includes the resource sharing option, and the
         * setting to preempt low priority tasks.
         * </p>
         * 
         * @param computeQuotaConfig
         *        Configuration of the compute allocation definition. This includes the resource sharing option, and the
         *        setting to preempt low priority tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeQuotaConfig(ComputeQuotaConfig computeQuotaConfig);

        /**
         * <p>
         * Configuration of the compute allocation definition. This includes the resource sharing option, and the
         * setting to preempt low priority tasks.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputeQuotaConfig.Builder} avoiding the
         * need to create one manually via {@link ComputeQuotaConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputeQuotaConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #computeQuotaConfig(ComputeQuotaConfig)}.
         * 
         * @param computeQuotaConfig
         *        a consumer that will call methods on {@link ComputeQuotaConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeQuotaConfig(ComputeQuotaConfig)
         */
        default Builder computeQuotaConfig(Consumer<ComputeQuotaConfig.Builder> computeQuotaConfig) {
            return computeQuotaConfig(ComputeQuotaConfig.builder().applyMutation(computeQuotaConfig).build());
        }

        /**
         * <p>
         * The target entity to allocate compute resources to.
         * </p>
         * 
         * @param computeQuotaTarget
         *        The target entity to allocate compute resources to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeQuotaTarget(ComputeQuotaTarget computeQuotaTarget);

        /**
         * <p>
         * The target entity to allocate compute resources to.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputeQuotaTarget.Builder} avoiding the
         * need to create one manually via {@link ComputeQuotaTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputeQuotaTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #computeQuotaTarget(ComputeQuotaTarget)}.
         * 
         * @param computeQuotaTarget
         *        a consumer that will call methods on {@link ComputeQuotaTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeQuotaTarget(ComputeQuotaTarget)
         */
        default Builder computeQuotaTarget(Consumer<ComputeQuotaTarget.Builder> computeQuotaTarget) {
            return computeQuotaTarget(ComputeQuotaTarget.builder().applyMutation(computeQuotaTarget).build());
        }

        /**
         * <p>
         * The state of the compute allocation being described. Use to enable or disable compute allocation.
         * </p>
         * <p>
         * Default is <code>Enabled</code>.
         * </p>
         * 
         * @param activationState
         *        The state of the compute allocation being described. Use to enable or disable compute allocation.</p>
         *        <p>
         *        Default is <code>Enabled</code>.
         * @see ActivationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivationState
         */
        Builder activationState(String activationState);

        /**
         * <p>
         * The state of the compute allocation being described. Use to enable or disable compute allocation.
         * </p>
         * <p>
         * Default is <code>Enabled</code>.
         * </p>
         * 
         * @param activationState
         *        The state of the compute allocation being described. Use to enable or disable compute allocation.</p>
         *        <p>
         *        Default is <code>Enabled</code>.
         * @see ActivationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivationState
         */
        Builder activationState(ActivationState activationState);

        /**
         * <p>
         * Creation time of the compute allocation configuration.
         * </p>
         * 
         * @param creationTime
         *        Creation time of the compute allocation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * @param createdBy
         *        The new value for the CreatedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * Last modified time of the compute allocation configuration.
         * </p>
         * 
         * @param lastModifiedTime
         *        Last modified time of the compute allocation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * @param lastModifiedBy
         *        The new value for the LastModifiedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(UserContext lastModifiedBy);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #lastModifiedBy(UserContext)}.
         * 
         * @param lastModifiedBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedBy(UserContext)
         */
        default Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return lastModifiedBy(UserContext.builder().applyMutation(lastModifiedBy).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String computeQuotaArn;

        private String computeQuotaId;

        private String name;

        private String description;

        private Integer computeQuotaVersion;

        private String status;

        private String failureReason;

        private String clusterArn;

        private ComputeQuotaConfig computeQuotaConfig;

        private ComputeQuotaTarget computeQuotaTarget;

        private String activationState;

        private Instant creationTime;

        private UserContext createdBy;

        private Instant lastModifiedTime;

        private UserContext lastModifiedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComputeQuotaResponse model) {
            super(model);
            computeQuotaArn(model.computeQuotaArn);
            computeQuotaId(model.computeQuotaId);
            name(model.name);
            description(model.description);
            computeQuotaVersion(model.computeQuotaVersion);
            status(model.status);
            failureReason(model.failureReason);
            clusterArn(model.clusterArn);
            computeQuotaConfig(model.computeQuotaConfig);
            computeQuotaTarget(model.computeQuotaTarget);
            activationState(model.activationState);
            creationTime(model.creationTime);
            createdBy(model.createdBy);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedBy(model.lastModifiedBy);
        }

        public final String getComputeQuotaArn() {
            return computeQuotaArn;
        }

        public final void setComputeQuotaArn(String computeQuotaArn) {
            this.computeQuotaArn = computeQuotaArn;
        }

        @Override
        public final Builder computeQuotaArn(String computeQuotaArn) {
            this.computeQuotaArn = computeQuotaArn;
            return this;
        }

        public final String getComputeQuotaId() {
            return computeQuotaId;
        }

        public final void setComputeQuotaId(String computeQuotaId) {
            this.computeQuotaId = computeQuotaId;
        }

        @Override
        public final Builder computeQuotaId(String computeQuotaId) {
            this.computeQuotaId = computeQuotaId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getComputeQuotaVersion() {
            return computeQuotaVersion;
        }

        public final void setComputeQuotaVersion(Integer computeQuotaVersion) {
            this.computeQuotaVersion = computeQuotaVersion;
        }

        @Override
        public final Builder computeQuotaVersion(Integer computeQuotaVersion) {
            this.computeQuotaVersion = computeQuotaVersion;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SchedulerResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final ComputeQuotaConfig.Builder getComputeQuotaConfig() {
            return computeQuotaConfig != null ? computeQuotaConfig.toBuilder() : null;
        }

        public final void setComputeQuotaConfig(ComputeQuotaConfig.BuilderImpl computeQuotaConfig) {
            this.computeQuotaConfig = computeQuotaConfig != null ? computeQuotaConfig.build() : null;
        }

        @Override
        public final Builder computeQuotaConfig(ComputeQuotaConfig computeQuotaConfig) {
            this.computeQuotaConfig = computeQuotaConfig;
            return this;
        }

        public final ComputeQuotaTarget.Builder getComputeQuotaTarget() {
            return computeQuotaTarget != null ? computeQuotaTarget.toBuilder() : null;
        }

        public final void setComputeQuotaTarget(ComputeQuotaTarget.BuilderImpl computeQuotaTarget) {
            this.computeQuotaTarget = computeQuotaTarget != null ? computeQuotaTarget.build() : null;
        }

        @Override
        public final Builder computeQuotaTarget(ComputeQuotaTarget computeQuotaTarget) {
            this.computeQuotaTarget = computeQuotaTarget;
            return this;
        }

        public final String getActivationState() {
            return activationState;
        }

        public final void setActivationState(String activationState) {
            this.activationState = activationState;
        }

        @Override
        public final Builder activationState(String activationState) {
            this.activationState = activationState;
            return this;
        }

        @Override
        public final Builder activationState(ActivationState activationState) {
            this.activationState(activationState == null ? null : activationState.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return lastModifiedBy != null ? lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        @Override
        public DescribeComputeQuotaResponse build() {
            return new DescribeComputeQuotaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
