/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDeviceResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeDeviceResponse.Builder, DescribeDeviceResponse> {
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceArn").getter(getter(DescribeDeviceResponse::deviceArn)).setter(setter(Builder::deviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceArn").build()).build();

    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceName").getter(getter(DescribeDeviceResponse::deviceName)).setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeDeviceResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceFleetName").getter(getter(DescribeDeviceResponse::deviceFleetName))
            .setter(setter(Builder::deviceFleetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()).build();

    private static final SdkField<String> IOT_THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IotThingName").getter(getter(DescribeDeviceResponse::iotThingName))
            .setter(setter(Builder::iotThingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IotThingName").build()).build();

    private static final SdkField<Instant> REGISTRATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RegistrationTime").getter(getter(DescribeDeviceResponse::registrationTime))
            .setter(setter(Builder::registrationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationTime").build()).build();

    private static final SdkField<Instant> LATEST_HEARTBEAT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestHeartbeat").getter(getter(DescribeDeviceResponse::latestHeartbeat))
            .setter(setter(Builder::latestHeartbeat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestHeartbeat").build()).build();

    private static final SdkField<List<EdgeModel>> MODELS_FIELD = SdkField
            .<List<EdgeModel>> builder(MarshallingType.LIST)
            .memberName("Models")
            .getter(getter(DescribeDeviceResponse::models))
            .setter(setter(Builder::models))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Models").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EdgeModel> builder(MarshallingType.SDK_POJO)
                                            .constructor(EdgeModel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_MODELS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxModels").getter(getter(DescribeDeviceResponse::maxModels)).setter(setter(Builder::maxModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxModels").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeDeviceResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentVersion").getter(getter(DescribeDeviceResponse::agentVersion))
            .setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ARN_FIELD,
            DEVICE_NAME_FIELD, DESCRIPTION_FIELD, DEVICE_FLEET_NAME_FIELD, IOT_THING_NAME_FIELD, REGISTRATION_TIME_FIELD,
            LATEST_HEARTBEAT_FIELD, MODELS_FIELD, MAX_MODELS_FIELD, NEXT_TOKEN_FIELD, AGENT_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DeviceArn", DEVICE_ARN_FIELD);
                    put("DeviceName", DEVICE_NAME_FIELD);
                    put("Description", DESCRIPTION_FIELD);
                    put("DeviceFleetName", DEVICE_FLEET_NAME_FIELD);
                    put("IotThingName", IOT_THING_NAME_FIELD);
                    put("RegistrationTime", REGISTRATION_TIME_FIELD);
                    put("LatestHeartbeat", LATEST_HEARTBEAT_FIELD);
                    put("Models", MODELS_FIELD);
                    put("MaxModels", MAX_MODELS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("AgentVersion", AGENT_VERSION_FIELD);
                }
            });

    private final String deviceArn;

    private final String deviceName;

    private final String description;

    private final String deviceFleetName;

    private final String iotThingName;

    private final Instant registrationTime;

    private final Instant latestHeartbeat;

    private final List<EdgeModel> models;

    private final Integer maxModels;

    private final String nextToken;

    private final String agentVersion;

    private DescribeDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.deviceArn = builder.deviceArn;
        this.deviceName = builder.deviceName;
        this.description = builder.description;
        this.deviceFleetName = builder.deviceFleetName;
        this.iotThingName = builder.iotThingName;
        this.registrationTime = builder.registrationTime;
        this.latestHeartbeat = builder.latestHeartbeat;
        this.models = builder.models;
        this.maxModels = builder.maxModels;
        this.nextToken = builder.nextToken;
        this.agentVersion = builder.agentVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the device.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the device.
     */
    public final String deviceArn() {
        return deviceArn;
    }

    /**
     * <p>
     * The unique identifier of the device.
     * </p>
     * 
     * @return The unique identifier of the device.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * A description of the device.
     * </p>
     * 
     * @return A description of the device.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the fleet the device belongs to.
     * </p>
     * 
     * @return The name of the fleet the device belongs to.
     */
    public final String deviceFleetName() {
        return deviceFleetName;
    }

    /**
     * <p>
     * The Amazon Web Services Internet of Things (IoT) object thing name associated with the device.
     * </p>
     * 
     * @return The Amazon Web Services Internet of Things (IoT) object thing name associated with the device.
     */
    public final String iotThingName() {
        return iotThingName;
    }

    /**
     * <p>
     * The timestamp of the last registration or de-reregistration.
     * </p>
     * 
     * @return The timestamp of the last registration or de-reregistration.
     */
    public final Instant registrationTime() {
        return registrationTime;
    }

    /**
     * <p>
     * The last heartbeat received from the device.
     * </p>
     * 
     * @return The last heartbeat received from the device.
     */
    public final Instant latestHeartbeat() {
        return latestHeartbeat;
    }

    /**
     * For responses, this returns true if the service returned a value for the Models property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasModels() {
        return models != null && !(models instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Models on the device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModels} method.
     * </p>
     * 
     * @return Models on the device.
     */
    public final List<EdgeModel> models() {
        return models;
    }

    /**
     * <p>
     * The maximum number of models.
     * </p>
     * 
     * @return The maximum number of models.
     */
    public final Integer maxModels() {
        return maxModels;
    }

    /**
     * <p>
     * The response from the last list when returning a list large enough to need tokening.
     * </p>
     * 
     * @return The response from the last list when returning a list large enough to need tokening.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Edge Manager agent version.
     * </p>
     * 
     * @return Edge Manager agent version.
     */
    public final String agentVersion() {
        return agentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deviceFleetName());
        hashCode = 31 * hashCode + Objects.hashCode(iotThingName());
        hashCode = 31 * hashCode + Objects.hashCode(registrationTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestHeartbeat());
        hashCode = 31 * hashCode + Objects.hashCode(hasModels() ? models() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxModels());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeviceResponse)) {
            return false;
        }
        DescribeDeviceResponse other = (DescribeDeviceResponse) obj;
        return Objects.equals(deviceArn(), other.deviceArn()) && Objects.equals(deviceName(), other.deviceName())
                && Objects.equals(description(), other.description())
                && Objects.equals(deviceFleetName(), other.deviceFleetName())
                && Objects.equals(iotThingName(), other.iotThingName())
                && Objects.equals(registrationTime(), other.registrationTime())
                && Objects.equals(latestHeartbeat(), other.latestHeartbeat()) && hasModels() == other.hasModels()
                && Objects.equals(models(), other.models()) && Objects.equals(maxModels(), other.maxModels())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(agentVersion(), other.agentVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDeviceResponse").add("DeviceArn", deviceArn()).add("DeviceName", deviceName())
                .add("Description", description()).add("DeviceFleetName", deviceFleetName()).add("IotThingName", iotThingName())
                .add("RegistrationTime", registrationTime()).add("LatestHeartbeat", latestHeartbeat())
                .add("Models", hasModels() ? models() : null).add("MaxModels", maxModels()).add("NextToken", nextToken())
                .add("AgentVersion", agentVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceArn":
            return Optional.ofNullable(clazz.cast(deviceArn()));
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DeviceFleetName":
            return Optional.ofNullable(clazz.cast(deviceFleetName()));
        case "IotThingName":
            return Optional.ofNullable(clazz.cast(iotThingName()));
        case "RegistrationTime":
            return Optional.ofNullable(clazz.cast(registrationTime()));
        case "LatestHeartbeat":
            return Optional.ofNullable(clazz.cast(latestHeartbeat()));
        case "Models":
            return Optional.ofNullable(clazz.cast(models()));
        case "MaxModels":
            return Optional.ofNullable(clazz.cast(maxModels()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "AgentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeviceResponse, T> g) {
        return obj -> g.apply((DescribeDeviceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDeviceResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the device.
         * </p>
         * 
         * @param deviceArn
         *        The Amazon Resource Name (ARN) of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * The unique identifier of the device.
         * </p>
         * 
         * @param deviceName
         *        The unique identifier of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * A description of the device.
         * </p>
         * 
         * @param description
         *        A description of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the fleet the device belongs to.
         * </p>
         * 
         * @param deviceFleetName
         *        The name of the fleet the device belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceFleetName(String deviceFleetName);

        /**
         * <p>
         * The Amazon Web Services Internet of Things (IoT) object thing name associated with the device.
         * </p>
         * 
         * @param iotThingName
         *        The Amazon Web Services Internet of Things (IoT) object thing name associated with the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotThingName(String iotThingName);

        /**
         * <p>
         * The timestamp of the last registration or de-reregistration.
         * </p>
         * 
         * @param registrationTime
         *        The timestamp of the last registration or de-reregistration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationTime(Instant registrationTime);

        /**
         * <p>
         * The last heartbeat received from the device.
         * </p>
         * 
         * @param latestHeartbeat
         *        The last heartbeat received from the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestHeartbeat(Instant latestHeartbeat);

        /**
         * <p>
         * Models on the device.
         * </p>
         * 
         * @param models
         *        Models on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(Collection<EdgeModel> models);

        /**
         * <p>
         * Models on the device.
         * </p>
         * 
         * @param models
         *        Models on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(EdgeModel... models);

        /**
         * <p>
         * Models on the device.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.EdgeModel.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sagemaker.model.EdgeModel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.EdgeModel.Builder#build()} is called immediately and
         * its result is passed to {@link #models(List<EdgeModel>)}.
         * 
         * @param models
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.EdgeModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #models(java.util.Collection<EdgeModel>)
         */
        Builder models(Consumer<EdgeModel.Builder>... models);

        /**
         * <p>
         * The maximum number of models.
         * </p>
         * 
         * @param maxModels
         *        The maximum number of models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxModels(Integer maxModels);

        /**
         * <p>
         * The response from the last list when returning a list large enough to need tokening.
         * </p>
         * 
         * @param nextToken
         *        The response from the last list when returning a list large enough to need tokening.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Edge Manager agent version.
         * </p>
         * 
         * @param agentVersion
         *        Edge Manager agent version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String deviceArn;

        private String deviceName;

        private String description;

        private String deviceFleetName;

        private String iotThingName;

        private Instant registrationTime;

        private Instant latestHeartbeat;

        private List<EdgeModel> models = DefaultSdkAutoConstructList.getInstance();

        private Integer maxModels;

        private String nextToken;

        private String agentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeviceResponse model) {
            super(model);
            deviceArn(model.deviceArn);
            deviceName(model.deviceName);
            description(model.description);
            deviceFleetName(model.deviceFleetName);
            iotThingName(model.iotThingName);
            registrationTime(model.registrationTime);
            latestHeartbeat(model.latestHeartbeat);
            models(model.models);
            maxModels(model.maxModels);
            nextToken(model.nextToken);
            agentVersion(model.agentVersion);
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDeviceFleetName() {
            return deviceFleetName;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        @Override
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        public final String getIotThingName() {
            return iotThingName;
        }

        public final void setIotThingName(String iotThingName) {
            this.iotThingName = iotThingName;
        }

        @Override
        public final Builder iotThingName(String iotThingName) {
            this.iotThingName = iotThingName;
            return this;
        }

        public final Instant getRegistrationTime() {
            return registrationTime;
        }

        public final void setRegistrationTime(Instant registrationTime) {
            this.registrationTime = registrationTime;
        }

        @Override
        public final Builder registrationTime(Instant registrationTime) {
            this.registrationTime = registrationTime;
            return this;
        }

        public final Instant getLatestHeartbeat() {
            return latestHeartbeat;
        }

        public final void setLatestHeartbeat(Instant latestHeartbeat) {
            this.latestHeartbeat = latestHeartbeat;
        }

        @Override
        public final Builder latestHeartbeat(Instant latestHeartbeat) {
            this.latestHeartbeat = latestHeartbeat;
            return this;
        }

        public final List<EdgeModel.Builder> getModels() {
            List<EdgeModel.Builder> result = EdgeModelsCopier.copyToBuilder(this.models);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModels(Collection<EdgeModel.BuilderImpl> models) {
            this.models = EdgeModelsCopier.copyFromBuilder(models);
        }

        @Override
        public final Builder models(Collection<EdgeModel> models) {
            this.models = EdgeModelsCopier.copy(models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(EdgeModel... models) {
            models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<EdgeModel.Builder>... models) {
            models(Stream.of(models).map(c -> EdgeModel.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxModels() {
            return maxModels;
        }

        public final void setMaxModels(Integer maxModels) {
            this.maxModels = maxModels;
        }

        @Override
        public final Builder maxModels(Integer maxModels) {
            this.maxModels = maxModels;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        @Override
        public DescribeDeviceResponse build() {
            return new DescribeDeviceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
