/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImageResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeImageResponse.Builder, DescribeImageResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeImageResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeImageResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(DescribeImageResponse::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeImageResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> IMAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageArn").getter(getter(DescribeImageResponse::imageArn)).setter(setter(Builder::imageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageArn").build()).build();

    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageName").getter(getter(DescribeImageResponse::imageName)).setter(setter(Builder::imageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()).build();

    private static final SdkField<String> IMAGE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageStatus").getter(getter(DescribeImageResponse::imageStatusAsString))
            .setter(setter(Builder::imageStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageStatus").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeImageResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeImageResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, FAILURE_REASON_FIELD, IMAGE_ARN_FIELD, IMAGE_NAME_FIELD, IMAGE_STATUS_FIELD,
            LAST_MODIFIED_TIME_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CreationTime", CREATION_TIME_FIELD);
                    put("Description", DESCRIPTION_FIELD);
                    put("DisplayName", DISPLAY_NAME_FIELD);
                    put("FailureReason", FAILURE_REASON_FIELD);
                    put("ImageArn", IMAGE_ARN_FIELD);
                    put("ImageName", IMAGE_NAME_FIELD);
                    put("ImageStatus", IMAGE_STATUS_FIELD);
                    put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
                    put("RoleArn", ROLE_ARN_FIELD);
                }
            });

    private final Instant creationTime;

    private final String description;

    private final String displayName;

    private final String failureReason;

    private final String imageArn;

    private final String imageName;

    private final String imageStatus;

    private final Instant lastModifiedTime;

    private final String roleArn;

    private DescribeImageResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.failureReason = builder.failureReason;
        this.imageArn = builder.imageArn;
        this.imageName = builder.imageName;
        this.imageStatus = builder.imageStatus;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * When the image was created.
     * </p>
     * 
     * @return When the image was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The description of the image.
     * </p>
     * 
     * @return The description of the image.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the image as displayed.
     * </p>
     * 
     * @return The name of the image as displayed.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * When a create, update, or delete operation fails, the reason for the failure.
     * </p>
     * 
     * @return When a create, update, or delete operation fails, the reason for the failure.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The ARN of the image.
     * </p>
     * 
     * @return The ARN of the image.
     */
    public final String imageArn() {
        return imageArn;
    }

    /**
     * <p>
     * The name of the image.
     * </p>
     * 
     * @return The name of the image.
     */
    public final String imageName() {
        return imageName;
    }

    /**
     * <p>
     * The status of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imageStatus} will
     * return {@link ImageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #imageStatusAsString}.
     * </p>
     * 
     * @return The status of the image.
     * @see ImageStatus
     */
    public final ImageStatus imageStatus() {
        return ImageStatus.fromValue(imageStatus);
    }

    /**
     * <p>
     * The status of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imageStatus} will
     * return {@link ImageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #imageStatusAsString}.
     * </p>
     * 
     * @return The status of the image.
     * @see ImageStatus
     */
    public final String imageStatusAsString() {
        return imageStatus;
    }

    /**
     * <p>
     * When the image was last modified.
     * </p>
     * 
     * @return When the image was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The ARN of the IAM role that enables Amazon SageMaker to perform tasks on your behalf.
     * </p>
     * 
     * @return The ARN of the IAM role that enables Amazon SageMaker to perform tasks on your behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(imageArn());
        hashCode = 31 * hashCode + Objects.hashCode(imageName());
        hashCode = 31 * hashCode + Objects.hashCode(imageStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageResponse)) {
            return false;
        }
        DescribeImageResponse other = (DescribeImageResponse) obj;
        return Objects.equals(creationTime(), other.creationTime()) && Objects.equals(description(), other.description())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(imageArn(), other.imageArn()) && Objects.equals(imageName(), other.imageName())
                && Objects.equals(imageStatusAsString(), other.imageStatusAsString())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImageResponse").add("CreationTime", creationTime()).add("Description", description())
                .add("DisplayName", displayName()).add("FailureReason", failureReason()).add("ImageArn", imageArn())
                .add("ImageName", imageName()).add("ImageStatus", imageStatusAsString())
                .add("LastModifiedTime", lastModifiedTime()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "ImageArn":
            return Optional.ofNullable(clazz.cast(imageArn()));
        case "ImageName":
            return Optional.ofNullable(clazz.cast(imageName()));
        case "ImageStatus":
            return Optional.ofNullable(clazz.cast(imageStatusAsString()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageResponse, T> g) {
        return obj -> g.apply((DescribeImageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImageResponse> {
        /**
         * <p>
         * When the image was created.
         * </p>
         * 
         * @param creationTime
         *        When the image was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The description of the image.
         * </p>
         * 
         * @param description
         *        The description of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the image as displayed.
         * </p>
         * 
         * @param displayName
         *        The name of the image as displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * When a create, update, or delete operation fails, the reason for the failure.
         * </p>
         * 
         * @param failureReason
         *        When a create, update, or delete operation fails, the reason for the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The ARN of the image.
         * </p>
         * 
         * @param imageArn
         *        The ARN of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageArn(String imageArn);

        /**
         * <p>
         * The name of the image.
         * </p>
         * 
         * @param imageName
         *        The name of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageName(String imageName);

        /**
         * <p>
         * The status of the image.
         * </p>
         * 
         * @param imageStatus
         *        The status of the image.
         * @see ImageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageStatus
         */
        Builder imageStatus(String imageStatus);

        /**
         * <p>
         * The status of the image.
         * </p>
         * 
         * @param imageStatus
         *        The status of the image.
         * @see ImageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageStatus
         */
        Builder imageStatus(ImageStatus imageStatus);

        /**
         * <p>
         * When the image was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        When the image was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The ARN of the IAM role that enables Amazon SageMaker to perform tasks on your behalf.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that enables Amazon SageMaker to perform tasks on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private Instant creationTime;

        private String description;

        private String displayName;

        private String failureReason;

        private String imageArn;

        private String imageName;

        private String imageStatus;

        private Instant lastModifiedTime;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageResponse model) {
            super(model);
            creationTime(model.creationTime);
            description(model.description);
            displayName(model.displayName);
            failureReason(model.failureReason);
            imageArn(model.imageArn);
            imageName(model.imageName);
            imageStatus(model.imageStatus);
            lastModifiedTime(model.lastModifiedTime);
            roleArn(model.roleArn);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getImageArn() {
            return imageArn;
        }

        public final void setImageArn(String imageArn) {
            this.imageArn = imageArn;
        }

        @Override
        public final Builder imageArn(String imageArn) {
            this.imageArn = imageArn;
            return this;
        }

        public final String getImageName() {
            return imageName;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final String getImageStatus() {
            return imageStatus;
        }

        public final void setImageStatus(String imageStatus) {
            this.imageStatus = imageStatus;
        }

        @Override
        public final Builder imageStatus(String imageStatus) {
            this.imageStatus = imageStatus;
            return this;
        }

        @Override
        public final Builder imageStatus(ImageStatus imageStatus) {
            this.imageStatus(imageStatus == null ? null : imageStatus.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public DescribeImageResponse build() {
            return new DescribeImageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
