/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePartnerAppResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribePartnerAppResponse.Builder, DescribePartnerAppResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribePartnerAppResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribePartnerAppResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DescribePartnerAppResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribePartnerAppResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribePartnerAppResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(DescribePartnerAppResponse::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<String> BASE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseUrl").getter(getter(DescribePartnerAppResponse::baseUrl)).setter(setter(Builder::baseUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseUrl").build()).build();

    private static final SdkField<PartnerAppMaintenanceConfig> MAINTENANCE_CONFIG_FIELD = SdkField
            .<PartnerAppMaintenanceConfig> builder(MarshallingType.SDK_POJO).memberName("MaintenanceConfig")
            .getter(getter(DescribePartnerAppResponse::maintenanceConfig)).setter(setter(Builder::maintenanceConfig))
            .constructor(PartnerAppMaintenanceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceConfig").build()).build();

    private static final SdkField<String> TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tier")
            .getter(getter(DescribePartnerAppResponse::tier)).setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(DescribePartnerAppResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<PartnerAppConfig> APPLICATION_CONFIG_FIELD = SdkField
            .<PartnerAppConfig> builder(MarshallingType.SDK_POJO).memberName("ApplicationConfig")
            .getter(getter(DescribePartnerAppResponse::applicationConfig)).setter(setter(Builder::applicationConfig))
            .constructor(PartnerAppConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationConfig").build()).build();

    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthType").getter(getter(DescribePartnerAppResponse::authTypeAsString))
            .setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthType").build()).build();

    private static final SdkField<Boolean> ENABLE_IAM_SESSION_BASED_IDENTITY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableIamSessionBasedIdentity")
            .getter(getter(DescribePartnerAppResponse::enableIamSessionBasedIdentity))
            .setter(setter(Builder::enableIamSessionBasedIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIamSessionBasedIdentity")
                    .build()).build();

    private static final SdkField<ErrorInfo> ERROR_FIELD = SdkField.<ErrorInfo> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(DescribePartnerAppResponse::error)).setter(setter(Builder::error))
            .constructor(ErrorInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            TYPE_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, EXECUTION_ROLE_ARN_FIELD, BASE_URL_FIELD, MAINTENANCE_CONFIG_FIELD,
            TIER_FIELD, VERSION_FIELD, APPLICATION_CONFIG_FIELD, AUTH_TYPE_FIELD, ENABLE_IAM_SESSION_BASED_IDENTITY_FIELD,
            ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Arn", ARN_FIELD);
                    put("Name", NAME_FIELD);
                    put("Type", TYPE_FIELD);
                    put("Status", STATUS_FIELD);
                    put("CreationTime", CREATION_TIME_FIELD);
                    put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
                    put("BaseUrl", BASE_URL_FIELD);
                    put("MaintenanceConfig", MAINTENANCE_CONFIG_FIELD);
                    put("Tier", TIER_FIELD);
                    put("Version", VERSION_FIELD);
                    put("ApplicationConfig", APPLICATION_CONFIG_FIELD);
                    put("AuthType", AUTH_TYPE_FIELD);
                    put("EnableIamSessionBasedIdentity", ENABLE_IAM_SESSION_BASED_IDENTITY_FIELD);
                    put("Error", ERROR_FIELD);
                }
            });

    private final String arn;

    private final String name;

    private final String type;

    private final String status;

    private final Instant creationTime;

    private final String executionRoleArn;

    private final String baseUrl;

    private final PartnerAppMaintenanceConfig maintenanceConfig;

    private final String tier;

    private final String version;

    private final PartnerAppConfig applicationConfig;

    private final String authType;

    private final Boolean enableIamSessionBasedIdentity;

    private final ErrorInfo error;

    private DescribePartnerAppResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.executionRoleArn = builder.executionRoleArn;
        this.baseUrl = builder.baseUrl;
        this.maintenanceConfig = builder.maintenanceConfig;
        this.tier = builder.tier;
        this.version = builder.version;
        this.applicationConfig = builder.applicationConfig;
        this.authType = builder.authType;
        this.enableIamSessionBasedIdentity = builder.enableIamSessionBasedIdentity;
        this.error = builder.error;
    }

    /**
     * <p>
     * The ARN of the SageMaker Partner AI App that was described.
     * </p>
     * 
     * @return The ARN of the SageMaker Partner AI App that was described.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the SageMaker Partner AI App.
     * </p>
     * 
     * @return The name of the SageMaker Partner AI App.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of SageMaker Partner AI App. Must be one of the following: <code>lakera-guard</code>, <code>comet</code>, <code>deepchecks-llm-evaluation</code>, or <code>fiddler</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PartnerAppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of SageMaker Partner AI App. Must be one of the following: <code>lakera-guard</code>,
     *         <code>comet</code>, <code>deepchecks-llm-evaluation</code>, or <code>fiddler</code>.
     * @see PartnerAppType
     */
    public final PartnerAppType type() {
        return PartnerAppType.fromValue(type);
    }

    /**
     * <p>
     * The type of SageMaker Partner AI App. Must be one of the following: <code>lakera-guard</code>, <code>comet</code>, <code>deepchecks-llm-evaluation</code>, or <code>fiddler</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PartnerAppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of SageMaker Partner AI App. Must be one of the following: <code>lakera-guard</code>,
     *         <code>comet</code>, <code>deepchecks-llm-evaluation</code>, or <code>fiddler</code>.
     * @see PartnerAppType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The status of the SageMaker Partner AI App.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PartnerAppStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the SageMaker Partner AI App.
     * @see PartnerAppStatus
     */
    public final PartnerAppStatus status() {
        return PartnerAppStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the SageMaker Partner AI App.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PartnerAppStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the SageMaker Partner AI App.
     * @see PartnerAppStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time that the SageMaker Partner AI App was created.
     * </p>
     * 
     * @return The time that the SageMaker Partner AI App was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The ARN of the IAM role associated with the SageMaker Partner AI App.
     * </p>
     * 
     * @return The ARN of the IAM role associated with the SageMaker Partner AI App.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The URL of the SageMaker Partner AI App that the Application SDK uses to support in-app calls for the user.
     * </p>
     * 
     * @return The URL of the SageMaker Partner AI App that the Application SDK uses to support in-app calls for the
     *         user.
     */
    public final String baseUrl() {
        return baseUrl;
    }

    /**
     * <p>
     * Maintenance configuration settings for the SageMaker Partner AI App.
     * </p>
     * 
     * @return Maintenance configuration settings for the SageMaker Partner AI App.
     */
    public final PartnerAppMaintenanceConfig maintenanceConfig() {
        return maintenanceConfig;
    }

    /**
     * <p>
     * The instance type and size of the cluster attached to the SageMaker Partner AI App.
     * </p>
     * 
     * @return The instance type and size of the cluster attached to the SageMaker Partner AI App.
     */
    public final String tier() {
        return tier;
    }

    /**
     * <p>
     * The version of the SageMaker Partner AI App.
     * </p>
     * 
     * @return The version of the SageMaker Partner AI App.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * Configuration settings for the SageMaker Partner AI App.
     * </p>
     * 
     * @return Configuration settings for the SageMaker Partner AI App.
     */
    public final PartnerAppConfig applicationConfig() {
        return applicationConfig;
    }

    /**
     * <p>
     * The authorization type that users use to access the SageMaker Partner AI App.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link PartnerAppAuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The authorization type that users use to access the SageMaker Partner AI App.
     * @see PartnerAppAuthType
     */
    public final PartnerAppAuthType authType() {
        return PartnerAppAuthType.fromValue(authType);
    }

    /**
     * <p>
     * The authorization type that users use to access the SageMaker Partner AI App.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link PartnerAppAuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The authorization type that users use to access the SageMaker Partner AI App.
     * @see PartnerAppAuthType
     */
    public final String authTypeAsString() {
        return authType;
    }

    /**
     * <p>
     * When set to <code>TRUE</code>, the SageMaker Partner AI App sets the Amazon Web Services IAM session name or the
     * authenticated IAM user as the identity of the SageMaker Partner AI App user.
     * </p>
     * 
     * @return When set to <code>TRUE</code>, the SageMaker Partner AI App sets the Amazon Web Services IAM session name
     *         or the authenticated IAM user as the identity of the SageMaker Partner AI App user.
     */
    public final Boolean enableIamSessionBasedIdentity() {
        return enableIamSessionBasedIdentity;
    }

    /**
     * <p>
     * This is an error field object that contains the error code and the reason for an operation failure.
     * </p>
     * 
     * @return This is an error field object that contains the error code and the reason for an operation failure.
     */
    public final ErrorInfo error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(baseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(tier());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(applicationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enableIamSessionBasedIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePartnerAppResponse)) {
            return false;
        }
        DescribePartnerAppResponse other = (DescribePartnerAppResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(executionRoleArn(), other.executionRoleArn()) && Objects.equals(baseUrl(), other.baseUrl())
                && Objects.equals(maintenanceConfig(), other.maintenanceConfig()) && Objects.equals(tier(), other.tier())
                && Objects.equals(version(), other.version()) && Objects.equals(applicationConfig(), other.applicationConfig())
                && Objects.equals(authTypeAsString(), other.authTypeAsString())
                && Objects.equals(enableIamSessionBasedIdentity(), other.enableIamSessionBasedIdentity())
                && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePartnerAppResponse").add("Arn", arn()).add("Name", name()).add("Type", typeAsString())
                .add("Status", statusAsString()).add("CreationTime", creationTime()).add("ExecutionRoleArn", executionRoleArn())
                .add("BaseUrl", baseUrl()).add("MaintenanceConfig", maintenanceConfig()).add("Tier", tier())
                .add("Version", version()).add("ApplicationConfig", applicationConfig()).add("AuthType", authTypeAsString())
                .add("EnableIamSessionBasedIdentity", enableIamSessionBasedIdentity()).add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "BaseUrl":
            return Optional.ofNullable(clazz.cast(baseUrl()));
        case "MaintenanceConfig":
            return Optional.ofNullable(clazz.cast(maintenanceConfig()));
        case "Tier":
            return Optional.ofNullable(clazz.cast(tier()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "ApplicationConfig":
            return Optional.ofNullable(clazz.cast(applicationConfig()));
        case "AuthType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        case "EnableIamSessionBasedIdentity":
            return Optional.ofNullable(clazz.cast(enableIamSessionBasedIdentity()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribePartnerAppResponse, T> g) {
        return obj -> g.apply((DescribePartnerAppResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribePartnerAppResponse> {
        /**
         * <p>
         * The ARN of the SageMaker Partner AI App that was described.
         * </p>
         * 
         * @param arn
         *        The ARN of the SageMaker Partner AI App that was described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the SageMaker Partner AI App.
         * </p>
         * 
         * @param name
         *        The name of the SageMaker Partner AI App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of SageMaker Partner AI App. Must be one of the following: <code>lakera-guard</code>,
         * <code>comet</code>, <code>deepchecks-llm-evaluation</code>, or <code>fiddler</code>.
         * </p>
         * 
         * @param type
         *        The type of SageMaker Partner AI App. Must be one of the following: <code>lakera-guard</code>,
         *        <code>comet</code>, <code>deepchecks-llm-evaluation</code>, or <code>fiddler</code>.
         * @see PartnerAppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartnerAppType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of SageMaker Partner AI App. Must be one of the following: <code>lakera-guard</code>,
         * <code>comet</code>, <code>deepchecks-llm-evaluation</code>, or <code>fiddler</code>.
         * </p>
         * 
         * @param type
         *        The type of SageMaker Partner AI App. Must be one of the following: <code>lakera-guard</code>,
         *        <code>comet</code>, <code>deepchecks-llm-evaluation</code>, or <code>fiddler</code>.
         * @see PartnerAppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartnerAppType
         */
        Builder type(PartnerAppType type);

        /**
         * <p>
         * The status of the SageMaker Partner AI App.
         * </p>
         * 
         * @param status
         *        The status of the SageMaker Partner AI App.
         * @see PartnerAppStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartnerAppStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the SageMaker Partner AI App.
         * </p>
         * 
         * @param status
         *        The status of the SageMaker Partner AI App.
         * @see PartnerAppStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartnerAppStatus
         */
        Builder status(PartnerAppStatus status);

        /**
         * <p>
         * The time that the SageMaker Partner AI App was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the SageMaker Partner AI App was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The ARN of the IAM role associated with the SageMaker Partner AI App.
         * </p>
         * 
         * @param executionRoleArn
         *        The ARN of the IAM role associated with the SageMaker Partner AI App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The URL of the SageMaker Partner AI App that the Application SDK uses to support in-app calls for the user.
         * </p>
         * 
         * @param baseUrl
         *        The URL of the SageMaker Partner AI App that the Application SDK uses to support in-app calls for the
         *        user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseUrl(String baseUrl);

        /**
         * <p>
         * Maintenance configuration settings for the SageMaker Partner AI App.
         * </p>
         * 
         * @param maintenanceConfig
         *        Maintenance configuration settings for the SageMaker Partner AI App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceConfig(PartnerAppMaintenanceConfig maintenanceConfig);

        /**
         * <p>
         * Maintenance configuration settings for the SageMaker Partner AI App.
         * </p>
         * This is a convenience method that creates an instance of the {@link PartnerAppMaintenanceConfig.Builder}
         * avoiding the need to create one manually via {@link PartnerAppMaintenanceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PartnerAppMaintenanceConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #maintenanceConfig(PartnerAppMaintenanceConfig)}.
         * 
         * @param maintenanceConfig
         *        a consumer that will call methods on {@link PartnerAppMaintenanceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceConfig(PartnerAppMaintenanceConfig)
         */
        default Builder maintenanceConfig(Consumer<PartnerAppMaintenanceConfig.Builder> maintenanceConfig) {
            return maintenanceConfig(PartnerAppMaintenanceConfig.builder().applyMutation(maintenanceConfig).build());
        }

        /**
         * <p>
         * The instance type and size of the cluster attached to the SageMaker Partner AI App.
         * </p>
         * 
         * @param tier
         *        The instance type and size of the cluster attached to the SageMaker Partner AI App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tier(String tier);

        /**
         * <p>
         * The version of the SageMaker Partner AI App.
         * </p>
         * 
         * @param version
         *        The version of the SageMaker Partner AI App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * Configuration settings for the SageMaker Partner AI App.
         * </p>
         * 
         * @param applicationConfig
         *        Configuration settings for the SageMaker Partner AI App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationConfig(PartnerAppConfig applicationConfig);

        /**
         * <p>
         * Configuration settings for the SageMaker Partner AI App.
         * </p>
         * This is a convenience method that creates an instance of the {@link PartnerAppConfig.Builder} avoiding the
         * need to create one manually via {@link PartnerAppConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PartnerAppConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #applicationConfig(PartnerAppConfig)}.
         * 
         * @param applicationConfig
         *        a consumer that will call methods on {@link PartnerAppConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationConfig(PartnerAppConfig)
         */
        default Builder applicationConfig(Consumer<PartnerAppConfig.Builder> applicationConfig) {
            return applicationConfig(PartnerAppConfig.builder().applyMutation(applicationConfig).build());
        }

        /**
         * <p>
         * The authorization type that users use to access the SageMaker Partner AI App.
         * </p>
         * 
         * @param authType
         *        The authorization type that users use to access the SageMaker Partner AI App.
         * @see PartnerAppAuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartnerAppAuthType
         */
        Builder authType(String authType);

        /**
         * <p>
         * The authorization type that users use to access the SageMaker Partner AI App.
         * </p>
         * 
         * @param authType
         *        The authorization type that users use to access the SageMaker Partner AI App.
         * @see PartnerAppAuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartnerAppAuthType
         */
        Builder authType(PartnerAppAuthType authType);

        /**
         * <p>
         * When set to <code>TRUE</code>, the SageMaker Partner AI App sets the Amazon Web Services IAM session name or
         * the authenticated IAM user as the identity of the SageMaker Partner AI App user.
         * </p>
         * 
         * @param enableIamSessionBasedIdentity
         *        When set to <code>TRUE</code>, the SageMaker Partner AI App sets the Amazon Web Services IAM session
         *        name or the authenticated IAM user as the identity of the SageMaker Partner AI App user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableIamSessionBasedIdentity(Boolean enableIamSessionBasedIdentity);

        /**
         * <p>
         * This is an error field object that contains the error code and the reason for an operation failure.
         * </p>
         * 
         * @param error
         *        This is an error field object that contains the error code and the reason for an operation failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorInfo error);

        /**
         * <p>
         * This is an error field object that contains the error code and the reason for an operation failure.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorInfo.Builder} avoiding the need to
         * create one manually via {@link ErrorInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorInfo)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorInfo)
         */
        default Builder error(Consumer<ErrorInfo.Builder> error) {
            return error(ErrorInfo.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String type;

        private String status;

        private Instant creationTime;

        private String executionRoleArn;

        private String baseUrl;

        private PartnerAppMaintenanceConfig maintenanceConfig;

        private String tier;

        private String version;

        private PartnerAppConfig applicationConfig;

        private String authType;

        private Boolean enableIamSessionBasedIdentity;

        private ErrorInfo error;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePartnerAppResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            type(model.type);
            status(model.status);
            creationTime(model.creationTime);
            executionRoleArn(model.executionRoleArn);
            baseUrl(model.baseUrl);
            maintenanceConfig(model.maintenanceConfig);
            tier(model.tier);
            version(model.version);
            applicationConfig(model.applicationConfig);
            authType(model.authType);
            enableIamSessionBasedIdentity(model.enableIamSessionBasedIdentity);
            error(model.error);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PartnerAppType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PartnerAppStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getBaseUrl() {
            return baseUrl;
        }

        public final void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        @Override
        public final Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public final PartnerAppMaintenanceConfig.Builder getMaintenanceConfig() {
            return maintenanceConfig != null ? maintenanceConfig.toBuilder() : null;
        }

        public final void setMaintenanceConfig(PartnerAppMaintenanceConfig.BuilderImpl maintenanceConfig) {
            this.maintenanceConfig = maintenanceConfig != null ? maintenanceConfig.build() : null;
        }

        @Override
        public final Builder maintenanceConfig(PartnerAppMaintenanceConfig maintenanceConfig) {
            this.maintenanceConfig = maintenanceConfig;
            return this;
        }

        public final String getTier() {
            return tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final PartnerAppConfig.Builder getApplicationConfig() {
            return applicationConfig != null ? applicationConfig.toBuilder() : null;
        }

        public final void setApplicationConfig(PartnerAppConfig.BuilderImpl applicationConfig) {
            this.applicationConfig = applicationConfig != null ? applicationConfig.build() : null;
        }

        @Override
        public final Builder applicationConfig(PartnerAppConfig applicationConfig) {
            this.applicationConfig = applicationConfig;
            return this;
        }

        public final String getAuthType() {
            return authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(PartnerAppAuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final Boolean getEnableIamSessionBasedIdentity() {
            return enableIamSessionBasedIdentity;
        }

        public final void setEnableIamSessionBasedIdentity(Boolean enableIamSessionBasedIdentity) {
            this.enableIamSessionBasedIdentity = enableIamSessionBasedIdentity;
        }

        @Override
        public final Builder enableIamSessionBasedIdentity(Boolean enableIamSessionBasedIdentity) {
            this.enableIamSessionBasedIdentity = enableIamSessionBasedIdentity;
            return this;
        }

        public final ErrorInfo.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorInfo.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorInfo error) {
            this.error = error;
            return this;
        }

        @Override
        public DescribePartnerAppResponse build() {
            return new DescribePartnerAppResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
