/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the drift check bias baselines that can be used when the model monitor is set using the model package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DriftCheckBias implements SdkPojo, Serializable, ToCopyableBuilder<DriftCheckBias.Builder, DriftCheckBias> {
    private static final SdkField<FileSource> CONFIG_FILE_FIELD = SdkField.<FileSource> builder(MarshallingType.SDK_POJO)
            .memberName("ConfigFile").getter(getter(DriftCheckBias::configFile)).setter(setter(Builder::configFile))
            .constructor(FileSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigFile").build()).build();

    private static final SdkField<MetricsSource> PRE_TRAINING_CONSTRAINTS_FIELD = SdkField
            .<MetricsSource> builder(MarshallingType.SDK_POJO).memberName("PreTrainingConstraints")
            .getter(getter(DriftCheckBias::preTrainingConstraints)).setter(setter(Builder::preTrainingConstraints))
            .constructor(MetricsSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreTrainingConstraints").build())
            .build();

    private static final SdkField<MetricsSource> POST_TRAINING_CONSTRAINTS_FIELD = SdkField
            .<MetricsSource> builder(MarshallingType.SDK_POJO).memberName("PostTrainingConstraints")
            .getter(getter(DriftCheckBias::postTrainingConstraints)).setter(setter(Builder::postTrainingConstraints))
            .constructor(MetricsSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostTrainingConstraints").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_FILE_FIELD,
            PRE_TRAINING_CONSTRAINTS_FIELD, POST_TRAINING_CONSTRAINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ConfigFile", CONFIG_FILE_FIELD);
                    put("PreTrainingConstraints", PRE_TRAINING_CONSTRAINTS_FIELD);
                    put("PostTrainingConstraints", POST_TRAINING_CONSTRAINTS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final FileSource configFile;

    private final MetricsSource preTrainingConstraints;

    private final MetricsSource postTrainingConstraints;

    private DriftCheckBias(BuilderImpl builder) {
        this.configFile = builder.configFile;
        this.preTrainingConstraints = builder.preTrainingConstraints;
        this.postTrainingConstraints = builder.postTrainingConstraints;
    }

    /**
     * <p>
     * The bias config file for a model.
     * </p>
     * 
     * @return The bias config file for a model.
     */
    public final FileSource configFile() {
        return configFile;
    }

    /**
     * <p>
     * The pre-training constraints.
     * </p>
     * 
     * @return The pre-training constraints.
     */
    public final MetricsSource preTrainingConstraints() {
        return preTrainingConstraints;
    }

    /**
     * <p>
     * The post-training constraints.
     * </p>
     * 
     * @return The post-training constraints.
     */
    public final MetricsSource postTrainingConstraints() {
        return postTrainingConstraints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configFile());
        hashCode = 31 * hashCode + Objects.hashCode(preTrainingConstraints());
        hashCode = 31 * hashCode + Objects.hashCode(postTrainingConstraints());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DriftCheckBias)) {
            return false;
        }
        DriftCheckBias other = (DriftCheckBias) obj;
        return Objects.equals(configFile(), other.configFile())
                && Objects.equals(preTrainingConstraints(), other.preTrainingConstraints())
                && Objects.equals(postTrainingConstraints(), other.postTrainingConstraints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DriftCheckBias").add("ConfigFile", configFile())
                .add("PreTrainingConstraints", preTrainingConstraints())
                .add("PostTrainingConstraints", postTrainingConstraints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigFile":
            return Optional.ofNullable(clazz.cast(configFile()));
        case "PreTrainingConstraints":
            return Optional.ofNullable(clazz.cast(preTrainingConstraints()));
        case "PostTrainingConstraints":
            return Optional.ofNullable(clazz.cast(postTrainingConstraints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DriftCheckBias, T> g) {
        return obj -> g.apply((DriftCheckBias) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DriftCheckBias> {
        /**
         * <p>
         * The bias config file for a model.
         * </p>
         * 
         * @param configFile
         *        The bias config file for a model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configFile(FileSource configFile);

        /**
         * <p>
         * The bias config file for a model.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileSource.Builder} avoiding the need to
         * create one manually via {@link FileSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileSource.Builder#build()} is called immediately and its result
         * is passed to {@link #configFile(FileSource)}.
         * 
         * @param configFile
         *        a consumer that will call methods on {@link FileSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configFile(FileSource)
         */
        default Builder configFile(Consumer<FileSource.Builder> configFile) {
            return configFile(FileSource.builder().applyMutation(configFile).build());
        }

        /**
         * <p>
         * The pre-training constraints.
         * </p>
         * 
         * @param preTrainingConstraints
         *        The pre-training constraints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preTrainingConstraints(MetricsSource preTrainingConstraints);

        /**
         * <p>
         * The pre-training constraints.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricsSource.Builder} avoiding the need
         * to create one manually via {@link MetricsSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricsSource.Builder#build()} is called immediately and its
         * result is passed to {@link #preTrainingConstraints(MetricsSource)}.
         * 
         * @param preTrainingConstraints
         *        a consumer that will call methods on {@link MetricsSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preTrainingConstraints(MetricsSource)
         */
        default Builder preTrainingConstraints(Consumer<MetricsSource.Builder> preTrainingConstraints) {
            return preTrainingConstraints(MetricsSource.builder().applyMutation(preTrainingConstraints).build());
        }

        /**
         * <p>
         * The post-training constraints.
         * </p>
         * 
         * @param postTrainingConstraints
         *        The post-training constraints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postTrainingConstraints(MetricsSource postTrainingConstraints);

        /**
         * <p>
         * The post-training constraints.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricsSource.Builder} avoiding the need
         * to create one manually via {@link MetricsSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricsSource.Builder#build()} is called immediately and its
         * result is passed to {@link #postTrainingConstraints(MetricsSource)}.
         * 
         * @param postTrainingConstraints
         *        a consumer that will call methods on {@link MetricsSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postTrainingConstraints(MetricsSource)
         */
        default Builder postTrainingConstraints(Consumer<MetricsSource.Builder> postTrainingConstraints) {
            return postTrainingConstraints(MetricsSource.builder().applyMutation(postTrainingConstraints).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FileSource configFile;

        private MetricsSource preTrainingConstraints;

        private MetricsSource postTrainingConstraints;

        private BuilderImpl() {
        }

        private BuilderImpl(DriftCheckBias model) {
            configFile(model.configFile);
            preTrainingConstraints(model.preTrainingConstraints);
            postTrainingConstraints(model.postTrainingConstraints);
        }

        public final FileSource.Builder getConfigFile() {
            return configFile != null ? configFile.toBuilder() : null;
        }

        public final void setConfigFile(FileSource.BuilderImpl configFile) {
            this.configFile = configFile != null ? configFile.build() : null;
        }

        @Override
        public final Builder configFile(FileSource configFile) {
            this.configFile = configFile;
            return this;
        }

        public final MetricsSource.Builder getPreTrainingConstraints() {
            return preTrainingConstraints != null ? preTrainingConstraints.toBuilder() : null;
        }

        public final void setPreTrainingConstraints(MetricsSource.BuilderImpl preTrainingConstraints) {
            this.preTrainingConstraints = preTrainingConstraints != null ? preTrainingConstraints.build() : null;
        }

        @Override
        public final Builder preTrainingConstraints(MetricsSource preTrainingConstraints) {
            this.preTrainingConstraints = preTrainingConstraints;
            return this;
        }

        public final MetricsSource.Builder getPostTrainingConstraints() {
            return postTrainingConstraints != null ? postTrainingConstraints.toBuilder() : null;
        }

        public final void setPostTrainingConstraints(MetricsSource.BuilderImpl postTrainingConstraints) {
            this.postTrainingConstraints = postTrainingConstraints != null ? postTrainingConstraints.build() : null;
        }

        @Override
        public final Builder postTrainingConstraints(MetricsSource postTrainingConstraints) {
            this.postTrainingConstraints = postTrainingConstraints;
            return this;
        }

        @Override
        public DriftCheckBias build() {
            return new DriftCheckBias(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
