/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the configuration of a deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EdgeDeploymentConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EdgeDeploymentConfig.Builder, EdgeDeploymentConfig> {
    private static final SdkField<String> FAILURE_HANDLING_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureHandlingPolicy").getter(getter(EdgeDeploymentConfig::failureHandlingPolicyAsString))
            .setter(setter(Builder::failureHandlingPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureHandlingPolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(FAILURE_HANDLING_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("FailureHandlingPolicy", FAILURE_HANDLING_POLICY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String failureHandlingPolicy;

    private EdgeDeploymentConfig(BuilderImpl builder) {
        this.failureHandlingPolicy = builder.failureHandlingPolicy;
    }

    /**
     * <p>
     * Toggle that determines whether to rollback to previous configuration if the current deployment fails. By default
     * this is turned on. You may turn this off if you want to investigate the errors yourself.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #failureHandlingPolicy} will return {@link FailureHandlingPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #failureHandlingPolicyAsString}.
     * </p>
     * 
     * @return Toggle that determines whether to rollback to previous configuration if the current deployment fails. By
     *         default this is turned on. You may turn this off if you want to investigate the errors yourself.
     * @see FailureHandlingPolicy
     */
    public final FailureHandlingPolicy failureHandlingPolicy() {
        return FailureHandlingPolicy.fromValue(failureHandlingPolicy);
    }

    /**
     * <p>
     * Toggle that determines whether to rollback to previous configuration if the current deployment fails. By default
     * this is turned on. You may turn this off if you want to investigate the errors yourself.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #failureHandlingPolicy} will return {@link FailureHandlingPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #failureHandlingPolicyAsString}.
     * </p>
     * 
     * @return Toggle that determines whether to rollback to previous configuration if the current deployment fails. By
     *         default this is turned on. You may turn this off if you want to investigate the errors yourself.
     * @see FailureHandlingPolicy
     */
    public final String failureHandlingPolicyAsString() {
        return failureHandlingPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failureHandlingPolicyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeDeploymentConfig)) {
            return false;
        }
        EdgeDeploymentConfig other = (EdgeDeploymentConfig) obj;
        return Objects.equals(failureHandlingPolicyAsString(), other.failureHandlingPolicyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EdgeDeploymentConfig").add("FailureHandlingPolicy", failureHandlingPolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailureHandlingPolicy":
            return Optional.ofNullable(clazz.cast(failureHandlingPolicyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EdgeDeploymentConfig, T> g) {
        return obj -> g.apply((EdgeDeploymentConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EdgeDeploymentConfig> {
        /**
         * <p>
         * Toggle that determines whether to rollback to previous configuration if the current deployment fails. By
         * default this is turned on. You may turn this off if you want to investigate the errors yourself.
         * </p>
         * 
         * @param failureHandlingPolicy
         *        Toggle that determines whether to rollback to previous configuration if the current deployment fails.
         *        By default this is turned on. You may turn this off if you want to investigate the errors yourself.
         * @see FailureHandlingPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailureHandlingPolicy
         */
        Builder failureHandlingPolicy(String failureHandlingPolicy);

        /**
         * <p>
         * Toggle that determines whether to rollback to previous configuration if the current deployment fails. By
         * default this is turned on. You may turn this off if you want to investigate the errors yourself.
         * </p>
         * 
         * @param failureHandlingPolicy
         *        Toggle that determines whether to rollback to previous configuration if the current deployment fails.
         *        By default this is turned on. You may turn this off if you want to investigate the errors yourself.
         * @see FailureHandlingPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailureHandlingPolicy
         */
        Builder failureHandlingPolicy(FailureHandlingPolicy failureHandlingPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String failureHandlingPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeDeploymentConfig model) {
            failureHandlingPolicy(model.failureHandlingPolicy);
        }

        public final String getFailureHandlingPolicy() {
            return failureHandlingPolicy;
        }

        public final void setFailureHandlingPolicy(String failureHandlingPolicy) {
            this.failureHandlingPolicy = failureHandlingPolicy;
        }

        @Override
        public final Builder failureHandlingPolicy(String failureHandlingPolicy) {
            this.failureHandlingPolicy = failureHandlingPolicy;
            return this;
        }

        @Override
        public final Builder failureHandlingPolicy(FailureHandlingPolicy failureHandlingPolicy) {
            this.failureHandlingPolicy(failureHandlingPolicy == null ? null : failureHandlingPolicy.toString());
            return this;
        }

        @Override
        public EdgeDeploymentConfig build() {
            return new EdgeDeploymentConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
