/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information summarizing the deployment stage results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EdgeDeploymentStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<EdgeDeploymentStatus.Builder, EdgeDeploymentStatus> {
    private static final SdkField<String> STAGE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StageStatus").getter(getter(EdgeDeploymentStatus::stageStatusAsString))
            .setter(setter(Builder::stageStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageStatus").build()).build();

    private static final SdkField<Integer> EDGE_DEPLOYMENT_SUCCESS_IN_STAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("EdgeDeploymentSuccessInStage")
            .getter(getter(EdgeDeploymentStatus::edgeDeploymentSuccessInStage))
            .setter(setter(Builder::edgeDeploymentSuccessInStage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentSuccessInStage")
                    .build()).build();

    private static final SdkField<Integer> EDGE_DEPLOYMENT_PENDING_IN_STAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("EdgeDeploymentPendingInStage")
            .getter(getter(EdgeDeploymentStatus::edgeDeploymentPendingInStage))
            .setter(setter(Builder::edgeDeploymentPendingInStage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentPendingInStage")
                    .build()).build();

    private static final SdkField<Integer> EDGE_DEPLOYMENT_FAILED_IN_STAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("EdgeDeploymentFailedInStage")
            .getter(getter(EdgeDeploymentStatus::edgeDeploymentFailedInStage))
            .setter(setter(Builder::edgeDeploymentFailedInStage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentFailedInStage")
                    .build()).build();

    private static final SdkField<String> EDGE_DEPLOYMENT_STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EdgeDeploymentStatusMessage")
            .getter(getter(EdgeDeploymentStatus::edgeDeploymentStatusMessage))
            .setter(setter(Builder::edgeDeploymentStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentStatusMessage")
                    .build()).build();

    private static final SdkField<Instant> EDGE_DEPLOYMENT_STAGE_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EdgeDeploymentStageStartTime")
            .getter(getter(EdgeDeploymentStatus::edgeDeploymentStageStartTime))
            .setter(setter(Builder::edgeDeploymentStageStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentStageStartTime")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_STATUS_FIELD,
            EDGE_DEPLOYMENT_SUCCESS_IN_STAGE_FIELD, EDGE_DEPLOYMENT_PENDING_IN_STAGE_FIELD,
            EDGE_DEPLOYMENT_FAILED_IN_STAGE_FIELD, EDGE_DEPLOYMENT_STATUS_MESSAGE_FIELD, EDGE_DEPLOYMENT_STAGE_START_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("StageStatus", STAGE_STATUS_FIELD);
                    put("EdgeDeploymentSuccessInStage", EDGE_DEPLOYMENT_SUCCESS_IN_STAGE_FIELD);
                    put("EdgeDeploymentPendingInStage", EDGE_DEPLOYMENT_PENDING_IN_STAGE_FIELD);
                    put("EdgeDeploymentFailedInStage", EDGE_DEPLOYMENT_FAILED_IN_STAGE_FIELD);
                    put("EdgeDeploymentStatusMessage", EDGE_DEPLOYMENT_STATUS_MESSAGE_FIELD);
                    put("EdgeDeploymentStageStartTime", EDGE_DEPLOYMENT_STAGE_START_TIME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String stageStatus;

    private final Integer edgeDeploymentSuccessInStage;

    private final Integer edgeDeploymentPendingInStage;

    private final Integer edgeDeploymentFailedInStage;

    private final String edgeDeploymentStatusMessage;

    private final Instant edgeDeploymentStageStartTime;

    private EdgeDeploymentStatus(BuilderImpl builder) {
        this.stageStatus = builder.stageStatus;
        this.edgeDeploymentSuccessInStage = builder.edgeDeploymentSuccessInStage;
        this.edgeDeploymentPendingInStage = builder.edgeDeploymentPendingInStage;
        this.edgeDeploymentFailedInStage = builder.edgeDeploymentFailedInStage;
        this.edgeDeploymentStatusMessage = builder.edgeDeploymentStatusMessage;
        this.edgeDeploymentStageStartTime = builder.edgeDeploymentStageStartTime;
    }

    /**
     * <p>
     * The general status of the current stage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stageStatus} will
     * return {@link StageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageStatusAsString}.
     * </p>
     * 
     * @return The general status of the current stage.
     * @see StageStatus
     */
    public final StageStatus stageStatus() {
        return StageStatus.fromValue(stageStatus);
    }

    /**
     * <p>
     * The general status of the current stage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stageStatus} will
     * return {@link StageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageStatusAsString}.
     * </p>
     * 
     * @return The general status of the current stage.
     * @see StageStatus
     */
    public final String stageStatusAsString() {
        return stageStatus;
    }

    /**
     * <p>
     * The number of edge devices with the successful deployment in the current stage.
     * </p>
     * 
     * @return The number of edge devices with the successful deployment in the current stage.
     */
    public final Integer edgeDeploymentSuccessInStage() {
        return edgeDeploymentSuccessInStage;
    }

    /**
     * <p>
     * The number of edge devices yet to pick up the deployment in current stage, or in progress.
     * </p>
     * 
     * @return The number of edge devices yet to pick up the deployment in current stage, or in progress.
     */
    public final Integer edgeDeploymentPendingInStage() {
        return edgeDeploymentPendingInStage;
    }

    /**
     * <p>
     * The number of edge devices that failed the deployment in current stage.
     * </p>
     * 
     * @return The number of edge devices that failed the deployment in current stage.
     */
    public final Integer edgeDeploymentFailedInStage() {
        return edgeDeploymentFailedInStage;
    }

    /**
     * <p>
     * A detailed message about deployment status in current stage.
     * </p>
     * 
     * @return A detailed message about deployment status in current stage.
     */
    public final String edgeDeploymentStatusMessage() {
        return edgeDeploymentStatusMessage;
    }

    /**
     * <p>
     * The time when the deployment API started.
     * </p>
     * 
     * @return The time when the deployment API started.
     */
    public final Instant edgeDeploymentStageStartTime() {
        return edgeDeploymentStageStartTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stageStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(edgeDeploymentSuccessInStage());
        hashCode = 31 * hashCode + Objects.hashCode(edgeDeploymentPendingInStage());
        hashCode = 31 * hashCode + Objects.hashCode(edgeDeploymentFailedInStage());
        hashCode = 31 * hashCode + Objects.hashCode(edgeDeploymentStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(edgeDeploymentStageStartTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeDeploymentStatus)) {
            return false;
        }
        EdgeDeploymentStatus other = (EdgeDeploymentStatus) obj;
        return Objects.equals(stageStatusAsString(), other.stageStatusAsString())
                && Objects.equals(edgeDeploymentSuccessInStage(), other.edgeDeploymentSuccessInStage())
                && Objects.equals(edgeDeploymentPendingInStage(), other.edgeDeploymentPendingInStage())
                && Objects.equals(edgeDeploymentFailedInStage(), other.edgeDeploymentFailedInStage())
                && Objects.equals(edgeDeploymentStatusMessage(), other.edgeDeploymentStatusMessage())
                && Objects.equals(edgeDeploymentStageStartTime(), other.edgeDeploymentStageStartTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EdgeDeploymentStatus").add("StageStatus", stageStatusAsString())
                .add("EdgeDeploymentSuccessInStage", edgeDeploymentSuccessInStage())
                .add("EdgeDeploymentPendingInStage", edgeDeploymentPendingInStage())
                .add("EdgeDeploymentFailedInStage", edgeDeploymentFailedInStage())
                .add("EdgeDeploymentStatusMessage", edgeDeploymentStatusMessage())
                .add("EdgeDeploymentStageStartTime", edgeDeploymentStageStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StageStatus":
            return Optional.ofNullable(clazz.cast(stageStatusAsString()));
        case "EdgeDeploymentSuccessInStage":
            return Optional.ofNullable(clazz.cast(edgeDeploymentSuccessInStage()));
        case "EdgeDeploymentPendingInStage":
            return Optional.ofNullable(clazz.cast(edgeDeploymentPendingInStage()));
        case "EdgeDeploymentFailedInStage":
            return Optional.ofNullable(clazz.cast(edgeDeploymentFailedInStage()));
        case "EdgeDeploymentStatusMessage":
            return Optional.ofNullable(clazz.cast(edgeDeploymentStatusMessage()));
        case "EdgeDeploymentStageStartTime":
            return Optional.ofNullable(clazz.cast(edgeDeploymentStageStartTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EdgeDeploymentStatus, T> g) {
        return obj -> g.apply((EdgeDeploymentStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EdgeDeploymentStatus> {
        /**
         * <p>
         * The general status of the current stage.
         * </p>
         * 
         * @param stageStatus
         *        The general status of the current stage.
         * @see StageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StageStatus
         */
        Builder stageStatus(String stageStatus);

        /**
         * <p>
         * The general status of the current stage.
         * </p>
         * 
         * @param stageStatus
         *        The general status of the current stage.
         * @see StageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StageStatus
         */
        Builder stageStatus(StageStatus stageStatus);

        /**
         * <p>
         * The number of edge devices with the successful deployment in the current stage.
         * </p>
         * 
         * @param edgeDeploymentSuccessInStage
         *        The number of edge devices with the successful deployment in the current stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeDeploymentSuccessInStage(Integer edgeDeploymentSuccessInStage);

        /**
         * <p>
         * The number of edge devices yet to pick up the deployment in current stage, or in progress.
         * </p>
         * 
         * @param edgeDeploymentPendingInStage
         *        The number of edge devices yet to pick up the deployment in current stage, or in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeDeploymentPendingInStage(Integer edgeDeploymentPendingInStage);

        /**
         * <p>
         * The number of edge devices that failed the deployment in current stage.
         * </p>
         * 
         * @param edgeDeploymentFailedInStage
         *        The number of edge devices that failed the deployment in current stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeDeploymentFailedInStage(Integer edgeDeploymentFailedInStage);

        /**
         * <p>
         * A detailed message about deployment status in current stage.
         * </p>
         * 
         * @param edgeDeploymentStatusMessage
         *        A detailed message about deployment status in current stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeDeploymentStatusMessage(String edgeDeploymentStatusMessage);

        /**
         * <p>
         * The time when the deployment API started.
         * </p>
         * 
         * @param edgeDeploymentStageStartTime
         *        The time when the deployment API started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeDeploymentStageStartTime(Instant edgeDeploymentStageStartTime);
    }

    static final class BuilderImpl implements Builder {
        private String stageStatus;

        private Integer edgeDeploymentSuccessInStage;

        private Integer edgeDeploymentPendingInStage;

        private Integer edgeDeploymentFailedInStage;

        private String edgeDeploymentStatusMessage;

        private Instant edgeDeploymentStageStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeDeploymentStatus model) {
            stageStatus(model.stageStatus);
            edgeDeploymentSuccessInStage(model.edgeDeploymentSuccessInStage);
            edgeDeploymentPendingInStage(model.edgeDeploymentPendingInStage);
            edgeDeploymentFailedInStage(model.edgeDeploymentFailedInStage);
            edgeDeploymentStatusMessage(model.edgeDeploymentStatusMessage);
            edgeDeploymentStageStartTime(model.edgeDeploymentStageStartTime);
        }

        public final String getStageStatus() {
            return stageStatus;
        }

        public final void setStageStatus(String stageStatus) {
            this.stageStatus = stageStatus;
        }

        @Override
        public final Builder stageStatus(String stageStatus) {
            this.stageStatus = stageStatus;
            return this;
        }

        @Override
        public final Builder stageStatus(StageStatus stageStatus) {
            this.stageStatus(stageStatus == null ? null : stageStatus.toString());
            return this;
        }

        public final Integer getEdgeDeploymentSuccessInStage() {
            return edgeDeploymentSuccessInStage;
        }

        public final void setEdgeDeploymentSuccessInStage(Integer edgeDeploymentSuccessInStage) {
            this.edgeDeploymentSuccessInStage = edgeDeploymentSuccessInStage;
        }

        @Override
        public final Builder edgeDeploymentSuccessInStage(Integer edgeDeploymentSuccessInStage) {
            this.edgeDeploymentSuccessInStage = edgeDeploymentSuccessInStage;
            return this;
        }

        public final Integer getEdgeDeploymentPendingInStage() {
            return edgeDeploymentPendingInStage;
        }

        public final void setEdgeDeploymentPendingInStage(Integer edgeDeploymentPendingInStage) {
            this.edgeDeploymentPendingInStage = edgeDeploymentPendingInStage;
        }

        @Override
        public final Builder edgeDeploymentPendingInStage(Integer edgeDeploymentPendingInStage) {
            this.edgeDeploymentPendingInStage = edgeDeploymentPendingInStage;
            return this;
        }

        public final Integer getEdgeDeploymentFailedInStage() {
            return edgeDeploymentFailedInStage;
        }

        public final void setEdgeDeploymentFailedInStage(Integer edgeDeploymentFailedInStage) {
            this.edgeDeploymentFailedInStage = edgeDeploymentFailedInStage;
        }

        @Override
        public final Builder edgeDeploymentFailedInStage(Integer edgeDeploymentFailedInStage) {
            this.edgeDeploymentFailedInStage = edgeDeploymentFailedInStage;
            return this;
        }

        public final String getEdgeDeploymentStatusMessage() {
            return edgeDeploymentStatusMessage;
        }

        public final void setEdgeDeploymentStatusMessage(String edgeDeploymentStatusMessage) {
            this.edgeDeploymentStatusMessage = edgeDeploymentStatusMessage;
        }

        @Override
        public final Builder edgeDeploymentStatusMessage(String edgeDeploymentStatusMessage) {
            this.edgeDeploymentStatusMessage = edgeDeploymentStatusMessage;
            return this;
        }

        public final Instant getEdgeDeploymentStageStartTime() {
            return edgeDeploymentStageStartTime;
        }

        public final void setEdgeDeploymentStageStartTime(Instant edgeDeploymentStageStartTime) {
            this.edgeDeploymentStageStartTime = edgeDeploymentStageStartTime;
        }

        @Override
        public final Builder edgeDeploymentStageStartTime(Instant edgeDeploymentStageStartTime) {
            this.edgeDeploymentStageStartTime = edgeDeploymentStageStartTime;
            return this;
        }

        @Override
        public EdgeDeploymentStatus build() {
            return new EdgeDeploymentStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
