/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Status of edge devices with this model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EdgeModelStat implements SdkPojo, Serializable, ToCopyableBuilder<EdgeModelStat.Builder, EdgeModelStat> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(EdgeModelStat::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelVersion").getter(getter(EdgeModelStat::modelVersion)).setter(setter(Builder::modelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()).build();

    private static final SdkField<Long> OFFLINE_DEVICE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("OfflineDeviceCount").getter(getter(EdgeModelStat::offlineDeviceCount))
            .setter(setter(Builder::offlineDeviceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfflineDeviceCount").build())
            .build();

    private static final SdkField<Long> CONNECTED_DEVICE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ConnectedDeviceCount").getter(getter(EdgeModelStat::connectedDeviceCount))
            .setter(setter(Builder::connectedDeviceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedDeviceCount").build())
            .build();

    private static final SdkField<Long> ACTIVE_DEVICE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ActiveDeviceCount").getter(getter(EdgeModelStat::activeDeviceCount))
            .setter(setter(Builder::activeDeviceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDeviceCount").build()).build();

    private static final SdkField<Long> SAMPLING_DEVICE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SamplingDeviceCount").getter(getter(EdgeModelStat::samplingDeviceCount))
            .setter(setter(Builder::samplingDeviceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingDeviceCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            MODEL_VERSION_FIELD, OFFLINE_DEVICE_COUNT_FIELD, CONNECTED_DEVICE_COUNT_FIELD, ACTIVE_DEVICE_COUNT_FIELD,
            SAMPLING_DEVICE_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ModelName", MODEL_NAME_FIELD);
                    put("ModelVersion", MODEL_VERSION_FIELD);
                    put("OfflineDeviceCount", OFFLINE_DEVICE_COUNT_FIELD);
                    put("ConnectedDeviceCount", CONNECTED_DEVICE_COUNT_FIELD);
                    put("ActiveDeviceCount", ACTIVE_DEVICE_COUNT_FIELD);
                    put("SamplingDeviceCount", SAMPLING_DEVICE_COUNT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String modelName;

    private final String modelVersion;

    private final Long offlineDeviceCount;

    private final Long connectedDeviceCount;

    private final Long activeDeviceCount;

    private final Long samplingDeviceCount;

    private EdgeModelStat(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.modelVersion = builder.modelVersion;
        this.offlineDeviceCount = builder.offlineDeviceCount;
        this.connectedDeviceCount = builder.connectedDeviceCount;
        this.activeDeviceCount = builder.activeDeviceCount;
        this.samplingDeviceCount = builder.samplingDeviceCount;
    }

    /**
     * <p>
     * The name of the model.
     * </p>
     * 
     * @return The name of the model.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The model version.
     * </p>
     * 
     * @return The model version.
     */
    public final String modelVersion() {
        return modelVersion;
    }

    /**
     * <p>
     * The number of devices that have this model version and do not have a heart beat.
     * </p>
     * 
     * @return The number of devices that have this model version and do not have a heart beat.
     */
    public final Long offlineDeviceCount() {
        return offlineDeviceCount;
    }

    /**
     * <p>
     * The number of devices that have this model version and have a heart beat.
     * </p>
     * 
     * @return The number of devices that have this model version and have a heart beat.
     */
    public final Long connectedDeviceCount() {
        return connectedDeviceCount;
    }

    /**
     * <p>
     * The number of devices that have this model version, a heart beat, and are currently running.
     * </p>
     * 
     * @return The number of devices that have this model version, a heart beat, and are currently running.
     */
    public final Long activeDeviceCount() {
        return activeDeviceCount;
    }

    /**
     * <p>
     * The number of devices with this model version and are producing sample data.
     * </p>
     * 
     * @return The number of devices with this model version and are producing sample data.
     */
    public final Long samplingDeviceCount() {
        return samplingDeviceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(offlineDeviceCount());
        hashCode = 31 * hashCode + Objects.hashCode(connectedDeviceCount());
        hashCode = 31 * hashCode + Objects.hashCode(activeDeviceCount());
        hashCode = 31 * hashCode + Objects.hashCode(samplingDeviceCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeModelStat)) {
            return false;
        }
        EdgeModelStat other = (EdgeModelStat) obj;
        return Objects.equals(modelName(), other.modelName()) && Objects.equals(modelVersion(), other.modelVersion())
                && Objects.equals(offlineDeviceCount(), other.offlineDeviceCount())
                && Objects.equals(connectedDeviceCount(), other.connectedDeviceCount())
                && Objects.equals(activeDeviceCount(), other.activeDeviceCount())
                && Objects.equals(samplingDeviceCount(), other.samplingDeviceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EdgeModelStat").add("ModelName", modelName()).add("ModelVersion", modelVersion())
                .add("OfflineDeviceCount", offlineDeviceCount()).add("ConnectedDeviceCount", connectedDeviceCount())
                .add("ActiveDeviceCount", activeDeviceCount()).add("SamplingDeviceCount", samplingDeviceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "ModelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        case "OfflineDeviceCount":
            return Optional.ofNullable(clazz.cast(offlineDeviceCount()));
        case "ConnectedDeviceCount":
            return Optional.ofNullable(clazz.cast(connectedDeviceCount()));
        case "ActiveDeviceCount":
            return Optional.ofNullable(clazz.cast(activeDeviceCount()));
        case "SamplingDeviceCount":
            return Optional.ofNullable(clazz.cast(samplingDeviceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EdgeModelStat, T> g) {
        return obj -> g.apply((EdgeModelStat) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EdgeModelStat> {
        /**
         * <p>
         * The name of the model.
         * </p>
         * 
         * @param modelName
         *        The name of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The model version.
         * </p>
         * 
         * @param modelVersion
         *        The model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(String modelVersion);

        /**
         * <p>
         * The number of devices that have this model version and do not have a heart beat.
         * </p>
         * 
         * @param offlineDeviceCount
         *        The number of devices that have this model version and do not have a heart beat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offlineDeviceCount(Long offlineDeviceCount);

        /**
         * <p>
         * The number of devices that have this model version and have a heart beat.
         * </p>
         * 
         * @param connectedDeviceCount
         *        The number of devices that have this model version and have a heart beat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectedDeviceCount(Long connectedDeviceCount);

        /**
         * <p>
         * The number of devices that have this model version, a heart beat, and are currently running.
         * </p>
         * 
         * @param activeDeviceCount
         *        The number of devices that have this model version, a heart beat, and are currently running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeDeviceCount(Long activeDeviceCount);

        /**
         * <p>
         * The number of devices with this model version and are producing sample data.
         * </p>
         * 
         * @param samplingDeviceCount
         *        The number of devices with this model version and are producing sample data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplingDeviceCount(Long samplingDeviceCount);
    }

    static final class BuilderImpl implements Builder {
        private String modelName;

        private String modelVersion;

        private Long offlineDeviceCount;

        private Long connectedDeviceCount;

        private Long activeDeviceCount;

        private Long samplingDeviceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeModelStat model) {
            modelName(model.modelName);
            modelVersion(model.modelVersion);
            offlineDeviceCount(model.offlineDeviceCount);
            connectedDeviceCount(model.connectedDeviceCount);
            activeDeviceCount(model.activeDeviceCount);
            samplingDeviceCount(model.samplingDeviceCount);
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelVersion() {
            return modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final Long getOfflineDeviceCount() {
            return offlineDeviceCount;
        }

        public final void setOfflineDeviceCount(Long offlineDeviceCount) {
            this.offlineDeviceCount = offlineDeviceCount;
        }

        @Override
        public final Builder offlineDeviceCount(Long offlineDeviceCount) {
            this.offlineDeviceCount = offlineDeviceCount;
            return this;
        }

        public final Long getConnectedDeviceCount() {
            return connectedDeviceCount;
        }

        public final void setConnectedDeviceCount(Long connectedDeviceCount) {
            this.connectedDeviceCount = connectedDeviceCount;
        }

        @Override
        public final Builder connectedDeviceCount(Long connectedDeviceCount) {
            this.connectedDeviceCount = connectedDeviceCount;
            return this;
        }

        public final Long getActiveDeviceCount() {
            return activeDeviceCount;
        }

        public final void setActiveDeviceCount(Long activeDeviceCount) {
            this.activeDeviceCount = activeDeviceCount;
        }

        @Override
        public final Builder activeDeviceCount(Long activeDeviceCount) {
            this.activeDeviceCount = activeDeviceCount;
            return this;
        }

        public final Long getSamplingDeviceCount() {
            return samplingDeviceCount;
        }

        public final void setSamplingDeviceCount(Long samplingDeviceCount) {
            this.samplingDeviceCount = samplingDeviceCount;
        }

        @Override
        public final Builder samplingDeviceCount(Long samplingDeviceCount) {
            this.samplingDeviceCount = samplingDeviceCount;
            return this;
        }

        @Override
        public EdgeModelStat build() {
            return new EdgeModelStat(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
