/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Shows the latest objective metric emitted by a training job that was launched by a hyperparameter tuning job. You
 * define the objective metric in the <code>HyperParameterTuningJobObjective</code> parameter of <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html"
 * >HyperParameterTuningJobConfig</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FinalHyperParameterTuningJobObjectiveMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<FinalHyperParameterTuningJobObjectiveMetric.Builder, FinalHyperParameterTuningJobObjectiveMetric> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(FinalHyperParameterTuningJobObjectiveMetric::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(FinalHyperParameterTuningJobObjectiveMetric::metricName))
            .setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<Float> VALUE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Value")
            .getter(getter(FinalHyperParameterTuningJobObjectiveMetric::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, METRIC_NAME_FIELD,
            VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Type", TYPE_FIELD);
                    put("MetricName", METRIC_NAME_FIELD);
                    put("Value", VALUE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String metricName;

    private final Float value;

    private FinalHyperParameterTuningJobObjectiveMetric(BuilderImpl builder) {
        this.type = builder.type;
        this.metricName = builder.metricName;
        this.value = builder.value;
    }

    /**
     * <p>
     * Select if you want to minimize or maximize the objective metric during hyperparameter tuning.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link HyperParameterTuningJobObjectiveType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return Select if you want to minimize or maximize the objective metric during hyperparameter tuning.
     * @see HyperParameterTuningJobObjectiveType
     */
    public final HyperParameterTuningJobObjectiveType type() {
        return HyperParameterTuningJobObjectiveType.fromValue(type);
    }

    /**
     * <p>
     * Select if you want to minimize or maximize the objective metric during hyperparameter tuning.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link HyperParameterTuningJobObjectiveType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return Select if you want to minimize or maximize the objective metric during hyperparameter tuning.
     * @see HyperParameterTuningJobObjectiveType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the objective metric. For SageMaker built-in algorithms, metrics are defined per algorithm. See the
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/xgboost-tuning.html">metrics for XGBoost</a> as an
     * example. You can also use a custom algorithm for training and define your own metrics. For more information, see
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics-variables.html">
     * Define metrics and environment variables</a>.
     * </p>
     * 
     * @return The name of the objective metric. For SageMaker built-in algorithms, metrics are defined per algorithm.
     *         See the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/xgboost-tuning.html">metrics for
     *         XGBoost</a> as an example. You can also use a custom algorithm for training and define your own metrics.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics-variables.html"
     *         >Define metrics and environment variables</a>.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The value of the objective metric.
     * </p>
     * 
     * @return The value of the objective metric.
     */
    public final Float value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FinalHyperParameterTuningJobObjectiveMetric)) {
            return false;
        }
        FinalHyperParameterTuningJobObjectiveMetric other = (FinalHyperParameterTuningJobObjectiveMetric) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(metricName(), other.metricName())
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FinalHyperParameterTuningJobObjectiveMetric").add("Type", typeAsString())
                .add("MetricName", metricName()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FinalHyperParameterTuningJobObjectiveMetric, T> g) {
        return obj -> g.apply((FinalHyperParameterTuningJobObjectiveMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FinalHyperParameterTuningJobObjectiveMetric> {
        /**
         * <p>
         * Select if you want to minimize or maximize the objective metric during hyperparameter tuning.
         * </p>
         * 
         * @param type
         *        Select if you want to minimize or maximize the objective metric during hyperparameter tuning.
         * @see HyperParameterTuningJobObjectiveType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HyperParameterTuningJobObjectiveType
         */
        Builder type(String type);

        /**
         * <p>
         * Select if you want to minimize or maximize the objective metric during hyperparameter tuning.
         * </p>
         * 
         * @param type
         *        Select if you want to minimize or maximize the objective metric during hyperparameter tuning.
         * @see HyperParameterTuningJobObjectiveType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HyperParameterTuningJobObjectiveType
         */
        Builder type(HyperParameterTuningJobObjectiveType type);

        /**
         * <p>
         * The name of the objective metric. For SageMaker built-in algorithms, metrics are defined per algorithm. See
         * the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/xgboost-tuning.html">metrics for XGBoost</a> as
         * an example. You can also use a custom algorithm for training and define your own metrics. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics-variables.html"
         * >Define metrics and environment variables</a>.
         * </p>
         * 
         * @param metricName
         *        The name of the objective metric. For SageMaker built-in algorithms, metrics are defined per
         *        algorithm. See the <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/xgboost-tuning.html">metrics for XGBoost</a> as
         *        an example. You can also use a custom algorithm for training and define your own metrics. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics-variables.html"
         *        >Define metrics and environment variables</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The value of the objective metric.
         * </p>
         * 
         * @param value
         *        The value of the objective metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Float value);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String metricName;

        private Float value;

        private BuilderImpl() {
        }

        private BuilderImpl(FinalHyperParameterTuningJobObjectiveMetric model) {
            type(model.type);
            metricName(model.metricName);
            value(model.value);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HyperParameterTuningJobObjectiveType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final Float getValue() {
            return value;
        }

        public final void setValue(Float value) {
            this.value = value;
        }

        @Override
        public final Builder value(Float value) {
            this.value = value;
            return this;
        }

        @Override
        public FinalHyperParameterTuningJobObjectiveMetric build() {
            return new FinalHyperParameterTuningJobObjectiveMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
