/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Any dependencies related to hub content, such as scripts, model artifacts, datasets, or notebooks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HubContentDependency implements SdkPojo, Serializable,
        ToCopyableBuilder<HubContentDependency.Builder, HubContentDependency> {
    private static final SdkField<String> DEPENDENCY_ORIGIN_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DependencyOriginPath").getter(getter(HubContentDependency::dependencyOriginPath))
            .setter(setter(Builder::dependencyOriginPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependencyOriginPath").build())
            .build();

    private static final SdkField<String> DEPENDENCY_COPY_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DependencyCopyPath").getter(getter(HubContentDependency::dependencyCopyPath))
            .setter(setter(Builder::dependencyCopyPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependencyCopyPath").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPENDENCY_ORIGIN_PATH_FIELD,
            DEPENDENCY_COPY_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DependencyOriginPath", DEPENDENCY_ORIGIN_PATH_FIELD);
                    put("DependencyCopyPath", DEPENDENCY_COPY_PATH_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String dependencyOriginPath;

    private final String dependencyCopyPath;

    private HubContentDependency(BuilderImpl builder) {
        this.dependencyOriginPath = builder.dependencyOriginPath;
        this.dependencyCopyPath = builder.dependencyCopyPath;
    }

    /**
     * <p>
     * The hub content dependency origin path.
     * </p>
     * 
     * @return The hub content dependency origin path.
     */
    public final String dependencyOriginPath() {
        return dependencyOriginPath;
    }

    /**
     * <p>
     * The hub content dependency copy path.
     * </p>
     * 
     * @return The hub content dependency copy path.
     */
    public final String dependencyCopyPath() {
        return dependencyCopyPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dependencyOriginPath());
        hashCode = 31 * hashCode + Objects.hashCode(dependencyCopyPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HubContentDependency)) {
            return false;
        }
        HubContentDependency other = (HubContentDependency) obj;
        return Objects.equals(dependencyOriginPath(), other.dependencyOriginPath())
                && Objects.equals(dependencyCopyPath(), other.dependencyCopyPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HubContentDependency").add("DependencyOriginPath", dependencyOriginPath())
                .add("DependencyCopyPath", dependencyCopyPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DependencyOriginPath":
            return Optional.ofNullable(clazz.cast(dependencyOriginPath()));
        case "DependencyCopyPath":
            return Optional.ofNullable(clazz.cast(dependencyCopyPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HubContentDependency, T> g) {
        return obj -> g.apply((HubContentDependency) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HubContentDependency> {
        /**
         * <p>
         * The hub content dependency origin path.
         * </p>
         * 
         * @param dependencyOriginPath
         *        The hub content dependency origin path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencyOriginPath(String dependencyOriginPath);

        /**
         * <p>
         * The hub content dependency copy path.
         * </p>
         * 
         * @param dependencyCopyPath
         *        The hub content dependency copy path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencyCopyPath(String dependencyCopyPath);
    }

    static final class BuilderImpl implements Builder {
        private String dependencyOriginPath;

        private String dependencyCopyPath;

        private BuilderImpl() {
        }

        private BuilderImpl(HubContentDependency model) {
            dependencyOriginPath(model.dependencyOriginPath);
            dependencyCopyPath(model.dependencyCopyPath);
        }

        public final String getDependencyOriginPath() {
            return dependencyOriginPath;
        }

        public final void setDependencyOriginPath(String dependencyOriginPath) {
            this.dependencyOriginPath = dependencyOriginPath;
        }

        @Override
        public final Builder dependencyOriginPath(String dependencyOriginPath) {
            this.dependencyOriginPath = dependencyOriginPath;
            return this;
        }

        public final String getDependencyCopyPath() {
            return dependencyCopyPath;
        }

        public final void setDependencyCopyPath(String dependencyCopyPath) {
            this.dependencyCopyPath = dependencyCopyPath;
        }

        @Override
        public final Builder dependencyCopyPath(String dependencyCopyPath) {
            this.dependencyCopyPath = dependencyCopyPath;
            return this;
        }

        @Override
        public HubContentDependency build() {
            return new HubContentDependency(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
