/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a hub.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HubInfo implements SdkPojo, Serializable, ToCopyableBuilder<HubInfo.Builder, HubInfo> {
    private static final SdkField<String> HUB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubName").getter(getter(HubInfo::hubName)).setter(setter(Builder::hubName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubName").build()).build();

    private static final SdkField<String> HUB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("HubArn")
            .getter(getter(HubInfo::hubArn)).setter(setter(Builder::hubArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubArn").build()).build();

    private static final SdkField<String> HUB_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubDisplayName").getter(getter(HubInfo::hubDisplayName)).setter(setter(Builder::hubDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubDisplayName").build()).build();

    private static final SdkField<String> HUB_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubDescription").getter(getter(HubInfo::hubDescription)).setter(setter(Builder::hubDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubDescription").build()).build();

    private static final SdkField<List<String>> HUB_SEARCH_KEYWORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HubSearchKeywords")
            .getter(getter(HubInfo::hubSearchKeywords))
            .setter(setter(Builder::hubSearchKeywords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubSearchKeywords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> HUB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubStatus").getter(getter(HubInfo::hubStatusAsString)).setter(setter(Builder::hubStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubStatus").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(HubInfo::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(HubInfo::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_NAME_FIELD, HUB_ARN_FIELD,
            HUB_DISPLAY_NAME_FIELD, HUB_DESCRIPTION_FIELD, HUB_SEARCH_KEYWORDS_FIELD, HUB_STATUS_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("HubName", HUB_NAME_FIELD);
                    put("HubArn", HUB_ARN_FIELD);
                    put("HubDisplayName", HUB_DISPLAY_NAME_FIELD);
                    put("HubDescription", HUB_DESCRIPTION_FIELD);
                    put("HubSearchKeywords", HUB_SEARCH_KEYWORDS_FIELD);
                    put("HubStatus", HUB_STATUS_FIELD);
                    put("CreationTime", CREATION_TIME_FIELD);
                    put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String hubName;

    private final String hubArn;

    private final String hubDisplayName;

    private final String hubDescription;

    private final List<String> hubSearchKeywords;

    private final String hubStatus;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private HubInfo(BuilderImpl builder) {
        this.hubName = builder.hubName;
        this.hubArn = builder.hubArn;
        this.hubDisplayName = builder.hubDisplayName;
        this.hubDescription = builder.hubDescription;
        this.hubSearchKeywords = builder.hubSearchKeywords;
        this.hubStatus = builder.hubStatus;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The name of the hub.
     * </p>
     * 
     * @return The name of the hub.
     */
    public final String hubName() {
        return hubName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the hub.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the hub.
     */
    public final String hubArn() {
        return hubArn;
    }

    /**
     * <p>
     * The display name of the hub.
     * </p>
     * 
     * @return The display name of the hub.
     */
    public final String hubDisplayName() {
        return hubDisplayName;
    }

    /**
     * <p>
     * A description of the hub.
     * </p>
     * 
     * @return A description of the hub.
     */
    public final String hubDescription() {
        return hubDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the HubSearchKeywords property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHubSearchKeywords() {
        return hubSearchKeywords != null && !(hubSearchKeywords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The searchable keywords for the hub.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHubSearchKeywords} method.
     * </p>
     * 
     * @return The searchable keywords for the hub.
     */
    public final List<String> hubSearchKeywords() {
        return hubSearchKeywords;
    }

    /**
     * <p>
     * The status of the hub.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hubStatus} will
     * return {@link HubStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hubStatusAsString}.
     * </p>
     * 
     * @return The status of the hub.
     * @see HubStatus
     */
    public final HubStatus hubStatus() {
        return HubStatus.fromValue(hubStatus);
    }

    /**
     * <p>
     * The status of the hub.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hubStatus} will
     * return {@link HubStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hubStatusAsString}.
     * </p>
     * 
     * @return The status of the hub.
     * @see HubStatus
     */
    public final String hubStatusAsString() {
        return hubStatus;
    }

    /**
     * <p>
     * The date and time that the hub was created.
     * </p>
     * 
     * @return The date and time that the hub was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time that the hub was last modified.
     * </p>
     * 
     * @return The date and time that the hub was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hubName());
        hashCode = 31 * hashCode + Objects.hashCode(hubArn());
        hashCode = 31 * hashCode + Objects.hashCode(hubDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(hubDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasHubSearchKeywords() ? hubSearchKeywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hubStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HubInfo)) {
            return false;
        }
        HubInfo other = (HubInfo) obj;
        return Objects.equals(hubName(), other.hubName()) && Objects.equals(hubArn(), other.hubArn())
                && Objects.equals(hubDisplayName(), other.hubDisplayName())
                && Objects.equals(hubDescription(), other.hubDescription())
                && hasHubSearchKeywords() == other.hasHubSearchKeywords()
                && Objects.equals(hubSearchKeywords(), other.hubSearchKeywords())
                && Objects.equals(hubStatusAsString(), other.hubStatusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HubInfo").add("HubName", hubName()).add("HubArn", hubArn())
                .add("HubDisplayName", hubDisplayName()).add("HubDescription", hubDescription())
                .add("HubSearchKeywords", hasHubSearchKeywords() ? hubSearchKeywords() : null)
                .add("HubStatus", hubStatusAsString()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HubName":
            return Optional.ofNullable(clazz.cast(hubName()));
        case "HubArn":
            return Optional.ofNullable(clazz.cast(hubArn()));
        case "HubDisplayName":
            return Optional.ofNullable(clazz.cast(hubDisplayName()));
        case "HubDescription":
            return Optional.ofNullable(clazz.cast(hubDescription()));
        case "HubSearchKeywords":
            return Optional.ofNullable(clazz.cast(hubSearchKeywords()));
        case "HubStatus":
            return Optional.ofNullable(clazz.cast(hubStatusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HubInfo, T> g) {
        return obj -> g.apply((HubInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HubInfo> {
        /**
         * <p>
         * The name of the hub.
         * </p>
         * 
         * @param hubName
         *        The name of the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubName(String hubName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the hub.
         * </p>
         * 
         * @param hubArn
         *        The Amazon Resource Name (ARN) of the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubArn(String hubArn);

        /**
         * <p>
         * The display name of the hub.
         * </p>
         * 
         * @param hubDisplayName
         *        The display name of the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubDisplayName(String hubDisplayName);

        /**
         * <p>
         * A description of the hub.
         * </p>
         * 
         * @param hubDescription
         *        A description of the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubDescription(String hubDescription);

        /**
         * <p>
         * The searchable keywords for the hub.
         * </p>
         * 
         * @param hubSearchKeywords
         *        The searchable keywords for the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubSearchKeywords(Collection<String> hubSearchKeywords);

        /**
         * <p>
         * The searchable keywords for the hub.
         * </p>
         * 
         * @param hubSearchKeywords
         *        The searchable keywords for the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubSearchKeywords(String... hubSearchKeywords);

        /**
         * <p>
         * The status of the hub.
         * </p>
         * 
         * @param hubStatus
         *        The status of the hub.
         * @see HubStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubStatus
         */
        Builder hubStatus(String hubStatus);

        /**
         * <p>
         * The status of the hub.
         * </p>
         * 
         * @param hubStatus
         *        The status of the hub.
         * @see HubStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubStatus
         */
        Builder hubStatus(HubStatus hubStatus);

        /**
         * <p>
         * The date and time that the hub was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time that the hub was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time that the hub was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time that the hub was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String hubName;

        private String hubArn;

        private String hubDisplayName;

        private String hubDescription;

        private List<String> hubSearchKeywords = DefaultSdkAutoConstructList.getInstance();

        private String hubStatus;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(HubInfo model) {
            hubName(model.hubName);
            hubArn(model.hubArn);
            hubDisplayName(model.hubDisplayName);
            hubDescription(model.hubDescription);
            hubSearchKeywords(model.hubSearchKeywords);
            hubStatus(model.hubStatus);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getHubName() {
            return hubName;
        }

        public final void setHubName(String hubName) {
            this.hubName = hubName;
        }

        @Override
        public final Builder hubName(String hubName) {
            this.hubName = hubName;
            return this;
        }

        public final String getHubArn() {
            return hubArn;
        }

        public final void setHubArn(String hubArn) {
            this.hubArn = hubArn;
        }

        @Override
        public final Builder hubArn(String hubArn) {
            this.hubArn = hubArn;
            return this;
        }

        public final String getHubDisplayName() {
            return hubDisplayName;
        }

        public final void setHubDisplayName(String hubDisplayName) {
            this.hubDisplayName = hubDisplayName;
        }

        @Override
        public final Builder hubDisplayName(String hubDisplayName) {
            this.hubDisplayName = hubDisplayName;
            return this;
        }

        public final String getHubDescription() {
            return hubDescription;
        }

        public final void setHubDescription(String hubDescription) {
            this.hubDescription = hubDescription;
        }

        @Override
        public final Builder hubDescription(String hubDescription) {
            this.hubDescription = hubDescription;
            return this;
        }

        public final Collection<String> getHubSearchKeywords() {
            if (hubSearchKeywords instanceof SdkAutoConstructList) {
                return null;
            }
            return hubSearchKeywords;
        }

        public final void setHubSearchKeywords(Collection<String> hubSearchKeywords) {
            this.hubSearchKeywords = HubSearchKeywordListCopier.copy(hubSearchKeywords);
        }

        @Override
        public final Builder hubSearchKeywords(Collection<String> hubSearchKeywords) {
            this.hubSearchKeywords = HubSearchKeywordListCopier.copy(hubSearchKeywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubSearchKeywords(String... hubSearchKeywords) {
            hubSearchKeywords(Arrays.asList(hubSearchKeywords));
            return this;
        }

        public final String getHubStatus() {
            return hubStatus;
        }

        public final void setHubStatus(String hubStatus) {
            this.hubStatus = hubStatus;
        }

        @Override
        public final Builder hubStatus(String hubStatus) {
            this.hubStatus = hubStatus;
            return this;
        }

        @Override
        public final Builder hubStatus(HubStatus hubStatus) {
            this.hubStatus(hubStatus == null ? null : hubStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public HubInfo build() {
            return new HubInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
