/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains runtime information about both current and completed hyperparameter tuning jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HyperParameterTuningJobCompletionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<HyperParameterTuningJobCompletionDetails.Builder, HyperParameterTuningJobCompletionDetails> {
    private static final SdkField<Integer> NUMBER_OF_TRAINING_JOBS_OBJECTIVE_NOT_IMPROVING_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfTrainingJobsObjectiveNotImproving")
            .getter(getter(HyperParameterTuningJobCompletionDetails::numberOfTrainingJobsObjectiveNotImproving))
            .setter(setter(Builder::numberOfTrainingJobsObjectiveNotImproving))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NumberOfTrainingJobsObjectiveNotImproving").build()).build();

    private static final SdkField<Instant> CONVERGENCE_DETECTED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ConvergenceDetectedTime")
            .getter(getter(HyperParameterTuningJobCompletionDetails::convergenceDetectedTime))
            .setter(setter(Builder::convergenceDetectedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConvergenceDetectedTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NUMBER_OF_TRAINING_JOBS_OBJECTIVE_NOT_IMPROVING_FIELD, CONVERGENCE_DETECTED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("NumberOfTrainingJobsObjectiveNotImproving", NUMBER_OF_TRAINING_JOBS_OBJECTIVE_NOT_IMPROVING_FIELD);
                    put("ConvergenceDetectedTime", CONVERGENCE_DETECTED_TIME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer numberOfTrainingJobsObjectiveNotImproving;

    private final Instant convergenceDetectedTime;

    private HyperParameterTuningJobCompletionDetails(BuilderImpl builder) {
        this.numberOfTrainingJobsObjectiveNotImproving = builder.numberOfTrainingJobsObjectiveNotImproving;
        this.convergenceDetectedTime = builder.convergenceDetectedTime;
    }

    /**
     * <p>
     * The number of training jobs launched by a tuning job that are not improving (1% or less) as measured by model
     * performance evaluated against an objective function.
     * </p>
     * 
     * @return The number of training jobs launched by a tuning job that are not improving (1% or less) as measured by
     *         model performance evaluated against an objective function.
     */
    public final Integer numberOfTrainingJobsObjectiveNotImproving() {
        return numberOfTrainingJobsObjectiveNotImproving;
    }

    /**
     * <p>
     * The time in timestamp format that AMT detected model convergence, as defined by a lack of significant improvement
     * over time based on criteria developed over a wide range of diverse benchmarking tests.
     * </p>
     * 
     * @return The time in timestamp format that AMT detected model convergence, as defined by a lack of significant
     *         improvement over time based on criteria developed over a wide range of diverse benchmarking tests.
     */
    public final Instant convergenceDetectedTime() {
        return convergenceDetectedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfTrainingJobsObjectiveNotImproving());
        hashCode = 31 * hashCode + Objects.hashCode(convergenceDetectedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTuningJobCompletionDetails)) {
            return false;
        }
        HyperParameterTuningJobCompletionDetails other = (HyperParameterTuningJobCompletionDetails) obj;
        return Objects.equals(numberOfTrainingJobsObjectiveNotImproving(), other.numberOfTrainingJobsObjectiveNotImproving())
                && Objects.equals(convergenceDetectedTime(), other.convergenceDetectedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HyperParameterTuningJobCompletionDetails")
                .add("NumberOfTrainingJobsObjectiveNotImproving", numberOfTrainingJobsObjectiveNotImproving())
                .add("ConvergenceDetectedTime", convergenceDetectedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberOfTrainingJobsObjectiveNotImproving":
            return Optional.ofNullable(clazz.cast(numberOfTrainingJobsObjectiveNotImproving()));
        case "ConvergenceDetectedTime":
            return Optional.ofNullable(clazz.cast(convergenceDetectedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HyperParameterTuningJobCompletionDetails, T> g) {
        return obj -> g.apply((HyperParameterTuningJobCompletionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HyperParameterTuningJobCompletionDetails> {
        /**
         * <p>
         * The number of training jobs launched by a tuning job that are not improving (1% or less) as measured by model
         * performance evaluated against an objective function.
         * </p>
         * 
         * @param numberOfTrainingJobsObjectiveNotImproving
         *        The number of training jobs launched by a tuning job that are not improving (1% or less) as measured
         *        by model performance evaluated against an objective function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfTrainingJobsObjectiveNotImproving(Integer numberOfTrainingJobsObjectiveNotImproving);

        /**
         * <p>
         * The time in timestamp format that AMT detected model convergence, as defined by a lack of significant
         * improvement over time based on criteria developed over a wide range of diverse benchmarking tests.
         * </p>
         * 
         * @param convergenceDetectedTime
         *        The time in timestamp format that AMT detected model convergence, as defined by a lack of significant
         *        improvement over time based on criteria developed over a wide range of diverse benchmarking tests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder convergenceDetectedTime(Instant convergenceDetectedTime);
    }

    static final class BuilderImpl implements Builder {
        private Integer numberOfTrainingJobsObjectiveNotImproving;

        private Instant convergenceDetectedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterTuningJobCompletionDetails model) {
            numberOfTrainingJobsObjectiveNotImproving(model.numberOfTrainingJobsObjectiveNotImproving);
            convergenceDetectedTime(model.convergenceDetectedTime);
        }

        public final Integer getNumberOfTrainingJobsObjectiveNotImproving() {
            return numberOfTrainingJobsObjectiveNotImproving;
        }

        public final void setNumberOfTrainingJobsObjectiveNotImproving(Integer numberOfTrainingJobsObjectiveNotImproving) {
            this.numberOfTrainingJobsObjectiveNotImproving = numberOfTrainingJobsObjectiveNotImproving;
        }

        @Override
        public final Builder numberOfTrainingJobsObjectiveNotImproving(Integer numberOfTrainingJobsObjectiveNotImproving) {
            this.numberOfTrainingJobsObjectiveNotImproving = numberOfTrainingJobsObjectiveNotImproving;
            return this;
        }

        public final Instant getConvergenceDetectedTime() {
            return convergenceDetectedTime;
        }

        public final void setConvergenceDetectedTime(Instant convergenceDetectedTime) {
            this.convergenceDetectedTime = convergenceDetectedTime;
        }

        @Override
        public final Builder convergenceDetectedTime(Instant convergenceDetectedTime) {
            this.convergenceDetectedTime = convergenceDetectedTime;
            return this;
        }

        @Override
        public HyperParameterTuningJobCompletionDetails build() {
            return new HyperParameterTuningJobCompletionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
