/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the objective metric for a hyperparameter tuning job. Hyperparameter tuning uses the value of this metric to
 * evaluate the training jobs it launches, and returns the training job that results in either the highest or lowest
 * value for this metric, depending on the value you specify for the <code>Type</code> parameter. If you want to define
 * a custom objective metric, see <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics-variables.html">Define
 * metrics and environment variables</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HyperParameterTuningJobObjective implements SdkPojo, Serializable,
        ToCopyableBuilder<HyperParameterTuningJobObjective.Builder, HyperParameterTuningJobObjective> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(HyperParameterTuningJobObjective::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(HyperParameterTuningJobObjective::metricName))
            .setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TYPE_FIELD, METRIC_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Type", TYPE_FIELD);
                    put("MetricName", METRIC_NAME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String metricName;

    private HyperParameterTuningJobObjective(BuilderImpl builder) {
        this.type = builder.type;
        this.metricName = builder.metricName;
    }

    /**
     * <p>
     * Whether to minimize or maximize the objective metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link HyperParameterTuningJobObjectiveType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return Whether to minimize or maximize the objective metric.
     * @see HyperParameterTuningJobObjectiveType
     */
    public final HyperParameterTuningJobObjectiveType type() {
        return HyperParameterTuningJobObjectiveType.fromValue(type);
    }

    /**
     * <p>
     * Whether to minimize or maximize the objective metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link HyperParameterTuningJobObjectiveType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return Whether to minimize or maximize the objective metric.
     * @see HyperParameterTuningJobObjectiveType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the metric to use for the objective metric.
     * </p>
     * 
     * @return The name of the metric to use for the objective metric.
     */
    public final String metricName() {
        return metricName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTuningJobObjective)) {
            return false;
        }
        HyperParameterTuningJobObjective other = (HyperParameterTuningJobObjective) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(metricName(), other.metricName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HyperParameterTuningJobObjective").add("Type", typeAsString()).add("MetricName", metricName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HyperParameterTuningJobObjective, T> g) {
        return obj -> g.apply((HyperParameterTuningJobObjective) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HyperParameterTuningJobObjective> {
        /**
         * <p>
         * Whether to minimize or maximize the objective metric.
         * </p>
         * 
         * @param type
         *        Whether to minimize or maximize the objective metric.
         * @see HyperParameterTuningJobObjectiveType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HyperParameterTuningJobObjectiveType
         */
        Builder type(String type);

        /**
         * <p>
         * Whether to minimize or maximize the objective metric.
         * </p>
         * 
         * @param type
         *        Whether to minimize or maximize the objective metric.
         * @see HyperParameterTuningJobObjectiveType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HyperParameterTuningJobObjectiveType
         */
        Builder type(HyperParameterTuningJobObjectiveType type);

        /**
         * <p>
         * The name of the metric to use for the objective metric.
         * </p>
         * 
         * @param metricName
         *        The name of the metric to use for the objective metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String metricName;

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterTuningJobObjective model) {
            type(model.type);
            metricName(model.metricName);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HyperParameterTuningJobObjectiveType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public HyperParameterTuningJobObjective build() {
            return new HyperParameterTuningJobObjective(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
