/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The IAM Identity details associated with the user. These details are associated with model package groups, model
 * packages and project entities only.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IamIdentity implements SdkPojo, Serializable, ToCopyableBuilder<IamIdentity.Builder, IamIdentity> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(IamIdentity::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalId").getter(getter(IamIdentity::principalId)).setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()).build();

    private static final SdkField<String> SOURCE_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceIdentity").getter(getter(IamIdentity::sourceIdentity)).setter(setter(Builder::sourceIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIdentity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, PRINCIPAL_ID_FIELD,
            SOURCE_IDENTITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Arn", ARN_FIELD);
                    put("PrincipalId", PRINCIPAL_ID_FIELD);
                    put("SourceIdentity", SOURCE_IDENTITY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String principalId;

    private final String sourceIdentity;

    private IamIdentity(BuilderImpl builder) {
        this.arn = builder.arn;
        this.principalId = builder.principalId;
        this.sourceIdentity = builder.sourceIdentity;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM identity.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM identity.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the principal that assumes the IAM identity.
     * </p>
     * 
     * @return The ID of the principal that assumes the IAM identity.
     */
    public final String principalId() {
        return principalId;
    }

    /**
     * <p>
     * The person or application which assumes the IAM identity.
     * </p>
     * 
     * @return The person or application which assumes the IAM identity.
     */
    public final String sourceIdentity() {
        return sourceIdentity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceIdentity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IamIdentity)) {
            return false;
        }
        IamIdentity other = (IamIdentity) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(principalId(), other.principalId())
                && Objects.equals(sourceIdentity(), other.sourceIdentity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IamIdentity").add("Arn", arn()).add("PrincipalId", principalId())
                .add("SourceIdentity", sourceIdentity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "PrincipalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "SourceIdentity":
            return Optional.ofNullable(clazz.cast(sourceIdentity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IamIdentity, T> g) {
        return obj -> g.apply((IamIdentity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IamIdentity> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM identity.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the IAM identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the principal that assumes the IAM identity.
         * </p>
         * 
         * @param principalId
         *        The ID of the principal that assumes the IAM identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * The person or application which assumes the IAM identity.
         * </p>
         * 
         * @param sourceIdentity
         *        The person or application which assumes the IAM identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIdentity(String sourceIdentity);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String principalId;

        private String sourceIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(IamIdentity model) {
            arn(model.arn);
            principalId(model.principalId);
            sourceIdentity(model.sourceIdentity);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getSourceIdentity() {
            return sourceIdentity;
        }

        public final void setSourceIdentity(String sourceIdentity) {
            this.sourceIdentity = sourceIdentity;
        }

        @Override
        public final Builder sourceIdentity(String sourceIdentity) {
            this.sourceIdentity = sourceIdentity;
            return this;
        }

        @Override
        public IamIdentity build() {
            return new IamIdentity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
