/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon SageMaker Canvas application setting where you configure OAuth for connecting to an external data source,
 * such as Snowflake.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityProviderOAuthSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityProviderOAuthSetting.Builder, IdentityProviderOAuthSetting> {
    private static final SdkField<String> DATA_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceName").getter(getter(IdentityProviderOAuthSetting::dataSourceNameAsString))
            .setter(setter(Builder::dataSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(IdentityProviderOAuthSetting::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(IdentityProviderOAuthSetting::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_NAME_FIELD,
            STATUS_FIELD, SECRET_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DataSourceName", DATA_SOURCE_NAME_FIELD);
                    put("Status", STATUS_FIELD);
                    put("SecretArn", SECRET_ARN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String dataSourceName;

    private final String status;

    private final String secretArn;

    private IdentityProviderOAuthSetting(BuilderImpl builder) {
        this.dataSourceName = builder.dataSourceName;
        this.status = builder.status;
        this.secretArn = builder.secretArn;
    }

    /**
     * <p>
     * The name of the data source that you're connecting to. Canvas currently supports OAuth for Snowflake and
     * Salesforce Data Cloud.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSourceName}
     * will return {@link DataSourceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dataSourceNameAsString}.
     * </p>
     * 
     * @return The name of the data source that you're connecting to. Canvas currently supports OAuth for Snowflake and
     *         Salesforce Data Cloud.
     * @see DataSourceName
     */
    public final DataSourceName dataSourceName() {
        return DataSourceName.fromValue(dataSourceName);
    }

    /**
     * <p>
     * The name of the data source that you're connecting to. Canvas currently supports OAuth for Snowflake and
     * Salesforce Data Cloud.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSourceName}
     * will return {@link DataSourceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dataSourceNameAsString}.
     * </p>
     * 
     * @return The name of the data source that you're connecting to. Canvas currently supports OAuth for Snowflake and
     *         Salesforce Data Cloud.
     * @see DataSourceName
     */
    public final String dataSourceNameAsString() {
        return dataSourceName;
    }

    /**
     * <p>
     * Describes whether OAuth for a data source is enabled or disabled in the Canvas application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Describes whether OAuth for a data source is enabled or disabled in the Canvas application.
     * @see FeatureStatus
     */
    public final FeatureStatus status() {
        return FeatureStatus.fromValue(status);
    }

    /**
     * <p>
     * Describes whether OAuth for a data source is enabled or disabled in the Canvas application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Describes whether OAuth for a data source is enabled or disabled in the Canvas application.
     * @see FeatureStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The ARN of an Amazon Web Services Secrets Manager secret that stores the credentials from your identity provider,
     * such as the client ID and secret, authorization URL, and token URL.
     * </p>
     * 
     * @return The ARN of an Amazon Web Services Secrets Manager secret that stores the credentials from your identity
     *         provider, such as the client ID and secret, authorization URL, and token URL.
     */
    public final String secretArn() {
        return secretArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityProviderOAuthSetting)) {
            return false;
        }
        IdentityProviderOAuthSetting other = (IdentityProviderOAuthSetting) obj;
        return Objects.equals(dataSourceNameAsString(), other.dataSourceNameAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(secretArn(), other.secretArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityProviderOAuthSetting").add("DataSourceName", dataSourceNameAsString())
                .add("Status", statusAsString()).add("SecretArn", secretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceName":
            return Optional.ofNullable(clazz.cast(dataSourceNameAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IdentityProviderOAuthSetting, T> g) {
        return obj -> g.apply((IdentityProviderOAuthSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityProviderOAuthSetting> {
        /**
         * <p>
         * The name of the data source that you're connecting to. Canvas currently supports OAuth for Snowflake and
         * Salesforce Data Cloud.
         * </p>
         * 
         * @param dataSourceName
         *        The name of the data source that you're connecting to. Canvas currently supports OAuth for Snowflake
         *        and Salesforce Data Cloud.
         * @see DataSourceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceName
         */
        Builder dataSourceName(String dataSourceName);

        /**
         * <p>
         * The name of the data source that you're connecting to. Canvas currently supports OAuth for Snowflake and
         * Salesforce Data Cloud.
         * </p>
         * 
         * @param dataSourceName
         *        The name of the data source that you're connecting to. Canvas currently supports OAuth for Snowflake
         *        and Salesforce Data Cloud.
         * @see DataSourceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceName
         */
        Builder dataSourceName(DataSourceName dataSourceName);

        /**
         * <p>
         * Describes whether OAuth for a data source is enabled or disabled in the Canvas application.
         * </p>
         * 
         * @param status
         *        Describes whether OAuth for a data source is enabled or disabled in the Canvas application.
         * @see FeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Describes whether OAuth for a data source is enabled or disabled in the Canvas application.
         * </p>
         * 
         * @param status
         *        Describes whether OAuth for a data source is enabled or disabled in the Canvas application.
         * @see FeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureStatus
         */
        Builder status(FeatureStatus status);

        /**
         * <p>
         * The ARN of an Amazon Web Services Secrets Manager secret that stores the credentials from your identity
         * provider, such as the client ID and secret, authorization URL, and token URL.
         * </p>
         * 
         * @param secretArn
         *        The ARN of an Amazon Web Services Secrets Manager secret that stores the credentials from your
         *        identity provider, such as the client ID and secret, authorization URL, and token URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);
    }

    static final class BuilderImpl implements Builder {
        private String dataSourceName;

        private String status;

        private String secretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityProviderOAuthSetting model) {
            dataSourceName(model.dataSourceName);
            status(model.status);
            secretArn(model.secretArn);
        }

        public final String getDataSourceName() {
            return dataSourceName;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        @Override
        public final Builder dataSourceName(DataSourceName dataSourceName) {
            this.dataSourceName(dataSourceName == null ? null : dataSourceName.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FeatureStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        @Override
        public IdentityProviderOAuthSetting build() {
            return new IdentityProviderOAuthSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
