/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Runtime settings for a model that is deployed with an inference component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceComponentRuntimeConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceComponentRuntimeConfig.Builder, InferenceComponentRuntimeConfig> {
    private static final SdkField<Integer> COPY_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CopyCount").getter(getter(InferenceComponentRuntimeConfig::copyCount))
            .setter(setter(Builder::copyCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COPY_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CopyCount", COPY_COUNT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer copyCount;

    private InferenceComponentRuntimeConfig(BuilderImpl builder) {
        this.copyCount = builder.copyCount;
    }

    /**
     * <p>
     * The number of runtime copies of the model container to deploy with the inference component. Each copy can serve
     * inference requests.
     * </p>
     * 
     * @return The number of runtime copies of the model container to deploy with the inference component. Each copy can
     *         serve inference requests.
     */
    public final Integer copyCount() {
        return copyCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(copyCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceComponentRuntimeConfig)) {
            return false;
        }
        InferenceComponentRuntimeConfig other = (InferenceComponentRuntimeConfig) obj;
        return Objects.equals(copyCount(), other.copyCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceComponentRuntimeConfig").add("CopyCount", copyCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CopyCount":
            return Optional.ofNullable(clazz.cast(copyCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InferenceComponentRuntimeConfig, T> g) {
        return obj -> g.apply((InferenceComponentRuntimeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceComponentRuntimeConfig> {
        /**
         * <p>
         * The number of runtime copies of the model container to deploy with the inference component. Each copy can
         * serve inference requests.
         * </p>
         * 
         * @param copyCount
         *        The number of runtime copies of the model container to deploy with the inference component. Each copy
         *        can serve inference requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyCount(Integer copyCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer copyCount;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceComponentRuntimeConfig model) {
            copyCount(model.copyCount);
        }

        public final Integer getCopyCount() {
            return copyCount;
        }

        public final void setCopyCount(Integer copyCount) {
            this.copyCount = copyCount;
        }

        @Override
        public final Builder copyCount(Integer copyCount) {
            this.copyCount = copyCount;
            return this;
        }

        @Override
        public InferenceComponentRuntimeConfig build() {
            return new InferenceComponentRuntimeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
