/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the properties of an inference component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceComponentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceComponentSummary.Builder, InferenceComponentSummary> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(InferenceComponentSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> INFERENCE_COMPONENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceComponentArn").getter(getter(InferenceComponentSummary::inferenceComponentArn))
            .setter(setter(Builder::inferenceComponentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceComponentArn").build())
            .build();

    private static final SdkField<String> INFERENCE_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceComponentName").getter(getter(InferenceComponentSummary::inferenceComponentName))
            .setter(setter(Builder::inferenceComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceComponentName").build())
            .build();

    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointArn").getter(getter(InferenceComponentSummary::endpointArn))
            .setter(setter(Builder::endpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()).build();

    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(InferenceComponentSummary::endpointName))
            .setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> VARIANT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VariantName").getter(getter(InferenceComponentSummary::variantName))
            .setter(setter(Builder::variantName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariantName").build()).build();

    private static final SdkField<String> INFERENCE_COMPONENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceComponentStatus").getter(getter(InferenceComponentSummary::inferenceComponentStatusAsString))
            .setter(setter(Builder::inferenceComponentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceComponentStatus").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(InferenceComponentSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            INFERENCE_COMPONENT_ARN_FIELD, INFERENCE_COMPONENT_NAME_FIELD, ENDPOINT_ARN_FIELD, ENDPOINT_NAME_FIELD,
            VARIANT_NAME_FIELD, INFERENCE_COMPONENT_STATUS_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CreationTime", CREATION_TIME_FIELD);
                    put("InferenceComponentArn", INFERENCE_COMPONENT_ARN_FIELD);
                    put("InferenceComponentName", INFERENCE_COMPONENT_NAME_FIELD);
                    put("EndpointArn", ENDPOINT_ARN_FIELD);
                    put("EndpointName", ENDPOINT_NAME_FIELD);
                    put("VariantName", VARIANT_NAME_FIELD);
                    put("InferenceComponentStatus", INFERENCE_COMPONENT_STATUS_FIELD);
                    put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Instant creationTime;

    private final String inferenceComponentArn;

    private final String inferenceComponentName;

    private final String endpointArn;

    private final String endpointName;

    private final String variantName;

    private final String inferenceComponentStatus;

    private final Instant lastModifiedTime;

    private InferenceComponentSummary(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.inferenceComponentArn = builder.inferenceComponentArn;
        this.inferenceComponentName = builder.inferenceComponentName;
        this.endpointArn = builder.endpointArn;
        this.endpointName = builder.endpointName;
        this.variantName = builder.variantName;
        this.inferenceComponentStatus = builder.inferenceComponentStatus;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The time when the inference component was created.
     * </p>
     * 
     * @return The time when the inference component was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the inference component.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the inference component.
     */
    public final String inferenceComponentArn() {
        return inferenceComponentArn;
    }

    /**
     * <p>
     * The name of the inference component.
     * </p>
     * 
     * @return The name of the inference component.
     */
    public final String inferenceComponentName() {
        return inferenceComponentName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.
     */
    public final String endpointArn() {
        return endpointArn;
    }

    /**
     * <p>
     * The name of the endpoint that hosts the inference component.
     * </p>
     * 
     * @return The name of the endpoint that hosts the inference component.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * The name of the production variant that hosts the inference component.
     * </p>
     * 
     * @return The name of the production variant that hosts the inference component.
     */
    public final String variantName() {
        return variantName;
    }

    /**
     * <p>
     * The status of the inference component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inferenceComponentStatus} will return {@link InferenceComponentStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #inferenceComponentStatusAsString}.
     * </p>
     * 
     * @return The status of the inference component.
     * @see InferenceComponentStatus
     */
    public final InferenceComponentStatus inferenceComponentStatus() {
        return InferenceComponentStatus.fromValue(inferenceComponentStatus);
    }

    /**
     * <p>
     * The status of the inference component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inferenceComponentStatus} will return {@link InferenceComponentStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #inferenceComponentStatusAsString}.
     * </p>
     * 
     * @return The status of the inference component.
     * @see InferenceComponentStatus
     */
    public final String inferenceComponentStatusAsString() {
        return inferenceComponentStatus;
    }

    /**
     * <p>
     * The time when the inference component was last updated.
     * </p>
     * 
     * @return The time when the inference component was last updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceComponentArn());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(variantName());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceComponentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceComponentSummary)) {
            return false;
        }
        InferenceComponentSummary other = (InferenceComponentSummary) obj;
        return Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(inferenceComponentArn(), other.inferenceComponentArn())
                && Objects.equals(inferenceComponentName(), other.inferenceComponentName())
                && Objects.equals(endpointArn(), other.endpointArn()) && Objects.equals(endpointName(), other.endpointName())
                && Objects.equals(variantName(), other.variantName())
                && Objects.equals(inferenceComponentStatusAsString(), other.inferenceComponentStatusAsString())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceComponentSummary").add("CreationTime", creationTime())
                .add("InferenceComponentArn", inferenceComponentArn()).add("InferenceComponentName", inferenceComponentName())
                .add("EndpointArn", endpointArn()).add("EndpointName", endpointName()).add("VariantName", variantName())
                .add("InferenceComponentStatus", inferenceComponentStatusAsString()).add("LastModifiedTime", lastModifiedTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "InferenceComponentArn":
            return Optional.ofNullable(clazz.cast(inferenceComponentArn()));
        case "InferenceComponentName":
            return Optional.ofNullable(clazz.cast(inferenceComponentName()));
        case "EndpointArn":
            return Optional.ofNullable(clazz.cast(endpointArn()));
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "VariantName":
            return Optional.ofNullable(clazz.cast(variantName()));
        case "InferenceComponentStatus":
            return Optional.ofNullable(clazz.cast(inferenceComponentStatusAsString()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InferenceComponentSummary, T> g) {
        return obj -> g.apply((InferenceComponentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceComponentSummary> {
        /**
         * <p>
         * The time when the inference component was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the inference component was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the inference component.
         * </p>
         * 
         * @param inferenceComponentArn
         *        The Amazon Resource Name (ARN) of the inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceComponentArn(String inferenceComponentArn);

        /**
         * <p>
         * The name of the inference component.
         * </p>
         * 
         * @param inferenceComponentName
         *        The name of the inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceComponentName(String inferenceComponentName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.
         * </p>
         * 
         * @param endpointArn
         *        The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointArn(String endpointArn);

        /**
         * <p>
         * The name of the endpoint that hosts the inference component.
         * </p>
         * 
         * @param endpointName
         *        The name of the endpoint that hosts the inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * The name of the production variant that hosts the inference component.
         * </p>
         * 
         * @param variantName
         *        The name of the production variant that hosts the inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variantName(String variantName);

        /**
         * <p>
         * The status of the inference component.
         * </p>
         * 
         * @param inferenceComponentStatus
         *        The status of the inference component.
         * @see InferenceComponentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceComponentStatus
         */
        Builder inferenceComponentStatus(String inferenceComponentStatus);

        /**
         * <p>
         * The status of the inference component.
         * </p>
         * 
         * @param inferenceComponentStatus
         *        The status of the inference component.
         * @see InferenceComponentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceComponentStatus
         */
        Builder inferenceComponentStatus(InferenceComponentStatus inferenceComponentStatus);

        /**
         * <p>
         * The time when the inference component was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time when the inference component was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationTime;

        private String inferenceComponentArn;

        private String inferenceComponentName;

        private String endpointArn;

        private String endpointName;

        private String variantName;

        private String inferenceComponentStatus;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceComponentSummary model) {
            creationTime(model.creationTime);
            inferenceComponentArn(model.inferenceComponentArn);
            inferenceComponentName(model.inferenceComponentName);
            endpointArn(model.endpointArn);
            endpointName(model.endpointName);
            variantName(model.variantName);
            inferenceComponentStatus(model.inferenceComponentStatus);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getInferenceComponentArn() {
            return inferenceComponentArn;
        }

        public final void setInferenceComponentArn(String inferenceComponentArn) {
            this.inferenceComponentArn = inferenceComponentArn;
        }

        @Override
        public final Builder inferenceComponentArn(String inferenceComponentArn) {
            this.inferenceComponentArn = inferenceComponentArn;
            return this;
        }

        public final String getInferenceComponentName() {
            return inferenceComponentName;
        }

        public final void setInferenceComponentName(String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
        }

        @Override
        public final Builder inferenceComponentName(String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
            return this;
        }

        public final String getEndpointArn() {
            return endpointArn;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getVariantName() {
            return variantName;
        }

        public final void setVariantName(String variantName) {
            this.variantName = variantName;
        }

        @Override
        public final Builder variantName(String variantName) {
            this.variantName = variantName;
            return this;
        }

        public final String getInferenceComponentStatus() {
            return inferenceComponentStatus;
        }

        public final void setInferenceComponentStatus(String inferenceComponentStatus) {
            this.inferenceComponentStatus = inferenceComponentStatus;
        }

        @Override
        public final Builder inferenceComponentStatus(String inferenceComponentStatus) {
            this.inferenceComponentStatus = inferenceComponentStatus;
            return this;
        }

        @Override
        public final Builder inferenceComponentStatus(InferenceComponentStatus inferenceComponentStatus) {
            this.inferenceComponentStatus(inferenceComponentStatus == null ? null : inferenceComponentStatus.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public InferenceComponentSummary build() {
            return new InferenceComponentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
