/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A returned array object for the <code>Steps</code> response field in the <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListInferenceRecommendationsJobSteps.html"
 * >ListInferenceRecommendationsJobSteps</a> API command.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceRecommendationsJobStep implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceRecommendationsJobStep.Builder, InferenceRecommendationsJobStep> {
    private static final SdkField<String> STEP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StepType").getter(getter(InferenceRecommendationsJobStep::stepTypeAsString))
            .setter(setter(Builder::stepType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepType").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(InferenceRecommendationsJobStep::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(InferenceRecommendationsJobStep::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<RecommendationJobInferenceBenchmark> INFERENCE_BENCHMARK_FIELD = SdkField
            .<RecommendationJobInferenceBenchmark> builder(MarshallingType.SDK_POJO).memberName("InferenceBenchmark")
            .getter(getter(InferenceRecommendationsJobStep::inferenceBenchmark)).setter(setter(Builder::inferenceBenchmark))
            .constructor(RecommendationJobInferenceBenchmark::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceBenchmark").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_TYPE_FIELD,
            JOB_NAME_FIELD, STATUS_FIELD, INFERENCE_BENCHMARK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("StepType", STEP_TYPE_FIELD);
                    put("JobName", JOB_NAME_FIELD);
                    put("Status", STATUS_FIELD);
                    put("InferenceBenchmark", INFERENCE_BENCHMARK_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String stepType;

    private final String jobName;

    private final String status;

    private final RecommendationJobInferenceBenchmark inferenceBenchmark;

    private InferenceRecommendationsJobStep(BuilderImpl builder) {
        this.stepType = builder.stepType;
        this.jobName = builder.jobName;
        this.status = builder.status;
        this.inferenceBenchmark = builder.inferenceBenchmark;
    }

    /**
     * <p>
     * The type of the subtask.
     * </p>
     * <p>
     * <code>BENCHMARK</code>: Evaluate the performance of your model on different instance types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepType} will
     * return {@link RecommendationStepType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stepTypeAsString}.
     * </p>
     * 
     * @return The type of the subtask.</p>
     *         <p>
     *         <code>BENCHMARK</code>: Evaluate the performance of your model on different instance types.
     * @see RecommendationStepType
     */
    public final RecommendationStepType stepType() {
        return RecommendationStepType.fromValue(stepType);
    }

    /**
     * <p>
     * The type of the subtask.
     * </p>
     * <p>
     * <code>BENCHMARK</code>: Evaluate the performance of your model on different instance types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepType} will
     * return {@link RecommendationStepType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stepTypeAsString}.
     * </p>
     * 
     * @return The type of the subtask.</p>
     *         <p>
     *         <code>BENCHMARK</code>: Evaluate the performance of your model on different instance types.
     * @see RecommendationStepType
     */
    public final String stepTypeAsString() {
        return stepType;
    }

    /**
     * <p>
     * The name of the Inference Recommender job.
     * </p>
     * 
     * @return The name of the Inference Recommender job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The current status of the benchmark.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecommendationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the benchmark.
     * @see RecommendationJobStatus
     */
    public final RecommendationJobStatus status() {
        return RecommendationJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the benchmark.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecommendationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the benchmark.
     * @see RecommendationJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The details for a specific benchmark.
     * </p>
     * 
     * @return The details for a specific benchmark.
     */
    public final RecommendationJobInferenceBenchmark inferenceBenchmark() {
        return inferenceBenchmark;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceBenchmark());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceRecommendationsJobStep)) {
            return false;
        }
        InferenceRecommendationsJobStep other = (InferenceRecommendationsJobStep) obj;
        return Objects.equals(stepTypeAsString(), other.stepTypeAsString()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(inferenceBenchmark(), other.inferenceBenchmark());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceRecommendationsJobStep").add("StepType", stepTypeAsString()).add("JobName", jobName())
                .add("Status", statusAsString()).add("InferenceBenchmark", inferenceBenchmark()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StepType":
            return Optional.ofNullable(clazz.cast(stepTypeAsString()));
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "InferenceBenchmark":
            return Optional.ofNullable(clazz.cast(inferenceBenchmark()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InferenceRecommendationsJobStep, T> g) {
        return obj -> g.apply((InferenceRecommendationsJobStep) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceRecommendationsJobStep> {
        /**
         * <p>
         * The type of the subtask.
         * </p>
         * <p>
         * <code>BENCHMARK</code>: Evaluate the performance of your model on different instance types.
         * </p>
         * 
         * @param stepType
         *        The type of the subtask.</p>
         *        <p>
         *        <code>BENCHMARK</code>: Evaluate the performance of your model on different instance types.
         * @see RecommendationStepType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationStepType
         */
        Builder stepType(String stepType);

        /**
         * <p>
         * The type of the subtask.
         * </p>
         * <p>
         * <code>BENCHMARK</code>: Evaluate the performance of your model on different instance types.
         * </p>
         * 
         * @param stepType
         *        The type of the subtask.</p>
         *        <p>
         *        <code>BENCHMARK</code>: Evaluate the performance of your model on different instance types.
         * @see RecommendationStepType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationStepType
         */
        Builder stepType(RecommendationStepType stepType);

        /**
         * <p>
         * The name of the Inference Recommender job.
         * </p>
         * 
         * @param jobName
         *        The name of the Inference Recommender job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The current status of the benchmark.
         * </p>
         * 
         * @param status
         *        The current status of the benchmark.
         * @see RecommendationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the benchmark.
         * </p>
         * 
         * @param status
         *        The current status of the benchmark.
         * @see RecommendationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationJobStatus
         */
        Builder status(RecommendationJobStatus status);

        /**
         * <p>
         * The details for a specific benchmark.
         * </p>
         * 
         * @param inferenceBenchmark
         *        The details for a specific benchmark.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceBenchmark(RecommendationJobInferenceBenchmark inferenceBenchmark);

        /**
         * <p>
         * The details for a specific benchmark.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RecommendationJobInferenceBenchmark.Builder} avoiding the need to create one manually via
         * {@link RecommendationJobInferenceBenchmark#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationJobInferenceBenchmark.Builder#build()} is called
         * immediately and its result is passed to {@link #inferenceBenchmark(RecommendationJobInferenceBenchmark)}.
         * 
         * @param inferenceBenchmark
         *        a consumer that will call methods on {@link RecommendationJobInferenceBenchmark.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceBenchmark(RecommendationJobInferenceBenchmark)
         */
        default Builder inferenceBenchmark(Consumer<RecommendationJobInferenceBenchmark.Builder> inferenceBenchmark) {
            return inferenceBenchmark(RecommendationJobInferenceBenchmark.builder().applyMutation(inferenceBenchmark).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String stepType;

        private String jobName;

        private String status;

        private RecommendationJobInferenceBenchmark inferenceBenchmark;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceRecommendationsJobStep model) {
            stepType(model.stepType);
            jobName(model.jobName);
            status(model.status);
            inferenceBenchmark(model.inferenceBenchmark);
        }

        public final String getStepType() {
            return stepType;
        }

        public final void setStepType(String stepType) {
            this.stepType = stepType;
        }

        @Override
        public final Builder stepType(String stepType) {
            this.stepType = stepType;
            return this;
        }

        @Override
        public final Builder stepType(RecommendationStepType stepType) {
            this.stepType(stepType == null ? null : stepType.toString());
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecommendationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final RecommendationJobInferenceBenchmark.Builder getInferenceBenchmark() {
            return inferenceBenchmark != null ? inferenceBenchmark.toBuilder() : null;
        }

        public final void setInferenceBenchmark(RecommendationJobInferenceBenchmark.BuilderImpl inferenceBenchmark) {
            this.inferenceBenchmark = inferenceBenchmark != null ? inferenceBenchmark.build() : null;
        }

        @Override
        public final Builder inferenceBenchmark(RecommendationJobInferenceBenchmark inferenceBenchmark) {
            this.inferenceBenchmark = inferenceBenchmark;
            return this;
        }

        @Override
        public InferenceRecommendationsJobStep build() {
            return new InferenceRecommendationsJobStep(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
