/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings for the JupyterLab application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JupyterLabAppSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<JupyterLabAppSettings.Builder, JupyterLabAppSettings> {
    private static final SdkField<ResourceSpec> DEFAULT_RESOURCE_SPEC_FIELD = SdkField
            .<ResourceSpec> builder(MarshallingType.SDK_POJO).memberName("DefaultResourceSpec")
            .getter(getter(JupyterLabAppSettings::defaultResourceSpec)).setter(setter(Builder::defaultResourceSpec))
            .constructor(ResourceSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultResourceSpec").build())
            .build();

    private static final SdkField<List<CustomImage>> CUSTOM_IMAGES_FIELD = SdkField
            .<List<CustomImage>> builder(MarshallingType.LIST)
            .memberName("CustomImages")
            .getter(getter(JupyterLabAppSettings::customImages))
            .setter(setter(Builder::customImages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomImages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomImage> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomImage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LIFECYCLE_CONFIG_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LifecycleConfigArns")
            .getter(getter(JupyterLabAppSettings::lifecycleConfigArns))
            .setter(setter(Builder::lifecycleConfigArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleConfigArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CodeRepository>> CODE_REPOSITORIES_FIELD = SdkField
            .<List<CodeRepository>> builder(MarshallingType.LIST)
            .memberName("CodeRepositories")
            .getter(getter(JupyterLabAppSettings::codeRepositories))
            .setter(setter(Builder::codeRepositories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeRepositories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CodeRepository> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodeRepository::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AppLifecycleManagement> APP_LIFECYCLE_MANAGEMENT_FIELD = SdkField
            .<AppLifecycleManagement> builder(MarshallingType.SDK_POJO).memberName("AppLifecycleManagement")
            .getter(getter(JupyterLabAppSettings::appLifecycleManagement)).setter(setter(Builder::appLifecycleManagement))
            .constructor(AppLifecycleManagement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppLifecycleManagement").build())
            .build();

    private static final SdkField<EmrSettings> EMR_SETTINGS_FIELD = SdkField.<EmrSettings> builder(MarshallingType.SDK_POJO)
            .memberName("EmrSettings").getter(getter(JupyterLabAppSettings::emrSettings)).setter(setter(Builder::emrSettings))
            .constructor(EmrSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmrSettings").build()).build();

    private static final SdkField<String> BUILT_IN_LIFECYCLE_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BuiltInLifecycleConfigArn").getter(getter(JupyterLabAppSettings::builtInLifecycleConfigArn))
            .setter(setter(Builder::builtInLifecycleConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuiltInLifecycleConfigArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_RESOURCE_SPEC_FIELD,
            CUSTOM_IMAGES_FIELD, LIFECYCLE_CONFIG_ARNS_FIELD, CODE_REPOSITORIES_FIELD, APP_LIFECYCLE_MANAGEMENT_FIELD,
            EMR_SETTINGS_FIELD, BUILT_IN_LIFECYCLE_CONFIG_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DefaultResourceSpec", DEFAULT_RESOURCE_SPEC_FIELD);
                    put("CustomImages", CUSTOM_IMAGES_FIELD);
                    put("LifecycleConfigArns", LIFECYCLE_CONFIG_ARNS_FIELD);
                    put("CodeRepositories", CODE_REPOSITORIES_FIELD);
                    put("AppLifecycleManagement", APP_LIFECYCLE_MANAGEMENT_FIELD);
                    put("EmrSettings", EMR_SETTINGS_FIELD);
                    put("BuiltInLifecycleConfigArn", BUILT_IN_LIFECYCLE_CONFIG_ARN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final ResourceSpec defaultResourceSpec;

    private final List<CustomImage> customImages;

    private final List<String> lifecycleConfigArns;

    private final List<CodeRepository> codeRepositories;

    private final AppLifecycleManagement appLifecycleManagement;

    private final EmrSettings emrSettings;

    private final String builtInLifecycleConfigArn;

    private JupyterLabAppSettings(BuilderImpl builder) {
        this.defaultResourceSpec = builder.defaultResourceSpec;
        this.customImages = builder.customImages;
        this.lifecycleConfigArns = builder.lifecycleConfigArns;
        this.codeRepositories = builder.codeRepositories;
        this.appLifecycleManagement = builder.appLifecycleManagement;
        this.emrSettings = builder.emrSettings;
        this.builtInLifecycleConfigArn = builder.builtInLifecycleConfigArn;
    }

    /**
     * Returns the value of the DefaultResourceSpec property for this object.
     * 
     * @return The value of the DefaultResourceSpec property for this object.
     */
    public final ResourceSpec defaultResourceSpec() {
        return defaultResourceSpec;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomImages property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomImages() {
        return customImages != null && !(customImages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of custom SageMaker images that are configured to run as a JupyterLab app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomImages} method.
     * </p>
     * 
     * @return A list of custom SageMaker images that are configured to run as a JupyterLab app.
     */
    public final List<CustomImage> customImages() {
        return customImages;
    }

    /**
     * For responses, this returns true if the service returned a value for the LifecycleConfigArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLifecycleConfigArns() {
        return lifecycleConfigArns != null && !(lifecycleConfigArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the lifecycle configurations attached to the user profile or domain. To remove
     * a lifecycle config, you must set <code>LifecycleConfigArns</code> to an empty list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLifecycleConfigArns} method.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the lifecycle configurations attached to the user profile or domain. To
     *         remove a lifecycle config, you must set <code>LifecycleConfigArns</code> to an empty list.
     */
    public final List<String> lifecycleConfigArns() {
        return lifecycleConfigArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the CodeRepositories property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCodeRepositories() {
        return codeRepositories != null && !(codeRepositories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab
     * application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCodeRepositories} method.
     * </p>
     * 
     * @return A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab
     *         application.
     */
    public final List<CodeRepository> codeRepositories() {
        return codeRepositories;
    }

    /**
     * <p>
     * Indicates whether idle shutdown is activated for JupyterLab applications.
     * </p>
     * 
     * @return Indicates whether idle shutdown is activated for JupyterLab applications.
     */
    public final AppLifecycleManagement appLifecycleManagement() {
        return appLifecycleManagement;
    }

    /**
     * <p>
     * The configuration parameters that specify the IAM roles assumed by the execution role of SageMaker (assumable
     * roles) and the cluster instances or job execution environments (execution roles or runtime roles) to manage and
     * access resources required for running Amazon EMR clusters or Amazon EMR Serverless applications.
     * </p>
     * 
     * @return The configuration parameters that specify the IAM roles assumed by the execution role of SageMaker
     *         (assumable roles) and the cluster instances or job execution environments (execution roles or runtime
     *         roles) to manage and access resources required for running Amazon EMR clusters or Amazon EMR Serverless
     *         applications.
     */
    public final EmrSettings emrSettings() {
        return emrSettings;
    }

    /**
     * <p>
     * The lifecycle configuration that runs before the default lifecycle configuration. It can override changes made in
     * the default lifecycle configuration.
     * </p>
     * 
     * @return The lifecycle configuration that runs before the default lifecycle configuration. It can override changes
     *         made in the default lifecycle configuration.
     */
    public final String builtInLifecycleConfigArn() {
        return builtInLifecycleConfigArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultResourceSpec());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomImages() ? customImages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLifecycleConfigArns() ? lifecycleConfigArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCodeRepositories() ? codeRepositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(appLifecycleManagement());
        hashCode = 31 * hashCode + Objects.hashCode(emrSettings());
        hashCode = 31 * hashCode + Objects.hashCode(builtInLifecycleConfigArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JupyterLabAppSettings)) {
            return false;
        }
        JupyterLabAppSettings other = (JupyterLabAppSettings) obj;
        return Objects.equals(defaultResourceSpec(), other.defaultResourceSpec()) && hasCustomImages() == other.hasCustomImages()
                && Objects.equals(customImages(), other.customImages())
                && hasLifecycleConfigArns() == other.hasLifecycleConfigArns()
                && Objects.equals(lifecycleConfigArns(), other.lifecycleConfigArns())
                && hasCodeRepositories() == other.hasCodeRepositories()
                && Objects.equals(codeRepositories(), other.codeRepositories())
                && Objects.equals(appLifecycleManagement(), other.appLifecycleManagement())
                && Objects.equals(emrSettings(), other.emrSettings())
                && Objects.equals(builtInLifecycleConfigArn(), other.builtInLifecycleConfigArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JupyterLabAppSettings").add("DefaultResourceSpec", defaultResourceSpec())
                .add("CustomImages", hasCustomImages() ? customImages() : null)
                .add("LifecycleConfigArns", hasLifecycleConfigArns() ? lifecycleConfigArns() : null)
                .add("CodeRepositories", hasCodeRepositories() ? codeRepositories() : null)
                .add("AppLifecycleManagement", appLifecycleManagement()).add("EmrSettings", emrSettings())
                .add("BuiltInLifecycleConfigArn", builtInLifecycleConfigArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultResourceSpec":
            return Optional.ofNullable(clazz.cast(defaultResourceSpec()));
        case "CustomImages":
            return Optional.ofNullable(clazz.cast(customImages()));
        case "LifecycleConfigArns":
            return Optional.ofNullable(clazz.cast(lifecycleConfigArns()));
        case "CodeRepositories":
            return Optional.ofNullable(clazz.cast(codeRepositories()));
        case "AppLifecycleManagement":
            return Optional.ofNullable(clazz.cast(appLifecycleManagement()));
        case "EmrSettings":
            return Optional.ofNullable(clazz.cast(emrSettings()));
        case "BuiltInLifecycleConfigArn":
            return Optional.ofNullable(clazz.cast(builtInLifecycleConfigArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<JupyterLabAppSettings, T> g) {
        return obj -> g.apply((JupyterLabAppSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JupyterLabAppSettings> {
        /**
         * Sets the value of the DefaultResourceSpec property for this object.
         *
         * @param defaultResourceSpec
         *        The new value for the DefaultResourceSpec property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultResourceSpec(ResourceSpec defaultResourceSpec);

        /**
         * Sets the value of the DefaultResourceSpec property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResourceSpec.Builder} avoiding the need
         * to create one manually via {@link ResourceSpec#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceSpec.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultResourceSpec(ResourceSpec)}.
         * 
         * @param defaultResourceSpec
         *        a consumer that will call methods on {@link ResourceSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultResourceSpec(ResourceSpec)
         */
        default Builder defaultResourceSpec(Consumer<ResourceSpec.Builder> defaultResourceSpec) {
            return defaultResourceSpec(ResourceSpec.builder().applyMutation(defaultResourceSpec).build());
        }

        /**
         * <p>
         * A list of custom SageMaker images that are configured to run as a JupyterLab app.
         * </p>
         * 
         * @param customImages
         *        A list of custom SageMaker images that are configured to run as a JupyterLab app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customImages(Collection<CustomImage> customImages);

        /**
         * <p>
         * A list of custom SageMaker images that are configured to run as a JupyterLab app.
         * </p>
         * 
         * @param customImages
         *        A list of custom SageMaker images that are configured to run as a JupyterLab app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customImages(CustomImage... customImages);

        /**
         * <p>
         * A list of custom SageMaker images that are configured to run as a JupyterLab app.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.CustomImage.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sagemaker.model.CustomImage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.CustomImage.Builder#build()} is called immediately and
         * its result is passed to {@link #customImages(List<CustomImage>)}.
         * 
         * @param customImages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.CustomImage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customImages(java.util.Collection<CustomImage>)
         */
        Builder customImages(Consumer<CustomImage.Builder>... customImages);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the lifecycle configurations attached to the user profile or domain. To
         * remove a lifecycle config, you must set <code>LifecycleConfigArns</code> to an empty list.
         * </p>
         * 
         * @param lifecycleConfigArns
         *        The Amazon Resource Name (ARN) of the lifecycle configurations attached to the user profile or domain.
         *        To remove a lifecycle config, you must set <code>LifecycleConfigArns</code> to an empty list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleConfigArns(Collection<String> lifecycleConfigArns);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the lifecycle configurations attached to the user profile or domain. To
         * remove a lifecycle config, you must set <code>LifecycleConfigArns</code> to an empty list.
         * </p>
         * 
         * @param lifecycleConfigArns
         *        The Amazon Resource Name (ARN) of the lifecycle configurations attached to the user profile or domain.
         *        To remove a lifecycle config, you must set <code>LifecycleConfigArns</code> to an empty list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleConfigArns(String... lifecycleConfigArns);

        /**
         * <p>
         * A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab
         * application.
         * </p>
         * 
         * @param codeRepositories
         *        A list of Git repositories that SageMaker automatically displays to users for cloning in the
         *        JupyterLab application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeRepositories(Collection<CodeRepository> codeRepositories);

        /**
         * <p>
         * A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab
         * application.
         * </p>
         * 
         * @param codeRepositories
         *        A list of Git repositories that SageMaker automatically displays to users for cloning in the
         *        JupyterLab application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeRepositories(CodeRepository... codeRepositories);

        /**
         * <p>
         * A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab
         * application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.CodeRepository.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.sagemaker.model.CodeRepository#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.CodeRepository.Builder#build()} is called immediately
         * and its result is passed to {@link #codeRepositories(List<CodeRepository>)}.
         * 
         * @param codeRepositories
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.CodeRepository.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeRepositories(java.util.Collection<CodeRepository>)
         */
        Builder codeRepositories(Consumer<CodeRepository.Builder>... codeRepositories);

        /**
         * <p>
         * Indicates whether idle shutdown is activated for JupyterLab applications.
         * </p>
         * 
         * @param appLifecycleManagement
         *        Indicates whether idle shutdown is activated for JupyterLab applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appLifecycleManagement(AppLifecycleManagement appLifecycleManagement);

        /**
         * <p>
         * Indicates whether idle shutdown is activated for JupyterLab applications.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppLifecycleManagement.Builder} avoiding
         * the need to create one manually via {@link AppLifecycleManagement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppLifecycleManagement.Builder#build()} is called immediately and
         * its result is passed to {@link #appLifecycleManagement(AppLifecycleManagement)}.
         * 
         * @param appLifecycleManagement
         *        a consumer that will call methods on {@link AppLifecycleManagement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appLifecycleManagement(AppLifecycleManagement)
         */
        default Builder appLifecycleManagement(Consumer<AppLifecycleManagement.Builder> appLifecycleManagement) {
            return appLifecycleManagement(AppLifecycleManagement.builder().applyMutation(appLifecycleManagement).build());
        }

        /**
         * <p>
         * The configuration parameters that specify the IAM roles assumed by the execution role of SageMaker (assumable
         * roles) and the cluster instances or job execution environments (execution roles or runtime roles) to manage
         * and access resources required for running Amazon EMR clusters or Amazon EMR Serverless applications.
         * </p>
         * 
         * @param emrSettings
         *        The configuration parameters that specify the IAM roles assumed by the execution role of SageMaker
         *        (assumable roles) and the cluster instances or job execution environments (execution roles or runtime
         *        roles) to manage and access resources required for running Amazon EMR clusters or Amazon EMR
         *        Serverless applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emrSettings(EmrSettings emrSettings);

        /**
         * <p>
         * The configuration parameters that specify the IAM roles assumed by the execution role of SageMaker (assumable
         * roles) and the cluster instances or job execution environments (execution roles or runtime roles) to manage
         * and access resources required for running Amazon EMR clusters or Amazon EMR Serverless applications.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmrSettings.Builder} avoiding the need to
         * create one manually via {@link EmrSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmrSettings.Builder#build()} is called immediately and its result
         * is passed to {@link #emrSettings(EmrSettings)}.
         * 
         * @param emrSettings
         *        a consumer that will call methods on {@link EmrSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emrSettings(EmrSettings)
         */
        default Builder emrSettings(Consumer<EmrSettings.Builder> emrSettings) {
            return emrSettings(EmrSettings.builder().applyMutation(emrSettings).build());
        }

        /**
         * <p>
         * The lifecycle configuration that runs before the default lifecycle configuration. It can override changes
         * made in the default lifecycle configuration.
         * </p>
         * 
         * @param builtInLifecycleConfigArn
         *        The lifecycle configuration that runs before the default lifecycle configuration. It can override
         *        changes made in the default lifecycle configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder builtInLifecycleConfigArn(String builtInLifecycleConfigArn);
    }

    static final class BuilderImpl implements Builder {
        private ResourceSpec defaultResourceSpec;

        private List<CustomImage> customImages = DefaultSdkAutoConstructList.getInstance();

        private List<String> lifecycleConfigArns = DefaultSdkAutoConstructList.getInstance();

        private List<CodeRepository> codeRepositories = DefaultSdkAutoConstructList.getInstance();

        private AppLifecycleManagement appLifecycleManagement;

        private EmrSettings emrSettings;

        private String builtInLifecycleConfigArn;

        private BuilderImpl() {
        }

        private BuilderImpl(JupyterLabAppSettings model) {
            defaultResourceSpec(model.defaultResourceSpec);
            customImages(model.customImages);
            lifecycleConfigArns(model.lifecycleConfigArns);
            codeRepositories(model.codeRepositories);
            appLifecycleManagement(model.appLifecycleManagement);
            emrSettings(model.emrSettings);
            builtInLifecycleConfigArn(model.builtInLifecycleConfigArn);
        }

        public final ResourceSpec.Builder getDefaultResourceSpec() {
            return defaultResourceSpec != null ? defaultResourceSpec.toBuilder() : null;
        }

        public final void setDefaultResourceSpec(ResourceSpec.BuilderImpl defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec != null ? defaultResourceSpec.build() : null;
        }

        @Override
        public final Builder defaultResourceSpec(ResourceSpec defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec;
            return this;
        }

        public final List<CustomImage.Builder> getCustomImages() {
            List<CustomImage.Builder> result = CustomImagesCopier.copyToBuilder(this.customImages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomImages(Collection<CustomImage.BuilderImpl> customImages) {
            this.customImages = CustomImagesCopier.copyFromBuilder(customImages);
        }

        @Override
        public final Builder customImages(Collection<CustomImage> customImages) {
            this.customImages = CustomImagesCopier.copy(customImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customImages(CustomImage... customImages) {
            customImages(Arrays.asList(customImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customImages(Consumer<CustomImage.Builder>... customImages) {
            customImages(Stream.of(customImages).map(c -> CustomImage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getLifecycleConfigArns() {
            if (lifecycleConfigArns instanceof SdkAutoConstructList) {
                return null;
            }
            return lifecycleConfigArns;
        }

        public final void setLifecycleConfigArns(Collection<String> lifecycleConfigArns) {
            this.lifecycleConfigArns = LifecycleConfigArnsCopier.copy(lifecycleConfigArns);
        }

        @Override
        public final Builder lifecycleConfigArns(Collection<String> lifecycleConfigArns) {
            this.lifecycleConfigArns = LifecycleConfigArnsCopier.copy(lifecycleConfigArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleConfigArns(String... lifecycleConfigArns) {
            lifecycleConfigArns(Arrays.asList(lifecycleConfigArns));
            return this;
        }

        public final List<CodeRepository.Builder> getCodeRepositories() {
            List<CodeRepository.Builder> result = CodeRepositoriesCopier.copyToBuilder(this.codeRepositories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCodeRepositories(Collection<CodeRepository.BuilderImpl> codeRepositories) {
            this.codeRepositories = CodeRepositoriesCopier.copyFromBuilder(codeRepositories);
        }

        @Override
        public final Builder codeRepositories(Collection<CodeRepository> codeRepositories) {
            this.codeRepositories = CodeRepositoriesCopier.copy(codeRepositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeRepositories(CodeRepository... codeRepositories) {
            codeRepositories(Arrays.asList(codeRepositories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeRepositories(Consumer<CodeRepository.Builder>... codeRepositories) {
            codeRepositories(Stream.of(codeRepositories).map(c -> CodeRepository.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AppLifecycleManagement.Builder getAppLifecycleManagement() {
            return appLifecycleManagement != null ? appLifecycleManagement.toBuilder() : null;
        }

        public final void setAppLifecycleManagement(AppLifecycleManagement.BuilderImpl appLifecycleManagement) {
            this.appLifecycleManagement = appLifecycleManagement != null ? appLifecycleManagement.build() : null;
        }

        @Override
        public final Builder appLifecycleManagement(AppLifecycleManagement appLifecycleManagement) {
            this.appLifecycleManagement = appLifecycleManagement;
            return this;
        }

        public final EmrSettings.Builder getEmrSettings() {
            return emrSettings != null ? emrSettings.toBuilder() : null;
        }

        public final void setEmrSettings(EmrSettings.BuilderImpl emrSettings) {
            this.emrSettings = emrSettings != null ? emrSettings.build() : null;
        }

        @Override
        public final Builder emrSettings(EmrSettings emrSettings) {
            this.emrSettings = emrSettings;
            return this;
        }

        public final String getBuiltInLifecycleConfigArn() {
            return builtInLifecycleConfigArn;
        }

        public final void setBuiltInLifecycleConfigArn(String builtInLifecycleConfigArn) {
            this.builtInLifecycleConfigArn = builtInLifecycleConfigArn;
        }

        @Override
        public final Builder builtInLifecycleConfigArn(String builtInLifecycleConfigArn) {
            this.builtInLifecycleConfigArn = builtInLifecycleConfigArn;
            return this;
        }

        @Override
        public JupyterLabAppSettings build() {
            return new JupyterLabAppSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
