/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAppImageConfigsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListAppImageConfigsRequest.Builder, ListAppImageConfigsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListAppImageConfigsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAppImageConfigsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameContains").getter(getter(ListAppImageConfigsRequest::nameContains))
            .setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()).build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeBefore").getter(getter(ListAppImageConfigsRequest::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeAfter").getter(getter(ListAppImageConfigsRequest::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()).build();

    private static final SdkField<Instant> MODIFIED_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedTimeBefore").getter(getter(ListAppImageConfigsRequest::modifiedTimeBefore))
            .setter(setter(Builder::modifiedTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedTimeBefore").build())
            .build();

    private static final SdkField<Instant> MODIFIED_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedTimeAfter").getter(getter(ListAppImageConfigsRequest::modifiedTimeAfter))
            .setter(setter(Builder::modifiedTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedTimeAfter").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListAppImageConfigsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListAppImageConfigsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, NAME_CONTAINS_FIELD, CREATION_TIME_BEFORE_FIELD, CREATION_TIME_AFTER_FIELD,
            MODIFIED_TIME_BEFORE_FIELD, MODIFIED_TIME_AFTER_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("MaxResults", MAX_RESULTS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("NameContains", NAME_CONTAINS_FIELD);
                    put("CreationTimeBefore", CREATION_TIME_BEFORE_FIELD);
                    put("CreationTimeAfter", CREATION_TIME_AFTER_FIELD);
                    put("ModifiedTimeBefore", MODIFIED_TIME_BEFORE_FIELD);
                    put("ModifiedTimeAfter", MODIFIED_TIME_AFTER_FIELD);
                    put("SortBy", SORT_BY_FIELD);
                    put("SortOrder", SORT_ORDER_FIELD);
                }
            });

    private final Integer maxResults;

    private final String nextToken;

    private final String nameContains;

    private final Instant creationTimeBefore;

    private final Instant creationTimeAfter;

    private final Instant modifiedTimeBefore;

    private final Instant modifiedTimeAfter;

    private final String sortBy;

    private final String sortOrder;

    private ListAppImageConfigsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.nameContains = builder.nameContains;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.modifiedTimeBefore = builder.modifiedTimeBefore;
        this.modifiedTimeAfter = builder.modifiedTimeAfter;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * The total number of items to return in the response. If the total number of items available is more than the
     * value specified, a <code>NextToken</code> is provided in the response. To resume pagination, provide the
     * <code>NextToken</code> value in the as part of a subsequent call. The default value is 10.
     * </p>
     * 
     * @return The total number of items to return in the response. If the total number of items available is more than
     *         the value specified, a <code>NextToken</code> is provided in the response. To resume pagination, provide
     *         the <code>NextToken</code> value in the as part of a subsequent call. The default value is 10.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the previous call to <code>ListImages</code> didn't return the full set of AppImageConfigs, the call returns a
     * token for getting the next set of AppImageConfigs.
     * </p>
     * 
     * @return If the previous call to <code>ListImages</code> didn't return the full set of AppImageConfigs, the call
     *         returns a token for getting the next set of AppImageConfigs.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A filter that returns only AppImageConfigs whose name contains the specified string.
     * </p>
     * 
     * @return A filter that returns only AppImageConfigs whose name contains the specified string.
     */
    public final String nameContains() {
        return nameContains;
    }

    /**
     * <p>
     * A filter that returns only AppImageConfigs created on or before the specified time.
     * </p>
     * 
     * @return A filter that returns only AppImageConfigs created on or before the specified time.
     */
    public final Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * A filter that returns only AppImageConfigs created on or after the specified time.
     * </p>
     * 
     * @return A filter that returns only AppImageConfigs created on or after the specified time.
     */
    public final Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    /**
     * <p>
     * A filter that returns only AppImageConfigs modified on or before the specified time.
     * </p>
     * 
     * @return A filter that returns only AppImageConfigs modified on or before the specified time.
     */
    public final Instant modifiedTimeBefore() {
        return modifiedTimeBefore;
    }

    /**
     * <p>
     * A filter that returns only AppImageConfigs modified on or after the specified time.
     * </p>
     * 
     * @return A filter that returns only AppImageConfigs modified on or after the specified time.
     */
    public final Instant modifiedTimeAfter() {
        return modifiedTimeAfter;
    }

    /**
     * <p>
     * The property used to sort results. The default value is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link AppImageConfigSortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return The property used to sort results. The default value is <code>CreationTime</code>.
     * @see AppImageConfigSortKey
     */
    public final AppImageConfigSortKey sortBy() {
        return AppImageConfigSortKey.fromValue(sortBy);
    }

    /**
     * <p>
     * The property used to sort results. The default value is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link AppImageConfigSortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return The property used to sort results. The default value is <code>CreationTime</code>.
     * @see AppImageConfigSortKey
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The sort order. The default value is <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order. The default value is <code>Descending</code>.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order. The default value is <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order. The default value is <code>Descending</code>.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppImageConfigsRequest)) {
            return false;
        }
        ListAppImageConfigsRequest other = (ListAppImageConfigsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(nameContains(), other.nameContains())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(creationTimeAfter(), other.creationTimeAfter())
                && Objects.equals(modifiedTimeBefore(), other.modifiedTimeBefore())
                && Objects.equals(modifiedTimeAfter(), other.modifiedTimeAfter())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAppImageConfigsRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("NameContains", nameContains()).add("CreationTimeBefore", creationTimeBefore())
                .add("CreationTimeAfter", creationTimeAfter()).add("ModifiedTimeBefore", modifiedTimeBefore())
                .add("ModifiedTimeAfter", modifiedTimeAfter()).add("SortBy", sortByAsString())
                .add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "NameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        case "ModifiedTimeBefore":
            return Optional.ofNullable(clazz.cast(modifiedTimeBefore()));
        case "ModifiedTimeAfter":
            return Optional.ofNullable(clazz.cast(modifiedTimeAfter()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAppImageConfigsRequest, T> g) {
        return obj -> g.apply((ListAppImageConfigsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAppImageConfigsRequest> {
        /**
         * <p>
         * The total number of items to return in the response. If the total number of items available is more than the
         * value specified, a <code>NextToken</code> is provided in the response. To resume pagination, provide the
         * <code>NextToken</code> value in the as part of a subsequent call. The default value is 10.
         * </p>
         * 
         * @param maxResults
         *        The total number of items to return in the response. If the total number of items available is more
         *        than the value specified, a <code>NextToken</code> is provided in the response. To resume pagination,
         *        provide the <code>NextToken</code> value in the as part of a subsequent call. The default value is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the previous call to <code>ListImages</code> didn't return the full set of AppImageConfigs, the call
         * returns a token for getting the next set of AppImageConfigs.
         * </p>
         * 
         * @param nextToken
         *        If the previous call to <code>ListImages</code> didn't return the full set of AppImageConfigs, the
         *        call returns a token for getting the next set of AppImageConfigs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A filter that returns only AppImageConfigs whose name contains the specified string.
         * </p>
         * 
         * @param nameContains
         *        A filter that returns only AppImageConfigs whose name contains the specified string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        /**
         * <p>
         * A filter that returns only AppImageConfigs created on or before the specified time.
         * </p>
         * 
         * @param creationTimeBefore
         *        A filter that returns only AppImageConfigs created on or before the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * A filter that returns only AppImageConfigs created on or after the specified time.
         * </p>
         * 
         * @param creationTimeAfter
         *        A filter that returns only AppImageConfigs created on or after the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        /**
         * <p>
         * A filter that returns only AppImageConfigs modified on or before the specified time.
         * </p>
         * 
         * @param modifiedTimeBefore
         *        A filter that returns only AppImageConfigs modified on or before the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedTimeBefore(Instant modifiedTimeBefore);

        /**
         * <p>
         * A filter that returns only AppImageConfigs modified on or after the specified time.
         * </p>
         * 
         * @param modifiedTimeAfter
         *        A filter that returns only AppImageConfigs modified on or after the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedTimeAfter(Instant modifiedTimeAfter);

        /**
         * <p>
         * The property used to sort results. The default value is <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        The property used to sort results. The default value is <code>CreationTime</code>.
         * @see AppImageConfigSortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppImageConfigSortKey
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The property used to sort results. The default value is <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        The property used to sort results. The default value is <code>CreationTime</code>.
         * @see AppImageConfigSortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppImageConfigSortKey
         */
        Builder sortBy(AppImageConfigSortKey sortBy);

        /**
         * <p>
         * The sort order. The default value is <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order. The default value is <code>Descending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order. The default value is <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order. The default value is <code>Descending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String nameContains;

        private Instant creationTimeBefore;

        private Instant creationTimeAfter;

        private Instant modifiedTimeBefore;

        private Instant modifiedTimeAfter;

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppImageConfigsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            nameContains(model.nameContains);
            creationTimeBefore(model.creationTimeBefore);
            creationTimeAfter(model.creationTimeAfter);
            modifiedTimeBefore(model.modifiedTimeBefore);
            modifiedTimeAfter(model.modifiedTimeAfter);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getNameContains() {
            return nameContains;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getModifiedTimeBefore() {
            return modifiedTimeBefore;
        }

        public final void setModifiedTimeBefore(Instant modifiedTimeBefore) {
            this.modifiedTimeBefore = modifiedTimeBefore;
        }

        @Override
        public final Builder modifiedTimeBefore(Instant modifiedTimeBefore) {
            this.modifiedTimeBefore = modifiedTimeBefore;
            return this;
        }

        public final Instant getModifiedTimeAfter() {
            return modifiedTimeAfter;
        }

        public final void setModifiedTimeAfter(Instant modifiedTimeAfter) {
            this.modifiedTimeAfter = modifiedTimeAfter;
        }

        @Override
        public final Builder modifiedTimeAfter(Instant modifiedTimeAfter) {
            this.modifiedTimeAfter = modifiedTimeAfter;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(AppImageConfigSortKey sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAppImageConfigsRequest build() {
            return new ListAppImageConfigsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
