/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCandidatesForAutoMlJobResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListCandidatesForAutoMlJobResponse.Builder, ListCandidatesForAutoMlJobResponse> {
    private static final SdkField<List<AutoMLCandidate>> CANDIDATES_FIELD = SdkField
            .<List<AutoMLCandidate>> builder(MarshallingType.LIST)
            .memberName("Candidates")
            .getter(getter(ListCandidatesForAutoMlJobResponse::candidates))
            .setter(setter(Builder::candidates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Candidates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoMLCandidate> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoMLCandidate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCandidatesForAutoMlJobResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANDIDATES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Candidates", CANDIDATES_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<AutoMLCandidate> candidates;

    private final String nextToken;

    private ListCandidatesForAutoMlJobResponse(BuilderImpl builder) {
        super(builder);
        this.candidates = builder.candidates;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Candidates property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCandidates() {
        return candidates != null && !(candidates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summaries about the <code>AutoMLCandidates</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCandidates} method.
     * </p>
     * 
     * @return Summaries about the <code>AutoMLCandidates</code>.
     */
    public final List<AutoMLCandidate> candidates() {
        return candidates;
    }

    /**
     * <p>
     * If the previous response was truncated, you receive this token. Use it in your next request to receive the next
     * set of results.
     * </p>
     * 
     * @return If the previous response was truncated, you receive this token. Use it in your next request to receive
     *         the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCandidates() ? candidates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCandidatesForAutoMlJobResponse)) {
            return false;
        }
        ListCandidatesForAutoMlJobResponse other = (ListCandidatesForAutoMlJobResponse) obj;
        return hasCandidates() == other.hasCandidates() && Objects.equals(candidates(), other.candidates())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCandidatesForAutoMlJobResponse").add("Candidates", hasCandidates() ? candidates() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Candidates":
            return Optional.ofNullable(clazz.cast(candidates()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCandidatesForAutoMlJobResponse, T> g) {
        return obj -> g.apply((ListCandidatesForAutoMlJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCandidatesForAutoMlJobResponse> {
        /**
         * <p>
         * Summaries about the <code>AutoMLCandidates</code>.
         * </p>
         * 
         * @param candidates
         *        Summaries about the <code>AutoMLCandidates</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder candidates(Collection<AutoMLCandidate> candidates);

        /**
         * <p>
         * Summaries about the <code>AutoMLCandidates</code>.
         * </p>
         * 
         * @param candidates
         *        Summaries about the <code>AutoMLCandidates</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder candidates(AutoMLCandidate... candidates);

        /**
         * <p>
         * Summaries about the <code>AutoMLCandidates</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.AutoMLCandidate.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.sagemaker.model.AutoMLCandidate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.AutoMLCandidate.Builder#build()} is called immediately
         * and its result is passed to {@link #candidates(List<AutoMLCandidate>)}.
         * 
         * @param candidates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.AutoMLCandidate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #candidates(java.util.Collection<AutoMLCandidate>)
         */
        Builder candidates(Consumer<AutoMLCandidate.Builder>... candidates);

        /**
         * <p>
         * If the previous response was truncated, you receive this token. Use it in your next request to receive the
         * next set of results.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was truncated, you receive this token. Use it in your next request to receive
         *        the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<AutoMLCandidate> candidates = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCandidatesForAutoMlJobResponse model) {
            super(model);
            candidates(model.candidates);
            nextToken(model.nextToken);
        }

        public final List<AutoMLCandidate.Builder> getCandidates() {
            List<AutoMLCandidate.Builder> result = AutoMLCandidatesCopier.copyToBuilder(this.candidates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCandidates(Collection<AutoMLCandidate.BuilderImpl> candidates) {
            this.candidates = AutoMLCandidatesCopier.copyFromBuilder(candidates);
        }

        @Override
        public final Builder candidates(Collection<AutoMLCandidate> candidates) {
            this.candidates = AutoMLCandidatesCopier.copy(candidates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder candidates(AutoMLCandidate... candidates) {
            candidates(Arrays.asList(candidates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder candidates(Consumer<AutoMLCandidate.Builder>... candidates) {
            candidates(Stream.of(candidates).map(c -> AutoMLCandidate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCandidatesForAutoMlJobResponse build() {
            return new ListCandidatesForAutoMlJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
