/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListClusterSchedulerConfigsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListClusterSchedulerConfigsResponse.Builder, ListClusterSchedulerConfigsResponse> {
    private static final SdkField<List<ClusterSchedulerConfigSummary>> CLUSTER_SCHEDULER_CONFIG_SUMMARIES_FIELD = SdkField
            .<List<ClusterSchedulerConfigSummary>> builder(MarshallingType.LIST)
            .memberName("ClusterSchedulerConfigSummaries")
            .getter(getter(ListClusterSchedulerConfigsResponse::clusterSchedulerConfigSummaries))
            .setter(setter(Builder::clusterSchedulerConfigSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSchedulerConfigSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusterSchedulerConfigSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterSchedulerConfigSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListClusterSchedulerConfigsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLUSTER_SCHEDULER_CONFIG_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ClusterSchedulerConfigSummaries", CLUSTER_SCHEDULER_CONFIG_SUMMARIES_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<ClusterSchedulerConfigSummary> clusterSchedulerConfigSummaries;

    private final String nextToken;

    private ListClusterSchedulerConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.clusterSchedulerConfigSummaries = builder.clusterSchedulerConfigSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterSchedulerConfigSummaries
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasClusterSchedulerConfigSummaries() {
        return clusterSchedulerConfigSummaries != null && !(clusterSchedulerConfigSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summaries of the cluster policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterSchedulerConfigSummaries}
     * method.
     * </p>
     * 
     * @return Summaries of the cluster policies.
     */
    public final List<ClusterSchedulerConfigSummary> clusterSchedulerConfigSummaries() {
        return clusterSchedulerConfigSummaries;
    }

    /**
     * <p>
     * If the previous response was truncated, you will receive this token. Use it in your next request to receive the
     * next set of results.
     * </p>
     * 
     * @return If the previous response was truncated, you will receive this token. Use it in your next request to
     *         receive the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasClusterSchedulerConfigSummaries() ? clusterSchedulerConfigSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClusterSchedulerConfigsResponse)) {
            return false;
        }
        ListClusterSchedulerConfigsResponse other = (ListClusterSchedulerConfigsResponse) obj;
        return hasClusterSchedulerConfigSummaries() == other.hasClusterSchedulerConfigSummaries()
                && Objects.equals(clusterSchedulerConfigSummaries(), other.clusterSchedulerConfigSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListClusterSchedulerConfigsResponse")
                .add("ClusterSchedulerConfigSummaries",
                        hasClusterSchedulerConfigSummaries() ? clusterSchedulerConfigSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterSchedulerConfigSummaries":
            return Optional.ofNullable(clazz.cast(clusterSchedulerConfigSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListClusterSchedulerConfigsResponse, T> g) {
        return obj -> g.apply((ListClusterSchedulerConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListClusterSchedulerConfigsResponse> {
        /**
         * <p>
         * Summaries of the cluster policies.
         * </p>
         * 
         * @param clusterSchedulerConfigSummaries
         *        Summaries of the cluster policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSchedulerConfigSummaries(Collection<ClusterSchedulerConfigSummary> clusterSchedulerConfigSummaries);

        /**
         * <p>
         * Summaries of the cluster policies.
         * </p>
         * 
         * @param clusterSchedulerConfigSummaries
         *        Summaries of the cluster policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSchedulerConfigSummaries(ClusterSchedulerConfigSummary... clusterSchedulerConfigSummaries);

        /**
         * <p>
         * Summaries of the cluster policies.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterSchedulerConfigSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterSchedulerConfigSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterSchedulerConfigSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #clusterSchedulerConfigSummaries(List<ClusterSchedulerConfigSummary>)}.
         * 
         * @param clusterSchedulerConfigSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ClusterSchedulerConfigSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterSchedulerConfigSummaries(java.util.Collection<ClusterSchedulerConfigSummary>)
         */
        Builder clusterSchedulerConfigSummaries(
                Consumer<ClusterSchedulerConfigSummary.Builder>... clusterSchedulerConfigSummaries);

        /**
         * <p>
         * If the previous response was truncated, you will receive this token. Use it in your next request to receive
         * the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was truncated, you will receive this token. Use it in your next request to
         *        receive the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<ClusterSchedulerConfigSummary> clusterSchedulerConfigSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClusterSchedulerConfigsResponse model) {
            super(model);
            clusterSchedulerConfigSummaries(model.clusterSchedulerConfigSummaries);
            nextToken(model.nextToken);
        }

        public final List<ClusterSchedulerConfigSummary.Builder> getClusterSchedulerConfigSummaries() {
            List<ClusterSchedulerConfigSummary.Builder> result = ClusterSchedulerConfigSummaryListCopier
                    .copyToBuilder(this.clusterSchedulerConfigSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterSchedulerConfigSummaries(
                Collection<ClusterSchedulerConfigSummary.BuilderImpl> clusterSchedulerConfigSummaries) {
            this.clusterSchedulerConfigSummaries = ClusterSchedulerConfigSummaryListCopier
                    .copyFromBuilder(clusterSchedulerConfigSummaries);
        }

        @Override
        public final Builder clusterSchedulerConfigSummaries(
                Collection<ClusterSchedulerConfigSummary> clusterSchedulerConfigSummaries) {
            this.clusterSchedulerConfigSummaries = ClusterSchedulerConfigSummaryListCopier.copy(clusterSchedulerConfigSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSchedulerConfigSummaries(ClusterSchedulerConfigSummary... clusterSchedulerConfigSummaries) {
            clusterSchedulerConfigSummaries(Arrays.asList(clusterSchedulerConfigSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSchedulerConfigSummaries(
                Consumer<ClusterSchedulerConfigSummary.Builder>... clusterSchedulerConfigSummaries) {
            clusterSchedulerConfigSummaries(Stream.of(clusterSchedulerConfigSummaries)
                    .map(c -> ClusterSchedulerConfigSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListClusterSchedulerConfigsResponse build() {
            return new ListClusterSchedulerConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
