/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListClustersResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListClustersResponse.Builder, ListClustersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListClustersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ClusterSummary>> CLUSTER_SUMMARIES_FIELD = SdkField
            .<List<ClusterSummary>> builder(MarshallingType.LIST)
            .memberName("ClusterSummaries")
            .getter(getter(ListClustersResponse::clusterSummaries))
            .setter(setter(Builder::clusterSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusterSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            CLUSTER_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("ClusterSummaries", CLUSTER_SUMMARIES_FIELD);
                }
            });

    private final String nextToken;

    private final List<ClusterSummary> clusterSummaries;

    private ListClustersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.clusterSummaries = builder.clusterSummaries;
    }

    /**
     * <p>
     * If the result of the previous <code>ListClusters</code> request was truncated, the response includes a
     * <code>NextToken</code>. To retrieve the next set of clusters, use the token in the next request.
     * </p>
     * 
     * @return If the result of the previous <code>ListClusters</code> request was truncated, the response includes a
     *         <code>NextToken</code>. To retrieve the next set of clusters, use the token in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClusterSummaries() {
        return clusterSummaries != null && !(clusterSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The summaries of listed SageMaker HyperPod clusters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterSummaries} method.
     * </p>
     * 
     * @return The summaries of listed SageMaker HyperPod clusters.
     */
    public final List<ClusterSummary> clusterSummaries() {
        return clusterSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterSummaries() ? clusterSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersResponse)) {
            return false;
        }
        ListClustersResponse other = (ListClustersResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasClusterSummaries() == other.hasClusterSummaries()
                && Objects.equals(clusterSummaries(), other.clusterSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListClustersResponse").add("NextToken", nextToken())
                .add("ClusterSummaries", hasClusterSummaries() ? clusterSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ClusterSummaries":
            return Optional.ofNullable(clazz.cast(clusterSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListClustersResponse, T> g) {
        return obj -> g.apply((ListClustersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListClustersResponse> {
        /**
         * <p>
         * If the result of the previous <code>ListClusters</code> request was truncated, the response includes a
         * <code>NextToken</code>. To retrieve the next set of clusters, use the token in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the result of the previous <code>ListClusters</code> request was truncated, the response includes a
         *        <code>NextToken</code>. To retrieve the next set of clusters, use the token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The summaries of listed SageMaker HyperPod clusters.
         * </p>
         * 
         * @param clusterSummaries
         *        The summaries of listed SageMaker HyperPod clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSummaries(Collection<ClusterSummary> clusterSummaries);

        /**
         * <p>
         * The summaries of listed SageMaker HyperPod clusters.
         * </p>
         * 
         * @param clusterSummaries
         *        The summaries of listed SageMaker HyperPod clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSummaries(ClusterSummary... clusterSummaries);

        /**
         * <p>
         * The summaries of listed SageMaker HyperPod clusters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.sagemaker.model.ClusterSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #clusterSummaries(List<ClusterSummary>)}.
         * 
         * @param clusterSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ClusterSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterSummaries(java.util.Collection<ClusterSummary>)
         */
        Builder clusterSummaries(Consumer<ClusterSummary.Builder>... clusterSummaries);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ClusterSummary> clusterSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersResponse model) {
            super(model);
            nextToken(model.nextToken);
            clusterSummaries(model.clusterSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ClusterSummary.Builder> getClusterSummaries() {
            List<ClusterSummary.Builder> result = ClusterSummariesCopier.copyToBuilder(this.clusterSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterSummaries(Collection<ClusterSummary.BuilderImpl> clusterSummaries) {
            this.clusterSummaries = ClusterSummariesCopier.copyFromBuilder(clusterSummaries);
        }

        @Override
        public final Builder clusterSummaries(Collection<ClusterSummary> clusterSummaries) {
            this.clusterSummaries = ClusterSummariesCopier.copy(clusterSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSummaries(ClusterSummary... clusterSummaries) {
            clusterSummaries(Arrays.asList(clusterSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSummaries(Consumer<ClusterSummary.Builder>... clusterSummaries) {
            clusterSummaries(Stream.of(clusterSummaries).map(c -> ClusterSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListClustersResponse build() {
            return new ListClustersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
