/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEdgePackagingJobsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListEdgePackagingJobsRequest.Builder, ListEdgePackagingJobsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEdgePackagingJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListEdgePackagingJobsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeAfter").getter(getter(ListEdgePackagingJobsRequest::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()).build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeBefore").getter(getter(ListEdgePackagingJobsRequest::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTimeAfter").getter(getter(ListEdgePackagingJobsRequest::lastModifiedTimeAfter))
            .setter(setter(Builder::lastModifiedTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeAfter").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTimeBefore").getter(getter(ListEdgePackagingJobsRequest::lastModifiedTimeBefore))
            .setter(setter(Builder::lastModifiedTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeBefore").build())
            .build();

    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameContains").getter(getter(ListEdgePackagingJobsRequest::nameContains))
            .setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()).build();

    private static final SdkField<String> MODEL_NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelNameContains").getter(getter(ListEdgePackagingJobsRequest::modelNameContains))
            .setter(setter(Builder::modelNameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelNameContains").build()).build();

    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusEquals").getter(getter(ListEdgePackagingJobsRequest::statusEqualsAsString))
            .setter(setter(Builder::statusEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusEquals").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListEdgePackagingJobsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListEdgePackagingJobsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, CREATION_TIME_AFTER_FIELD, CREATION_TIME_BEFORE_FIELD, LAST_MODIFIED_TIME_AFTER_FIELD,
            LAST_MODIFIED_TIME_BEFORE_FIELD, NAME_CONTAINS_FIELD, MODEL_NAME_CONTAINS_FIELD, STATUS_EQUALS_FIELD, SORT_BY_FIELD,
            SORT_ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("MaxResults", MAX_RESULTS_FIELD);
                    put("CreationTimeAfter", CREATION_TIME_AFTER_FIELD);
                    put("CreationTimeBefore", CREATION_TIME_BEFORE_FIELD);
                    put("LastModifiedTimeAfter", LAST_MODIFIED_TIME_AFTER_FIELD);
                    put("LastModifiedTimeBefore", LAST_MODIFIED_TIME_BEFORE_FIELD);
                    put("NameContains", NAME_CONTAINS_FIELD);
                    put("ModelNameContains", MODEL_NAME_CONTAINS_FIELD);
                    put("StatusEquals", STATUS_EQUALS_FIELD);
                    put("SortBy", SORT_BY_FIELD);
                    put("SortOrder", SORT_ORDER_FIELD);
                }
            });

    private final String nextToken;

    private final Integer maxResults;

    private final Instant creationTimeAfter;

    private final Instant creationTimeBefore;

    private final Instant lastModifiedTimeAfter;

    private final Instant lastModifiedTimeBefore;

    private final String nameContains;

    private final String modelNameContains;

    private final String statusEquals;

    private final String sortBy;

    private final String sortOrder;

    private ListEdgePackagingJobsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.lastModifiedTimeAfter = builder.lastModifiedTimeAfter;
        this.lastModifiedTimeBefore = builder.lastModifiedTimeBefore;
        this.nameContains = builder.nameContains;
        this.modelNameContains = builder.modelNameContains;
        this.statusEquals = builder.statusEquals;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * The response from the last list when returning a list large enough to need tokening.
     * </p>
     * 
     * @return The response from the last list when returning a list large enough to need tokening.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Maximum number of results to select.
     * </p>
     * 
     * @return Maximum number of results to select.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Select jobs where the job was created after specified time.
     * </p>
     * 
     * @return Select jobs where the job was created after specified time.
     */
    public final Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    /**
     * <p>
     * Select jobs where the job was created before specified time.
     * </p>
     * 
     * @return Select jobs where the job was created before specified time.
     */
    public final Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * Select jobs where the job was updated after specified time.
     * </p>
     * 
     * @return Select jobs where the job was updated after specified time.
     */
    public final Instant lastModifiedTimeAfter() {
        return lastModifiedTimeAfter;
    }

    /**
     * <p>
     * Select jobs where the job was updated before specified time.
     * </p>
     * 
     * @return Select jobs where the job was updated before specified time.
     */
    public final Instant lastModifiedTimeBefore() {
        return lastModifiedTimeBefore;
    }

    /**
     * <p>
     * Filter for jobs containing this name in their packaging job name.
     * </p>
     * 
     * @return Filter for jobs containing this name in their packaging job name.
     */
    public final String nameContains() {
        return nameContains;
    }

    /**
     * <p>
     * Filter for jobs where the model name contains this string.
     * </p>
     * 
     * @return Filter for jobs where the model name contains this string.
     */
    public final String modelNameContains() {
        return modelNameContains;
    }

    /**
     * <p>
     * The job status to filter for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link EdgePackagingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return The job status to filter for.
     * @see EdgePackagingJobStatus
     */
    public final EdgePackagingJobStatus statusEquals() {
        return EdgePackagingJobStatus.fromValue(statusEquals);
    }

    /**
     * <p>
     * The job status to filter for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link EdgePackagingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return The job status to filter for.
     * @see EdgePackagingJobStatus
     */
    public final String statusEqualsAsString() {
        return statusEquals;
    }

    /**
     * <p>
     * Use to specify what column to sort by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ListEdgePackagingJobsSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return Use to specify what column to sort by.
     * @see ListEdgePackagingJobsSortBy
     */
    public final ListEdgePackagingJobsSortBy sortBy() {
        return ListEdgePackagingJobsSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * Use to specify what column to sort by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ListEdgePackagingJobsSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return Use to specify what column to sort by.
     * @see ListEdgePackagingJobsSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * What direction to sort by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return What direction to sort by.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * What direction to sort by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return What direction to sort by.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(modelNameContains());
        hashCode = 31 * hashCode + Objects.hashCode(statusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEdgePackagingJobsRequest)) {
            return false;
        }
        ListEdgePackagingJobsRequest other = (ListEdgePackagingJobsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(creationTimeAfter(), other.creationTimeAfter())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(lastModifiedTimeAfter(), other.lastModifiedTimeAfter())
                && Objects.equals(lastModifiedTimeBefore(), other.lastModifiedTimeBefore())
                && Objects.equals(nameContains(), other.nameContains())
                && Objects.equals(modelNameContains(), other.modelNameContains())
                && Objects.equals(statusEqualsAsString(), other.statusEqualsAsString())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEdgePackagingJobsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("CreationTimeAfter", creationTimeAfter()).add("CreationTimeBefore", creationTimeBefore())
                .add("LastModifiedTimeAfter", lastModifiedTimeAfter()).add("LastModifiedTimeBefore", lastModifiedTimeBefore())
                .add("NameContains", nameContains()).add("ModelNameContains", modelNameContains())
                .add("StatusEquals", statusEqualsAsString()).add("SortBy", sortByAsString())
                .add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "LastModifiedTimeAfter":
            return Optional.ofNullable(clazz.cast(lastModifiedTimeAfter()));
        case "LastModifiedTimeBefore":
            return Optional.ofNullable(clazz.cast(lastModifiedTimeBefore()));
        case "NameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        case "ModelNameContains":
            return Optional.ofNullable(clazz.cast(modelNameContains()));
        case "StatusEquals":
            return Optional.ofNullable(clazz.cast(statusEqualsAsString()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListEdgePackagingJobsRequest, T> g) {
        return obj -> g.apply((ListEdgePackagingJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListEdgePackagingJobsRequest> {
        /**
         * <p>
         * The response from the last list when returning a list large enough to need tokening.
         * </p>
         * 
         * @param nextToken
         *        The response from the last list when returning a list large enough to need tokening.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Maximum number of results to select.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of results to select.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Select jobs where the job was created after specified time.
         * </p>
         * 
         * @param creationTimeAfter
         *        Select jobs where the job was created after specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        /**
         * <p>
         * Select jobs where the job was created before specified time.
         * </p>
         * 
         * @param creationTimeBefore
         *        Select jobs where the job was created before specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * Select jobs where the job was updated after specified time.
         * </p>
         * 
         * @param lastModifiedTimeAfter
         *        Select jobs where the job was updated after specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter);

        /**
         * <p>
         * Select jobs where the job was updated before specified time.
         * </p>
         * 
         * @param lastModifiedTimeBefore
         *        Select jobs where the job was updated before specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore);

        /**
         * <p>
         * Filter for jobs containing this name in their packaging job name.
         * </p>
         * 
         * @param nameContains
         *        Filter for jobs containing this name in their packaging job name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        /**
         * <p>
         * Filter for jobs where the model name contains this string.
         * </p>
         * 
         * @param modelNameContains
         *        Filter for jobs where the model name contains this string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelNameContains(String modelNameContains);

        /**
         * <p>
         * The job status to filter for.
         * </p>
         * 
         * @param statusEquals
         *        The job status to filter for.
         * @see EdgePackagingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EdgePackagingJobStatus
         */
        Builder statusEquals(String statusEquals);

        /**
         * <p>
         * The job status to filter for.
         * </p>
         * 
         * @param statusEquals
         *        The job status to filter for.
         * @see EdgePackagingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EdgePackagingJobStatus
         */
        Builder statusEquals(EdgePackagingJobStatus statusEquals);

        /**
         * <p>
         * Use to specify what column to sort by.
         * </p>
         * 
         * @param sortBy
         *        Use to specify what column to sort by.
         * @see ListEdgePackagingJobsSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListEdgePackagingJobsSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * Use to specify what column to sort by.
         * </p>
         * 
         * @param sortBy
         *        Use to specify what column to sort by.
         * @see ListEdgePackagingJobsSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListEdgePackagingJobsSortBy
         */
        Builder sortBy(ListEdgePackagingJobsSortBy sortBy);

        /**
         * <p>
         * What direction to sort by.
         * </p>
         * 
         * @param sortOrder
         *        What direction to sort by.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * What direction to sort by.
         * </p>
         * 
         * @param sortOrder
         *        What direction to sort by.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private Instant creationTimeAfter;

        private Instant creationTimeBefore;

        private Instant lastModifiedTimeAfter;

        private Instant lastModifiedTimeBefore;

        private String nameContains;

        private String modelNameContains;

        private String statusEquals;

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEdgePackagingJobsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            creationTimeAfter(model.creationTimeAfter);
            creationTimeBefore(model.creationTimeBefore);
            lastModifiedTimeAfter(model.lastModifiedTimeAfter);
            lastModifiedTimeBefore(model.lastModifiedTimeBefore);
            nameContains(model.nameContains);
            modelNameContains(model.modelNameContains);
            statusEquals(model.statusEquals);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final Instant getLastModifiedTimeAfter() {
            return lastModifiedTimeAfter;
        }

        public final void setLastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
        }

        @Override
        public final Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
            return this;
        }

        public final Instant getLastModifiedTimeBefore() {
            return lastModifiedTimeBefore;
        }

        public final void setLastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
        }

        @Override
        public final Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
            return this;
        }

        public final String getNameContains() {
            return nameContains;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final String getModelNameContains() {
            return modelNameContains;
        }

        public final void setModelNameContains(String modelNameContains) {
            this.modelNameContains = modelNameContains;
        }

        @Override
        public final Builder modelNameContains(String modelNameContains) {
            this.modelNameContains = modelNameContains;
            return this;
        }

        public final String getStatusEquals() {
            return statusEquals;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(EdgePackagingJobStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ListEdgePackagingJobsSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEdgePackagingJobsRequest build() {
            return new ListEdgePackagingJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
